<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Module frontend view
 *
 * @package    mod_tlive
 * @copyright  2013  Teleskill Italia S.r.l
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 **/

require_once('../../config.php');
require_once('locallib.php');

$id = optional_param('id',  0,  PARAM_INT); /* course_module ID,  or */
$a  = optional_param('a',  0,  PARAM_INT);  /* tlive instance ID */
$rsid = optional_param('rsid', 0, PARAM_INT);
$lsid = optional_param('lsid', 0, PARAM_INT);
$psid = optional_param('psid',  0,  PARAM_INT);
$pid = optional_param('pid',  0,  PARAM_INT);
$context = context_module::instance($id);
$opt = optional_param('opt', '', PARAM_TEXT);

if ($id) {
    if (! $cm = get_coursemodule_from_id('tlive',  $id)) {
        error('Course Module ID was incorrect');
    }

    if (! $course = $DB->get_record('course',  array('id' => $cm->course))) {
        error('Course is misconfigured');
    }

    if (! $tlive = $DB->get_record('tlive',  array('id' => $cm->instance))) {
        error('Course module is incorrect');
    }

} else if ($a) {
    if (! $tlive = $DB->get_record('tlive', array('id' => $a))) {
        error('Course module is incorrect');
    }
    if (! $course = $DB->get_record('course',  array('id' => $tlive->course))) {
        error('Course is misconfigured');
    }
    if (! $cm = get_coursemodule_from_instance('tlive',  $tlive->id,  $course->id)) {
        error('Course Module ID was incorrect');
    }

} else {
    error('You must specify a course_module ID or an instance ID');
}

$url = new moodle_url('/mod/tlive/view.php',  array('id' => $cm->id));
$PAGE->set_url($url);
$PAGE->requires->jquery();
$PAGE->requires->css(new moodle_url('/mod/tlive/css/style.css'));
$PAGE->requires->js(new moodle_url('/mod/tlive/javascript/jquery.guest.access.js.php'));

require_login($course,  true,  $cm);

$event = \mod_tlive\event\course_module_viewed::create(array(
    'objectid' => $PAGE->cm->instance,
    'context' => $PAGE->context,
));
$event->add_record_snapshot('course', $PAGE->course);
// In the next line you can use $PAGE->activityrecord if you have set it, or skip this line if you don't have a record.
$event->add_record_snapshot($PAGE->cm->modname, $tlive);
$event->trigger();

/* Print the page header */
$strtlives = get_string('modulenameplural',  'tlive');
$strtlive  = get_string('modulename',  'tlive');

$pagetitle = strip_tags($course->shortname.': '.format_string($tlive->name));
$PAGE->set_title($pagetitle);
$PAGE->set_heading($course->fullname);
echo $OUTPUT->header();

/* Print the main part of the page */
if (!isset($CFG->tlive_clientcode)) {
    die ('tlive is not configured. You have to set <a href="'.$CFG->wwwroot.
    '/admin/settings.php?section=modsettingtlive">tlive general settings</a> before continue.');
}

/* if you didn't find a roomid specified into $tlive record try to define it now */
$testmode = false;
if (empty($tlive->roomid) && !$testmode) {
    $xmlanswer = tlive_createroom($tlive);

    if (!tlive_readxmlanswer($xmlanswer,  'errorcode')) {
        $tlive->roomid = tlive_readxmlanswer($xmlanswer,  'roomid');
        $DB->update_record('tlive',  $tlive);

        if ($tlive->emailconfman) {
            tlive_sendemail($tlive,  'add');
        }
    }
}

/* if you still have a missig roomid inside $tlive record declare you can not proceed */
if (empty($tlive->roomid) && !$testmode) {
    include_once('./missingroom.php');
} else {
    include_once('./getparams.php');
    include_once('./tabs.php');
    include_once('./redirect.php');
}

/* Finish the page */
echo $OUTPUT->footer();