<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * This function verifies if there are places available for the event submitted
 *
 * @package    mod_tlive
 * @copyright  2013  Teleskill Italia S.r.l
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 **/
defined('MOODLE_INTERNAL') OR die('not allowed');

/**
 * This function check for current event, if there are places available
 * @param int $maxusers Max number of participants
 * @param int $users Number of users
 * @param int $startdate Start of conference (unix timestamp)
 * @param int $enddate End of conference (unix timestamp)
 * @param int $update Id of event to update (optional)
 * @return boolean
 */
function event_availability($maxusers, $users, $startdate, $enddate, $update=null) {

    global $DB;

    /* If users==0 return false */
    if ($users==0) {
        return false;
    }

    /* Query to search all events that intersect with current */
    $strsqlstring = "SELECT * FROM {tlive} WHERE ";

    /* Add  exclusion condition->  "if current event already exists and must be modified */
    if (!empty($update)) {
        $strsqlstring .= "id<>'$update' AND ";
    }

    $strsqlstring .= "(((startdate>='$startdate' AND startdate<'$enddate') OR
                      (enddate>'$startdate' AND enddate<='$enddate') OR (startdate<='$startdate' AND enddate>'$startdate')))
                       ORDER BY startdate, enddate ASC";

    /* Sliding window of aux array for comparison */
    $count=0;

    if ($res = $DB->get_records_sql($strsqlstring)) {
        /* Nested loop that make comparisons between time interval, to count total participants */

        foreach ($res as $i) {
            /* Subarray used to make comparisons between events */
            $subarray = array_slice($res, $count+1, count($res));

            $userscount=0;

            foreach ($subarray as $j) {

                /* Checks if two time intervals intersect, then makes users partial sum */
                if ($i->enddate>$j->startdate) {
                    /* somma parziale */
                    $userscount = $userscount + $j->users;

                }

            }

            /* Total sum */
            $userscount = $userscount + $users + $i->users;

            if ($userscount  > $maxusers) {
                /* If total users is greater than max users, return false  */
                return false;
            }

            $count++;

        }
        /* if there aren't any events that intersect the current */

    } else {

        if ($users > $maxusers) {
            /* If total users is greater than max users, return false  */
            return false;

        }
    }

    return true;
}