<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Backup steps for mod_tlive are defined here.
 *
 * @package     mod_tlive
 * @category    backup
 * @copyright   Teleskill Italia S.r.l
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

// For more information about the backup and restore process, please visit:
// https://docs.moodle.org/dev/Backup_2.0_for_developers
// https://docs.moodle.org/dev/Restore_2.0_for_developers

/**
 * Define the complete structure for backup, with file and id annotations.
 */
class backup_tlive_activity_structure_step extends backup_activity_structure_step {

    /**
     * Define backup structure of tlive items
     */
    protected function define_structure() {

        /* To know if we are including userinfo */
        $userinfo = $this->get_setting_value('userinfo');

        /* Define each element separated */
        $tlive = new backup_nested_element('tlive', array('id'), array('name',
        'intro', 'introformat', 'timecreated', 'timemodified', 'roomid', 'confmanid', 'emailconfman',
        'startdate', 'enddate', 'opentoblank','users', 'logo', 'completiontlive', 'completiontlivepoll' , 'completiontliveviewsubmit'));

        /* Define sources */
        $tlive->set_source_table('tlive', array('id' => backup::VAR_ACTIVITYID));

        /* Return the root element (tlive), wrapped into standard activity structure */
        return $this->prepare_activity_structure($tlive);
    }
    
}
