<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * All the steps to restore mod_tlive are defined here.
 *
 * @package     mod_tlive
 * @category    restore
 * @copyright   Teleskill Italia S.r.l
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

// For more information about the backup and restore process, please visit:
// https://docs.moodle.org/dev/Backup_2.0_for_developers
// https://docs.moodle.org/dev/Restore_2.0_for_developers

/**
 * Defines the structure step to restore one mod_tlive activity.
 */
class restore_tlive_activity_structure_step extends restore_activity_structure_step {

    /**
     * Structure step to restore one game activity
     */
    protected function define_structure() {

        $paths = array();
        $userinfo = $this->get_setting_value('userinfo');

        $paths[] = new restore_path_element('tlive', '/activity/tlive');

        /* Return the paths wrapped into standard activity structure */
        return $this->prepare_activity_structure($paths);
    }

    /**
     * Restore data function
     *
     * @param array $data
     */
    protected function process_tlive($data) {
        global $DB;

        $data = (object)$data;
        $oldid = $data->id;

        $data->course = $this->get_courseid();

        $data->timemodified = $this->apply_date_offset($data->timemodified);

        /* insert the tlive record */
        $newitemid = $DB->insert_record('tlive', $data);
        /* immediately after inserting "activity" record, call this */
        $this->apply_activity_instance($newitemid);
    }

    /**
     * Called after restore task
     */
    protected function after_execute() {
        /* Add tlive related files, no need to match by itemname (just internally handled context) */
    }
}