<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * The room_join event.
 *
 * @package     mod_tlive
 * @copyright   Teleskill Italia S.r.l
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
*/

namespace mod_tlive\event;
defined('MOODLE_INTERNAL') || die();

class room_join extends \core\event\base {
    protected function init() {
        $this->data['crud'] = 'c'; // c(reate), r(ead), u(pdate), d(elete)
        $this->data['edulevel'] = self::LEVEL_PARTICIPATING;
        $this->data['objecttable'] = 'tlive';       
    }
 
    public static function get_name() {
        return get_string('eventroom_join', 'mod_tlive');
    }
 
    public function get_description() {
    	
    	$guest_name = '';
    	    	
    	if(isset($this->other['guest_name'])) {
    		$guest_name = $this->other['guest_name'];	
    	}
    	
        return "The user with id {$this->userid} {$guest_name} join the videoconference with id {$this->objectid}.";
    }
 
    public function get_url() {
    	
    	global $CFG;
    	
    	if($this->userid == $CFG->siteguest) {
    		$url = '/mod/tlive/custom_login/join_guest.php?';	
    	} else {
    		$url = '/mod/tlive/custom_login/join.php?';	
    	}
    	
        return new \moodle_url($url, array('id' => $this->contextinstanceid));
    }
   
     /**
     * Return the legacy event log data.
     *
     * @return array|null
     */
    protected function get_legacy_logdata() {
    	// Override if you are migrating an add_to_log() call.
        return array($this->courseid, 'tlive', 'join', 'join.php?id=' . $this->contextinstanceid, $this->objectid,
            $this->contextinstanceid);
    }
    
}