<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Show week calendar page with events scheduled
 *
 * @package     mod_tlive
 * @copyright   Teleskill Italia S.r.l
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

require_once(dirname(__FILE__) . '/../../../config.php');

/* Check if user is logged */
require_login();
?>

<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="content-type" content="text/html; charset=UTF-8">

<?php
    /* Select language file */
    $ln = array("en", "it", "es", "es_es");

    if (isset($SESSION->lang)) {

        if (in_array($SESSION->lang, $ln)) {
            $lang = $SESSION->lang;
        }else{
            $lang = $USER->lang;
        }

    }else{

        $lang = $USER->lang;
    }

    echo "<script type='text/javascript' src='lang/".$lang.".js'></script>";
?>
    <link rel='stylesheet' type='text/css' href='../javascript/lib/bootstrap/bootstrap.min.css' />
    <link rel='stylesheet' type='text/css' href='../javascript/lib/jqueryui/jqueryui.min.css' />
    <link rel='stylesheet' type='text/css' href='../javascript/lib/fullcalendar/fullcalendar.min.css' />
      

</head>
<body>
    <div id='calendar'></div>
    <input type="hidden" name="calendarlang" id="calendarlang" value="<?php echo $lang; ?>" />

    <div id="fullCalModal" class="modal fade" data-backdrop="static" data-keyboard="false">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 id="modalTitle" class="modal-title"></h4>
                    <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">×</span> <span class="sr-only">close</span></button>
                </div>
                <div id="modalBody" class="modal-body">
                    <div id="event_edit_container">
                        <form>
                            
                            <input type="hidden" />
                            
                            <span><?php echo get_string('conference_date', 'tlive');?> </span><span class="date_holder"></span>
                            <br>
                            <label for="start"><?php echo get_string('label_start', 'tlive');?></label><select id="startselect" class="form-control"  name="start"><option value="">
                            <?php echo get_string('label_select_start', 'tlive');?></option></select>
                            
                            <label for="end"><?php echo get_string('label_end', 'tlive');?> </label><select id="endselect" class="form-control" name="end"><option value="">
                            <?php echo get_string('label_select_end', 'tlive');?></option></select>
                            
                            <label for="users"><?php echo get_string('label_users', 'tlive');?></label><input class="form-control" type="text" name="users" />
                                                           
                        </form>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo get_string('cancel', 'tlive');?></button>
                    <button class="btn btn-primary"><a id="eventSave" target="_blank"><?php echo get_string('save', 'tlive');?></a></button>
                </div>
            </div>
        </div>
    </div>
   

    <script type='text/javascript' src='../javascript/lib/jquery/jquery.min.js'></script>
    <script type='text/javascript' src='../javascript/lib/jqueryui/jqueryui.min.js'></script>
    <script type='text/javascript' src='../javascript/lib/moment/moment.min.js'></script>
    <script type='text/javascript' src='../javascript/lib/bootstrap/bootstrap.min.js'></script>
    <script type='text/javascript' src='../javascript/lib/fullcalendar/fullcalendar.min.js'></script>
    <script type='text/javascript' src='../javascript/custom_calendar.js'></script>
</body>
</html>