<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Verify if there are places available for the event submitted, then encode a json that return true or false
 *
 * @package     mod_tlive
 * @copyright   Teleskill Italia S.r.l
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

require_once(dirname(__FILE__) . '/../../../config.php');
require_once("../custom_event/event_availability.php");

/* Load max users param */
$maxusers = $CFG->tlive_maxusers;

$update = optional_param('update', 0, PARAM_INT);
$startdate = optional_param('startdate', 0, PARAM_TEXT);
$enddate = optional_param('enddate', 0, PARAM_TEXT);
$users = optional_param('users', 0, PARAM_INT);

/* Convert datetime string to unix time format */
//$timezone = usertimezone();

$timezone =  $timezone = get_user_timezone();

/* If user time zone is not equal to server local time set default time zone as user time zone */
//if ($timezone!= get_string('serverlocaltime')) {
date_default_timezone_set($timezone);
//}
$startdate = strtotime($startdate);
$enddate = strtotime($enddate);

/* verifies that date fields are valid */
if (!empty($startdate) && !empty($enddate)) {

    if ($update!=0) {

        $success = event_availability($maxusers, $users, $startdate, $enddate, $update);

    } else {

        $success = event_availability($maxusers, $users, $startdate, $enddate);
    }
} else {

    $success = false;

}

/* Return json answer */
$aux=array(
'success' => $success
);

echo json_encode($aux);