<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Videoconference summary with activity completion state
 *
 * @package     mod_tlive
 * @copyright   Teleskill Italia S.r.l
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') OR die('not allowed');

/* Course module */
$id = optional_param('id',  0,  PARAM_INT);
$context = context_course::instance($COURSE->id);

$blnCompletion = ($tlive->completiontlive || $tlive->completiontlivepoll || $tlive->completiontliveviewsubmit);
$now = new DateTime("now", core_date::get_user_timezone_object());
$roomExpired = ($now->getTimeStamp() > $tlive->enddate);
$submit_class = '';

if (!isguestuser() && $USER->id != $tlive->confmanid && !has_capability('moodle/site:config', $context) && $blnCompletion) {
    
	echo '<div align="right">' . get_string('completion', 'tlive') . ' ';
	$img = 'uncomplete.png';
    
	if ($DB->get_record('course_modules_completion', array('coursemoduleid'=>$id, 'userid'=>$USER->id) ) ) {
        $img = 'complete.png';
    }

    echo '<img align="middle" src="' . $CFG->wwwroot . '/mod/tlive/pix/' . $img . '">';
    echo '</div>';
}

$strftime = get_string('displaytimeformat', 'tlive');
$strfdate = get_string('displaydateformat', 'tlive');

if(!$CFG->tlive_disabledate) {
	echo get_string('conference',  'tlive') . userdate($tlive->startdate, $strfdate) . '<br />';
	echo '<ul><li>' . get_string('starting',  'tlive') . userdate($tlive->startdate, $strftime) . '</li>';
	echo '<li>' . get_string('ending',  'tlive') . userdate($tlive->enddate, $strftime) . '</li></ul>';
}

echo '<strong>' . get_string('title',  'tlive') . '</strong><div style="margin-left: 27px;">' . $tlive->name . '</div>';
echo '<strong>' . get_string('descr',  'tlive') . '</strong><div style="margin-left: 27px;">' . $tlive->intro . '</div>';

echo '<div class="form-container">';

if(!$roomExpired) {
	$submit_id = 'goto';
	$buttonlabel = get_string('jointlive', 'tlive');

	if(isguestuser()) {
		$form_action = $CFG->wwwroot . '/mod/tlive/custom_login/join_guest.php';
	} else {
		$form_action = $CFG->wwwroot . '/mod/tlive/custom_login/join.php';
	}

	if ($tlive->opentoblank) {
		echo '<form id="join" method="post" target="_blank" action="' . $form_action . '" target="_blank" class="clearfix">';
	} else {
		echo '<form id="join" method="post" action="' . $form_action . '" class="clearfix">';
	}

	if(isguestuser()) {	
		if(!isset($SESSION->tlive_guest_id)) {
			echo '<p>' . get_string('guest_form_desc','tlive').'<p>';
			echo '<label for="firstname">' . get_string('firstname') . '</label><input type="text" name="firstname" value="" /><br/>';
			echo '<label for="lastname">' . get_string('lastname') . '</label><input type="text" name="lastname" value="" /><br/>';
			echo '<label for="email">' . get_string('email') . '</label><input type="text" name="email" value="" /><br/>';
		}
	}

	echo '<input type="hidden" name="s" value="' . session_id() . '" />';
	echo '<input type="hidden" name="id" value="' . $cm->id . '" />';

	echo '<input type="button" id="' . $submit_id . '" name="goto" value="' . $buttonlabel . '" title="' . $buttonlabel . '" />';
	echo '<div id="guest-notice"></div>';

	echo '</form>';

	if ($tlive->opentoblank) {
		echo '<div style="margin-top:10px;color: red;">' . get_string('willopentoblank', 'tlive') . '</div>';
	}

} else {
	echo '<p class="notice">' . get_string('notice_conference_end', 'tlive') . '</p>';
}

echo '</div>';