<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Plugin upgrade steps are defined here.
 *
 * @package     mod_tlive
 * @category    upgrade
 * @copyright   Teleskill Italia S.r.l
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

require_once(__DIR__.'/upgradelib.php');

/**
 * Execute mod_tlive upgrade from the given old version.
 *
 * @param int $oldversion
 * @return bool $result Upgrade success or failed
 */
function xmldb_tlive_upgrade($oldversion=0) {

    global $CFG,$DB;

    $dbman = $DB->get_manager();

    $result = true;

    if ($oldversion < 2014032400) {

        // Define field banner to be added to tlive.
        $table = new xmldb_table('tlive');
        $field = new xmldb_field('banner', XMLDB_TYPE_CHAR, '255', null, null, null, null, 'logo');

        // Conditionally launch add field banner.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Tlive savepoint reached.
        upgrade_mod_savepoint(true, 2014032400, 'tlive');
    }
    
    if ($oldversion < 2017030200) {
    	
    	$query = "UPDATE {logstore_standard_log} SET eventname=? WHERE action=? AND target=? AND component=?";
    	$DB->execute($query, array("\\mod_tlive\\event\\stats_update","update", "stats", "mod_tlive") ); 
    	
    	$query = "UPDATE {logstore_standard_log} SET eventname=? WHERE action=? AND target=? AND component=?"	;
    	$DB->execute($query, array("\\mod_tlive\\event\\room_join", "join", "room", "mod_tlive") );
    	
    	
    	if (file_exists($CFG->dirroot.'/mod/tlive/classes/event/join_room.php') ) {
    		unlink($CFG->dirroot.'/mod/tlive/classes/event/join_room.php');    		
    	} 
    	
    	if (file_exists($CFG->dirroot.'/mod/tlive/classes/event/update_stats.php') ) {
    		unlink($CFG->dirroot.'/mod/tlive/classes/event/update_stats.php');    		
    	}
    	
    	// Tlive savepoint reached.
        upgrade_mod_savepoint(true, 2017030200, 'tlive');
    }
    
    if ($oldversion < 2017040100) {
    	
    	// Define field banner to be added to tlive.
        $table = new xmldb_table('tlive');
        $field = new xmldb_field('avquality', XMLDB_TYPE_INTEGER, '2', null, XMLDB_NOTNULL, null, '0', null);

        // Conditionally launch add field banner.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }
        
        $table = new xmldb_table('tlive_rooms');
        $field = new xmldb_field('lastreccheck', XMLDB_TYPE_INTEGER, '10', null, null, null, null, null );
    	
    	if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }
        
        $table = new xmldb_table('tlive_user_sessions');
        $field = new xmldb_field('idguest', XMLDB_TYPE_INTEGER, '10', null, XMLDB_NOTNULL, null, '0', null);
    	
    	if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }            
        
        $table = new xmldb_table('tlive_guest_users');
        $table->add_field('id', XMLDB_TYPE_INTEGER, '10', XMLDB_UNSIGNED, XMLDB_NOTNULL, XMLDB_SEQUENCE, null, null);
        $table->add_field('firstname', XMLDB_TYPE_CHAR, '255', null, XMLDB_NOTNULL, null, null, null);
        $table->add_field('lastname', XMLDB_TYPE_CHAR, '255', null, XMLDB_NOTNULL, null, null, null, null);
        $table->add_field('timecreated', XMLDB_TYPE_INTEGER, '10', null, null, null, null, null);
    	$table->add_key('primary', XMLDB_KEY_PRIMARY, array('id'), null, null);
    	
    	$dbman->create_table($table);
    	
    	$table = new xmldb_table('tlive_recs');
    	$table->add_field('recid', XMLDB_TYPE_INTEGER, '10', null, XMLDB_NOTNULL, null, null, null);
    	$table->add_field('roomid', XMLDB_TYPE_INTEGER, '10', null, XMLDB_NOTNULL, null, null, null);
    	$table->add_field('title', XMLDB_TYPE_CHAR, '255', null, null, null, null, null);
    	$table->add_field('status', XMLDB_TYPE_INTEGER, '2', null, null, null, null, null, null);
    	$table->add_field('timecreated', XMLDB_TYPE_INTEGER, '10', null, null, null, null, null);
    	$table->add_field('duration', XMLDB_TYPE_INTEGER, '10', null, null, null, null, null);
    	
    	$dbman->create_table($table);
    	
    	$table = new xmldb_table('tlive_recs_files');
    	$table->add_field('fileid', XMLDB_TYPE_INTEGER, '10', null, XMLDB_NOTNULL, null, null, null);
    	$table->add_field('recid', XMLDB_TYPE_INTEGER, '10', null, XMLDB_NOTNULL, null, null, null);
    	$table->add_field('format', XMLDB_TYPE_INTEGER, '2', null, null, null, null, null);
    	$table->add_field('url', XMLDB_TYPE_CHAR, '255', null, null, null, null, null);
    	$table->add_field('scorm', XMLDB_TYPE_INTEGER, '1', null, XMLDB_NOTNULL, null, '0', null);
    	$table->add_field('zip', XMLDB_TYPE_INTEGER, '1', null, XMLDB_NOTNULL, null, '0', null);
    	
    	$dbman->create_table($table);
    }
    
    if ($oldversion < 2017050100) {
    	
    	$query = "SHOW INDEXES FROM {tlive_recs} WHERE Key_name = 'PRIMARY'";
    	if(!$DB->get_record_sql($query)) {
	    	$query = "ALTER TABLE {tlive_recs} ADD PRIMARY KEY (recid)";
	    }
	    
	    $query = "SHOW INDEXES FROM {tlive_recs_files} WHERE Key_name = 'PRIMARY'";
    	if(!$DB->get_record_sql($query)) {	    
    		$query = "ALTER TABLE {tlive_recs_files} ADD PRIMARY KEY (fileid)";
    		$DB->execute($query);
    	}
    	
    	upgrade_mod_savepoint(true, 2017050100, 'tlive');
    }
    
    if($oldversion < 2018010800) {
    	
    	// Define field banner to be added to tlive.
        $table = new xmldb_table('tlive_guest_users');
        $field = new xmldb_field('email', XMLDB_TYPE_CHAR, '255', null, null, null, null, null);

        // Conditionally launch add field email.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }	
        
        upgrade_mod_savepoint(true, 2018010800, 'tlive');
    }

    //Modified confmanid int to char
    if ($oldversion < 2021033001) {

        // Changing type of field confmanid on table tlive to char.
        $table = new xmldb_table('tlive');
        $field = new xmldb_field('confmanid', XMLDB_TYPE_CHAR, '255', null, null, null, '0', 'roomid');

        // Launch change of type for field confmanid.
        $dbman->change_field_type($table, $field);

        // Tlive savepoint reached.
        upgrade_mod_savepoint(true, 2021033001, 'tlive');
    }

    if ($oldversion < 2021110203) {
        $table = new xmldb_table('tlive');
        $field = new xmldb_field('id_piano_formativo', XMLDB_TYPE_CHAR, '255', null, null, null, null, null);
        $dbman->add_field($table, $field);
        $field = new xmldb_field('piano_formativo', XMLDB_TYPE_CHAR, '255', null, null, null, null, null);
        $dbman->add_field($table, $field);
        $field = new xmldb_field('id_progetto', XMLDB_TYPE_CHAR, '255', null, null, null, null, null);
        $dbman->add_field($table, $field);
        $field = new xmldb_field('id_edizione', XMLDB_TYPE_CHAR, '255', null, null, null, null, null);
        $dbman->add_field($table, $field);

        // Tlive savepoint reached.
        upgrade_mod_savepoint(true, 2021110203, 'tlive');
    }

    if($oldversion < 2023022901) {
        $table = new xmldb_table('tlive_presence_check');
    	$table->add_field('presence_id', XMLDB_TYPE_INTEGER, '10', null, null, null, null, null);
    	$table->add_field('lesson_session_id', XMLDB_TYPE_INTEGER, '10', null, null, null, null, null);
    	$table->add_field('creation_date', XMLDB_TYPE_INTEGER, '10', null, null, null, null, null);
    	
    	$dbman->create_table($table);

        $table = new xmldb_table('tlive_user_presences');
    	$table->add_field('user_presences_id', XMLDB_TYPE_INTEGER, '10', null, null, null, null, null);
    	$table->add_field('presence_id', XMLDB_TYPE_INTEGER, '10', null, null, null, null, null);
        $table->add_field('user_session_id', XMLDB_TYPE_INTEGER, '10', null, null, null, null, null);
    	$table->add_field('creation_date', XMLDB_TYPE_INTEGER, '10', null, null, null, null, null);
    	
    	$dbman->create_table($table);

        upgrade_mod_savepoint(true, 2023022901, 'tlive');
    }

    return $result;
}