//set datatables lib path for requirejs
requirejs.config({
    paths: {
    'datatables': '../../../mod/tlive/javascript/lib/datatable/js/datatables.min'
    }
}); 

//Require tlive jquery
require(['jquery'], function($) {

    $(document).ready(function () { 

        if($('#useraccesspdf').val()){

            //get data value from input field
            var encodedStringAtoB = $('#useraccesspdf').val();
            //json parse and decode base64
            var obj=JSON.parse(atob(encodedStringAtoB));
            //assign data into dataSet variable
            var dataSetUser = obj.data;
        }  
        
        if($('#pollspdf').val()){
    
            //get data value from input field
            var encodedStringAtoB = $('#pollspdf').val();
            //json parse and decode base64
            var obj=JSON.parse(atob(encodedStringAtoB));
            //assign data into dataSet variable
            var dataSetPoll = obj.data;
        }

        //Require datatables
        require(['datatables'], function() {
            
            //build datatable based on codicefiscale field exist
            if($('#codicefiscaleck').val() != '') {

                //build datatable based on lessonid field exist
                if($('#lessonidck').val() != '') {

                    //build datatable based on total duration exist
                    if($('#totalck').val() != '') {
                        
                        //build user datatable
                        $('#user-table').dataTable({
                            "language": {
                                search: translation['search']+" "+'<i class="fa fa-search" aria-hidden="true" fa-4x></i>',
                                "lengthMenu": translation['display']+" _MENU_ "+translation['records'],
                                "info": translation['show']+" _PAGE_ "+translation['of']+" _PAGES_",
                                "infoEmpty": translation['norecord'],
                            },
                            responsive: true,
                            data: dataSetUser,
                            columns: [
                                { title: translation['start'] },
                                { title: translation['end'] },
                                { title: 'UserID' },
                                { title: translation['userLastName'] },
                                { title: translation['userFirstName'] },
                                { title: 'Email' },
                                { title: translation['role'] },
                                { title: translation['moodle_role'] },
                                { title: translation['tlive_codicefiscale'] },
                                { title: translation['header_duration'] },
                                { title: translation['HHMMSS'] },
                                { title: translation['presencePassed'] },
                                { title: translation['presenceCheck'] }
                            ]
                        });

                    }else{
                        
                        //build user datatable
                        $('#user-table').dataTable({
                            "language": {
                                search: translation['search']+" "+'<i class="fa fa-search" aria-hidden="true" fa-4x></i>',
                                "lengthMenu": translation['display']+" _MENU_ "+translation['records'],
                                "info": translation['show']+" _PAGE_ "+translation['of']+" _PAGES_",
                                "infoEmpty": translation['norecord'],
                            },
                            responsive: true,
                            data: dataSetUser,
                            columns: [
                                { title: translation['start'] },
                                { title: translation['end'] },
                                { title: 'UserID' },
                                { title: translation['userLastName'] },
                                { title: translation['userFirstName'] },
                                { title: 'Email' },
                                { title: translation['role'] },
                                { title: translation['moodle_role'] },
                                { title: translation['tlive_codicefiscale'] },
                                { title: translation['header_duration'] },
                            ]
                        });
                        
                    }    

                } else{
                    
                    //build user datatable
                    $('#user-table').dataTable({
                        "language": {
                            search: translation['search']+" "+'<i class="fa fa-search" aria-hidden="true" fa-4x></i>',
                            "lengthMenu": translation['display']+" _MENU_ "+translation['records'],
                            "info": translation['show']+" _PAGE_ "+translation['of']+" _PAGES_",
                            "infoEmpty": translation['norecord'],
                        },
                        responsive: true,
                        data: dataSetUser,
                        
                        columns: [
                            { title: translation['start'] },
                            { title: translation['end'] },
                            { title: translation['userLastName'] },
                            { title: translation['userFirstName'] },
                            { title: translation['role'] },
                            { title: translation['tlive_codicefiscale'] },
                            { title: translation['course_name'] },
                            { title: translation['activity'] },
                        ]
                    });
                }   

                //build poll datatable
                $('#poll-table').dataTable({
                    "language": {
                        search: translation['search']+" "+'<i class="fa fa-search" aria-hidden="true" fa-4x></i>',
                        "lengthMenu": translation['display']+" _MENU_ "+translation['records'],
                        "info": translation['show']+" _PAGE_ "+translation['of']+" _PAGES_",
                        "infoEmpty": translation['norecord'],
                    },
                    responsive: true,
                    data: dataSetPoll,
                    columns: [
                        { title: translation['user'] },
                        { title: translation['role'] },
                        {title: translation['tlive_codicefiscale'] },
                        { title: translation['course_name'] },
                        { title: translation['activity'] },
                        { title: translation['answer'] },
                        { title: translation['result'] }
                    ]
                });

            } else {

                //build datatable based on lessonid field exist
                if($('#lessonidck').val() != ''){

                    //build datatable based on total user lession duration
                    if($('#totalck').val() != ''){

                        //build user datatable
                        $('#user-table').dataTable({
                            "language": {
                                search: translation['search']+" "+'<i class="fa fa-search" aria-hidden="true" fa-4x></i>',
                                "lengthMenu": translation['display']+" _MENU_ "+translation['records'],
                                "info": translation['show']+" _PAGE_ "+translation['of']+" _PAGES_",
                                "infoEmpty": translation['norecord'],
                            },
                            responsive: true,
                            data: dataSetUser,
                            columns: [
                                { title: translation['start'] },
                                { title: translation['end'] },
                                { title: 'UserID' },
                                { title: translation['userLastName'] },
                                { title: translation['userFirstName'] },
                                { title: 'Email' },
                                { title: translation['role'] },
                                { title: translation['moodle_role'] },
                                {title: translation['header_duration'] },
                                {title: translation['HHMMSS'] },
                                { title: translation['presencePassed'] },
                                { title: translation['presenceCheck'] }
                            ]
                        });

                    } else{

                        //build user datatable
                        $('#user-table').dataTable({
                            "language": {
                                search: translation['search']+" "+'<i class="fa fa-search" aria-hidden="true" fa-4x></i>',
                                "lengthMenu": translation['display']+" _MENU_ "+translation['records'],
                                "info": translation['show']+" _PAGE_ "+translation['of']+" _PAGES_",
                                "infoEmpty": translation['norecord'],
                            },
                            responsive: true,
                            data: dataSetUser,
                            columns: [
                                { title: translation['start'] },
                                { title: translation['end'] },
                                { title: 'UserID' },
                                { title: translation['userLastName'] },
                                { title: translation['userFirstName'] },
                                { title: 'Email' },
                                { title: translation['role'] },
                                { title: translation['moodle_role'] },
                                {title: translation['header_duration'] },
                            ]
                        });
                        
                    }   

                } else{

                    //build user datatable
                    $('#user-table').dataTable({
                        "language": {
                            search: translation['search']+" "+'<i class="fa fa-search" aria-hidden="true" fa-4x></i>',
                            "lengthMenu": translation['display']+" _MENU_ "+translation['records'],
                            "info": translation['show']+" _PAGE_ "+translation['of']+" _PAGES_",
                            "infoEmpty": translation['norecord'],
                        },
                        responsive: true,
                        data: dataSetUser,
                       
                        columns: [
                            { title: translation['start'] },
                            { title: translation['end'] },
                            { title: translation['userLastName'] },
                            { title: translation['userFirstName'] },
                            { title: translation['role'] },
                            { title: translation['course_name'] },
                            { title: translation['activity'] },
                        ]
                    });
                }   

                //build poll datatable
                $('#poll-table').dataTable({
                    "language": {
                        search: translation['search']+" "+'<i class="fa fa-search" aria-hidden="true" fa-4x></i>',
                        "lengthMenu": translation['display']+" _MENU_ "+translation['records'],
                        "info": translation['show']+" _PAGE_ "+translation['of']+" _PAGES_",
                        "infoEmpty": translation['norecord'],
                    },
                    responsive: true,
                    data: dataSetPoll,
                    columns: [
                        { title: translation['user'] },
                        { title: translation['role'] },
                        { title: translation['course_name'] },
                        { title: translation['activity'] },
                        { title: translation['answer'] },
                        { title: translation['result'] }
                    ]
                });

            }

        });

    });    
    
});  
