<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * English strings are defined here.
 *
 * @package     mod_tlive
 * @category    string
 * @copyright   Teleskill Italia S.r.l
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accesses'] = 'Access';
$string['access_list'] = 'Access list';
$string['admin'] = 'Administrator';
$string['answer'] = 'Answer';
$string['answer_correct'] = 'Correct';
$string['answer_wrong'] = 'Wrong';
$string['askforsessionperroom'] = 'Room sessions';
$string['avi'] = 'avi';
$string['avquality'] = 'Audio/video quality';
$string['avquality_default'] = 'Channel default';
$string['avquality_low'] = 'Standard 160 x 120 (150 kbps)';
$string['avquality_medium'] = 'Medium 320 x 240 (200 kbps)';
$string['avquality_high'] = 'High 640 x 480 (500 kbps)';
$string['banner'] = 'Wizard\'s banner <br><i>(Advised: 850x148px)</i>';
$string['channeldataerror'] = 'Required data were not available.<br /><br />Server provided the following answer: \"$a\".';
$string['channelloginfo'] = '<p> * relative to the whole videoconference channel </p> <p> ** maximum number evaluated for the whole videoconference channel </p>';
$string['complete'] = 'Complete';
$string['completion'] = 'Completion';
$string['completiontlivegroup'] = 'Activity frequence';
$string['completiontlivegroup_help'] = 'Set the required time, to achieve the activiy completion';
$string['completiontlive'] = 'Activity frequence (mins)';
$string['completionsubmit'] = 'Enable';
$string['completiontlivepoll'] = 'N. of correct answers';
$string['completiontlivepollgroup'] = 'N. of correct answers';
$string['completiontlivepollgroup_help'] = 'Set the required minimum number of correct answers, to achieve the activiy completion';
$string['completiontliveviewgroup'] = 'Entry into room';
$string['completiontliveviewgroup_help'] = 'Achieve activity completion if user enters the room';
$string['conference'] = 'Videoconference session on ';
$string['conference_date'] = 'Videoconference date:';
$string['conferencemanager'] = 'Conference manager';
$string['configserver_fs'] = 'Teleskill Live server features';
$string['correct'] = 'Result';
$string['coursecreator'] = 'Course creator';
$string['course_name'] = 'Course name';
$string['course_shortname'] = 'Course code';
$string['descr'] = 'Agenda';
$string['displaydateformat'] = '%m/%d/%Y';
$string['displaytimeformat'] = '%H:%M';
$string['displaytimeformattable'] = '%H:%M:%S';
$string['editingteacher'] = 'Editing teacher';
$string['end'] = 'End';
$string['emailbody_add'] = 'The teacher of the course <a href="{$a->courseurl}">{$a->coursename}</a> selected you as "Conference manager" for the meeting titled {$a->conferencename} and foreseen for {$a->timestart}. You are requested to join the videoconference as first user at the starting time o\'clock in order to start it. None else than you is allowed to start this web meeting. Thanks in advance for your punctuality.';
$string['emailbody_del'] = 'The teacher of the course <a href="{$a->courseurl}">{$a->coursename}</a> canceled the videoconerence {$a->conferencename}. Thanks, anyway, for the commitment.';
$string['emailbody_retire'] = 'The teacher of the course <a href="{$a->courseurl}">{$a->coursename}</a> take you off the engagement of "Conference manager". You are free of the responsability of "Conference manager" as in the previous communication. Thanks, anyway, for the commitment.';
$string['emailbody_update'] = 'The teacher of the course <a href="{$a->courseurl}">{$a->coursename}</a> changed the videoconference {$a->conferencename} starting date. The new starting time is: {$a->timestart}. You are request to take note of it. Thanks for the commitment.';
$string['emailbody_add_nodate'] = 'The teacher of the course <a href="{$a->courseurl}">{$a->coursename}</a> selected you as "Conference manager" for the meeting titled {$a->conferencename}. You are requested to join the videoconference as first user in order to start it. None else than you is allowed to start this web meeting. Thanks in advance for your punctuality.';
$string['emailbody_del_nodate'] = 'The teacher of the course <a href="{$a->courseurl}">{$a->coursename}</a> canceled the videoconerence {$a->conferencename}. Thanks, anyway, for the commitment.';
$string['emailbody_retire_nodate'] = 'The teacher of the course <a href="{$a->courseurl}">{$a->coursename}</a> take you off the engagement of "Conference manager". You are free of the responsability of "Conference manager" as in the previous communication. Thanks, anyway, for the commitment.';
$string['emailconfman'] = 'Informe now the conference manager through email';
$string['emailnotsent'] = 'An error occurred sending the eamail from {$a->roomcreator} to {$a->conferencemanager}';
$string['emailsubject'] = 'Videoconferenza {$a->conferencename} of the course {$a->coursename}';
$string['emptyxml'] = 'Server didn\'t provide any XML answer.<br />Hints:<ul><li>Is internet available?</li><li>Was the XML question well structured? (change the debug level into the admin block at least to \"$a\" to view questions on the screen)</li><li>Is cURL working fine?</li></ul>';
$string['enddate'] = 'Room closure date';
$string['endhour'] = 'End time';
$string['ending'] = 'Closing at: ';
$string['errorunzipfile'] = 'Error, unzip failed';
$string['explain_clientcode'] = 'Teleskill user ID, needful to get teleskill services';
$string['explain_protocol'] = 'Communication protocol (http o https)';
$string['explain_disabledate'] = 'Disable room scheduling';
$string['explain_serverhost'] = 'Name or IP of the tlive server';
$string['explain_serverport'] = 'Communication door of the tlive videoconference';
$string['explain_maxusers'] = 'Max users number for videoconference';
$string['explain_cronstart'] = 'Beginning of time slot when scheduled task is enabled';
$string['explain_cronend'] = 'End of time slot when scheduled task is disabled';
$string['export'] = 'Export data';
$string['err_form_guest'] = 'You have not entered data to access the videoconference, <a href="{$a}">click here to go back</a>';
$string['eventroom_join'] = "Join videoconference";
$string['eventstats_update'] = "Update statistics";
$string['fetchlogs'] = 'Show logs';
$string['fetchlogserror'] = 'An error encorred during server logs gathering.<br /><br />Server provided the following answer: \"$a\".';
$string['filedescription'] = 'Recorded file';
$string['firsttabname'] = 'Videoconference';
$string['flatchannel'] = 'Flat channel';
$string['flv'] = 'flv';
$string['fromdate'] = 'Starting search date and time';
$string['from'] = 'from ';
$string['from_day'] = 'From ';
$string['frontpage'] = 'Authenticated user on frontpage';
$string['ftp'] = 'ftp';
$string['goback'] = 'Go back';
$string['goback_recs'] = 'Go back to the recs';
$string['guest'] = 'Guest';
$string['guest_form_desc'] = 'Please enter your firstname and lastname';
$string['header_credits'] = 'Credits*';
$string['header_date'] = 'Date';
$string['header_duration'] = 'Duration';
$string['header_role'] = 'Role';
$string['header_rooms'] = 'Maximum number of rooms in the channel**';
$string['header_sid'] = 'Session ID';
$string['header_uid'] = 'User ID';
$string['header_users'] = 'Concurrent users**';
$string['ipaddress'] = 'Ip Address';
$string['jointlive'] = 'Join the videoconference';
$string['joinrecs'] = 'View recordings';
$string['label_start'] = 'Start: ';
$string['label_end'] = 'End: ';
$string['label_users'] = 'Participants: ';
$string['label_select_start'] = 'Select start time';
$string['label_select_end'] = 'Select end time';
$string['lesson'] = 'Lesson of ';
$string['lesson_head'] = 'Lesson';
$string['logs'] = 'Logs summary';
$string['logo'] = 'Welcome picture <br><i>(Advised: 570x260px)</i>';
$string['manager'] = 'Manager';
$string['missingconferencemanager'] = 'No users enabled for the conference manager role';
$string['selectconferencemanager'] = 'Select user to enabled for the conference manager role';
$string['modulename'] = 'Teleskill Live 2.0';
$string['modulenameplural'] = 'Teleskill Live 2.0';
$string['new_event'] = 'New Event';
$string['nodescriptionfilefound'] = 'No description file is available on the server';
$string['nologsavailable'] = 'Logs file not available.Not any information about tlive videoconference\'s rooms is available on the server.';
$string['nopollsavailable'] = 'Polls data are not available';
$string['nosessionperroomavailable'] = 'Room sessions data are not available.';
$string['nosessionperpoolavailable'] = 'Polls sessions data are not available';
$string['nousersessionavailable'] = 'User sessions data are not available';
$string['noroomsavailable'] = 'No rooms available';
$string['notjoined'] = 'Videoconference access denied.<br /><br />Server provided the following answer: \"$a\".<br /><br />Please contact technical assistance to rise up this prolem.';
$string['notallowed'] = 'Access denied';
$string['notice_conference_end'] = 'Videoconferencing is finished.';
$string['opentoblank'] = 'Open the videoconference in a new window';
$string['participant'] = 'User';
$string['places_not_available'] = 'Warning! There are no places available.';
$string['pluginadministration'] = 'Teleskill Live Administration';
$string['pluginname'] = 'Teleskill Live 2.0';
$string['poll'] = 'Poll';
$string['poll_results'] = 'Poll results';
$string['polls'] = 'Polls';
$string['pollstext'] = 'Polls';
$string['poll_session'] = 'Poll session';
$string['poll_sessions'] = 'Poll sessions';
$string['question'] = 'Question';
$string['rec_title'] = 'Title';
$string['rec_view'] = 'View';
$string['recavailable'] = 'Recorded file available';
$string['recnotavailable'] = 'Recorded file not available';
$string['recs_not_enabled'] = 'Recs not enabled';
$string['recs_update'] = 'Update recs list';
$string['recorddescription'] = 'Recorded sessio: ';
$string['redo_log'] = 'Edit search parameters';
$string['reducedebuglevel'] = 'Reduce the debug level to hide \$xml_request and \$xml_answer';
$string['reporttlive'] = 'Teleskill Live';
$string['required_fields'] = 'Required fields';
$string['riseupdebuglevel'] = ' (increase the debug level from Moodle\'s admin block at least to \"$a\" to show it)';
$string['role'] = 'Role';
$string['roomcreationfailed'] = 'An error encorred during the creation of a room for this videoconference. Check if start and end coincide or some Teleskill Live setting is wrong';
$string['roomid'] = 'Room ID';
$string['room_lessons_sessions'] = 'Lessons summary';
$string['room_sessions'] = 'Sessions summary';
$string['room_session'] = 'Session of ';
$string['rooms'] = 'Activities summary';
$string['secondtabname'] = 'Logs';
$string['sess_date'] = 'Date and time of the beginning of the record (GMT+0)';
$string['sess_duration'] = 'Duration in seconds of the record';
$string['sess_id'] = 'Unique ID of the recorded sesion';
$string['sess_mode'] = 'Access protocol';
$string['sess_roomid'] = 'Activity';
$string['sess_src'] = 'Absolute access URL';
$string['sess_status'] = 'Status';
$string['sess_type'] = 'Format';
$string['session'] = 'Session';
$string['sessionlog'] = 'Teleskill Live session log per room or per channel.';
$string['sessionperchannel'] = 'per channel (all the rooms)';
$string['sessionperroomerror'] = 'An error occurred during session data gathering.<br /><br />Server provided the following answer: \"$a\".';
$string['skin'] = 'Style sheet file URL';
$string['speaker'] = 'Moderator';
$string['star'] = '*';
$string['start'] = 'Start';
$string['startdate'] = 'Videoconference date';
$string['starthour'] = 'Start time';
$string['starting'] = 'Starting at: ';
$string['streaming'] = 'streaming';
$string['student'] = 'Student';
$string['tab2page1'] = 'Log';
$string['tab2page2'] = 'Channel data';
$string['teacher'] = 'Teacher';
$string['title'] = 'Subject';
$string['todate'] = 'Date and time of the end of the record (GMT+0)';
$string['unlimitedrooms'] = 'Unlimited room number';
$string['uselessinstance'] = 'A technical probem occurred during videoconference join. Please contact technical assistance to rise up this prolem..';
$string['users'] = 'Number of concurrent user allowed in the videoconference room';
$string['webconference'] = 'Videoconference';
$string['tlive_clientcode'] = 'User code';
$string['tlive_cronrecs_settings'] = 'Update Teleskill Live repository';
$string['tlive_cronstats_settings'] = 'Update Teleskill Live reports';
$string['tlive_defaults_fs'] = 'Unique Channel Client Code';
$string['tlive_protocol'] = 'Web protocol';
$string['tlive_disabledate'] = 'Disable scheduling';
$string['tlive_admincf'] = 'All Admins are conference manager';
$string['tlive_admincf_desc'] = 'All Admins are conference manager';
$string['tlive_managercf'] = 'All system manager users are Conference Managers';
$string['tlive_managercf_desc'] = 'By applying this option, all system manager users are Conference Managers in all rooms';
$string['tlive_serverhost'] = 'Name or URL of the tlive server host';
$string['tlive_serverport'] = 'Web door';
$string['tlive:conferencemanagercandidate'] = 'Manage conference';
$string['tlive:addinstance'] = 'Add conference';
$string['tlive:managelogs'] = 'Manage log';
$string['tlive_maxusers'] = 'Max users';
$string['tlive_rec_player_width'] = 'Player width';
$string['tlive_rec_player_height'] = 'Player height';
$string['tlive_rec_player_responsive'] = 'Enable responsive player';
$string['tlive'] = 'Teleskill Live';
$string['tliveintro'] = 'Intro';
$string['tlivename'] = 'Nome';
$string['tlivespecific'] = 'Videoconference specific data';
$string['to'] = 'to ';
$string['to_day'] = 'To ';
$string['update'] = 'Update';
$string['update_err'] = 'Unable to update';
$string['stats_update'] = 'Update statistics';
$string['update_success'] = 'Success';
$string['user'] = 'User';
$string['willopentoblank'] = 'Videoconference will be opened in a new window';
$string['cancel'] = 'Cancel';
$string['save'] = 'Save';
$string['everyonewhocan'] = 'Everyone who can';
$string['activity'] = 'Activity';
$string['updatestatstask'] = 'Update statistics task';
$string['tlive_codicefiscalecode'] = 'Codice fiscale shortcode';
$string['tlive_codicefiscalecode_desc'] = 'If use codice fiscale field, Enter here shortcode';
$string['tlive_codicefiscale'] = 'Tax Code';
$string['total_access'] = 'Total Access';
$string['explain_maxmanager'] = 'Maximum number of conference manager';
$string['tlive_maxmanager'] = 'Maximum conference manager';
$string['tlivespecific_excelheader'] = 'Dati piano formativo';
$string['id_piano_formativo'] = 'ID Piano Formativo: ';
$string['piano_formativo'] = 'Piano Formativo: ';
$string['id_progetto'] = 'ID Progetto: ';
$string['id_edizione'] = 'ID Edizione: ';
$string['moodle_role'] = 'Ruolo Moodle';

/* Export - Verifica presenze */
$string['total_presence_check'] = 'Verifiche Totali';
$string['total_presence_passed'] = 'Verifiche Superate';
