<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Log summary page
 *
 * @package     mod_tlive
 * @copyright   Teleskill Italia S.r.l
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */


defined('MOODLE_INTERNAL') OR die('not allowed');

require_once('../../config.php');

/* $id, $rsid, $lsid, $psid, $pid, $opt declared in view.php
 * $xmlanswer = tlive_askforlogs($complete,  $tlive);
 * tlive_savelogs($xmlanswer);
 *
 * If $updstat=1, update statistics logs  (file updstat.php) */
$updstat = optional_param('upd_stat', 0, PARAM_INT);
$context = context_course::instance($COURSE->id);

if ($updstat==1) {

    $event = \mod_tlive\event\stats_update::create(array(
	    'objectid' => $tlive->id,
	    'context' => context_module::instance($cm->id)
	));
	$event->trigger();
	
    $complete = 0;
    $xmlanswer = tlive_askforlogs($complete,  $tlive);
    tlive_savelogs($xmlanswer);
    /* Updating activity completion for all participants */
    $completion = new completion_info($course);

    if ($completion->is_enabled($cm) && ($tlive->completiontlive || $tlive->completiontlivepoll) ) {

        /*  query to extract users from lessions
            $query = 'SELECT DISTINCT us.iduser, rs.roomid, ra.roleid FROM mdl_tlive_lesson_user_sessions as uls
            INNER JOIN mdl_tlive_user_sessions as us ON uls.usersessionid=us.usersessionid
            INNER JOIN mdl_tlive_rooms_sessions as rs ON us.roomsessionid=rs.roomsessionid
            INNER JOIN mdl_role_assignments as ra ON us.iduser=ra.userid
            WHERE rs.roomid=? AND ra.roleid=5';
        */
        /*  query to extract users from room sessions -->if and only if user is a student (roleid=5),
            check activity as completed
            $query = 'SELECT DISTINCT us.iduser FROM mdl_tlive_user_sessions as us
            INNER JOIN mdl_tlive_rooms_sessions as r ON us.roomsessionid = r.roomsessionid
            INNER JOIN mdl_role_assignments as ra ON us.iduser=ra.userid
            WHERE r.roomid=? AND ra.contextid=? AND ra.roleid=5';
        */
        /* query to extract users relative to Teleskill Live role
            -> if and only if user is not a conference managae */
            $query = 'SELECT DISTINCT us.iduser FROM {tlive_user_sessions} as us
            INNER JOIN {tlive_rooms_sessions} as r ON us.roomsessionid = r.roomsessionid
            WHERE r.roomid=?';

        if ($users = $DB->get_records_sql($query, array($tlive->roomid, $tlive->confmanid))) {
            foreach ($users as $user) {

                /* $user_role = get_user_roles($context, $user->iduser);
                updating activity completion for each user */
                $completion->update_state($cm, COMPLETION_COMPLETE, $user->iduser);

            }
        }
    }
}
/* Sessions summary */
$roominstance = $DB->get_field('course_modules', 'instance', array('id' => $id));
$roomrecord = $DB->get_record('tlive', array('id' => $roominstance));
$bln1 = false;
$bln2 = false;
if ($rsid == 0 && $lsid == 0) {

    $OUTPUT->box_start();

    /* Room sessions table */
    $tableroomsessions = new html_table();
    $tableroomsessions->head = array(get_string('session', 'tlive'), get_string('polls', 'tlive'), get_string('accesses', 'tlive'));
    $tableroomsessions->data = array();
    /*
     * Lesson sessions table
     */
    $tablelessonsessions = new html_table();
    $tablelessonsessions->head  = array(get_string('lesson_head', 'tlive'), get_string('accesses', 'tlive'), get_string('total_access', 'tlive'));
    $tablelessonsessions->data = array();
    echo "<h2>".$roomrecord->name."</h2>";

    if ($sessions = $DB->get_records('tlive_rooms_sessions', array('roomid' => $roomrecord->roomid), 'startdate, enddate ASC')) {
        $strfdate = get_string('displaydateformat',  'tlive');
        $strftime = get_string('displaytimeformat',  'tlive');

        foreach ($sessions as $s) {

            $sesstext = get_string("room_session",  "tlive").userdate($s->startdate, $strfdate).' ';
            $sesstext.= get_string("from", "tlive").userdate($s->startdate, $strftime).' ';
            $sesstext.= get_string("to", "tlive").userdate($s->enddate, $strftime);

            $pollslink = "<a href=\"?id=$id&tab=2&rsid=$s->roomsessionid\">".get_string('pollstext', 'tlive')."</a>";
            $sessionslink = "<a href=\"?id=$id&tab=2&rsid=$s->roomsessionid&opt=access\">".get_string('accesses', 'tlive')."</a>";

            $aux = array($sesstext, $pollslink, $sessionslink);
            array_push($tableroomsessions->data, $aux);

            $condition = array('roomsessionid' => $s->roomsessionid);
            $lessonsessions = $DB->get_records('tlive_lesson_sessions', $condition, 'startdate, enddate ASC');

            if ($lessonsessions) {

                foreach ($lessonsessions as $r) {

                    $sesstext = get_string("lesson",  "tlive").userdate($r->startdate, $strfdate).' ';
                    $sesstext .= get_string("from", "tlive").userdate($r->startdate, $strftime).' ';
                    $sesstext .= get_string("to", "tlive").date("G:i", $r->enddate);
                    $sessionslink = "<a href=\"?id=$id&rsid=$r->roomsessionid&tab=2&lsid=$r->lessonsessionid&opt=access\">";
                    $sessionslink .= get_string('accesses', 'tlive')."</a>";
                    $sessionsTotlink = "<a href=\"?id=$id&rsid=$r->roomsessionid&tab=2&lsid=$r->lessonsessionid&opt=access&total=total&roomid=$roominstance\">";
                    $sessionsTotlink .= get_string('total_access', 'tlive')."</a>";
                    $aux = array($sesstext, $sessionslink , $sessionsTotlink);
                    array_push($tablelessonsessions->data, $aux);
                }

                $bln2 = true;
            }
        }

        $bln1 = true;

    }
    echo "<h3>".get_string('room_sessions', 'tlive')."</h3>";

    if ($bln1) {

        echo html_writer::table($tableroomsessions);

    } else {

           echo get_string('nosessionperroomavailable', 'tlive');
    }
    if ($bln2) {

        echo "<h3>".get_string('room_lessons_sessions', 'tlive')."</h3>";
        echo html_writer::table($tablelessonsessions);

    }/* else {
    *   echo get_string('nosessionperroomavailable', 'tlive');
    *       } */
    $OUTPUT->box_end();
}