<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Retrieve polls data
 *
 * @package     mod_tlive
 * @copyright   Teleskill Italia S.r.l
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') OR die('not allowed');

/* $id, $rsid, $lsid, $psid, $pid, $opt declared in view.php */
if ($rsid!=0 && empty($opt)) {

    $OUTPUT->box_start();
    echo "<h3>".get_string('polls',  'tlive')."</h3>";
    $tablepolls = new html_table();
    $tablepolls->head  = array(get_string('poll',  'tlive'));
    $tablepolls->data = array();

    if (!$polls = $DB->get_records('tlive_polls', array('roomsessionid' => $rsid))) {

        echo get_string('nopollsavailable',  'tlive');

    } else {

        foreach ($polls as $p) {

            $link = "<a href=\"?id=$id&tab=2&pid=$p->pollid&rsid=$rsid\">".get_string("poll", "tlive").": ".$p->question."</a>";
            $aux = array($link);
            array_push($tablepolls->data, $aux);
        }
    }

    echo html_writer::table($tablepolls);
    
    $OUTPUT->box_end();
}