<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.
/**
 * Redirect tabs page
 *
 * @package     mod_tlive
 * @copyright   Teleskill Italia S.r.l
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
*/

defined('MOODLE_INTERNAL') OR die('not allowed');

/* $id, $rsid, $lsid, $psid, $pid, $opt , $total declared in view.php */
if (!empty($opt) && $opt == 'access') {

    $OUTPUT->box_start();
    $strfdate = get_string('displaydateformat',  'tlive');
    $strftime = get_string('displaytimeformat',  'tlive');

    /* Print title */
    if ($rsid != 0 && $lsid != 0) {

        $lessonsessionrecord = $DB->get_record('tlive_lesson_sessions', array('lessonsessionid' => $lsid));
        echo "<h3 style=\"text-align: center;font-weight: 400;\">".get_string('access_list', 'tlive')." - ".
        get_string("lesson",  "tlive").userdate($lessonsessionrecord->startdate, $strfdate)." ".get_string("from", "tlive").
        userdate($lessonsessionrecord->startdate, $strftime)." "
        .get_string("to", "tlive").userdate($lessonsessionrecord->enddate, $strftime)."</h3>";

    } else if ($rsid !=0) {

        $roomsessionrecord = $DB->get_record('tlive_rooms_sessions', array('roomsessionid' => $rsid));
        echo "<h3 style=\"text-align: center;font-weight: 400;\">".get_string('access_list', 'tlive')." - ".
        get_string("room_session",  "tlive").userdate($roomsessionrecord->startdate, $strfdate)." ".get_string("from", "tlive").
        userdate($roomsessionrecord->startdate, $strftime)." ".
        get_string("to", "tlive").userdate($roomsessionrecord->enddate, $strftime)."</h3>";

    }

    /* Sessions list */
    if ($rsid != 0) {

        /* Include JQuery libraries to print chart */
        $PAGE->requires->data_for_js('dirroot', $CFG->wwwroot);
        //$PAGE->requires->js( new moodle_url( $CFG->wwwroot . '/mod/tlive/javascript/lib/jquery/jquery.min.js'));
        $PAGE->requires->js( new moodle_url( $CFG->wwwroot . '/mod/tlive/javascript/user-access-chart.js' ));
        $PAGE->requires->js( new moodle_url( $CFG->wwwroot . '/mod/tlive/javascript/custom_data_table.js' ));

        /* User language choice for chart */
        $ln = array("en", "it", "es", "es_es");

        if (isset($SESSION->lang)) {
    
            if (in_array($SESSION->lang, $ln)) {
                $lang = $SESSION->lang;
            }else{
                $lang = $USER->lang;
            }
    
        }else{
    
            $lang = $USER->lang;
        }
        

        $PAGE->requires->js( new moodle_url ($CFG->wwwroot . '/mod/tlive/javascript/lib/charts/lang/'.$lang.'.js') );

        /* Print access chart */
        echo '<div style="width:85%; margin: auto;"><canvas id="canvas"></canvas></div>';

        /* Flag to call room session or lession session print */
        if ($lsid != 0) {

            $tableuserssessions = tlive_buildtableaccess($rsid, $lsid , $total);

        } else {

            $tableuserssessions = tlive_buildtableaccess($rsid);

        }

        $qrstr = $_SERVER["QUERY_STRING"];

        if ($tableuserssessions->data) {
            
            if (isset($total) && $total == 'total') {
                $tliveid = $tlive->id;
            } else {
                $tliveid = 0;
            }    


            echo "<div style=\"text-align:right;margin-bottom:1%;width:95%;font-weight:400;\">".get_string('export', 'tlive')."
            <form style=\"display: inline-block;\" id =\"test1\" action=\"$CFG->wwwroot/mod/tlive/logs/export-table.php\" method=\"post\"/> 
            <input type=\"hidden\" name=\"useraccesspdf\" id=\"useraccesspdf\" value=".base64_encode(json_encode($tableuserssessions))." />
            <input type=\"hidden\" name=\"tliveid\" id=\"tliveid\" value=" . $tliveid . " />
            <input type=\"submit\" value=\" \" formtarget=\"_blank\" style=\"background-image: url('$CFG->wwwroot/mod/tlive/javascript/lib/charts/images/pdf.png');
            border:none;width: 35px;height: 35px;display: inline;\"/></form>
            <form style=\"display: inline-block;\" id =\"test2\" action=\"$CFG->wwwroot/mod/tlive/logs/export-table.php\" method=\"post\"/> 
            <input type=\"hidden\" name=\"useraccessexc\" id=\"useraccessexc\" value=".base64_encode(json_encode($tableuserssessions))." />
            <input type=\"hidden\" name=\"tliveid\" id=\"tliveid\" value=" . $tliveid . " />
            <input type=\"submit\" value=\" \" formtarget=\"_blank\" style=\"background-image: url('$CFG->wwwroot/mod/tlive/javascript/lib/charts/images/xls.png');
            border:none;width: 35px;height: 35px;display: inline;\"/></form>
           </div>";

            if(!empty($CFG->tlive_codicefiscalecode)){ 

                $codicefiscalecode = $CFG->tlive_codicefiscalecode;
                
                $query = "SELECT ui.id, ui.data as codicefiscale
                FROM {user_info_data} AS ui    
                JOIN {user_info_field} as uif ON ui.fieldid = uif.id AND uif.shortname = '$codicefiscalecode' ";

                //check shortcode on database
                if (!$DB->get_records_sql($query)) {
                    echo  "<input type=\"hidden\" name=\"codicefiscaleck\" id=\"codicefiscaleck\" value=\"\" />";
                }else{
                    echo  "<input type=\"hidden\" name=\"codicefiscaleck\" id=\"codicefiscaleck\" value=".$CFG->tlive_codicefiscalecode." />";
                } 
                         
            }else{
                echo  "<input type=\"hidden\" name=\"codicefiscaleck\" id=\"codicefiscaleck\" value=\"\" />";
            }

            //check lesson id for datatable column
            if ($lsid != 0) {
                echo  "<input type=\"hidden\" name=\"lessonidck\" id=\"lessonidck\" value=".$lsid." />";
            }else{
                echo  "<input type=\"hidden\" name=\"lessonidck\" id=\"lessonidck\" value=\"\" />";
            }

            if (isset($total) && $total == 'total') {
                echo  "<input type=\"hidden\" name=\"totalck\" id=\"totalck\" value=".$total." />";
            }else{
                echo  "<input type=\"hidden\" name=\"totalck\" id=\"totalck\" value=\"\" />";
            }   

           ?>
                <!-- datatable for user access table-->
                <div style="overflow-x:auto;width:90%;text-align:center;margin:auto">
                    <table id="user-table" class="display" style="width:100%;">
                        <thead>
                            <tr>
                                            
                            </tr>
                        </thead>
                        <tfoot>
                            
                        </tfoot>
                    </table>
                </div>    

            <?php


        }
    }

    $OUTPUT->box_end();
}