<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Plugin administration pages are defined here.
 *
 * @package     mod_tlive
 * @category    admin
 * @copyright   Teleskill Italia S.r.l
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

//$PAGE->requires->js( new moodle_url($CFG->wwwroot . '/mod/tlive/javascript/lib/jquery/jquery.min.js') );
$PAGE->requires->js( new moodle_url($CFG->wwwroot . '/mod/tlive/javascript/settings.js.php') );

if ($ADMIN->fulltree) {

  // TODO: Define the plugin settings page.
  // https://docs.moodle.org/dev/Admin_settings

  $settings->add(new admin_setting_heading('tlive_defaultsettings_fs', get_string('configserver_fs', 'tlive'), ''));

  /* "tlive_protocol" field 
  $choices = array('http' => 'http', 'https' => 'https');
  $settings->add(new admin_setting_configselect('tlive_protocol', get_string('tlive_protocol', 'tlive'),
                    get_string('explain_protocol', 'tlive'), 'http', $choices));
  */

  /* "tlive_serverhost" field */
  $settings->add(new admin_setting_configtext('tlive_serverhost', get_string('tlive_serverhost', 'tlive'),
                    get_string('explain_serverhost', 'tlive'), 'https://asp.teleskill.it/tvclive/server-1-1.asp', PARAM_TEXT));

  /* "tlive_serverport" field 
  $settings->add(new admin_setting_configtext('tlive_serverport', get_string('tlive_serverport', 'tlive'),
                    get_string('explain_serverport', 'tlive'), '80', PARAM_TEXT));
  */

  $settings->add(new admin_setting_heading('tlive_defaults_fs', get_string('tlive_defaults_fs', 'tlive'), ''));

  /* "tlive_clientcode" field */
  $settings->add(new admin_setting_configtext('tlive_clientcode', get_string('tlive_clientcode', 'tlive'),
                    get_string('explain_clientcode', 'tlive'), '', PARAM_TEXT));

  /* "tlive_codicefiscale" field */
  $settings->add(new admin_setting_configtext('tlive_codicefiscalecode', get_string('tlive_codicefiscalecode', 'tlive'),
  get_string('tlive_codicefiscalecode_desc', 'tlive'), '', PARAM_TEXT));
                  

  /* "tlive_maxusers" field */
  $settings->add(new admin_setting_configtext('tlive_maxusers', get_string('tlive_maxusers', 'tlive'),
                                      get_string('explain_maxusers', 'tlive'), '1', PARAM_INT));
                                                                     
  /* "tlive_disabledate" field */
  $settings->add(new admin_setting_configcheckbox('tlive_disabledate', get_string('tlive_disabledate', 'tlive'),
                    get_string('explain_disabledate', 'tlive'), 0));                 

  /* "tlive_admincf" field */
  $settings->add(new admin_setting_configcheckbox('tlive_admincf', get_string('tlive_admincf', 'tlive'),
    get_string('tlive_admincf_desc', 'tlive'), 0));

  /* "tlive_managercf" field */
  $settings->add(new admin_setting_configcheckbox('tlive_managercf', get_string('tlive_managercf', 'tlive'),
    get_string('tlive_managercf_desc', 'tlive'), 0));

}
