<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * The task that provides a complete restore of mod_tlive is defined here.
 *
 * @package     mod_tlive
 * @category    restore
 * @copyright   Teleskill Italia S.r.l
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

// For more information about the backup and restore process, please visit:
// https://docs.moodle.org/dev/Backup_2.0_for_developers
// https://docs.moodle.org/dev/Restore_2.0_for_developers

require_once($CFG->dirroot.'//mod/tlive/backup/moodle2/restore_tlive_stepslib.php');

/**
 * Restore task for mod_tlive.
 */
class restore_tlive_activity_task extends restore_activity_task {

    /**
     * Define (add) particular settings this activity can have
     */
    protected function define_my_settings() {
        /* No particular settings for this activity */
    }

    /**
     * Define (add) particular steps this activity can have
     */
    protected function define_my_steps() {
        /* tlive only has one structure step */
        $this->add_step(new restore_tlive_activity_structure_step('tlive_structure', 'tlive.xml'));
    }

    /**
     * Define the contents in the activity that must be
     * processed by the link decoder
     */
    static public function define_decode_contents() {
        $contents = array();

        $contents[] = new restore_decode_content('tlive', array('intro'), 'tlive');

        return $contents;
    }

    /**
     * Define the decoding rules for links belonging
     * to the activity to be executed by the link decoder
     */
    static public function define_decode_rules() {
        $rules = array();

        $rules[] = new restore_decode_rule('TLIVEVIEWBYID', '/mod/tlive/view.php?id=$1', 'course_module');
        $rules[] = new restore_decode_rule('TLIVEINDEX', '/mod/tlive/index.php?id=$1', 'course');

        return $rules;

    }

    /**
     * Define the restore log rules that will be applied
     * by the {@link restore_logs_processor} when restoring
     * tlive logs. It must return one array
     * of {@link restore_log_rule} objects
     */
    static public function define_restore_log_rules() {
        $rules = array();

        $rules[] = new restore_log_rule('tlive', 'add', 'view.php?id={course_module}', '{tlive}');
        $rules[] = new restore_log_rule('tlive', 'update', 'view.php?id={course_module}', '{tlive}');
        $rules[] = new restore_log_rule('tlive', 'view', 'view.php?id={course_module}', '{tlive}');
        $rules[] = new restore_log_rule('tlive', 'join', 'login/join.php?id={course_module}&s='.session_id(), '{tlive}');
        $rules[] = new restore_log_rule('tlive', 'completion', 'view.php?id={course_module}', '{tlive}');

        return $rules;
    }

    /**
     * Define the restore log rules that will be applied
     * by the {@link restore_logs_processor} when restoring
     * course logs. It must return one array
     * of {@link restore_log_rule} objects
     *
     * Note this rules are applied when restoring course logs
     * by the restore final task, but are defined here at
     * activity level. All them are rules not linked to any module instance (cmid = 0)
     */
    static public function define_restore_log_rules_for_course() {
        $rules = array();

        $rules[] = new restore_log_rule('tlive', 'view all', 'index.php?id={course}', null);

        return $rules;
    }
}