var daystart,monthstart,yearstart,hourstart,minstart;
var dayend,monthend,yearend,hourend,minend;
var users,update;

var _dstart,_mstart,_ystart,_hstart,_minstart;
var _dend,_mend,_yend,_hend,_minend;

//return the entire query parameters without the question mark
var querystr = location.search.substring(1);
var dateInit;

if (querystr!=""){

  //Recovery from the query string of the start / end dates and number of users
  inputs = getQueryString(querystr);

  //input[0]->conference start date, input[1]->conference start date, input[2]->users, input[3]->event id

  yearstart = inputs[0].substring(0,4);
  monthstart = inputs[0].substring(4,6);
  daystart = inputs[0].substring(6,8);
  hourstart = inputs[0].substring(8,10);
  minstart = inputs[0].substring(10,12);

  yearend = inputs[1].substring(0,4);
  monthend = inputs[1].substring(4,6);
  dayend = inputs[1].substring(6,8);
  hourend = inputs[1].substring(8,10);
  minend = inputs[1].substring(10,12);

  users = inputs[2];


  var slotinterval = 5 ;

  //flag in case of editing of the conference
  update = inputs[3];

  //rewriting the date in the form YY/MM/DD
  dateaux = yearstart + "/" + monthstart + "/" + daystart;

  //creation of the date object, used to move the calendar to the week relative to the chosen day
  dateInit = new Date(dateaux);

}else{
  dateInit = new Date();
}
var scrollTime = moment().format("HH:mm");
document.addEventListener('DOMContentLoaded', function() {
    $.ajaxSetup( { "async": false } );
    var lang = "en";
    lang =document.getElementById("calendarlang").value;
    var calendarEl = document.getElementById('calendar');
    var calendar = new FullCalendar.Calendar(calendarEl, { 
      slotDuration: '00:05:00',
      headerToolbar: {
        left: 'dayGridMonth,timeGridWeek,timeGridDay',
        center: 'title',
        right: 'prev,next today'
      },
      buttonText:{
        today:    translation['today'],
        month:    translation['month'],
        week:     translation['week'],
        day:      translation['day'],
      },
      locale: lang,
      scrollTime: scrollTime,
      editable: true,
      draggable: true,
      allDaySlot: false,
      firstDay: 1,
      slotMinTime: "00:00",
      slotMaxTime: "24:00",
      slotLabelFormat: [
        {
          hour: '2-digit',
          minute: '2-digit',
          hour12:false,
        }
      ],
      dayMaxEvents: true, // when too many events in a day, show the popover

      eventTimeFormat: { 
        hour: '2-digit',
        minute: '2-digit',
        hour12:false,
      },

      events: {
        url: '../custom_event/events.php?s='+yearstart+monthstart+daystart+hourstart+minstart+'&e='+yearend+monthend+dayend+hourend+minend+'&u='+users+'&update='+update,
        method: 'GET',
        extraParams: { 
        },
        failure: function() {
          alert('there was an error while fetching events!');
        }
      },

      eventContent: function(eventInfo) {

        getStartEndEvent(eventInfo.event);

        var _start=_hstart+':'+_minstart;
        var _end=_hend+':'+_minend;
        var _d = _start +'-'+_end;

        return { html: '<div><h6><u>'+ _start + '-' + _end + '</u></h6><p style="font-weight: 400;">' + eventInfo.event.title +
        '<p/><p><img style="width: 30px;" src="images/conference.png"></p>' + eventInfo.event.extendedProps.users + '<div>' }
        
      },

      eventDidMount: function(info) {

        if (info.event.extendedProps.readonly === "true") {
            info.el.style.backgroundColor ="#dd0c0c";
        }

       /*  var el = document.createElement('div');
        var img = document.createElement('img');
        $(info.el).find('.fc-event-title-container').append("<img src='images/conference.png' alt='User Image' />");
        $(info.el).find('.fc-event-title-container').append('<p>'+info.event.extendedProps.users+'</p>'); */

        $(info.el).find(".fc-event-main").css({
          "text-align": "center",
          "font-size": "15px",
          "font-weight": "400"
        });
        
      },

      eventDrop: function(info) {
     
        getStartEndEvent(info.event);

        var _startdate=_ystart+_mstart+_dstart+_hstart+_minstart;
        var _enddate=_yend+_mend+_dend+_hend+_minend;

        var strJson = 'startdate='+_startdate+'&enddate='+_enddate+'&users='+info.event.extendedProps.users+'&update='+update;

        //check with json the availability of seats in the chosen time slot
        $.getJSON('../custom_calendar/check.php?'+strJson,function(json){
            
          var success=json.success;

          if(success==true){

            updateStartEndEvent(info.event);
            
            updateConferenceFields(info.event.start,info.event.end,info.event.extendedProps.users);
          
          }else{
            alert(translation['placeNotAvailable']);
          } 

        });
        
      },

      eventAllow: function(dropLocation, draggedEvent) {

        if (draggedEvent.extendedProps.readonly === "true") {
          return false;
        }
        else {
          return true;
        }

      },

      eventResize: function(info) {
        
        getStartEndEvent(info.event);

        var _startdate=_ystart+_mstart+_dstart+_hstart+_minstart;
        var _enddate=_yend+_mend+_dend+_hend+_minend;

        var strJson = 'startdate='+_startdate+'&enddate='+_enddate+'&users='+info.event.extendedProps.users+'&update='+update;

        //check with json the availability of seats in the chosen time slot
        $.getJSON('../custom_calendar/check.php?'+strJson,function(json){
            
          var success=json.success;

          if(success==true){

            updateStartEndEvent(info.event);
            
            updateConferenceFields(info.event.start,info.event.end,info.event.extendedProps.users);
          
          }else{
            alert(translation['placeNotAvailable']);
          } 

        });
        
      },
      
      eventClick:  function(info, jsEvent, view) {

        var eventObj = info.event;
          
        if (eventObj.extendedProps.readonly === "true") {
          return;
        }  
        
        var modelContent = $("#event_edit_container");
        resetForm(modelContent);
        $('#modalTitle').html(translation['edit']+" - "+eventObj.title);
        var startField = modelContent.find("select[name='start']").val(eventObj.start);
        var endField = modelContent.find("select[name='end']").val(eventObj.end);
        var usersField = modelContent.find("input[name='users']").val(eventObj.extendedProps.users);
        modelContent.find(".date_holder").text(moment(eventObj.start).format('MMM DD, YYYY'));

        setStarEndFields(startField,endField,slotinterval,eventObj);

        $('#fullCalModal').modal();

          $("#eventSave").on("click", function(e){

             
            var checknumeric = new RegExp("^[1-9]+[0-9]*$");

            if(checknumeric.test(usersField.val()) == false){
              alert(translation['insertUsers']);
            } else{

              getStartEndFields(new Date(startField.val()), new Date(endField.val()));

              var _startdate=_ystart+_mstart+_dstart+_hstart+_minstart;
              var _enddate=_yend+_mend+_dend+_hend+_minend;

              var strJson = 'startdate='+_startdate+'&enddate='+_enddate+'&users='+usersField.val()+'&update='+update;
              
              //check with json the availability of seats in the chosen time slot
              $.getJSON('../custom_calendar/check.php?'+strJson,function(json){
                 
                var success=json.success;

                if(success==true){

                  //passing dates and users from input fields
                  var event = calendar.getEventById(eventObj.id);
                  event.setStart(startField.val());
                  event.setEnd(endField.val());
                  event.setExtendedProp('users',usersField.val())

                  updateStartEndEvent(event);
                  
                  updateConferenceFields(event.start,event.end,event.extendedProps.users);
                  
                  $('#fullCalModal').modal('hide');
                  calendar.render();
                
                }else{
                  alert(translation['placeNotAvailable']);
                } 

              });
              
            }

          });
      }

    });

  calendar.changeView('timeGridWeek');
  
  calendar.render();

});

  
//Function getQueryStrings
function getQueryString(qs){

  var p = qs.split("?");
  var c = p[0].split("&");
  var start = c[0].split("=");
  var end = c[1].split("=");
  var users = c[2].split("=");
  var update= c[3].split("=");

  var dateSelected = new Array();

  //store in an array of start and end dates and the number of users
  dateSelected[0] = start[1];
  dateSelected[1] = end[1];
  dateSelected[2] = users[1];
  dateSelected[3] = update[1];

  return dateSelected;
} 

//Function that set Start and End fields
function setStarEndFields(startTimeField,endTimeField,slotinterval,eventObj){

  var startday,endday;
  startday = moment(eventObj.start).startOf('day');
  endday = moment(eventObj.end).endOf('day');

  var start = moment(startday, 'YYYY-MM-DD hh:mm a');
  var end = moment(endday, 'YYYY-MM-DD hh:mm a');

  // round starting minutes up to nearest 15 (12 --> 15, 17 --> 30)
  // note that 59 will round up to 60, and moment.js handles that correctly
  start.minutes(Math.ceil(start.minutes() / slotinterval) * slotinterval);

  var date = [];
  var dateFull = [];

  var current = moment(start);
  var eventStart = moment(moment(eventObj.start,'YYYY-MM-DD hh:mm a'));
  var eventEnd = moment(moment(eventObj.end,'YYYY-MM-DD hh:mm a'));

  while (current <= end) {
      date.push(current.format('HH:mm'));
      dateFull.push(current.format('YYYY-MM-DD HH:mm'));

      current.add(slotinterval, 'minutes');
  } 


  for(var i=0;i<date.length;i++){

    var startSelected = "";
    var endSelected = "";

    if ( dateFull[i] == (eventStart.format('YYYY-MM-DD HH:mm'))){
      startSelected = "selected=\"selected\"";
    }

    if (dateFull[i] == (eventEnd.format('YYYY-MM-DD HH:mm'))){
      endSelected = "selected=\"selected\"";
    }

    startTimeField.append("<option value=\"" + dateFull[i] + "\" " + startSelected + ">" + date[i] + "</option>");
    endTimeField.append("<option value=\"" + dateFull[i] + "\" " + endSelected + ">" + date[i] + "</option>");
  }  

  endTimeOptions = endTimeField.find("option");
  startTimeField.trigger("change");

}

var endTimeField = $("select[name='end']");
var endTimeOptions = endTimeField.find("option");

//reduces the end time options to be only after the start time options.
$("select[name='start']").change(function() {

  var startTime = $(this).find(":selected").val();
  var currentEndTime = endTimeField.find("option:selected").val();
  endTimeField.html(
    endTimeOptions.filter(function() {
        return startTime < $(this).val();
    })
  );

  var endTimeSelected = false;
  
  endTimeField.find("option").each(function() {
      if ($(this).val() === currentEndTime) {
        $(this).attr("selected", "selected");
        endTimeSelected = true;
        return false;
      }
  });

  if (!endTimeSelected) {
    //automatically select an end date 2 slots away.
    endTimeField.find("option:eq(1)").attr("selected", "selected");
  }

});


function resetForm(modelContent) {

  modelContent.find("input").val("");
  modelContent.find("textarea").val("");

  modelContent.find("select[name='start']").not(':first').remove();
  modelContent.find("select[name='end']").not(':first').remove();

  var sselect = document.getElementById("startselect");
  var length = sselect.options.length;
  for (i = length-1; i >= 0; i--) {
    sselect.options[i].remove();
  }

  var eselect = document.getElementById("endselect");
  var length = eselect.options.length;
  for (i = length-1; i >= 0; i--) {
    eselect.options[i].remove();
  }

}

//Function get start and end field
function getStartEndFields(dtmStartDate, dtmEndDate){

  _ystart = dtmStartDate.getFullYear();
  _mstart = pad((dtmStartDate.getMonth()+1).toString(),2);
  _dstart = pad(dtmStartDate.getDate().toString(),2);
  _hstart = pad(dtmStartDate.getHours().toString(),2);
  _minstart = pad(dtmStartDate.getMinutes().toString(), 2);

  _yend = dtmEndDate.getFullYear();
  _mend = pad((dtmEndDate.getMonth()+1).toString(),2);
  _dend = pad(dtmEndDate.getDate().toString(),2);
  _hend = pad(dtmEndDate.getHours().toString(),2);
  _minend = pad(dtmEndDate.getMinutes().toString(),2);

}

//Function update start end event fields
function updateStartEndEvent(calEvent){

  yearstart = calEvent.start.getFullYear();
  monthstart = pad((calEvent.start.getMonth()+1).toString(),2);
  daystart = pad(calEvent.start.getDate().toString(),2);
  hourstart = pad(calEvent.start.getHours().toString(),2);
  minstart = pad(calEvent.start.getMinutes().toString(), 2);

  yearend = calEvent.end.getFullYear();
  monthend = pad((calEvent.end.getMonth()+1).toString(),2);
  dayend = pad(calEvent.end.getDate().toString(),2);
  hourend = pad(calEvent.end.getHours().toString(),2);
  minend = pad(calEvent.end.getMinutes().toString(),2);

}

//Function update start end event conference fields
function updateConferenceFields(start,end,users){

  $('select[name="startdate[day]"]', window.opener.document ).val(start.getDate());
  $('select[name="startdate[month]"]', window.opener.document ).val(start.getMonth()+1);
  $('select[name="startdate[year]"]', window.opener.document ).val(start.getFullYear());
  $('select[name="starthour"]', window.opener.document ).val(start.getHours());
  $('select[name="startminute"]', window.opener.document ).val(start.getMinutes());

  $('select[name="enddate[year]"]', window.opener.document ).val(end.getFullYear());
  $('select[name="endhour"]', window.opener.document ).val(end.getHours());
  $('select[name="endminute"]', window.opener.document ).val(end.getMinutes());

  $( "#id_users", window.opener.document ).val(users);

}

//Function pad
function pad (str, max) {
  return str.length < max ? pad("0" + str, max) : str;
}

//Function start and end event
function getStartEndEvent(calEvent){

  _ystart = calEvent.start.getFullYear();
  _mstart = pad((calEvent.start.getMonth()+1).toString(),2);
  _dstart = pad(calEvent.start.getDate().toString(),2);
  _hstart = pad(calEvent.start.getHours().toString(),2);
  _minstart = pad(calEvent.start.getMinutes().toString(), 2);

  _yend = calEvent.end.getFullYear();
  _mend = pad((calEvent.end.getMonth()+1).toString(),2);
  _dend = pad(calEvent.end.getDate().toString(),2);
  _hend = pad(calEvent.end.getHours().toString(),2);
  _minend = pad(calEvent.end.getMinutes().toString(),2);

}

//Function bootstrap model draggable   
$('.modal-dialog').draggable();

$('#myModal').on('show.bs.modal', function() {

  $(this).find('.modal-body').css({
    'max-height': '100%'
  });

});