			
var queryString;          
var option = GetQueryStringParams('opt'); 

// set up moment and chartjs require
require.config({
    paths: {
    "moment": '../../../mod/tlive/javascript/lib/moment/moment.min',
    "chartjs": '../../../mod/tlive/javascript/lib/charts/Chart.min'
    }
});

//require tlive jquery
require(['jquery'], function ($) {

    $(document).ready(function () { 

        if(option=='answers'){
    
            var psid = GetQueryStringParams('psid')  		 	
            queryString='opt='+option+'&psid='+psid;
            text=translation['summary'];		 	
                                        
        }

        //Call getdatajson api for chart data
        $.getJSON(dirroot+'/mod/tlive/logs/getdatajson.php?'+queryString,function(result) { 

            //require chartjs,moment ,moment timezone
            require([dirroot+'/mod/tlive/javascript/lib/moment/moment-timezone.min.js'], function (moment) {                 
            
                require(['chartjs'], function(Chart) {
                
                    var labels = [], data = [];
            
                    $.each(result, function(i,d){

                        labels.push(d[0]);
                        data.push(d[1]);
                        
                    });
                
                    //canvas element
                    var canvas = document.getElementById('canvas');
                    new Chart(canvas, {
                        type: 'pie',
                        data: {
                            labels:labels,
                            datasets: [{
                                label: translation['poll_answer'],
                                data: data,
                                fill: true,
                                backgroundColor:'rgba(18, 18, 200, 0.7)'
                            }]
                        },
                        options: {
                            responsive: true,
                            title: {
                                display: true,
                                text: text
                            },
                            tooltips: {
                                callbacks: {
                                    label: function(tooltipItem, data) {                                    
                                        //tooltip show value as percentage
                                        let label = data.labels[tooltipItem.index];
                                        let dataset = data.datasets[tooltipItem.datasetIndex];
                                        let total = dataset.data.reduce(function(previousValue, currentValue, currentIndex, array) {
                                        return previousValue + currentValue;
                                        });
                                        let currentValue = dataset.data[tooltipItem.index];
                                        let percentage = Math.floor(((currentValue/total) * 100)+0.5);                                    
                                        return ' ' + label + ': ' + percentage + '%';

                                    }
                                }
                            }
                            
                        }
                    });
                    
                });

            });
        });    
    });

});

//Query string params function
function GetQueryStringParams(sParam)
{
    var sPageURL = window.location.search.substring(1);
    var sURLVariables = sPageURL.split('&');
    for (var i = 0; i < sURLVariables.length; i++) 
    {
        var sParameterName = sURLVariables[i].split('=');
        if (sParameterName[0] == sParam) 
        {
            return sParameterName[1];
        }
    }
}