<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Retrieve polls data
 *
 * @package     mod_tlive
 * @copyright   Teleskill Italia S.r.l
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
*/

require_once('../../../config.php');
require_once('../locallib.php');

ob_start(); 

if( isset($_POST['useraccesspdf']) && !empty($_POST['useraccesspdf']) ){
    $decoded = base64_decode($_POST["useraccesspdf"]);
    $user_access_table = json_decode($decoded); 
    tlive_exportpdf($user_access_table);
}

if( isset($_POST['useraccessexc']) && !empty($_POST['useraccessexc']) ){
    $decoded = base64_decode($_POST["useraccessexc"]);
    $user_access_table = json_decode($decoded); 
    tlive_exportxls($user_access_table);
}

if( isset($_POST['pollspdf']) && !empty($_POST['pollspdf']) ){
    $decoded = base64_decode($_POST["pollspdf"]);
    $polls_table = json_decode($decoded); 
    tlive_exportpdf($polls_table);
}

if( isset($_POST['pollsexc']) && !empty($_POST['pollsexc']) ){
    $decoded = base64_decode($_POST["pollsexc"]);
    $polls_table = json_decode($decoded); 
    tlive_exportxls($polls_table);
}



/**
 * This function exports an input html table to PDF , using TCPDF library
 *
 * @param object $table Html table object
 */
function tlive_exportpdf($table) {

    global $CFG , $COURSE;

    /* Load tcpdf library */
     require_once("$CFG->libdir/pdflib.php");

    /*  create new PDF document */
    $pdf = new pdf;

    // Set header data
    $pagetitlepdf = null;
    $pagetitlepdf = $COURSE->fullname;

    if(isset($_SERVER['HTTP_HOST'])){
        $web = $_SERVER['HTTP_HOST'];
    }else{
        $web = null;
    }

    $pdf->SetHeaderData('', '', $pagetitlepdf, $web);
    $pdf->setPrintHeader(true);
    $pdf->setPrintFooter(false);

    // set header fonts
    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
    
    /* set font */
    $pdf->SetFont('helvetica',  'B',  16);
    /*  add a page */
    $pdf->AddPage();
    $title = $table->title;
    $pdf->Write(0,  $title,  '',  0,  'C',  true,  0,  false,  false,  0);
    $pdf->SetFont('freesans',  '',  7);
    
    $html = tlive_buildhtmltable($table);

    $pdf->writeHTML(utf8_encode($html),  false,  false,  true,  false,  '');

    ob_end_clean();

    //Created file name based on title with grammer expression
    $data = $table->title;    
    $filename = substr($data, strpos($data, "-") + 1);
    $filename = preg_replace('/\s+/', '', $filename);
    $filename = str_replace("/","_",$filename);
    $filename = str_replace(":","_",$filename);
    $filename = $filename.".pdf";
    $filename = 'Export_'.$filename;
    $pdf->Output($filename,  'D');

}

/**
 * This function exports an input html table to Excel worksheet, using Moodle Excel library
 *
 * @param object $table Html table object
 */
function tlive_exportxls($table) {

    global $CFG , $COURSE;

    /* Moodle Excel lib */
    require_once("$CFG->libdir/excellib.class.php");

    //Created file name based on title with grammer expression
    $data = $table->title;    
    $filename = substr($data, strpos($data, "-") + 1);
    $filename = preg_replace('/\s+/', '', $filename);
    $filename = str_replace("/","_",$filename);
    $filename = str_replace(":","_",$filename);
    $filename = 'Export_'.$filename.".xls";
    
    /* Creating a workbook */
    $workbook = new MoodleExcelWorkbook("-");
    $workbook->send($filename);
    $myxls = $workbook->add_worksheet('Export');
    $myxls->set_column(0, 10, 30);

    /* Format style */
    $colnum = 0;
    $formatitle = $workbook->add_format();
    $formatitle->set_bold(3);
    $formatitle->set_size(16);
    $formathead = $workbook->add_format();
    $formathead->set_bold(1);
    $formathead->set_italic();
    $formathead->set_align('center');
    $formathead->set_bg_color('red');
    $formathead->set_fg_color('red');
    $formathead->set_size(14);
    $formathead->set_bottom(2);
    $formatrowodd = $workbook->add_format();
    $formatrowodd->set_bg_color('silver');
    $formatrowodd->set_fg_color('silver');
    $formatrowodd->set_bottom(2);
    $formatroweven = $workbook->add_format();
    $formatroweven->set_fg_color('white');
    $formatroweven->set_bg_color('white');
    $formatroweven->set_bottom(2);

    // Set header data
    $pagetitlexls = null;
    $pagetitlexls = $COURSE->fullname;

    if(isset($_SERVER['HTTP_HOST'])){
        $web = $_SERVER['HTTP_HOST'];
    }else{
        $web = null;
    }

    /* Xls Head Title*/
    $myxls->write(0, 0, $pagetitlexls, $formatitle);

     /* Xls Head url */
     $myxls->write(1, 0, $web, $formatitle);

     /* Xls Title */
     $myxls->write(3, 0, $table->title, $formatitle);

    $column = 0;
    $row = 5;

    /* Print table heading */
    foreach ($table->head as $h) {

        $myxls->write($row, $column, strip_tags($h), $formathead);
        $column++;
    }

    $row++;

    /* Print table body */
    foreach ($table->data as $data) {
        $column = 0;

        if ($row % 2!=0) {
            $formatrow = $formatrowodd;
        } else {
            $formatrow = $formatroweven;
        }

        foreach ($data as $d) {

            $myxls->write($row, $column, $d, $formatrow);
            $column++;
        }

        $row++;
    }

    $workbook->close();

}