<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Retrieve polls data
 *
 * @package     mod_tlive
 * @copyright   Teleskill Italia S.r.l
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
*/

 defined('MOODLE_INTERNAL') OR die('not allowed');
/*
 *$id, $rsid, $lsid, $psid, $pid, $opt declared in view.php
 */
$strfdate = get_string('displaydateformat', 'tlive');
$strftime = get_string('displaytimeformat', 'tlive');
/* Poll sessions list */
if ($pid != 0 && $rsid!=0) {

    $OUTPUT->box_start();
    echo "<h3 style=\"text-align: center;font-weight: 400;\">".get_string('poll_sessions', 'tlive')."</h3>";
    $tablepolls = new html_table();
    $tablepolls->head  = array(get_string('poll_session', 'tlive'), get_string('start', 'tlive'), get_string('end', 'tlive'));
    $tablepolls->data = array();
    $tablepolls->id = 'poll_sessions';

    if (!$pollssessions = $DB->get_records('tlive_polls_sessions', array('pollid' => $pid), 'opendate, closedate ASC')) {

        echo get_string('nosessionperpoolavailable', 'tlive');

    } else {

        foreach ($pollssessions as $p) {
            $pollsessiontext = "<a href=\"?id=$id&tab=2&rsid=$rsid&psid=$p->pollsessionid&opt=answers\">";
            $pollsessiontext.= get_string("poll_session",  "tlive").' '. userdate($p->opendate, $strfdate)."</a>";
            $start = userdate($p->opendate, $strftime);
            $end = ($p->closedate != 0) ? userdate($p->closedate, $strftime) : '';
            $aux = array($pollsessiontext, $start, $end);
            array_push($tablepolls->data, $aux);
        }

    }
    echo html_writer::table($tablepolls);
    $OUTPUT->box_end();
}
/* Print details flag (relative to a single poll session) */
if ($psid != 0 && $rsid!=0) {

    $pollrecord = $DB->get_record('tlive_polls_sessions', array('pollsessionid'=>$psid));

    /* Include JQuery libraries to print chart */
    $PAGE->requires->data_for_js('dirroot', $CFG->wwwroot);
    //$PAGE->requires->js( new moodle_url($CFG->wwwroot . '/mod/tlive/javascript/lib/jquery/jquery.min.js') );
    $PAGE->requires->js( new moodle_url($CFG->wwwroot . '/mod/tlive/javascript/polls-chart.js') );
    $PAGE->requires->js( new moodle_url( $CFG->wwwroot . '/mod/tlive/javascript/custom_data_table.js' ));

    /* Load user language */
    $ln = array("en", "it", "es", "es_es");

    if (isset($SESSION->lang)) {

        if (in_array($SESSION->lang, $ln)) {
            $lang = $SESSION->lang;
        }else{
            $lang = $USER->lang;
        }

    }else{

        $lang = $USER->lang;
    }
    
    $PAGE->requires->js( new moodle_url ($CFG->wwwroot . '/mod/tlive/javascript/lib/charts/lang/'.$lang.'.js') );

    $OUTPUT->box_start();
    $query = "SELECT p.question, ps.opendate, ps.closedate
    FROM {tlive_polls_sessions} as ps
    INNER JOIN {tlive_polls} as p ON ps.pollid=p.pollid
    WHERE ps.pollsessionid='$psid'";
    $poll = $DB->get_record_sql($query);
    echo "<h3 style=\"text-align: center;font-weight: 400;\">".get_string('question', 'tlive').": $poll->question,   ".get_string('poll_session', 'tlive').
    ' '.userdate($poll->opendate, $strfdate.' '.$strftime)." - ".userdate($poll->closedate, $strftime)."</h3>";

    /* Print donut chart */
    echo '<div style="width:70%;margin: auto;"><canvas id="canvas"></canvas></div>';

    /* Print user table with their answers */
    $table = tlive_buildtablepolls($psid);
    $qrstr = $_SERVER["QUERY_STRING"];

    
    echo "<div style=\"text-align:right;margin-bottom:1%;width:95%;font-weight:400;\">".get_string('export', 'tlive')."
    <form style=\"display: inline-block;\" id =\"test1\" action=\"$CFG->wwwroot/mod/tlive/logs/export-table.php\" method=\"post\"/> 
    <input type=\"hidden\" name=\"pollspdf\" id=\"pollspdf\" value=".base64_encode(json_encode($table))." />
    <input type=\"submit\" value=\" \" formtarget=\"_blank\" style=\"background-image: url('$CFG->wwwroot/mod/tlive/javascript/lib/charts/images/pdf.png');
    border:none;width: 35px;height: 35px;display: inline;\"/></form>
    <form style=\"display: inline-block;\" id =\"test2\" action=\"$CFG->wwwroot/mod/tlive/logs/export-table.php\" method=\"post\"/> 
    <input type=\"hidden\" name=\"pollsexc\" id=\"pollsexc\" value=".base64_encode(json_encode($table))." />
    <input type=\"submit\" value=\" \" formtarget=\"_blank\" style=\"background-image: url('$CFG->wwwroot/mod/tlive/javascript/lib/charts/images/xls.png');
    border:none;width: 35px;height: 35px;display: inline;\"/></form>
    </div>";

        //check if codicefiscale field exist 
        if(!empty($CFG->tlive_codicefiscalecode)){ 

            $codicefiscalecode = $CFG->tlive_codicefiscalecode;
            
            $query = "SELECT ui.data as codicefiscale
            FROM {user_info_data} AS ui    
            JOIN {user_info_field} as uif ON ui.fieldid = uif.id AND uif.shortname = '$codicefiscalecode' ";

            //check shortcode on database
            if (!$DB->get_records_sql($query)) {
                echo  "<input type=\"hidden\" name=\"codicefiscaleck\" id=\"codicefiscaleck\" value=\"\" />";
            }else{
                echo  "<input type=\"hidden\" name=\"codicefiscaleck\" id=\"codicefiscaleck\" value=".$CFG->tlive_codicefiscalecode." />";
            }          
        }else{
            echo  "<input type=\"hidden\" name=\"codicefiscaleck\" id=\"codicefiscaleck\" value=\"\" />";
        }

        ?>
            <!-- datatable for user access table-->
            <div style="overflow-x:auto;width:90%;text-align:center;margin:auto">
                <table id="poll-table" class="display" style="width:100%;">
                    <thead>
                        <tr>
                                        
                        </tr>
                    </thead>
                    <tfoot>
                        
                    </tfoot>
                </table>
            </div>    

        <?php
       

    $OUTPUT->box_end();

}