<?php

defined('ABSPATH') or die;

function tlive_install() {

	global $wpdb;
	global $tliveDBversion;

	$tliveDBversion = '1.1';
	require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );

	$rooms = $wpdb->prefix . 'tlive_rooms';
	$enrolments = $wpdb->prefix . 'tlive_enrolments';
	$roomslog = $wpdb->prefix . 'tlive_rooms_logs';
	$usersessions = $wpdb->prefix . 'tlive_user_sessions';
	$roomsessions = $wpdb->prefix . 'tlive_rooms_sessions';
	$lessonsessions = $wpdb->prefix . 'tlive_lesson_sessions';
	$lessonusersessions = $wpdb->prefix . 'tlive_lesson_user_sessions';
	$polls = $wpdb->prefix . 'tlive_polls';
	$pollssessions = $wpdb->prefix . 'tlive_polls_sessions';
	$pollsanswers = $wpdb->prefix . 'tlive_polls_answers';
	$userspollanswers = $wpdb->prefix . 'tlive_users_poll_answers';
	$presenceCheck = $wpdb->prefix . 'tlive_presence_check';
	$userPresence = $wpdb->prefix . 'tlive_user_presences';
	
	$query = "CREATE TABLE IF NOT EXISTS $rooms (
  			 id int(10) NOT NULL AUTO_INCREMENT,
  			 title varchar(100) NOT NULL,
  			 timestarted datetime DEFAULT NULL,
  			 timecompleted datetime DEFAULT NULL,
  			 roomid int(10) DEFAULT '0',
  			 users int(10) NOT NULL DEFAULT '0',
			 auto_enrol int(1) NOT NULL DEFAULT '0',
			 logo varchar(255) DEFAULT NULL,
			 banner varchar(255) DEFAULT NULL,
			 emailconfman int(1) NOT NULL DEFAULT '0',
			 emailusers int(1) NOT NULL DEFAULT '0',
			 PRIMARY KEY (id)
		    );";
	dbDelta($query);
	
	$query = " CREATE TABLE IF NOT EXISTS $enrolments (
  			 classroom_id int(10) NOT NULL AUTO_INCREMENT,
  			 user_id int(10) NOT NULL DEFAULT 0,
  			 role int(1) NOT NULL DEFAULT 1,
 		     PRIMARY KEY (classroom_id,user_id)
		    ); ";
	dbDelta($query);
	
	$query = "CREATE TABLE IF NOT EXISTS $roomslog (
  			   roomid int(10) NOT NULL,
  			  synchronized tinyint(1) DEFAULT NULL,
  			  PRIMARY KEY (roomid)
		    ); ";
	dbDelta($query);
	
	$query = "CREATE TABLE IF NOT EXISTS $usersessions (
  			  usersessionid int(10) NOT NULL,
  	          iduser int(10) DEFAULT NULL,
			  roomsessionid int(10) DEFAULT NULL,
			  roleid int(10) DEFAULT NULL,
			  startdate datetime DEFAULT NULL,
			  enddate datetime DEFAULT NULL,
			  ipaddress varchar(45) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
			  PRIMARY KEY (usersessionid)
		    ); ";
	dbDelta($query);
	
	$query = "CREATE TABLE IF NOT EXISTS $roomsessions (
  			  roomsessionid int(10) NOT NULL,
  			  roomid int(10) DEFAULT NULL,
              startdate datetime DEFAULT NULL,
              enddate datetime DEFAULT NULL,
              duration int(10) DEFAULT NULL,
              PRIMARY KEY (roomsessionid)
		    );";
	dbDelta($query);
	
	$query = "CREATE TABLE IF NOT EXISTS $lessonsessions (
  			  lessonsessionid int(10) NOT NULL,
              roomsessionid int(10) DEFAULT NULL,
              startdate datetime DEFAULT NULL,
              enddate datetime DEFAULT NULL,
              duration int(10) DEFAULT '0',
              PRIMARY KEY (lessonsessionid)
		    );";
	dbDelta($query);
	
	$query = "CREATE TABLE IF NOT EXISTS $lessonusersessions (
  			 sessionid int(10) NOT NULL AUTO_INCREMENT,
  			 lessonsessionid int(10) DEFAULT NULL,
             usersessionid int(10) DEFAULT NULL,
             startdate datetime DEFAULT NULL,
             enddate datetime DEFAULT NULL,
             duration int(10) DEFAULT NULL,
             PRIMARY KEY (sessionid)
		    );";
	dbDelta($query);
	
	$query = "CREATE TABLE IF NOT EXISTS $polls (
  			  pollid int(10) NOT NULL,
  			  question longtext CHARACTER SET utf8 COLLATE utf8_unicode_ci,
              roomsessionid int(10) DEFAULT '0',
              PRIMARY KEY (pollid)
		    );";
	dbDelta($query);
	
	$query = "CREATE TABLE IF NOT EXISTS $pollssessions (
  			  pollsessionid int(10) NOT NULL,
  			  pollid int(10) DEFAULT NULL,
              opendate datetime DEFAULT NULL,
              closedate datetime DEFAULT NULL,
              PRIMARY KEY (pollsessionid)
		    );";
	dbDelta($query);
	
	$query = "CREATE TABLE IF NOT EXISTS $pollsanswers (
  			  answerid int(10) NOT NULL,
              pollid int(10) DEFAULT NULL,
              answer longtext CHARACTER SET utf8 COLLATE utf8_unicode_ci,
              sequence int(10) DEFAULT '0',
              correct tinyint(1) DEFAULT '0',
              PRIMARY KEY (answerid)
		    );";
	dbDelta($query);
	
	$query = "CREATE TABLE IF NOT EXISTS $userspollanswers (
  			  userspollanswerid int(10) NOT NULL,
  			  pollsessionid int(10) DEFAULT NULL,
              usersessionid int(10) DEFAULT NULL,
              answerid int(10) DEFAULT NULL,
              creationdate datetime DEFAULT NULL,
              PRIMARY KEY (userspollanswerid)
		    );";
	dbDelta($query);

	$query = "CREATE TABLE IF NOT EXISTS $presenceCheck (
				presence_id int(10) NOT NULL,
				lesson_session_id int(10) DEFAULT NULL,
				creation_date datetime DEFAULT NULL,
				PRIMARY KEY (presence_id)
			);";
	dbDelta($query);

	$query = "CREATE TABLE IF NOT EXISTS $userPresence (
				user_presences_id int(10) NOT NULL,
				presence_id int(10) DEFAULT NULL,
				user_session_id int(10) DEFAULT NULL,
				creation_date datetime DEFAULT NULL,
				PRIMARY KEY (user_presences_id)
			);";
	dbDelta($query);

	/* save tlive db version for next updates */
	add_option("tlive_db_version", $tliveDBversion);
}
function tlive_uninstall() {}

// Callback function
function settingsLink($links) {
    $settingsLink = '<a href="admin.php?page=tlive-settings">Settings</a>';
    array_push($links, $settingsLink);
    return $links;
}
