var dstart, mstart, ystart, hstart, minstart;
var dend, mend, yend, hend, minend;
var users, update;
var startdate, enddate

var _dstart, _mstart, _ystart, _hstart, _minstart;
var _dend, _mend, _yend, _hend, _minend;


jQuery(document).ready(function($) {

   var $calendar = $('#calendar');
   var id = 10;

   //flag che abilita la creazione o meno di un singolo evento
   var count = 0;

   //recupero della querystring
   var qs = location.search.substring(1);
   var dateInit;
   var lastId;

   //disabilita l'asincronia delle chiamate per evitare comportamenti anomali nel caricamento degli eventi, quando si naviga tra una settimana e l'altra
   $.ajaxSetup( { "async": false } );

   if (qs != "") {

   //recupero dalla querystring delle date di inizio/fine e numero utenti
   inputs = getQueryString(qs);

   //input[0]->dati inizio conferenza, input[1]->dati fine conferenza, input[2]->n utenti, input[3]->id evento

   ystart = inputs[0].substring(0,4);
   mstart = inputs[0].substring(4,6);
   dstart = inputs[0].substring(6,8);
   hstart = inputs[0].substring(8,10);
   minstart = inputs[0].substring(10,12);

   yend = inputs[1].substring(0,4);
   mend = inputs[1].substring(4,6);
   dend = inputs[1].substring(6,8);
   hend = inputs[1].substring(8,10);
   minend = inputs[1].substring(10,12);

   users = inputs[2];

   //flag in caso di edit della conferenza
   update = inputs[3];

   //riscrittura della data nella forma YY/MM/DD
   dateaux = ystart + "/" + mstart + "/" + dstart;

   //creazione dell'oggetto data, utilizzato per spostare il calendario alla settimana relativa al giorno scelto
   dateInit = new Date(dateaux);

  } else {
    dateInit = new Date();
  }

   $calendar.weekCalendar({

      timeslotsPerHour : 12 ,
      allowCalEventOverlap : true,
      overlapEventsSeparate: true,
      firstDayOfWeek : 1,
      businessHours :{start: 0, end: 24, limitDisplay: true },
      use24Hour: true,
      daysToShow : 7,
      timeSeparator: " - ",
      timeFormat : "H:i",
      longMonths: translation['longMonths'],
      shortMonths: translation['shortMonths'],
      shortDays: translation['shortDays'],
      longDays: translation['longdays'],
      newEventText: translation['newEventText'],
      buttonText :{
        today : translation['today'],
         lastWeek : "&nbsp;&lt;&nbsp;",
         nextWeek : "&nbsp;&gt;&nbsp;"
      },

      height : function($calendar) {
         return $(window).height() - $("h1").outerHeight() - 1;
      },

      data: '../wp-content/plugins/teleskill-tlive/admin/services/getEvents.php?s='+ystart+mstart+dstart+hstart+minstart+'&e='+yend+mend+dend+hend+minend+'&u='+users+'&update='+update,

      eventRender : function(calEvent, $event) {
//         if (calEvent.end.getTime() < new Date().getTime()) {
//            $event.css("backgroundColor", "#aaa");
//            $event.find(".wc-time").css({
//               "backgroundColor" : "#999",
//               "border" : "1px solid #888"
//            });

         //}

         //$event.css("backgroundColor", "#dd0c0c");

         $event.find(".wc-users").css({
            "font-size":  "medium",
         });

         $event.find(".wc-title").css({
            "font-size":  "large",
            "font-weight": "bold"
         });

         $event.find(".wc-time").css({
            "font-size":  "medium",
            "font-weight": "bold"
         });

         //se la propriet� custom readonly specificata nel json � true rendi non modificabile l'evento
         if(calEvent.readonly == "true") {
            calEvent.readOnly = true;
            $event.css("backgroundColor", "#dd0c0c");
         }
      },
      draggable : function(calEvent, $event) {
         return calEvent.readOnly != true;
      },
      resizable : function(calEvent, $event) {
         return calEvent.readOnly != true;
      },
      eventNew : function(calEvent, $event) {

            if(count == 1) {

               var $dialogContent = $("#event_edit_container");
               resetForm($dialogContent);
               var startField = $dialogContent.find("select[name='start']").val(calEvent.start);
               var endField = $dialogContent.find("select[name='end']").val(calEvent.end);
               var usersField = $dialogContent.find("input[name='users']");
               //var bodyField = $dialogContent.find("textarea[name='body']");

               var buttonsOpts = {};

               buttonsOpts[translation['buttonSave']] = function() {
                  //verifica tramite json che ci siano posti disponibili
                  var checknumeric = new RegExp("^[1-9]+[0-9]*$");

                  if(checknumeric.test(usersField.val()) == false) {
                     alert(translation['insertUsers']);
                  } else {
                     getStartEndFields(new Date(startField.val()), new Date(endField.val()));

                     var _startdate=_ystart+_mstart+_dstart+_hstart+_minstart;
                     var _enddate=_yend+_mend+_dend+_hend+_minend;

                     var strJson = 'startdate='+_startdate+'&enddate='+_enddate+'&users='+usersField.val()+'&update='+update;

                     $.getJSON('services/checkEvent.php?'+strJson,function(json){

                        var success = json.success;

                        if(success == true) {
                           //alert(success)
                           calEvent.title = translation['newEventText'];
                           calEvent.start = new Date(startField.val());
                           calEvent.end = new Date(endField.val());
                           calEvent.users = usersField.val();

                           //aggiornamento dei campi data e utenti per la generazione della chiamata json
                           updateStartEndEvent(calEvent);
                           startdate=ystart+mstart+dstart+hstart+minstart;
                           enddate=yend+mend+dend+hend+minend;

                           calEvent.id = id;
                           id++;
                           //calEvent.body = bodyField.val();

                           $calendar.weekCalendar("removeUnsavedEvents");
                           $calendar.weekCalendar("updateEvent", calEvent);
                           $dialogContent.dialog("close");

                           updateConferenceFields(calEvent.start, calEvent.end, calEvent.users, calEvent);

                           count = 0;
                        } else {
                           alert(translation['placeNotAvailable']);
                        }

                     });
                  }
               };

               buttonsOpts[translation['buttonCancel']] = function() {
                                                            $dialogContent.dialog("close");
                                                         };

               $dialogContent.dialog({
                  modal: true,
                  title: translation['insertConference'],
                  close: function() {
                     $dialogContent.dialog("destroy");
                     $dialogContent.hide();
                     $('#calendar').weekCalendar("removeUnsavedEvents");
                  },
                  buttons: buttonsOpts
               }).show();

               $dialogContent.find(".date_holder").text($calendar.weekCalendar("formatDate", calEvent.start));
               setupStartAndEndTimeFields(startField, endField, calEvent, $calendar.weekCalendar("getTimeslotTimes", calEvent.start));

            } else {
               $calendar.weekCalendar("removeEvent", calEvent.id);
               $dialogContent.dialog("close");
            }
      },
      eventDrop : function(newCalEvent, oldCalEvent, element) {

        getStartEndEvent(newCalEvent);

        var _startdate=_ystart+_mstart+_dstart+_hstart+_minstart;
        var _enddate=_yend+_mend+_dend+_hend+_minend;

        var strJson = 'startdate='+_startdate+'&enddate='+_enddate+'&users='+newCalEvent.users+'&update='+update;

         $.getJSON('services/checkEvent.php?'+strJson,function(json){

         var success = json.success;

         if(success == true){
               //alert(success)
               updateStartEndEvent(newCalEvent);

               startdate=ystart+mstart+dstart+hstart+minstart;
               enddate=yend+mend+dend+hend+minend;

               updateConferenceFields(newCalEvent.start, newCalEvent.end, newCalEvent.users, newCalEvent);

         } else {
               $calendar.weekCalendar("removeEvent",oldCalEvent.id);
               $("#calendar").weekCalendar("updateEvent", oldCalEvent);

               alert(translation['placeNotAvailable']);
         }

         });
        //updateConferenceFields(newCalEvent.start,newCalEvent.end,newCalEvent.users);
        //updateStartEndEvent(newCalEvent);

      },
      eventResize : function(newCalEvent, oldCalEvent, element) {

        //recupero delle parti che compongono le date, necessarie per costruire la querystring da passare al json
        getStartEndEvent(newCalEvent);

        var _startdate=_ystart+_mstart+_dstart+_hstart+_minstart;
        var _enddate=_yend+_mend+_dend+_hend+_minend;

        var strJson = 'startdate='+_startdate+'&enddate='+_enddate+'&users='+newCalEvent.users+'&update='+update;

        //invocazione della pagina di verifica json
        $.getJSON('services/checkEvent.php?'+strJson,function(json){

        //recupero del valore true/false restituito dalla pagina json
        var success = json.success;

        if(success == true) {
            //alert(success)

            //aggiornamento delle variabili globali di giorno,mese,anno,orario
            updateStartEndEvent(newCalEvent);

            startdate=ystart+mstart+dstart+hstart+minstart;
            enddate=yend+mend+dend+hend+minend;

            updateConferenceFields(newCalEvent.start, newCalEvent.end, newCalEvent.users, newCalEvent);

        }else {
            $calendar.weekCalendar("removeEvent",oldCalEvent.id);
            $("#calendar").weekCalendar("updateEvent", oldCalEvent);
            alert(translation['placeNotAvailable']);

        }

      });

      },
      eventClick : function(calEvent, $event) {

         if (calEvent.readOnly) {
            return;
         }

         var $dialogContent = $("#event_edit_container");
         resetForm($dialogContent);

         var startField = $dialogContent.find("select[name='start']").val(calEvent.start);
         var endField = $dialogContent.find("select[name='end']").val(calEvent.end);
         var usersField = $dialogContent.find("input[name='users']").val(calEvent.users);

         var buttonsOpts = {};

         buttonsOpts[translation['buttonSave']] = function() {
            var checknumeric = new RegExp("^[1-9]+[0-9]*$");

            if(checknumeric.test(usersField.val()) == false){
               alert(translation['insertUsers']);
            } else {

               getStartEndFields(new Date(startField.val()), new Date(endField.val()));

               var _startdate=_ystart+_mstart+_dstart+_hstart+_minstart;
               var _enddate=_yend+_mend+_dend+_hend+_minend;

               var strJson = 'startdate='+_startdate+'&enddate='+_enddate+'&users='+usersField.val()+'&update='+update;

               //verifica tramite json la disponibilit� di posti nella fascia oraria scelta
               $.getJSON('services/checkEvent.php?'+strJson,function(json) {

                  var success = json.success;

                  if(success == true) {
                     //passaggio delle date e utenti dai campi input
                     calEvent.start = new Date(startField.val());
                     calEvent.end = new Date(endField.val());
                     calEvent.users = usersField.val();

                     updateStartEndEvent(calEvent);
                     startdate=ystart+mstart+dstart+hstart+minstart;
                     enddate=yend+mend+dend+hend+minend;
                     //alert(success)
                     updateConferenceFields(calEvent.start, calEvent.end, calEvent.users, calEvent);
                     $calendar.weekCalendar("updateEvent", calEvent);
                     $dialogContent.dialog("close");
                     count=0;
                  } else {
                     alert(translation['placeNotAvailable']);
                  }
               });
            }
         };

         buttonsOpts[translation['buttonDelete']] = function() {
                  $calendar.weekCalendar("removeEvent", calEvent.id);
                  //flag che segnala l'azzeramento della querystring relativa al caricamento dell'evento temporaneamente memorizzato
                  var del=1;
                  updateStartEndEvent(calEvent,del);
                  $dialogContent.dialog("close");
                  count=1;
               };

         buttonsOpts[translation['buttonCancel']] = function() {
                  $dialogContent.dialog("close");
               }

         //var bodyField = $dialogContent.find("textarea[name='body']");
         //bodyField.val(calEvent.body);

         $dialogContent.dialog({
            modal: true,
            //title: "Edit - " + calEvent.title,
            title: translation['edit'] + " - " + calEvent.title,
            close: function() {
               $dialogContent.dialog("destroy");
               $dialogContent.hide();
               $('#calendar').weekCalendar("removeUnsavedEvents");
            },
            buttons: buttonsOpts
         }).show();

         var startField = $dialogContent.find("select[name='start']").val(calEvent.start);
         var endField = $dialogContent.find("select[name='end']").val(calEvent.end);
         $dialogContent.find(".date_holder").text($calendar.weekCalendar("formatDate", calEvent.start));
         setupStartAndEndTimeFields(startField, endField, calEvent, $calendar.weekCalendar("getTimeslotTimes", calEvent.start));
         $(window).resize().resize(); //fixes a bug in modal overlay size ??
      },
      eventMouseover : function(calEvent, $event) {
      },
      eventMouseout : function(calEvent, $event) {
      },
      noEvents : function() {

      },
      //data : function(start, end, callback) {
     //    callback(getEventData());
      //}
   });

   //caricamento della settimana relativa al giorno dell'evento
   $calendar.weekCalendar("gotoWeek", dateInit);

   function getQueryString(qs){
      //var pos =qs.indexOf("=");
      //dateSelected = qs.substring(pos+1,qs.length);
      var p = qs.split("?");
      var c = p[0].split("&");
      var start = c[0].split("=");
      var end = c[1].split("=");
      var users = c[2].split("=");
      var update= c[3].split("=");

      var dateSelected = new Array();

      //memorizza in un array le date di inizio e fine ed il numero di utenti
      dateSelected[0] = start[1];
      dateSelected[1] = end[1];
      dateSelected[2] = users[1];
      dateSelected[3] = update[1];

      return dateSelected;
   }

   function resetForm($dialogContent) {
      $dialogContent.find("input").val("");
      $dialogContent.find("textarea").val("");
   }

   //  function getEventData() {
   //
   //        alert("getEventData");
   //      var year = new Date().getFullYear();
   //      var month = new Date().getMonth();
   //      var day = new Date().getDate();
   //
   //
   //
   //      return {
   //         events : [
   //            {
   //               "id":1,
   //               "start": new Date(year, month, day, 12),
   //               "end": new Date(year, month, day, 13, 30),
   //               "users":"Lunch with Mike"
   //            },
   //            {
   //               "id":2,
   //               "start": new Date(year, month, day, 14),
   //               "end": new Date(year, month, day, 14, 45),
   //               "users":"Dev Meeting"
   //            }
   //
   //         ]
   //      };
   //   }

   /*
    * Sets up the start and end time fields in the calendar event
    * form for editing based on the calendar event being edited
    */
   function setupStartAndEndTimeFields($startTimeField, $endTimeField, calEvent, timeslotTimes) {

      console.log('startTimeField', $startTimeField);
      console.log('endTimeField', $endTimeField);
      console.log('calEvent', calEvent);
      console.log('timeslotTimes', timeslotTimes);

      for (var i = 0; i < timeslotTimes.length; i++) {
         var startTime = timeslotTimes[i].start;
         var endTime = timeslotTimes[i].end;
         var startSelected = "";
         if (startTime.getTime() === calEvent.start.getTime()) {
            startSelected = "selected=\"selected\"";
         }
         var endSelected = "";
         if (endTime.getTime() === calEvent.end.getTime()) {
            endSelected = "selected=\"selected\"";
         }
         $startTimeField.append("<option value=\"" + startTime + "\" " + startSelected + ">" + timeslotTimes[i].startFormatted + "</option>");
         $endTimeField.append("<option value=\"" + endTime + "\" " + endSelected + ">" + timeslotTimes[i].endFormatted + "</option>");

      }
      $endTimeOptions = $endTimeField.find("option");
      $startTimeField.trigger("change");
   }

   var $endTimeField = $("select[name='end']");
   var $endTimeOptions = $endTimeField.find("option");

   //reduces the end time options to be only after the start time options.
   $("select[name='start']").change(function() {
      
      var startTime = $(this).find(":selected").val();
      var currentEndTime = $endTimeField.find("option:selected").val();
      
      $endTimeField.html(
         $endTimeOptions.filter(function() {
            return startTime < $(this).val();
         })
      );

      var endTimeSelected = false;

      $endTimeField.find("option").each(function() {
         if ($(this).val() === currentEndTime) {
            $(this).attr("selected", "selected");
            endTimeSelected = true;
            return false;
         }
      });

      if (!endTimeSelected) {
         //automatically select an end date 2 slots away.
         $endTimeField.find("option:eq(1)").attr("selected", "selected");
      }

   });

   //aggiunta zeri significativi
   function pad (str, max) {
      return str.length < max ? pad("0" + str, max) : str;
   }

   //aggiornamento dei campi della form
   function updateConferenceFields(start, end, users, calEventObj) {

      newStartDate = calEventObj.start.getFullYear() + '-' + pad((calEventObj.start.getMonth()+1).toString(),2) + '-' + pad(calEventObj.start.getDate().toString(), 2);
      newStartTime = pad(calEventObj.start.getHours().toString(), 2) + ':' + pad(calEventObj.start.getMinutes().toString(), 2);
      newEndTime = pad(calEventObj.end.getHours().toString(), 2) + ':' + pad(calEventObj.end.getMinutes().toString(), 2);

      $('#eventDate', window.opener.document).val(newStartDate);
      $('#startTime', window.opener.document).attr({'value': newStartTime})
      $('#endTime', window.opener.document).attr({'value': newEndTime})
      $('#usersNumber', window.opener.document).val(users);
   }

   //scompattazione delle date per costruire la querystring, a partire dai valori della form d'input
   function getStartEndFields(dtmStartDate, dtmEndDate) {

      _ystart = dtmStartDate.getFullYear();
      _mstart = pad((dtmStartDate.getMonth()+1).toString(), 2);
      _dstart = pad(dtmStartDate.getDate().toString(), 2);
      _hstart = pad(dtmStartDate.getHours().toString(), 2);
      _minstart = pad(dtmStartDate.getMinutes().toString(), 2);

      _yend = dtmEndDate.getFullYear();
      _mend = pad((dtmEndDate.getMonth()+1).toString(), 2);
      _dend = pad(dtmEndDate.getDate().toString(), 2);
      _hend = pad(dtmEndDate.getHours().toString(), 2);
      _minend = pad(dtmEndDate.getMinutes().toString(), 2);

   }

   //scompattazione delle date (variabili locali) per costruire la querystring a partire dall'oggetto evento
   function getStartEndEvent(calEvent) {

      _ystart = calEvent.start.getFullYear();
      _mstart = pad((calEvent.start.getMonth()+1).toString(), 2);
      _dstart = pad(calEvent.start.getDate().toString(), 2);
      _hstart = pad(calEvent.start.getHours().toString(), 2);
      _minstart = pad(calEvent.start.getMinutes().toString(), 2);

      _yend = calEvent.end.getFullYear();
      _mend = pad((calEvent.end.getMonth()+1).toString(), 2);
      _dend = pad(calEvent.end.getDate().toString(), 2);
      _hend = pad(calEvent.end.getHours().toString(), 2);
      _minend = pad(calEvent.end.getMinutes().toString(), 2);

   }

   //scompattazione delle date (variabili globali) per costruire la querystring a partire dall'oggetto evento
   function updateStartEndEvent(calEvent, del){

      if(del != 1) {

         ystart = calEvent.start.getFullYear();
         mstart = pad((calEvent.start.getMonth()+1).toString(), 2);
         dstart = pad(calEvent.start.getDate().toString(), 2);
         hstart = pad(calEvent.start.getHours().toString(), 2);
         minstart = pad(calEvent.start.getMinutes().toString(), 2);

         yend = calEvent.end.getFullYear();
         mend = pad((calEvent.end.getMonth()+1).toString(), 2);
         dend = pad(calEvent.end.getDate().toString(), 2);
         hend = pad(calEvent.end.getHours().toString(), 2);
         minend = pad(calEvent.end.getMinutes().toString(), 2);

      } else {
         yestart = mstart = dstart = 0;
      }
   }
});