<?php

add_action('admin_menu', 'addMenuVoices');

// Callback function
function addMenuVoices() {
    add_menu_page(
        __('Teleskill Live 6.0 - Manage room', 'teleskill-tlive'),
        __('Teleskill Live 6.0', 'teleskill-tlive'),
        'read',
        'tlive-rooms',
        'listRoomCallback',
        TLIVE_URL . 'admin/img/ico.png',
        110
    );
    
    add_submenu_page('tlive-rooms', __('Rooms list', 'teleskill-tlive'), __('Rooms list', 'teleskill-tlive'), 'read', 'tlive-rooms', 'listRoomCallback');
    add_submenu_page('tlive-rooms', __('Add New Room', 'teleskill-tlive'), __('Add New Room', 'teleskill-tlive'), 'administrator', 'tlive-manage-room', 'manageRoomCallback');
    add_submenu_page('tlive-rooms', __('Settings', 'teleskill-tlive'), __('Settings', 'teleskill-tlive'), 'administrator', 'tlive-settings', 'pluginSettingsCallback');

    add_submenu_page('', __('Teleskill Live Access', 'teleskill-tlive'), __('Teleskill Live Access', 'teleskill-tlive'), 'read', 'tlive-room-login', 'roomLoginCallback');
    add_submenu_page('', __('Room Sessions', 'teleskill-tlive'), __('Room Sessions', 'teleskill-tlive'), 'publish_pages', 'tlive-rooms-sessions', 'roomSessionsCallback');
    add_submenu_page('', __('Room Access', 'teleskill-tlive'), __('Room Access', 'teleskill-tlive'), 'publish_pages', 'tlive-room-access', 'roomAccessCallback');
    add_submenu_page('', __('Lesson Access', 'teleskill-tlive'), __('Lesson Access', 'teleskill-tlive'), 'publish_pages', 'tlive-lesson-access','lessonAccessCallback');
    add_submenu_page('', __('Lesson Access', 'teleskill-tlive'), __('Lesson Access', 'teleskill-tlive'), 'publish_pages', 'tlive-lesson-totalaccess','lessonTotalAccessCallback');
    add_submenu_page('', __('Polls', 'teleskill-tlive'), __('Polls', 'teleskill-tlive'), 'publish_pages', 'tlive-polls', 'pollsCallback');
    add_submenu_page('', __('Poll Sessions', 'teleskill-tlive'), __('Poll Sessions', 'teleskill-tlive'), 'publish_pages', 'tlive-poll-sessions','pollSessionsCallback');
    add_submenu_page('', __('Poll Session', 'teleskill-tlive'), __('Poll Session', 'teleskill-tlive'), 'publish_pages', 'tlive-poll-session', 'pollSessionCallback');
    add_submenu_page('', __('Teleskill Live Participants', 'teleskill-tlive'), __('Teleskill Live Participants', 'teleskill-tlive'), 'publish_pages', 'tlive-manage-participants', 'manageParticipantsCallback');
}

function pollSessionCallback() {
    $lang = substr(get_bloginfo("language"), 0, 2);	
    require_once TLIVE_PATH . 'admin/pages/pollsSession.php';
    wp_register_script( 'jqueryhighstock', plugins_url('js/charts/highstock.js', __FILE__));
    wp_register_script( 'jqueryhighstockpoll', plugins_url('js/charts/answers-chart-pie.js',__FILE__));
    wp_register_script( 'jquerylang', plugins_url('js/lang/' . $lang . '.js', __FILE__));
    wp_enqueue_script('jqueryhighstock');
	wp_enqueue_script('jqueryhighstockpoll');
	wp_enqueue_script('jquerylang');
}

function pollSessionsCallback() {
    require_once TLIVE_PATH . 'admin/pages/pollsSessions.php';
}

function pollsCallback() {
    require_once TLIVE_PATH . 'admin/pages/polls.php';
}

function lessonTotalAccessCallback() {
    $lang = substr(get_bloginfo("language"), 0, 2);	
    require_once TLIVE_PATH . 'admin/pages/lessonTotalAccess.php';
    wp_register_script( 'jqueryhighstock', plugins_url('js/charts/highstock.js', __FILE__));
    wp_register_script( 'jqueryhighstockaccess', plugins_url('js/charts/users-access-chart.js',__FILE__));
    wp_register_script( 'jquerylang', plugins_url('js/lang/' . $lang . '.js', __FILE__));
    wp_enqueue_script('jqueryhighstock');
    wp_enqueue_script('jqueryhighstockaccess');
    wp_enqueue_script('jquerylang');
}

function lessonAccessCallback() {
    $lang = substr(get_bloginfo("language"), 0, 2);	
    require_once TLIVE_PATH . 'admin/pages/lessonAccess.php';
    wp_register_script( 'jqueryhighstock', plugins_url('js/charts/highstock.js', __FILE__));
    wp_register_script( 'jqueryhighstockaccess', plugins_url('js/charts/users-access-chart.js',__FILE__));
    wp_register_script( 'jquerylang', plugins_url('js/lang/' . $lang . '.js', __FILE__));
    wp_enqueue_script('jqueryhighstock');
    wp_enqueue_script('jqueryhighstockaccess');
    wp_enqueue_script('jquerylang');
}

function roomAccessCallback() {
    $lang = substr(get_bloginfo("language"), 0, 2);
    require_once TLIVE_PATH . 'admin/pages/roomAccess.php';
    wp_register_script( 'jqueryhighstock', plugins_url('js/charts/highstock.js', __FILE__));
    wp_register_script( 'jqueryhighstockaccess', plugins_url('js/charts/users-access-chart.js',__FILE__));
    wp_register_script( 'jquerylang', plugins_url('js/lang/' . $lang . '.js', __FILE__));
    wp_enqueue_script('jqueryhighstock');
    wp_enqueue_script('jqueryhighstockaccess');
    wp_enqueue_script('jquerylang');
}

function roomSessionsCallback() {
    require_once TLIVE_PATH . '/classes/tliveapi.class.php';
    require_once TLIVE_PATH . 'admin/pages/roomSessions.php';
}

function listRoomCallback() {
    require_once TLIVE_PATH . '/classes/tliveapi.class.php';
    require_once TLIVE_PATH . 'admin/pages/listRooms.php';
}

function manageParticipantsCallback() {
    wp_register_script('multiselect', plugins_url('js/multiselect/jquery.multi-select.js', __FILE__));
    wp_enqueue_script('multiselect');
    wp_enqueue_style('multiselect', plugins_url('js/multiselect/multi-select.css', __FILE__));

    require_once TLIVE_PATH . 'admin/pages/manageParticipants.php';
}

function roomLoginCallback() {
    require_once TLIVE_PATH . '/classes/tliveapi.class.php';
    require_once TLIVE_PATH . 'admin/pages/roomLogin.php';
}

function manageRoomCallback() {
    wp_register_script('multiselect', plugins_url('js/multiselect/jquery.multi-select.js', __FILE__));
    wp_enqueue_script('multiselect');
    wp_enqueue_style('multiselect', plugins_url('js/multiselect/multi-select.css', __FILE__));
    wp_register_script('opencalendar', plugins_url('js/open_calendar.js', __FILE__));
    wp_register_script('jqueryui', plugins_url('js/jquery-ui.js', __FILE__));
    wp_enqueue_script('opencalendar');
    wp_enqueue_script('jqueryui');
    
    require_once TLIVE_PATH . '/classes/tliveapi.class.php';
    require_once TLIVE_PATH . 'admin/pages/manageRoom.php';
}

function pluginSettingsCallback() {
    require_once TLIVE_PATH . 'admin/pages/settings.php';
}