<?php

require_once TLIVE_PATH . '/classes/tablelist.class.php';
require_once TLIVE_PATH . '/classes/tliveapi.class.php';

global $wpdb;

$id = (int)$_GET['id'];
$export = $_GET['export'];
$page = $_GET['page'];
$timezone = wp_timezone_string();
$table = new TliveListTable();
$settings = get_option('tlive-settings');

/* Export function */
if (!empty($export)) {
	
	$tlivehelper = new TvclHelper();
	$exptable = $tlivehelper->buildtableaccess('lessonaccess', $id);
	
	switch($export) {			
		case 'xls':
			ob_clean();
			$tlivehelper->exportXls($exptable, __('Lesson Access List', 'teleskill-tlive'));
			break;
		case 'pdf':	
			ob_clean();		
			$tlivehelper->exportpdf($exptable, LESSONS_LIST_STATS);
			break;
	}		
}

echo '<div class="wrap">';
echo '<h2>' . __('Lesson Access List', 'teleskill-tlive') . '</h2>';
echo '<br/><a onclick="history.go(-1);" class="button">' . __('Back', 'teleskill-tlive') . '</a><br><br>';
echo '<div id="container" style="min-width: 400px;height: 400px;margin: 0 auto"></div>';

$query = "SELECT uls.sessionid, us.iduser, uls.startdate, uls.enddate, us.roleid, us.ipaddress
			FROM $wpdb->tlive_lesson_user_sessions AS uls
			INNER JOIN $wpdb->tlive_user_sessions AS us ON uls.usersessionid = us.usersessionid			
			WHERE uls.lessonsessionid = %d";

if ($users = $wpdb->get_results($wpdb->prepare($query, $id),ARRAY_A) ) {
	$query = "SELECT * FROM $wpdb->tlive_lesson_sessions AS rs WHERE rs.lessonsessionid = %d";
	$lessonsession = $wpdb->get_row($wpdb->prepare($query, $id));		
	$sessiondate = tlive_print_datetime($lessonsession->startdate, 'l, j F Y');
	$start = tlive_print_datetime($lessonsession->startdate, 'H:i');
	$end = tlive_print_datetime($lessonsession->enddate, 'H:i');
	$sessiontext = sprintf(__('Lesson of %s from %s to %s', 'teleskill-tlive'), $sessiondate, $start, $end);
	
	echo "<table width=100%'>";
	echo "<tr>";
	echo "<td><h3>$sessiontext</h3></td>";		
	echo "<td style='text-align:right;'>";
    echo "<a href='?page=$page&id=$id&export=xls'><span class='dashicons dashicons-media-spreadsheet' style='margin-left: 10px; margin-right: 10px; font-size: 28px;'></span></a>";
	echo "<a href='?page=$page&id=$id&export=pdf'><span class='dashicons dashicons-pdf' style='margin-left: 10px; margin-right: 10px; font-size: 28px;'></span></a>";
    echo "</td>";
	echo "</tr>";
	echo "</table>";	
	
	for($i = 0; $i < count($users); $i++) {
		$userinfo = get_userdata($users[$i]['iduser']);
		/* format date event, time start and close */
		$users[$i]['participant'] = (!empty($userinfo->first_name) || !empty($userinfo->last_name)) ? $userinfo->first_name . ' ' . $userinfo->last_name : $userinfo->user_nicename;	 
		$users[$i]['startdate'] = tlive_print_datetime($users[$i]['startdate'], 'l, j F Y H:i');
		$users[$i]['enddate'] = tlive_print_datetime($users[$i]['enddate'], 'l, j F Y H:i');			
		$users[$i]['actions'] = [];
	}
}	

$columns['participant'] = __('Participant name', 'teleskill-tlive');
$columns['startdate'] = __('Start', 'teleskill-tlive');
$columns['enddate'] = __('End', 'teleskill-tlive');

$table->set_dspbulk(false);
$table->set_columns($columns);
$table->set_items($users);
	        
$table->prepare_items();
$table->display();

echo '</div>';
