<?php

require_once TLIVE_PATH . '/classes/tablelist.class.php';
require_once TLIVE_PATH . '/classes/tliveapi.class.php';

global $wpdb;

$id = (int)$_GET['id'];
$export = $_GET['export'];
$page = $_GET['page'];
$timezone = wp_timezone_string();
$table = new TliveListTable();
$settings = get_option('tlive-settings');

/* Export function */
if (!empty($export)) {
	
	$tlivehelper = new TvclHelper();
	$expTable = $tlivehelper->buildTableTotal($id);

	switch($export) {			
		case 'xls':
			ob_clean();
			$tlivehelper->exportXls($expTable, __('Lesson Access List Total', 'teleskill-tlive'));
			break;
		case 'pdf':	
			ob_clean();		
			$tlivehelper->exportPdf($expTable, LESSONS_LIST_TOTAL_STATS);
			break;
	}		
}

echo '<div class="wrap">';
echo '<h2>' . __('Lesson Access List', 'teleskill-tlive') . '</h2>';
echo '<br/><a onclick="history.go(-1);" class="button">' . __('Back', 'teleskill-tlive') . '</a><br><br>';
echo '<div id="container" style="min-width: 400px;height: 400px;margin: 0 auto"></div>';

$query = "SELECT us.iduser, MIN(uls.startdate) as start, MAX(uls.enddate) as end, SUM(uls.duration) as duration
			FROM $wpdb->tlive_lesson_user_sessions AS uls
			INNER JOIN $wpdb->tlive_user_sessions AS us ON uls.usersessionid = us.usersessionid			
			WHERE uls.lessonsessionid = %d group by us.iduser";

if ($lessonData = $wpdb->get_results($wpdb->prepare($query, $id), ARRAY_A) ) {
	$query = "SELECT * FROM $wpdb->tlive_lesson_sessions AS rs WHERE rs.lessonsessionid = %d";
	$lessonsession = $wpdb->get_row($wpdb->prepare($query, $id));		
	$sessiondate = tlive_print_datetime($lessonsession->startdate, 'l, j F Y');
	$start = tlive_print_datetime($lessonsession->startdate, 'H:i');
	$end = tlive_print_datetime($lessonsession->enddate, 'H:i');
	$sessiontext = sprintf(__('Lesson of %s from %s to %s', 'teleskill-tlive'), $sessiondate, $start, $end);
	
	echo "<table width=100%'>";
	echo "<tr>";
	echo "<td><h3>$sessiontext</h3></td>";		
	echo "<td style='text-align:right;'>";
    echo "<a href='?page=$page&id=$id&export=xls'><span class='dashicons dashicons-media-spreadsheet' style='margin-left: 10px; margin-right: 10px; font-size: 28px;'></span></a>";
	echo "<a href='?page=$page&id=$id&export=pdf'><span class='dashicons dashicons-pdf' style='margin-left: 10px; margin-right: 10px; font-size: 28px;'></span></a>";
    echo "</td>";
	echo "</tr>";
	echo "</table>";

	// Recupero il totale delle verifiche di presenza
	$query = "SELECT COUNT(*) as num_rows FROM $wpdb->tlive_presence_check WHERE lesson_session_id = %d";
	$checkCount = $wpdb->get_results($wpdb->prepare($query, $id));

	// Recupero il dettaglio delle verifiche per singolo utente
	$query = "SELECT us.iduser, Count(*) AS PresenceCheckCount
				FROM wp_tlive_presence_check pc
				INNER JOIN wp_tlive_user_presences up ON pc.presence_id = up.presence_id
				INNER JOIN wp_tlive_user_sessions us ON up.user_session_id = us.usersessionid
				WHERE pc.lesson_session_id = %d group by us.iduser";
	$checkCountDetail = $wpdb->get_results($wpdb->prepare($query, $id), ARRAY_A);

	for($i = 0; $i < count($lessonData); $i++) {
		$userinfo = get_userdata($lessonData[$i]['iduser']);
		$key = array_search($lessonData[$i]['iduser'], array_column($checkCountDetail, 'iduser'));

		/* format date event, time start and close */
		$lessonData[$i]['participant'] = (!empty($userinfo->first_name) || !empty($userinfo->last_name)) ? $userinfo->first_name . ' ' . $userinfo->last_name : $userinfo->user_nicename;	 
		$lessonData[$i]['startdate'] = tlive_print_datetime($lessonData[$i]['start'], 'l, j F Y H:i');
		$lessonData[$i]['enddate'] = tlive_print_datetime($lessonData[$i]['end'], 'l, j F Y H:i');
		$lessonData[$i]['duration'] = gmdate("H:i:s", $lessonData[$i]['duration']);
		$lessonData[$i]['total_check'] = (int)$checkCount[0]->num_rows;
		$lessonData[$i]['passed_check'] = (is_numeric($key)) ? $checkCountDetail[$key]["PresenceCheckCount"] : 'Conference Manager';
		$lessonData[$i]['actions'] = [];
	}
}	

$columns['participant'] = __('Participant name', 'teleskill-tlive');
$columns['startdate'] = __('Start', 'teleskill-tlive');
$columns['enddate'] = __('End', 'teleskill-tlive');
$columns['duration'] = __('Duration', 'teleskill-tlive');
$columns['total_check'] = __('Total check', 'teleskill-tlive');
$columns['passed_check'] = __('Passed check', 'teleskill-tlive');

$table->set_dspbulk(false);
$table->set_columns($columns);
$table->set_items($lessonData);
	        
$table->prepare_items();
$table->display();

echo '</div>';
