<?php
	global $wpdb;
	$id = (int)$_REQUEST['id'];

	/* check if room exists */
	$room = $wpdb->get_row($wpdb->prepare("SELECT id FROM $wpdb->tlive_rooms WHERE id = %d", $id));
	if (!$room->id) {
		echo '<div id="message" class="error">' . __('Error! Room not found', 'teleskill-tlive') . '</div>';
		return false;
	}

	
	/* save users enrolments */
	if(isset($_REQUEST['save']) && (int) $_REQUEST['save'] == 1) {
		$return = tlive_save_participants($_REQUEST['select_userid'], $id);
		
		if(is_wp_error($return)) {
			echo '<div id="message" class="error">' . $return->get_error_message() . '</div>';
		} else {
			echo '<div id="message" class="updated">' . __('List saved', 'teleskill-tlive') . '</div>';
		}
	}
	
	$enrolledUsers = $wpdb->get_results($wpdb->prepare ("SELECT user_id FROM $wpdb->tlive_enrolments WHERE classroom_id = %d AND role = %d", [$id, PARTICIPANT_ROLE_ID]), ARRAY_A);
	$enrolledUsers = array_column($enrolledUsers, 'user_id');

	$candidateUsers = $wpdb->get_results($wpdb->prepare("
		SELECT ID FROM $wpdb->users WHERE ID NOT IN (SELECT user_id FROM $wpdb->tlive_enrolments WHERE classroom_id = %d AND role = %d)", [$id, CONFERENCE_MANAGER_ROLE_ID]));

?>

<script type="text/javascript">
  // run pre selected options
  jQuery(document).ready(function($) {
    $('#select_userid').multiSelect({
		selectableHeader: "<div class='ms-header'>Elenco utenti</div>",
		selectionHeader: "<div class='ms-header'>Utenti selezionati</div>",
	});
});

</script>

<div class="wrap">
	<h2><?= __('List of participants', 'teleskill-tlive');?></h2>


	<form method="post" action="<?= "?page=tlive-manage-participants&id=$id"; ?>" name="enrolUsers" id="enrolUsers">
		<table class="form-table">
			<tbody>
				<tr>
					<th scope="row">
						<label><?= __('Participants', 'teleskill-tlive');?>: </label>
					</th>
					<td>
						<select multiple id="select_userid" name="select_userid[]">
							<?php 

								foreach ($candidateUsers as $user) {
									$userinfo = get_userdata($user->ID);
									$name = (!empty($userinfo->first_name) || !empty($userinfo->last_name)) ? $userinfo->first_name . ' ' . $userinfo->last_name : $userinfo->user_nicename;	 
									$selected = in_array($user->ID, $enrolledUsers) ? 'selected': '';
									echo "<option $selected value='$user->ID'>$name</option>";
								}
							?>
						</select>
					</td>
				</tr>
			</tbody>
		</table>
		
		<input type="submit" class="button button-primary" value="<?= __('Save');?>">
		<input type="hidden" name="save" value="1" />
		<a class="button action" href="?page=tlive-rooms"><?= __('Back', 'teleskill-tlive');?></a>
	</form>

</div>
