<?php
	
global $wpdb;
$id = isset($_REQUEST['id']) ? (int)$_REQUEST['id'] : 0;
$titlePage = __('Add New Room', 'teleskill-tlive');

$settings = get_option('tlive-settings');

// Save data & redirect
if(isset($_REQUEST['save']) && (int)$_REQUEST['save'] == 1) {

	$return = tlive_save_room($_REQUEST, $_FILES);		

	if (is_wp_error($return)) {
		$qr = '';
		if (isset($_REQUEST['id']) && $_REQUEST['id'] > 0) {
			$qr = '&id=' . $_REQUEST['id'] . '&action=edit';
		}

		echo '<div id="message" class="error">' . $return->get_error_message() . '</div><br>';
		echo '<a class="button action" href="?page=tlive-manage-room' . $qr . '">' . __('Back', 'teleskill-tlive') . '</a>';
		return false;
	}
	
	if($id == 0) {
		$message = 1;
	} else {
		$message = 2;
	}

	/* redirect */
	wp_redirect("?page=tlive-rooms&message=$message");
	exit;
}

/* edit mode, load data */
if (isset($_REQUEST['action']) && $_REQUEST['action'] == 'edit') {
	
	$titlePage = __('Edit Room', 'teleskill-tlive');
	$roomdata = $wpdb->get_row($wpdb->prepare("SELECT * FROM $wpdb->tlive_rooms AS r WHERE id = %d", $id));

	$conferenceManagers = $wpdb->get_results($wpdb->prepare ("SELECT user_id FROM $wpdb->tlive_enrolments WHERE classroom_id = %d AND role = %d", [$id, CONFERENCE_MANAGER_ROLE_ID]), ARRAY_A);
	$conferenceManagers = array_column($conferenceManagers, 'user_id');

	$title = stripslashes($roomdata->title);
	$start = $roomdata->timestarted;
	$end   = $roomdata->timecompleted;
	
	$usersNumber 	= $roomdata->users;
	$autoEnrol 		= $roomdata->auto_enrol;
	$emailconfman 	= $roomdata->emailconfman;
	$emailusers 	= $roomdata->emailusers;
	$logo 			= $roomdata->logo;
	$banner			= $roomdata->banner;
} else {
	// default start = now and end= now + 1hour
	$title = '';
	$start 			= 'NOW';
	$end 			= '+1 hour';
	$conferenceManagers = [];
	$emailconfman 	= 1;
	$emailusers 	= 0;
	$usersNumber 	= 1;
	$autoEnrol 		= 0;
	$logo 			= '';
	$banner 		= '';
}

$start	= new DateTime($start, new DateTimeZone('UTC'));
$end 	= new DateTime($end, new DateTimeZone('UTC'));

$start = roundToNearestMinuteInterval($start);
$end = roundToNearestMinuteInterval($end);

/* convert to system time zone */
$start->setTimeZone(new DateTimeZone(wp_timezone_string() ));
$end->setTimeZone(new DateTimeZone(wp_timezone_string() ));

$day = $start->format('Y-m-d');

/* convert to system time zone */
$timestarted 	= $start->format('H:i');
$timecompleted 	= $end->format('H:i');

$query = "SELECT id FROM $wpdb->users WHERE id NOT IN (SELECT user_id FROM $wpdb->tlive_enrolments WHERE classroom_id = $id AND role = 1)";
$users = $wpdb->get_results($query);

$checkConfmanEmail 	= ($emailconfman) ? 'checked' : '';
$checkUsersEmail 	= ($emailusers) ? 'checked' : '';
$checkAutoEnroll 	= ($autoEnrol) ? 'checked' : '';

?>

<script type="text/javascript">
  // run pre selected options
jQuery(document).ready(function($) {
    $('#select_conf_manager').multiSelect({
		selectableHeader: "<div class='ms-header'>Elenco utenti</div>",
		selectionHeader: "<div class='ms-header'>Utenti selezionati</div>",
	});
});

</script>

<div class="wrap"><h2><?= $titlePage ?></h2>
	<div class="wrap"> 
		<form method="post" action="<?= $_SERVER['REQUEST_URI'] ?>" method="post" enctype="multipart/form-data">  
			<input type='hidden' name='save'  value='1'>
			<input type='hidden' name='id'  value='<?= $id ?>'>
			<table class="form-table">
				<tbody>
					<tr>
						<th scope="row"><?= __('Room title', 'teleskill-tlive') ?>:</th>
						<td><input type='text' name='title' id='title' value='<?= $title ?>' placeholder="<?= __('Insert title', 'teleskill-tlive') ?>" required></td>
					</tr>
					<?php
						if (is_null($settings['disable_date'])) {
							echo "<tr>";
							echo "<th scope='row'>" . __('Event date', 'teleskill-tlive') . ":</th>";
							echo "<td>";
							echo "<input id='eventDate' type='date' name='day' class='date start' value='" . $day . "'>";
							echo "<span class='calendar dashicons dashicons-calendar-alt' style='margin-left: 10px; font-size: 28px; cursor: pointer;'></span>";
							echo "</td>";
							echo "</tr>";
							echo "<tr>";
							echo "<th scope='row'>" . __('Start', 'teleskill-tlive') . ":</th>";
							echo "<td>";
							echo "<input id='startTime' type='time' name='start' value='" . $timestarted . "' class='time start' step='300'>";
							echo " " . __('End', 'teleskill-tlive') . ": <input id='endTime' type='time' name='end' value='" . $timecompleted . "' class='time end' step='300'>";
							echo "</td>";
							echo "</tr>";
						}
					?>
					<tr>
						<th scope='row'><?= __('Conference Manager', 'teleskill-tlive') ?>:</th>
						<td>
							<select id='select_conf_manager' name='conf_manager[]' multiple style="width:400px">
								<?php
									foreach ($users as $user) {
										$data = get_userdata($user->id);
										$name = (!empty($data->first_name) || !empty($data->last_name)) ? $data->first_name . ' ' . $data->last_name : $data->user_nicename;
										$selected = in_array($user->id, $conferenceManagers) ? 'selected': '';
										echo "<option $selected value='$user->id'>$name</option>";
									}
								?>
							</select>
						</td>
					</tr>
					<tr>
						<th scope='row'><?= __('Max number of users', 'teleskill-tlive') ?>:</th>
						<td>
							<select id='usersNumber' name='usersNumber'>
								<?php
									$maxUsers = $settings['max_users'];
									for($i = 1; $i <= $maxUsers; $i++) {
										$selected = ($i == $usersNumber) ? 'selected': '';
										echo "<option $selected value='$i'>$i</option>";
									}
								?>
							</select>
						</td>
					</tr>
					<tr>	
						<th scope='row'><?= __('Notification mail conference manager', 'teleskill-tlive') ?>:</th>
						<td>
							<input type='checkbox' name='emailconfman' value='1' <?= $checkConfmanEmail?>>
						</td>
					</tr>
					<tr>	
						<th scope='row'><?= __('Notification mail participants', 'teleskill-tlive') ?>:</th>
						<td>
							<input type='checkbox' name='emailusers' value='1' <?= $checkUsersEmail?>>
						</td>
					</tr>
					<tr>	
						<th scope='row'><?= __('Public access', 'teleskill-tlive') ?>:</th>
						<td>
							<input type='checkbox' name='auto_enrol' value='1' <?= $checkAutoEnroll?>>
						</td>
					</tr>
					<tr>
						<th scope="row"><?= __('Logo', 'teleskill-tlive') ?>:</th>
						<td><input type='file' name='logo'>
						<?php
							if($logo) {
								echo '<br>';
								echo "<span>(" . __('Last uploaded', 'teleskill-tlive') . ":$logo)</span>";
							}
						?>
						</td>
					</tr>
					<tr>
						<th scope="row"><?= __('Banner', 'teleskill-tlive') ?>:</th>
						<td><input type='file' name='banner'>
						<?php
							if($logo) {
								echo '<br>';
								echo "<span>(" . __('Last uploaded', 'teleskill-tlive') . ":$logo)</span>";
							}
						?>
						</td>
					</tr>
					<tr>
						<td>
							<button id='submit' type='submit' class='button button-primary'><?= __('Save')?></button>
							<a onclick="history.go(-1);" class="button"><?= __('Abort', 'teleskill-tlive') ?></a><br><br>
						</td>
					</tr>
				</tbody>
			</table>	
		</form>
	</div>
</div>