<?php

require_once TLIVE_PATH . '/classes/tablelist.class.php';

global $wpdb;

$id = (int)$_GET['id'];
$timezone = wp_timezone_string();
$table = new TliveListTable();

echo '<div class="wrap"><h2>' . __('Polls Summary', 'teleskill-tlive') . '</h2>';
echo '<br><a onclick="history.go(-1);" class="button">' . __('Back', 'teleskill-tlive') . '</a><br><br>';

$query = "SELECT  * FROM $wpdb->tlive_polls WHERE roomsessionid = %d";		 

if ($rooms = $wpdb->get_results($wpdb->prepare($query,$id), ARRAY_A) ) {
	for($i = 0; $i < count($rooms); $i++) {
		$rooms[$i]['poll'] = sprintf('<a href="?page=%s&id=%d">' . stripslashes($rooms[$i]['question']) . '</a>', 'tlive-poll-sessions', $rooms[$i]['pollid']);					
		$rooms[$i]['actions'] = [];
	}
}

$columns['poll'] = __('Poll', 'teleskill-tlive');

$table->set_dspbulk(false);
$table->set_columns($columns);
$table->set_items($rooms);       
$table->prepare_items();
$table->display();

echo '</div>';
