<?php

require_once TLIVE_PATH . '/classes/tablelist.class.php';
require_once TLIVE_PATH . '/classes/tliveapi.class.php';

global $wpdb;

$id = (int)$_GET['id'];
$export = isset($_GET['export']) ? $_GET['export'] : 0;
$page = $_GET['page'];
$timezone = wp_timezone_string();
$table = new TliveListTable();

/* Export function */
if (!empty($export)) {	
	$tlivehelper = new TvclHelper();
	$exptable = $tlivehelper->buildtablepolls($id);	
	switch($export) {	
		case 'xls':
			$tlivehelper->exportXls($exptable, __('Poll Session', 'teleskill-tlive'));
			break;
		case 'pdf':	
			ob_clean();		
			$tlivehelper->exportpdf($exptable, POLLS_LIST_STATS);
			break;
	}
}

echo '<div class="wrap"><h2>' . __('Poll Session', 'teleskill-tlive') . '</h2>';
echo '<br/><a onclick="history.go(-1);" class="button">' . __('Back', 'teleskill-tlive') . '</a><br><br>';
echo '<div id="container" style="min-width: 400px;height: 400px;margin: 0 auto"></div>';

$query = "SELECT upa.userspollanswerid, u.id as userid, ps.correct, us.roleid,
	     	 ps.answer, us.startdate, us.enddate
	      	FROM ($wpdb->tlive_users_poll_answers AS upa
	        INNER JOIN $wpdb->tlive_user_sessions AS us ON upa.usersessionid = us.usersessionid	        
	        INNER JOIN $wpdb->tlive_polls_answers AS ps ON upa.answerid = ps.answerid
	        )
	        INNER JOIN $wpdb->users as u ON us.iduser = u.id
	        WHERE pollsessionid = %d";

if ($items = $wpdb->get_results($wpdb->prepare($query, $id), ARRAY_A) ) {
		
		$query = "SELECT p.question, ps.opendate, ps.closedate FROM $wpdb->tlive_polls_sessions AS ps 
					INNER JOIN $wpdb->tlive_polls AS p ON ps.pollid = p.pollid
					WHERE ps.pollsessionid = %d";
					
		$pollsession = $wpdb->get_row($wpdb->prepare($query,$id));		
		$sessiondate = tlive_print_datetime($pollsession->opendate, 'l, j F Y');
		$start = tlive_print_datetime($pollsession->opendate, 'H:i');
	    $end = tlive_print_datetime($pollsession->closedate, 'H:i');
		$sessiontext = sprintf(__('Session of %s from %s to %s', 'teleskill-tlive'), $sessiondate, $start, $end);
		$sessiontext = __('Question', 'teleskill-tlive') . ': ' . stripslashes($pollsession->question) . ', ' . $sessiontext . ' </h3>';
		
        echo "<table width=100%'>";
        echo "<tr>";
        echo "<td><h3>$sessiontext</h3></td>";		
        echo "<td style='text-align:right;'>";
        echo "<a href='?page=$page&id=$id&export=xls'><span class='dashicons dashicons-media-spreadsheet' style='margin-left: 10px; margin-right: 10px; font-size: 28px;'></span></a>";
        echo "<a href='?page=$page&id=$id&export=pdf'><span class='dashicons dashicons-pdf' style='margin-left: 10px; margin-right: 10px; font-size: 28px;'></span></a>";
        echo "</td>";
        echo "</tr>";
        echo "</table>";

		for ($i = 0; $i < count($items) ;$i++) {		
			$userinfo = get_userdata($items[$i]['userid']);
			$items[$i]['participant'] = (!empty($userinfo->first_name) || !empty($userinfo->last_name)) ? $userinfo->first_name . ' ' . $userinfo->last_name : $userinfo->user_nicename;	 
			$items[$i]['correct'] = $items[$i]['correct'] == 1 ? __('Correct', 'teleskill-tlive') :  __('Wrong', 'teleskill-tlive');
			$items[$i]['actions'] = array();
		}
}

$columns['participant'] = __('Participant\'s Name', 'teleskill-tlive');
$columns['answer'] = __('Answer', 'teleskill-tlive');
$columns['correct'] = __('Result', 'teleskill-tlive');

$table->set_dspbulk(false);
$table->set_columns($columns);
$table->set_items($items);
	        
$table->prepare_items();
$table->display();

echo '</div>';
