<?php

require_once TLIVE_PATH . '/classes/tablelist.class.php';

global $wpdb;

$id = (int)$_GET['id'];
$timezone = wp_timezone_string();
$table = new TliveListTable();

echo '<div class="wrap"><h2>' . __('Poll sessions list', 'teleskill-tlive') . '</h2>';
echo '<br/><a onclick="history.go(-1);" class="button">' . __('Back', 'teleskill-tlive') . '</a><br><br>';

$query = "SELECT  ps.pollsessionid,p.question,ps.opendate,ps.closedate FROM $wpdb->tlive_polls_sessions AS ps
			 INNER JOIN $wpdb->tlive_polls AS p ON ps.pollid = p.pollid
			 WHERE ps.pollid = %d";

if ($items = $wpdb->get_results($wpdb->prepare($query, $id), ARRAY_A) ) {
	echo' <h3>' . __('Poll session', 'teleskill-tlive') . ': ' . stripslashes($items[0]['question']) . '</h3>';
	
	for($i = 0; $i < count($items); $i++) {
		$polldate = tlive_print_datetime($items[$i]['opendate'], 'l, j F Y');
		$open = tlive_print_datetime($items[$i]['opendate'], 'H:i');
		$close = tlive_print_datetime($items[$i]['closedate'], 'H:i');
		$sessiontext = sprintf(__('Session of %s', 'teleskill-tlive'), $polldate);
		
		$items[$i]['pollsession'] = sprintf('<a href="?page=%s&id=%d">' . $sessiontext . '</a>', 'tlive-poll-session', $items[$i]['pollsessionid']);	
		$items[$i]['opendate'] = tlive_print_datetime($items[$i]['opendate'], 'H:i');
		$items[$i]['closedate'] = tlive_print_datetime($items[$i]['closedate'], 'H:i');
		$items[$i]['actions'] = [];
	}
}

$columns['pollsession'] = __('Poll Session', 'teleskill-tlive');
$columns['opendate'] = __('Start', 'teleskill-tlive');
$columns['closedate'] = __('End', 'teleskill-tlive');

$table->set_dspbulk(false);
$table->set_columns($columns);
$table->set_items($items);       
$table->prepare_items();
$table->display();

echo '</div>';
