<?php

require_once TLIVE_PATH . '/classes/tablelist.class.php';
require_once TLIVE_PATH . '/classes/tliveapi.class.php';

global $wpdb;

$id = (int)$_GET['id'];
$export = isset($_GET['export']) ? $_GET['export'] : 0;
$page = $_GET['page'];
$table = new TliveListTable();
$settings = get_option('tlive-settings');

/* Export function */
if (!empty($export)) {
	
	$tlivehelper = new TvclHelper();
	$exptable = $tlivehelper->buildtableaccess('roomaccess', $id);

	switch($export) {
		case 'xls':
			ob_clean();
			$tlivehelper->exportXls($exptable, __('Rooms Access List', 'teleskill-tlive'));
			break;
		case 'pdf':	
			ob_clean();		
			$tlivehelper->exportpdf($exptable, LESSONS_LIST_STATS);
			break;
	}	
}

echo '<div class="wrap">';
echo '<h2>' . __('Rooms Access List', 'teleskill-tlive') . '</h2>';
echo '<br/><a onclick="history.go(-1);" class="button">' . __('Back', 'teleskill-tlive') . '</a><br><br>';
echo '<div id="container" style="min-width: 400px;height: 400px;margin: 0 auto"></div>';

$query = "SELECT * FROM $wpdb->tlive_user_sessions AS us INNER JOIN $wpdb->users AS u ON us.iduser = u.id WHERE us.roomsessionid = %d";

if ($users = $wpdb->get_results($wpdb->prepare($query, $id), ARRAY_A) ) {
	$query = "SELECT * FROM $wpdb->tlive_rooms_sessions AS rs WHERE rs.roomsessionid = %d";
	$roomsession = $wpdb->get_row($wpdb->prepare($query, $id));		
	$sessiondate = tlive_print_datetime($roomsession->startdate, 'l, j F Y');
	$start = tlive_print_datetime($roomsession->startdate, 'H:i');
	$end = tlive_print_datetime($roomsession->enddate, 'H:i');
	$sessiontext = sprintf(__('Session of %s from %s to %s', 'teleskill-tlive'), $sessiondate, $start, $end);
	
	echo "<table width=100%'>";
	echo "<tr>";
	echo "<td><h3>$sessiontext</h3></td>";		
	echo "<td style='text-align:right;'>";
    echo "<a href='?page=$page&id=$id&export=xls'><span class='dashicons dashicons-media-spreadsheet' style='margin-left: 10px; margin-right: 10px; font-size: 28px;'></span></a>";
	echo "<a href='?page=$page&id=$id&export=pdf'><span class='dashicons dashicons-pdf' style='margin-left: 10px; margin-right: 10px; font-size: 28px;'></span></a>";
    echo "</td>";
	echo "</tr>";
	echo "</table>";	 
	
	for($i = 0; $i < count($users); $i++) {
		$userinfo = get_userdata($users[$i]['iduser']);
		/* format date event, time start and close */
		$users[$i]['participant'] = (!empty($userinfo->first_name) || !empty($userinfo->last_name)) ? $userinfo->first_name . ' ' . $userinfo->last_name : $userinfo->user_nicename;
		$users[$i]['startdate'] = tlive_print_datetime($users[$i]['startdate'], 'l, j F Y H:i');
		$users[$i]['enddate'] = tlive_print_datetime($users[$i]['enddate'], 'l, j F Y H:i');					
		$users[$i]['actions'] = array();
	}
}	

$columns['participant'] = __('Participant name', 'teleskill-tlive');
$columns['startdate'] = __('Start', 'teleskill-tlive');
$columns['enddate'] = __('End', 'teleskill-tlive');

$table->set_dspbulk(false);
$table->set_columns($columns);
$table->set_items($users);       
$table->prepare_items();
$table->display();

echo '</div>';
