<?php
global $wpdb;

$id = (int)$_REQUEST['id'];
$user = wp_get_current_user();
$return = tlive_user_login($user, $id);

if (is_wp_error($return) ) {
	echo '<div class="wrap"><div id="message" class="error">' . $return->get_error_message() . '</div></div>';
}

function tlive_user_login($user, $id) {
	
	global $wpdb;

	$room = $wpdb->get_row( $wpdb->prepare("SELECT * FROM $wpdb->tlive_rooms WHERE id = %d", $id));

	if ($user->ID != 0) {
		
		$query = "SELECT role FROM $wpdb->tlive_enrolments WHERE user_id = %d AND classroom_id = %d";
		$result = $wpdb->get_row($wpdb->prepare($query, [$user->ID, $id]));	

	    if ((int)$room->roomid != 0) { 	
	    
	    	/* if user is enrolled, load data */
			if ($result) {
				$role = $result->role;			
			/* else first check if auto enrol is enabled, then enable user access */					
			} else if ($user->ID != 0 && $room->auto_enrol) {
				/* enrol as participant */
				$role = PARTICIPANT_ROLE_ID;
				$query="INSERT INTO $wpdb->tlive_enrolments (classroom_id, user_id, role) VALUES (%d, %d, %d)";
				$wpdb->query($wpdb->prepare($query, $id, $user->ID, $role));			  	
			}	else {
				return new WP_Error('denied', __("Error. Access denied","tlive"));				
			}			
					
	        $userid = $user->ID;     
	        $name = $user->user_nicename;
	        $first_name = $user->first_name;
	        $last_name = $user->last_name;
	        $email = $user->user_email;
	        $lang = 'IT';
	
	        $userobj = new stdClass();
	        $userobj->userid = $userid;
	        $userobj->name = $name;
	        $userobj->first_name = $first_name;
	        $userobj->last_name = $last_name;
	        $userobj->role = $role;
	        $userobj->email = $email;
	        $userobj->lang = $lang;
	        
	        $helper = new TvclHelper();
	        $response = $helper->enableUser($userobj, $room->roomid);
	        
	        if (empty($response)) {
		 		return new WP_Error('responsefailed',__('Connection failed. Check if URL server and CCC in general settings are correct', 'teleskill-tlive'));
			}   
	        
	        if((int)$response->errorcode != 0) {
	        	return new WP_Error('denied', __("Error. Access denied","tlive"));        
	        } 
	
			wp_redirect($response->url);
	        exit;
	
	    } else {
	       return new WP_Error('denied', __("Error. Access denied","tlive") );
	    }
	
	} else {
	    return new WP_Error('nouser', __("Warning. You must log in", "tlive"));
	}
	
	return true;
}
