<?php

require_once TLIVE_PATH . '/classes/tablelist.class.php';

global $wpdb;

$id = (int)$_GET['id'];
$page = $_GET['page'];
$updateStats = isset($_GET['upd_stats']) ? (int)$_GET['upd_stats'] : 0;

if ($updateStats) {
	$query = "SELECT * FROM $wpdb->tlive_rooms WHERE id = %d";
	$room = $wpdb->get_row($wpdb->prepare($query, $id));
	$tliveapi = new TvclHelper();
	$xmlresponse = $tliveapi->getRoomLogs($room->roomid);
	$tliveapi->saveLogs($xmlresponse);
}

echo '<form method="post" name="upd_stats">';
echo '<div class="wrap">
	  <h2>' . __('Room\'s Report', 'teleskill-tlive') .
	  '<a href="?page=' . $page . '&id=' . $_GET['id'] . '&upd_stats=1" class="add-new-h2">' . __('Update statistics', 'teleskill-tlive') . '</a>' . '</h2>';
echo '<br/><a onclick="history.go(-1);" class="button">' . __('Back', 'teleskill-tlive') . '</a><br><br>';
echo' <h3>' . __('Sessions summary', 'teleskill-tlive') . '</h3>';

/* Rooms sessions */
$tablesessions = new TliveListTable();

$query = "SELECT rs.roomsessionid, rs.startdate, rs.enddate, rs.roomid FROM $wpdb->tlive_rooms_sessions AS rs
		   INNER JOIN $wpdb->tlive_rooms AS c ON rs.roomid = c.roomid
			 WHERE c.id = %d ORDER BY rs.startdate, rs.enddate ASC";

if ($sessions = $wpdb->get_results($wpdb->prepare($query, $id), ARRAY_A) ) {
	for($i=0; $i < count($sessions); $i++) {
		/* format date event, time start and close */
		$sessiondate    = tlive_print_datetime($sessions[$i]['startdate'], 'l, j F Y');
		$start          = tlive_print_datetime($sessions[$i]['startdate'], 'H:i');
		$end            = tlive_print_datetime($sessions[$i]['enddate'], 'H:i');
		$sessiontext    = sprintf(__('Session of %s from %s to %s', 'teleskill-tlive'), $sessiondate, $start, $end);

		$sessions[$i]['session'] = $sessiontext;
		$sessions[$i]['polls'] = sprintf('<a href="?page=%s&id=%d">' . __('View polls', 'teleskill-tlive') . '</a>', 'tlive-polls', $sessions[$i]['roomsessionid']);
		$sessions[$i]['access'] = sprintf('<a  href="?page=%s&id=%d">' . __('View access', 'teleskill-tlive') . '</a>', 'tlive-room-access', $sessions[$i]['roomsessionid']);
		$sessions[$i]['actions'] = [];
	}
}

$columns['session'] = __('Session', 'teleskill-tlive');
$columns['polls'] = __('Polls list', 'teleskill-tlive');
$columns['access'] = __('Access list', 'teleskill-tlive');

$tablesessions->set_dspbulk(false);
$tablesessions->set_columns($columns);
$tablesessions->set_items($sessions);
$tablesessions->prepare_items();
$tablesessions->display();

/* Lessons sessions */

$lessonstable = new TliveListTable();

$query = "SELECT ls.lessonsessionid, ls.startdate, ls.enddate FROM  $wpdb->tlive_lesson_sessions AS ls
			  INNER JOIN $wpdb->tlive_rooms_sessions AS rs ON ls.roomsessionid = rs.roomsessionid
			  INNER JOIN $wpdb->tlive_rooms AS c ON rs.roomid = c.roomid
			  WHERE c.id = %d ORDER BY ls.startdate, ls.enddate ASC";

if ($lessons = $wpdb->get_results($wpdb->prepare($query, $id), ARRAY_A) ) {
		for($i = 0; $i < count($lessons); $i++) {

			$lessondate = tlive_print_datetime($sessions[$i]['startdate'], 'l, j F Y');
			$start      = tlive_print_datetime($lessons[$i]['startdate'], 'H:i');
			$end        = tlive_print_datetime($lessons[$i]['enddate'], 'H:i');
			$lessontext = sprintf(__('Lesson of %s from %s to %s', 'teleskill-tlive'), $lessondate, $start, $end);

			/* format date event, time start and close */
			$lessons[$i]['lesson'] = $lessontext;
			$lessons[$i]['access'] = sprintf('<a  href="?page=%s&id=%d">' . __('View access', 'teleskill-tlive') . '</a>', 'tlive-lesson-access', $lessons[$i]['lessonsessionid']);
			$lessons[$i]['totalaccess'] = sprintf('<a  href="?page=%s&id=%d">' . __('View access', 'teleskill-tlive') . '</a>', 'tlive-lesson-totalaccess', $lessons[$i]['lessonsessionid']);
			$lessons[$i]['actions'] = [];
		}
}

echo '<h3>' . __('Lessons summary', 'teleskill-tlive') . '</h3>';

$columns = [];
$columns['lesson'] = __('Session', 'teleskill-tlive');
$columns['access'] = __('Access list', 'teleskill-tlive');
$columns['totalaccess'] = __('Total Access list', 'teleskill-tlive');

$lessonstable->set_dspbulk(false);
$lessonstable->set_columns($columns);
$lessonstable->set_items($lessons);
$lessonstable->prepare_items();
$lessonstable->display();

echo '</div>';