<?php

require('../../../../../../wp-blog-header.php');
require_once TLIVE_PATH . '/classes/tliveapi.class.php';

/* Load max users param */
$settings = get_option('tlive-settings');
$maxusers = $settings['max_users'];

$update = (int) $_GET['update'];
$startdate = $_GET['startdate'];
$enddate = $_GET['enddate'];
$users = (int) $_GET['users'];

/* Convert datetime string to unix time format */
$timezone = wp_timezone_string();

/* verifies that date fields are valid */
if (!empty($startdate) && !empty($enddate)) {

	$startdate = new DateTime($startdate,new DateTimeZone($timezone));
	$startdate->setTimeZone(new DateTimeZone('UTC') );

	$startdate = $startdate->format('Y-m-d H:i:s');	
	
	$enddate = new DateTime($enddate,new DateTimeZone($timezone));
	$enddate->setTimeZone(new DateTimeZone('UTC') );

	$enddate = $enddate->format('Y-m-d H:i:s');	
    $helper = new TvclHelper();
	$success = $helper->event_availability($startdate, $enddate, $maxusers, $users, $update);	
	
} else {
    $success = false;
}

/* Return json answer */
$aux = ['success' => $success];

echo json_encode($aux);
