<?php

require('../../../../../../wp-blog-header.php');

$tableUserSession = $wpdb->prefix . 'tlive_user_sessions';
$tableLessonUserSession = $wpdb->prefix . 'tlive_lesson_user_sessions';
$tableUserPollAnswer =  $wpdb->prefix . 'tlive_users_poll_answers';
$tablePollsAnswers =  $wpdb->prefix . 'tlive_polls_answers';

$id = (int)$_GET['id'];
$view = (string)$_GET['view'];

/* return a json with the number of poll answers */
if ($view == 'tlive-poll-session') {
	
	$query = "SELECT a.answerid, a.answer, COUNT(*) AS votes FROM $tableUserPollAnswer as pa
                INNER JOIN $tablePollsAnswers AS a ON pa.answerid = a.answerid 
                WHERE pollsessionid = %d GROUP BY pa.answerid";

    $answers = $wpdb->get_results($wpdb->prepare($query, $id));
    
    foreach ($answers as $a) {
        $aux = array($a->answer, (int)$a->votes);
        $json[] = $aux;
    }
}

if ($view == 'tlive-room-access' || $view == 'tlive-lesson-access' || $view == 'tlive-lesson-totalaccess') {
    
    switch($view) {
        /* query in case of lesson sessions */
		case 'tlive-lesson-access':
        case 'tlive-lesson-totalaccess':
			$query = "(SELECT CONCAT(sessionid, 'add'), startdate as access, 'add'
            FROM $tableLessonUserSession WHERE lessonsessionid = %d)
            UNION ALL
            (SELECT CONCAT(sessionid, 'del'), enddate as access, 'del' FROM $tableLessonUserSession
            WHERE lessonsessionid = %d) ORDER BY access ASC"; 
            break;
            /* othwerwise print room access data */
        case 'tlive-room-access':
            $query = "(SELECT CONCAT(usersessionid, 'add'), iduser, startdate as access, 'add'
            FROM $tableUserSession WHERE roomsessionid = %d)
            UNION ALL
            (SELECT CONCAT(usersessionid, 'del'), iduser, enddate as access, 'del'
            FROM $tableUserSession
            WHERE roomsessionid = %d) ORDER BY access ASC";        
            break;       	          
    }				

	if ($sessions = $wpdb->get_results($wpdb->prepare($query, $id, $id))) {
        
        /* attendace count number */
        $count = 0;
        /* $time_offset = date('Z');
        auxiliary var to save prec time of enter/exit room */
        $precaccess = 0;
        foreach ($sessions as $s) {

            $preccount = $count;

            if ($s->add == 'add') {
                $count++;
            } else {
                $count--;
            }
			
			/* get user local time offset $config->getValue('config.offset') is system default offset*/	
			$usertimezone = wp_timezone_string();
			$usertime = new DateTime($s->access, new DateTimeZone('UTC'));
			$usertime->setTimeZone(new DateTimeZone($usertimezone));
			$timezoneoffset = $usertime->getOffset();	    

            /* compute save day light offset */
            //$dst = dst_offset_on( (int)$s->access);
            //$dst = 0;
            $access = $usertime->getTimeStamp() + $timezoneoffset; //+ $dst;
            
            /* control condition that avoid to save two adjacent items having same time instants */
            if ($access != $precaccess && $precaccess != 0 ) {
                /* first, compute all events having same time instants, then add only one with sum of counts */
                $aux = array($precaccess * 1000, (int)$preccount);
                $json[] = $aux;
                /* add actual item
                notice: timestamp converted in milliseconds */
                $aux = array($access * 1000, (int)$count);
                $json[] = $aux;
            }
            $precaccess = $access;
        }
    }	    
}

echo json_encode($json);
