<?php

require('../../../../../../wp-blog-header.php');

$table = $wpdb->prefix . 'tlive_rooms';
$timezone = wp_timezone_string(); 
$query = "SELECT * FROM $table";
$res = $wpdb->get_results($query);
$arrayjson = array();

/* Load events already scheduled, not writable */

$count = 1;
$update = (int) $_GET['update'];

if (!empty($res)) {
    foreach ($res as $r) {
        if ($r->id != $update) {
        	
        	/* riscrive la data rispetto alla timezone dell'utente */
        	$start = new DateTime($r->timestarted,new DateTimeZone('UTC'));
        	$start->setTimeZone(new DateTimeZone($timezone) );
        	
        	$end = new DateTime($r->timecompleted,new DateTimeZone('UTC'));  
        	$end->setTimeZone(new DateTimeZone($timezone) );

            $arrayjson[] = [            
	            'id'=>$count,
	            'title'=> $r->title,
	            'start'=> $start->format('c'),
	            'end'=> $end->format('c'),
	            'users'=> $r->users,
	            'readonly'=>'true'
            ];

            $count++;
        }
    }
}

/* Load temporary event created at the end of list
 * if already inserted, load its title from db, else print "New event"
 */
$query = "SELECT * FROM $table WHERE id = %d";
$titleupdate = $wpdb->get_row($wpdb->prepare($query, $update));
$title = "";

if (!empty($titleupdate->title)) {	
    $title = $titleupdate->title;
} else {
    $title = __('New Event', 'teleskill-tlive');
}

if (!empty($_GET)) {

    $start = $_GET['s'];
    $end = $_GET['e'];
    $users = (int) $_GET['u'];  
   
    $start = new DateTime($start,new DateTimeZone($timezone));        
	$end = new DateTime($end,new DateTimeZone($timezone));    

    $arrayjson[] = [
        'id'        => $count,
        'title'     => $title,
        'start'     => $start->format('c'),
        'end'       => $end->format('c'),
        'users'     => $users,
        'readonly'  => 'false'
    ];
}

echo json_encode($arrayjson);
