<?php

/**
** Wordpress Table List Class
**/

if( ! class_exists( 'WP_List_Table' ) ) {
    require_once( ABSPATH . 'wp-admin/includes/class-wp-list-table.php' );
}

class TliveListTable extends WP_List_Table {

	private $columns;
	private $dspbulk;

	function get_columns() {
		return $this->columns;
	}

	function set_columns($columns) {
		$this->columns = $columns;
	}

	function set_items($data) {
		$this->items = $data;
	}
	
	function set_dspbulk($display = true) {
		$this->dspbulk = $display;
	}
	
	function get_dspbulk() {
		return $this->dspbulk;
	}

	function prepare_items() {
		  $columns = $this->get_columns();
		  $hidden = array();
		  $sortable = array();
		  $this->_column_headers = array($columns, $hidden, $sortable);
	}

	function column_default( $item, $column_name ) {
	    return $item[ $column_name ];
	}

	function column_title($item) {
		$actions = array();
		if (current_user_can('publish_pages')) {
	 		$actions = $item['actions'];	
   		}
  		return sprintf('%1$s %2$s', $item['title'], $this->row_actions($actions) );
	}

	function column_cb($item) {
        $return = sprintf('<input type="checkbox" name="rooms[]" value="%s" />', $item['id']);
	    return $return;
    }

    function get_bulk_actions() {
    	$actions = array();
    	if (current_user_can('publish_pages') && $this->get_dspbulk()) {
		  	$actions = ['delete' => __('Delete room', 'teleskill-tlive')];
		}
	  	return $actions;
	}
}
