<?php

function tlive_save_room($data, $files) {

	global $wpdb;	
	
	$tvcl 	= new TvclHelper();
	$id 	= (int)$data['id'];

	$day 	= (isset($data['day'])) ? date("Y/m/d", strtotime($data['day'])) : null;
	$start 	= (isset($data['start'])) ? $data['start'] : null;
	$end 	= (isset($data['end'])) ? $data['end'] : null;
	$confManagers = (isset($data['conf_manager'])) ? $data['conf_manager'] : null;

	$title 	= sanitize_text_field($data['title']);
	$title 	= stripslashes($title);
	
	$settings = get_option('tlive-settings');	
	$timezone = new DateTimeZone(wp_timezone_string());
	$maxUsers = $settings['max_users'];

	$usersNumber	= (int)$data['usersNumber'];
	$emailConfman 	= isset($data['emailconfman']) ? (int)$data['emailconfman'] : 0;	
	$emailusers 	= isset($data['emailusers']) ? (int)$data['emailusers'] : 0;

	/* build date respecting server time zone */
	if(!$settings['disable_date']) {
		$datestart 	= new DateTime($day . ' ' . $start, $timezone);
		$dateend 	= new DateTime($day . ' ' . $end, $timezone);
	} else {
		$datestart 	= new DateTime('now', $timezone);
		$dateend 	= new DateTime('now', $timezone);
	}
	
	/* convert to UTC */
	$datestart->setTimeZone(new DateTimeZone('UTC'));
	$dateend->setTimeZone(new DateTimeZone('UTC'));

	if (empty($data['title'])) {
		return new WP_Error('emptytitle', __('Warning. Insert a title', 'teleskill-tlive'));
	}

	if (!$confManagers) {
		return new WP_Error('emptyconfmanager', __('Warning. Select at least one conference manager', 'teleskill-tlive'));
	}

	/* check if date format is incorrect */
	if (!$settings['disable_date'] && !preg_match('@([0-9]{4})[/]([0-9]{2})[/]([0-9]{2})@', $day)) {
		return new WP_Error('datemalformed', __('Warning. Insert a correct date', 'teleskill-tlive'));
	}
	
	if(!$settings['disable_date']) {
		if (!$tvcl->event_availability($datestart->format('Y-m-d H:i:s'), $dateend->format('Y-m-d H:i:s'), $maxUsers, $usersNumber, $id)) {
			return new WP_Error('max_users_reached', __('Warning! There are no places available.', 'teleskill-tlive'));	
		}	
	}
	
	/* load images */
	$allowed_images = [
		'image/jpeg',
		'image/gif',
		'image/png'
	];

	$headers[] = 'Content-Type:text/html';

	$upload_dir = wp_upload_dir();

	foreach ($files as $key => $file) {

		if (($file['error'] == 0) ) {

			if(!in_array($file['type'], $allowed_images)) {
				return new WP_Error('imagenotallowed', __('Error. Image type not allowed', 'teleskill-tlive'));
			}

			if (!move_uploaded_file($file['tmp_name'], $upload_dir['path'] . '/' . $file['name'])) {
				return new WP_Error('imagenotsaved', __('Errore. Image not uploaded', 'teleskill-tlive'));
			}

			$filename = $file['name'];
		} else {
			/* load last filename */
			$filename = $wpdb->get_var($wpdb->prepare (
				"SELECT " . $key . " FROM $wpdb->tlive_rooms WHERE id = %d", $id)
			);
		}

		/* save logo and banner url */
		$data[$key] = $filename;
	}

	if($id == 0) {
		$curlResponse = $tvcl->createRoom($data);
	} else {
		$roomid = $wpdb->get_var($wpdb->prepare (
		"SELECT roomid FROM $wpdb->tlive_rooms WHERE id = %d", $id)
		);

		$curlResponse = $tvcl->editRoom($data, $roomid);
	}

	if (empty($curlResponse)) {
		 return new WP_Error('responsefailed', __('Connection failed. Check if URL server and CCC in general settings are correct', 'teleskill-tlive'));
	}

	//if room creation is successfull, insert room record in db
	if ((int)$curlResponse->errorcode != 0) {
		return new WP_Error('creationfailed', __((string)$curlResponse->errormessage, 'teleskill-tlive'));
	}

	$data['roomid'] = $curlResponse->roomid;

	$auto_enrol = (isset($data['auto_enrol'])) ? (int)$data['auto_enrol'] : 0;

	$logo   = $data['logo'];
	$banner = $data['banner'];

	$emailDay = tlive_print_datetime($datestart->format('Y-m-d H:i:s'),'l, j F Y, H:i');

	/* New room */
	if ($id == 0) {

		$roomid = (int)$data['roomid'];

		$query = "INSERT INTO $wpdb->tlive_rooms
			(title, timestarted, timecompleted, roomid, users, emailconfman, emailusers, auto_enrol, logo, banner)
			VALUES(%s, %s, %s, %d, %d, %d, %d, %d, %s, %s)";

		/* save room */
		$wpdb->query( $wpdb->prepare ($query, [
			$title, 
			$datestart->format('Y-m-d H:i:s'), 
			$dateend->format('Y-m-d H:i:s'),
			$roomid, 
			$usersNumber, 
			$emailConfman, 
			$emailusers, 
			$auto_enrol, 
			$logo, 
			$banner
		]));

		$id = $wpdb->insert_id;
		
		/* enrol conference manager */
		// Loop through all selected conference managers
		$query = "INSERT INTO $wpdb->tlive_enrolments (classroom_id, user_id, role) VALUES(%d, %d, %d)";

		foreach ($confManagers as $confManager) {
			$wpdb->query( $wpdb->prepare ($query, [$id, $confManager, CONFERENCE_MANAGER_ROLE_ID]));

			if($emailConfman) {
				/* send email to new conference manager */
				$url = 	sprintf(admin_url('admin.php?page=tlive-room-login&id=%d'), $id);
				$to = get_userdata($confManager)->user_email;
				$subject = sprintf(__('Videoconference %s', 'teleskill-tlive'), $title);
		
				//load config params
				$params = get_option('tlive-settings');
		
				if (!$params['disable_date']) {
					$message = sprintf(__("You are selected as Conference manager for the meeting titled <b>%s</b> scheduled on <b>%s</b>. <br>".
					"You are requested to join the videoconference as first user at the starting time o'clock in order to start it. ".
					"None else than you is allowed to start this web meeting.<br> ".
					"To access videoconference, follow this link <a href='%s'>%s</a><br><br>Thanks in advance for your punctuality.", 'teleskill-tlive'), $title, $emailDay, $url, $url);
				} else {
					$message = sprintf(__("You are selected as Conference manager for the meeting titled <b>%s</b>. <br>".
					"You are requested to join the videoconference as first user at the starting time o'clock in order to start it. ".
					"None else than you is allowed to start this web meeting.<br>.".
					"To access videoconference, follow this link <a href='%s'>%s</a><br><br>Thanks in advance for your punctuality.", 'teleskill-tlive'), $title, $url, $url);
				}
		
				/* send email */
				wp_mail($to, $subject, $message, $headers);
			}
		}

	/* edit room */
	} else {
		
		//load room record
	    $query = "SELECT * FROM $wpdb->tlive_rooms WHERE id = %d";
	    $room = $wpdb->get_row($wpdb->prepare($query, $id));
	    $precdatestart = new DateTime($room->timestarted, new DateTimeZone('UTC'));

		$query = "UPDATE $wpdb->tlive_rooms
			SET title = %s, timestarted = %s, timecompleted = %s, users = %d, auto_enrol = %d, emailconfman = %d, emailusers = %d, logo = %s, banner = %s WHERE id = %d";

		/* save room */
		$wpdb->query( $wpdb->prepare ($query, [
			$title,
			$datestart->format('Y-m-d H:i:s'),
			$dateend->format('Y-m-d H:i:s'),
			$usersNumber,
			$auto_enrol,
			$emailConfman,
			$emailusers,
			$logo,
			$banner,
			$id
		]));
		
		/* If user mail notification is enabled */
		if ($emailusers) {

			/* check if date event is changed, then send emails to users */
			if(!$settings['disable_date'] && $precdatestart != $datestart) {

				$query="SELECT u.id, u.user_email FROM $wpdb->tlive_enrolments AS e
					INNER JOIN $wpdb->users AS u ON e.user_id = u.ID
					WHERE e.classroom_id = %d";

				if ($users = $wpdb->get_results($wpdb->prepare($query, $id))) {

					$subject = sprintf(__('Videoconference %s', 'teleskill-tlive'), $title);
					$message = sprintf(__("The videconference <b>%s</b> starting date is changed.".
					"<br>The new starting time is <b>%s</b>. You are request to take note of it. <br>".
					"Thanks for the commitment.","tlive"),$title,$emailDay);

					foreach($users as $user) {
						$to = $user->user_email;
						wp_mail($to, $subject, $message, $headers);
					}
				}
			}
		}

		// Gestione conference manager

		/* retrieve old conference manager */
		$query = "SELECT user_id FROM $wpdb->tlive_enrolments WHERE classroom_id = %d AND role = %s";
		$currentConfManagers = $wpdb->get_results($wpdb->prepare($query, $id, CONFERENCE_MANAGER_ROLE_ID), ARRAY_A);
		
		var_dump($confManagers);
		echo "<br>";
		var_dump($currentConfManagers);
		echo "<br>";
		var_dump(array_column($currentConfManagers, 'user_id'));
		echo "<br>";
		
		// Ciclo dei Conference Manager precedenti per individuare quali rimuovere e quali confermare
		foreach (array_column($currentConfManagers, 'user_id') as $confManId) {
			
			$element = array_search($confManId, $confManagers);

			if(!$element) {
			print_r('passo qui');
				// Conference Manager rimosso
				$query = "DELETE FROM $wpdb->tlive_enrolments WHERE classroom_id = %d AND role = %d AND user_id = %d";
				$wpdb->query($wpdb->prepare($query, [$id, CONFERENCE_MANAGER_ROLE_ID, (int)$confManId]));

				if($emailConfman) {
					/* send email to old conference manager */
					$subject = sprintf(__('Videoconference %s', 'teleskill-tlive'), $title);
					$message = sprintf(__("You are removed as conference manager of <b>%s</b>.<br>Thanks, anyway, for the commitment.<br>", 'teleskill-tlive'), $title);
					$to = get_userdata((int)$confManId)->user_email;
				
					/* send email */
					wp_mail($to, $subject, $message, $headers);
				}

			} else {
				// Conference Manager confermato
				unset($confManagers[$element]);
			}

		}

		/* enrol conference manager */
		// Loop through all selected conference managers
		$query = "INSERT INTO $wpdb->tlive_enrolments (classroom_id, user_id, role) VALUES(%d, %d, %d)";
		foreach ($confManagers as $confManager) {
			$wpdb->query( $wpdb->prepare ($query, [$id, $confManager, CONFERENCE_MANAGER_ROLE_ID]));

			if($emailConfman) {
				/* send email to new conference manager */
				$url = 	sprintf(admin_url('admin.php?page=tlive-room-login&id=%d'), $id);
				$to = get_userdata($confManager)->user_email;
				$subject = sprintf(__('Videoconference %s', 'teleskill-tlive'), $title);
		
				//load config params
				$params = get_option('tlive-settings');
		
				if (!$params['disable_date']) {
					$message = sprintf(__("You are selected as Conference manager for the meeting titled <b>%s</b> scheduled on <b>%s</b>. <br>".
					"You are requested to join the videoconference as first user at the starting time o'clock in order to start it. ".
					"None else than you is allowed to start this web meeting.<br> ".
					"To access videoconference, follow this link <a href='%s'>%s</a><br><br>Thanks in advance for your punctuality.", 'teleskill-tlive'), $title, $emailDay, $url, $url);
				} else {
					$message = sprintf(__("You are selected as Conference manager for the meeting titled <b>%s</b>. <br>".
					"You are requested to join the videoconference as first user at the starting time o'clock in order to start it. ".
					"None else than you is allowed to start this web meeting.<br>.".
					"To access videoconference, follow this link <a href='%s'>%s</a><br><br>Thanks in advance for your punctuality.", 'teleskill-tlive'), $title, $url, $url);
				}
		
				/* send email */
				wp_mail($to, $subject, $message, $headers);	
			}
		}
	}
	return true;
}

function send_mail($title) {
	$subject = sprintf(__('Videoconference %s', 'teleskill-tlive'), $title);
}

function tlive_delete_rooms($rooms) {

	global $wpdb;
	$tvcl = new TvclHelper();
	
	$deleted = 0;
	foreach($rooms as $room) {

		$roomid = $wpdb->get_var($wpdb->prepare(
			"SELECT roomid FROM $wpdb->tlive_rooms WHERE id = %d", $room));

		$curlResponse = $tvcl->deleteRoom($roomid);

		if (empty($curlResponse)) {
			return new WP_Error('noresponse', __("Error. Server not responding.", 'teleskill-tlive'));
		}

		if ((int)$curlResponse->errorcode != 0) {
			return new WP_Error('serverfailed', __("Connection failed. Check if URL server and CCC in general settings are correct", 'teleskill-tlive'));
		}

	 	/* delete room record */
		if( !$wpdb->query($wpdb->prepare("DELETE FROM $wpdb->tlive_rooms WHERE id = %d", $room)) ) {
			return new WP_Error('delroomfailed', __("Error. Unable to delete room.", 'teleskill-tlive'));
		}

		/* delete enrolments */
		if ( !$wpdb->query($wpdb->prepare("DELETE FROM $wpdb->tlive_enrolments where classroom_id = %d", $room)) ) {
			return new WP_Error('delenrolmentsfailed', __("Unable to delete participants list", 'teleskill-tlive'));
		}

		$deleted++;
	}

	return $deleted;
}

function tlive_save_participants($user_ids, $id) {

	global $wpdb;

	//User role
	$role = PARTICIPANT_ROLE_ID;

	//Clear all user previously enrolled and update with new
	$query = "DELETE FROM $wpdb->tlive_enrolments WHERE classroom_id = %d AND role = %d";
	$wpdb->query($wpdb->prepare($query, [$id, $role]));

	$query = "SELECT * FROM $wpdb->tlive_rooms WHERE id = %d";
	$room = $wpdb->get_row($wpdb->prepare($query, $id));
	$title = $room->title;
	$emailusers = (int)$room->emailusers;

	if (!empty($user_ids)) {

		$to = [];
		$url = 	sprintf(admin_url('admin.php?page=tlive-room-login&id=%d'), $id);
		$subject = sprintf(__('Videoconference %s', 'teleskill-tlive'), $title);
		$emailDay = tlive_print_datetime($room->timestarted,'l, j F Y, H:i');

		//load config params
		$params = get_option('tlive-settings');

		if (!$params['disable_date']) {
			$message = sprintf(__("You are enrolled as participant of event <b>%s</b> scheduled on <b>%s</b>. <br>".
			"To access videoconference, follow this link <a href='%s'>%s</a><br><br>".
			"Thank you for your attention.<br>", 'teleskill-tlive'), $title, $emailDay, $url, $url);
		} else {
			$message = sprintf(__("You are enrolled as participant of event <b>%s</b>. <br>".
			"To access videoconference, follow this link <a href='%s'>%s</a><br><br>".
			"Thank you for your attention.<br>", 'teleskill-tlive'), $title, $url, $url);
		}

		$headers[] = 'Content-Type:text/html';

		foreach ($user_ids as $u) {
			$query = "INSERT INTO $wpdb->tlive_enrolments (classroom_id, user_id, role) VALUES (%d, %d, %d)";

			if (!$wpdb->query($wpdb->prepare($query, [$id, $u, $role]))) {
				return new WP_Error('saveparticipantsfailed', __('Error! Unable to save participants list', 'teleskill-tlive'));
			}

			/* prepare e-mails */
			$to = get_userdata($u)->user_email;

			/* send email */
			if ($emailusers) {
				wp_mail($to, $subject, $message, $headers);
			}
		}
	}
	return true;
}

function tlive_print_datetime($datetime, $format) {
	$date = new DateTime($datetime, new DateTimeZone('UTC') );

	//$date->setTimeZone(new DateTimeZone($timezone));
	//$date = get_date_from_gmt( $datetime, $format );
	$dateLocale = $date->getTimestamp() + get_option( 'gmt_offset') * HOUR_IN_SECONDS;
	return date_i18n($format, $dateLocale);
	//return $date->format($format);
}

function tlive_output_buffer() {
	ob_start();
}

function tlive_print_frontend_table($columns, $rows) {
	$html = "<table id='roomList'><thead>";
	         		
	foreach ($columns as $key=> $val) { 
		$html .= "<th>" . $val . "</th>";		
	 }	
	 
	$html .= "</thead><tbody>";		
		 
	for ($i = 0; $i < count($rows); $i++) { 
		$html .= "<tr>";		
					
		foreach ($columns as $key=> $val) { 
			$html .= "<td>" . $rows[$i][$key] . "</td>";				
		}

		$html .= "</tr>";		
	}
			
	$html.= "</tbody></table>";
	echo $html;
}

function roundToNearestMinuteInterval(\DateTime $dateTime, $minuteInterval = 10) {
    return $dateTime->setTime(
        $dateTime->format('H'),
        round($dateTime->format('i') / $minuteInterval) * $minuteInterval,
        0
    );
}
