<?php

add_action('admin_init', 'tliveRegisterSettings');

function tliveRegisterSettings() {

	/* set default settings */
	$default_settings = [
		'tvcl_url' => 'http://asp.teleskill.it/tvclive/server-1-1.asp',
		'max_users' => 100,
		'disable_date' => 0
	];

	add_option('tlive-settings',$default_settings);

	register_setting('tlive-settings-group','tlive-settings','tliveValidateSettings');

	add_settings_section('section', '', 'section_callback', 'tliveManageSettings');

	add_settings_field('tvcl_url', __('Server URL', 'teleskill-tlive'), 'field_tvclurl', 'tliveManageSettings', 'section');
    add_settings_field('ccc', __('CCC', 'teleskill-tlive'), 'field_ccc', 'tliveManageSettings', 'section');
    add_settings_field('max_users', __('Max number of users', 'teleskill-tlive'), 'field_max_users', 'tliveManageSettings', 'section');
    add_settings_field('disable_date', __('Disable room scheduling', 'teleskill-tlive'), 'field_disable_date', 'tliveManageSettings', 'section');

	include_once('settings_fields.php');

	/* enable show settings errors */
	add_action('admin_notices', 'showAdminNotices');
}

function showAdminNotices() {
    settings_errors();
}

function tliveValidateSettings($input) {

	$output = get_option('tlive-settings');
	$output['ccc'] = $input['ccc'];

	$output['disable_date'] = isset($input['disable_date']) ? $input['disable_date'] : null;

	if(!empty($input['tvcl_url'])) {
		$output['tvcl_url'] = $input['tvcl_url'];
	} else {
		add_settings_error('tlive-settings', 'empty-url', __('Error. URL server not defined', 'teleskill-tlive'));
	}

	if (is_numeric($input['max_users'])) {
		$output['max_users'] = $input['max_users'];
	} else {
		 add_settings_error('tlive-settings', 'invalid-numeric', __('Error. Insert a numerical value', 'teleskill-tlive'));
	}

	return $output;
}