<?php

if ( is_user_logged_in() ) {
	
	require_once TLIVE_PATH . '/classes/tablelist.class.php';

	global $wpdb;

	$user = wp_get_current_user();
	$timezone = wp_timezone_string();
	$settings = get_option('tlive-settings');

	/* check bulk delete action */
	echo '<div class="wrap">
		<h2>' . __('Rooms Available', 'teleskill-tlive') . '</h2>';

	$query = "SELECT cs.id, cs.title, cs.timestarted, cs.timecompleted,
			(SELECT count(user_id) FROM $wpdb->tlive_enrolments AS ce
				WHERE cs.id=ce.classroom_id AND ce.role=1 GROUP BY ce.classroom_id) AS user_count
		FROM $wpdb->tlive_rooms as cs ";
		
	/* filter allowed rooms if user is not an admin */	
	if(!current_user_can('publish_pages')) {
		
		$query .= "INNER JOIN $wpdb->tlive_enrolments AS te
			ON cs.id = te.classroom_id  
			WHERE user_id = %d AND auto_enrol = 0
			UNION 
			SELECT cs.id, cs.title, cs.timestarted, cs.timecompleted,
			(SELECT count(user_id) FROM $wpdb->tlive_enrolments AS ce
				WHERE cs.id = ce.classroom_id AND ce.role = 1 GROUP BY ce.classroom_id) AS user_count
			FROM $wpdb->tlive_rooms as cs
			LEFT JOIN $wpdb->tlive_enrolments AS ce ON cs.id = ce.classroom_id AND ce.user_id = %d
			WHERE cs.auto_enrol = 1 ORDER BY id DESC";	

		$rooms = $wpdb->get_results($wpdb->prepare($query, $user->ID, $user->ID), ARRAY_A);	
	} else {
		$query .= " ORDER BY id DESC";
		$rooms = $wpdb->get_results($query, ARRAY_A);	
	}

	if ($rooms) {
		for($i = 0; $i < count($rooms) ; $i++) {		
			$rooms[$i]['title'] = stripslashes($rooms[$i]['title']);

			/* format date event, time start and close */
			if (!$settings['disable_date']) {
				$rooms[$i]['day'] = tlive_print_datetime($rooms[$i]['timestarted'], 'l, j F Y');
				$rooms[$i]['timestarted'] = tlive_print_datetime($rooms[$i]['timestarted'], 'H:i');
				$rooms[$i]['timecompleted'] = tlive_print_datetime($rooms[$i]['timecompleted'], 'H:i');
			} else {
				$rooms[$i]['day'] = '-';
				$rooms[$i]['timestarted'] = '-';
				$rooms[$i]['timecompleted'] = '-';
			}

			$usercount = '<span class="dashicons dashicons-groups" style="margin-left: 10px; margin-right: 10px; font-size: 28px; cursor: pointer;"></span>' . (int)$rooms[$i]['user_count'];			
			
			if (current_user_can('publish_pages')) {	
				$usercount = sprintf('<a href="?page=%s&id=%d">' . $usercount . '</a>', 'tlive-manage-participants', $rooms[$i]['id']);
				$rooms[$i]['reports'] = sprintf('<a href="?page=%s&id=%d"><span class="dashicons dashicons-analytics" style="margin-left: 10px; margin-right: 10px; font-size: 28px; cursor: pointer;"></span></a>', 'tlive-rooms-sessions', $rooms[$i]['id']);
			}
			
			$rooms[$i]['user_count'] = $usercount;			
			//$data = get_userdata($rooms[$i]['conf_manager']); 						
			//$rooms[$i]['conf_manager'] = (!empty($data->first_name) || !empty($data->last_name)) ? $data->first_name . ' ' . $data->last_name : $data->user_nicename;
		
			/* Login url for each room */
			$rooms[$i]['access'] = sprintf('<a target="_blank" href="/wp-admin/admin.php?page=%s&id=%d"><span class="dashicons dashicons-desktop" style="margin-left: 10px; margin-right: 10px; font-size: 28px; cursor: pointer;"></span></a>', 'tlive-room-login', $rooms[$i]['id']);
			$rooms[$i]['actions'] = array(
				'edit' => sprintf('<a href="?page=tlive-manage-room&id=%s&action=edit">' . __('Edit') . '</a>', $rooms[$i]['id']),
			);
		}
	}

	$columns['title'] = __('Title', 'teleskill-tlive');
	$columns['day'] = __('Event date', 'teleskill-tlive');
	$columns['timestarted'] = __('Start', 'teleskill-tlive');
	$columns['timecompleted'] = __('End', 'teleskill-tlive');
	$columns['access'] = __('Access', 'teleskill-tlive');

	tlive_print_frontend_table($columns, $rooms);

	echo '</div>';
}