<?php
/*
*@package TeleskillTlive
*/

/* 
Plugin Name: Teleskill Live 6.0
Plugin URI: http://www.teleskill.net/ 
Author: Teleskill Italia S.r.l.
Version: 6.0.0
Description: Teleskill Live 6.0 SSO plugin 
Text Domain: teleskill-tlive
Domain Path: /languages
*/

defined('ABSPATH') or die;

define('TLIVE_PATH', trailingslashit( plugin_dir_path(__FILE__)));
define('TLIVE_URL', trailingslashit( plugins_url('/', __FILE__)));
define('PLUGIN_BASENAME', plugin_basename(__FILE__));
define('CONFERENCE_MANAGER_ROLE_ID', 2);
define('PARTICIPANT_ROLE_ID', 1);
define('POLLS_LIST_STATS', 0);
define('SESSIONS_LIST_STATS', 1);
define('LESSONS_LIST_STATS', 2);
define('LESSONS_LIST_TOTAL_STATS', 3);

add_action('init', 'tlive_init');
add_action('init', 'tlive_add_custom_shortcode');
add_action('init', 'tlive_load_text_domain');

require_once TLIVE_PATH . '/inc/functions.php';
if(is_admin()) {

    require_once TLIVE_PATH . '/admin/admin.php';

    register_activation_hook( __FILE__, 'tlive_install');
    register_deactivation_hook( __FILE__, 'tlive_uninstall');
	add_action('init', 'tlive_output_buffer');
    // Aggiunge 'settings' nelle opzioni del plugin
    add_filter('plugin_action_links_' . PLUGIN_BASENAME, 'settingsLink');

    // Aggiunge Menu
    require_once TLIVE_PATH . '/admin/menu.php';

    // Aggiunge settings page
    require_once TLIVE_PATH . '/inc/settings.php';

} else {
    require_once TLIVE_PATH . '/public/public.php';
}

function tlive_init() {
	
	global $wpdb;
	
	/* load tables handles */
	$wpdb->tlive_rooms = $wpdb->prefix . 'tlive_rooms';
	$wpdb->tlive_enrolments = $wpdb->prefix . 'tlive_enrolments';	
	$wpdb->tlive_rooms_logs = $wpdb->prefix . 'tlive_rooms_logs';	
	$wpdb->tlive_rooms_sessions = $wpdb->prefix . 'tlive_rooms_sessions';
	$wpdb->tlive_user_sessions = $wpdb->prefix . 'tlive_user_sessions';
	$wpdb->tlive_users_poll_answers = $wpdb->prefix . 'tlive_users_poll_answers';
	$wpdb->tlive_rooms_sessions = $wpdb->prefix . 'tlive_rooms_sessions';
	$wpdb->tlive_lesson_sessions = $wpdb->prefix . 'tlive_lesson_sessions';
	$wpdb->tlive_lesson_user_sessions = $wpdb->prefix . 'tlive_lesson_user_sessions';
	$wpdb->tlive_polls = $wpdb->prefix . 'tlive_polls';
	$wpdb->tlive_polls_answers = $wpdb->prefix . 'tlive_polls_answers';
	$wpdb->tlive_polls_sessions = $wpdb->prefix . 'tlive_polls_sessions';
	$wpdb->tlive_presence_check = $wpdb->prefix . 'tlive_presence_check';
	$wpdb->tlive_user_presences = $wpdb->prefix . 'tlive_user_presences';

	//load_plugin_textdomain('tlive', false, basename( dirname( __FILE__ ) ) . '/languages');
	//tlive_register_scripts();
	
	date_default_timezone_set(wp_timezone_string());
}

function tlive_add_custom_shortcode() {
	add_shortcode( 'tlive-view-rooms', 'tlive_frontend_view_rooms' );
}

function tlive_load_text_domain() {
	load_plugin_textdomain('teleskill-tlive', false, dirname( plugin_basename( __FILE__ ) ) . '/languages');
}

function tlive_frontend_view_rooms() {
	wp_enqueue_style('tlivestyle', plugins_url('/public/css/style.css', __FILE__));
	ob_start();
	include_once(TLIVE_PATH . '/public/frontendViewRooms.php');
	return ob_get_clean();
}