<?php
// da_DK

return [
    'language' => 'Danish',
    'formats' => [
        'date' => 'DD-MM-YYYY',
        'time' => 'HH:MM:SS',
        'datetime' => 'DD-MM-YYYY HH:MM:SS',
        'money' => '[$kr.]#,##0.00;[RED][$kr.]-#,##0.00',
    ],
    'functions' => [
        'HENTPIVOTDATA' => 'GETPIVOTDATA', //Returnerer data, der er lagret i en pivottabelrapport
        'KUBE.KPI.MEDLEM' => 'CUBEKPIMEMBER', //Returnerer navn, egenskab og mål for en KPI-indikator og viser navnet og egenskaben i cellen. En KPI-indikator er en målbar størrelse, f.eks. bruttooverskud pr. måned eller personaleudskiftning pr. kvartal, der bruges til at overvåge en organisations præstationer.
        'KUBE.MEDLEM' => 'CUBEMEMBER', //Returnerer et medlem eller en tupel fra kubehierarkiet. Bruges til at validere, om et medlem eller en tupel findes i kuben.
        'KUBEMEDLEM.EGENSKAB' => 'CUBEMEMBERPROPERTY', //Returnerer værdien af en egenskab for et medlem i kuben. Bruges til at validere, om et medlemsnavn findes i kuben, og returnere den angivne egenskab for medlemmet.
        'KUBEMEDLEM.RANG' => 'CUBERANKEDMEMBER', //Returnerer det n'te eller rangordnede medlem i et sæt. Bruges til at returnere et eller flere elementer i et sæt, f.eks. topsælgere eller de 10 bedste elever.
        'KUBESÆT' => 'CUBESET', //Definerer et beregnet sæt medlemmer eller tupler ved at sende et sætudtryk til kuben på serveren, som opretter sættet og returnerer det til Microsoft Office Excel.
        'KUBESÆT.TÆL' => 'CUBESETCOUNT', //Returnerer antallet af elementer i et sæt.
        'KUBEVÆRDI' => 'CUBEVALUE', //Returnerer en sammenlagt (aggregeret) værdi fra en kube.
        'DMIDDEL' => 'DAVERAGE', //Returnerer gennemsnittet af markerede databaseposter
        'DTÆL' => 'DCOUNT', //Tæller de celler, der indeholder tal, i en database
        'DTÆLV' => 'DCOUNTA', //Tæller udfyldte celler i en database
        'DHENT' => 'DGET', //Uddrager en enkelt post, der opfylder de angivne kriterier, fra en database
        'DMAKS' => 'DMAX', //Returnerer den største værdi blandt markerede databaseposter
        'DMIN' => 'DMIN', //Returnerer den mindste værdi blandt markerede databaseposter
        'DPRODUKT' => 'DPRODUCT', //Ganger værdierne i et bestemt felt med poster, der opfylder kriterierne i en database
        'DSTDAFV' => 'DSTDEV', //Beregner et skøn over standardafvigelsen baseret på en stikprøve af markerede databaseposter
        'DSTDAFVP' => 'DSTDEVP', //Beregner standardafvigelsen baseret på hele populationen af markerede databaseposter
        'DSUM' => 'DSUM', //Sammenlægger de tal i feltkolonnen i databasen, der opfylder kriterierne
        'DVARIANS' => 'DVAR', //Beregner varians baseret på en stikprøve af markerede databaseposter
        'DVARIANSP' => 'DVARP', //Beregner varians baseret på hele populationen af markerede databaseposter
        'DATO' => 'DATE', //Returnerer serienummeret for en bestemt dato
        'DATOVÆRDI' => 'DATEVALUE', //Konverterer en dato i form af tekst til et serienummer
        'DAG' => 'DAY', //Konverterer et serienummer til en dag i måneden
        'DAGE360' => 'DAYS360', //Beregner antallet af dage mellem to datoer på grundlag af et år med 360 dage
        'EDATO' => 'EDATE', //Returnerer serienummeret for den dato, der ligger det angivne antal måneder før eller efter startdatoen
        'SLUT.PÅ.MÅNED' => 'EOMONTH', //Returnerer serienummeret på den sidste dag i måneden før eller efter et angivet antal måneder
        'TIME' => 'HOUR', //Konverterer et serienummer til en time
        'MINUT' => 'MINUTE', //Konverterer et serienummer til et minut
        'MÅNED' => 'MONTH', //Konverterer et serienummer til en måned
        'ANTAL.ARBEJDSDAGE' => 'NETWORKDAYS', //Returnerer antallet af hele arbejdsdage mellem to datoer
        'NU' => 'NOW', //Returnerer serienummeret for den aktuelle dato eller det aktuelle klokkeslæt
        'SEKUND' => 'SECOND', //Konverterer et serienummer til et sekund
        'KLOKKESLÆT' => 'TIME', //Returnerer serienummeret for et bestemt klokkeslæt
        'TIDSVÆRDI' => 'TIMEVALUE', //Konverterer et klokkeslæt i form af tekst til et serienummer
        'IDAG' => 'TODAY', //Returnerer serienummeret for dags dato
        'UGEDAG' => 'WEEKDAY', //Konverterer et serienummer til en ugedag
        'UGE.NR' => 'WEEKNUM', //Konverterer et serienummer til et tal, der angiver ugenummeret i året
        'ARBEJDSDAG' => 'WORKDAY', //Returnerer serienummeret for dagen før eller efter det angivne antal arbejdsdage
        'ÅR' => 'YEAR', //Konverterer et serienummer til et år
        'ÅR.BRØK' => 'YEARFRAC', //Returnerer årsbrøken, der repræsenterer antallet af hele dage mellem startdato og slutdato
        'BESSELI' => 'BESSELI', //Returnerer den modificerede Bessel-funktion In(x)
        'BESSELJ' => 'BESSELJ', //Returnerer Bessel-funktionen Jn(x)
        'BESSELK' => 'BESSELK', //Returnerer den modificerede Bessel-funktion Kn(x)
        'BESSELY' => 'BESSELY', //Returnerer Bessel-funktionen Yn(x)
        'BIN.TIL.DEC' => 'BIN2DEC', //Konverterer et binært tal til et decimaltal
        'BIN.TIL.HEX' => 'BIN2HEX', //Konverterer et binært tal til et heksadecimalt tal
        'BIN.TIL.OKT' => 'BIN2OCT', //Konverterer et binært tal til et oktaltal.
        'KOMPLEKS' => 'COMPLEX', //Konverterer reelle og imaginære koefficienter til et komplekst tal
        'KONVERTER' => 'CONVERT', //Konverterer et tal fra én måleenhed til en anden
        'DEC.TIL.BIN' => 'DEC2BIN', //Konverterer et decimaltal til et binært tal
        'DEC.TIL.HEX' => 'DEC2HEX', //Konverterer et decimaltal til et heksadecimalt tal
        'DEC.TIL.OKT' => 'DEC2OCT', //Konverterer et decimaltal til et oktaltal
        'DELTA' => 'DELTA', //Tester, om to værdier er ens
        'FEJLFUNK' => 'ERF', //Returner fejlfunktionen
        'FEJLFUNK.KOMP' => 'ERFC', //Returnerer den komplementære fejlfunktion
        'GETRIN' => 'GESTEP', //Tester, om et tal er større end en grænseværdi
        'HEX.TIL.BIN' => 'HEX2BIN', //Konverterer et heksadecimalt tal til et binært tal
        'HEX.TIL.DEC' => 'HEX2DEC', //Konverterer et decimaltal til et heksadecimalt tal
        'HEX.TIL.OKT' => 'HEX2OCT', //Konverterer et heksadecimalt tal til et oktaltal
        'IMAGABS' => 'IMABS', //Returnerer den absolutte værdi (modulus) for et komplekst tal
        'IMAGINÆR' => 'IMAGINARY', //Returnerer den imaginære koefficient for et komplekst tal
        'IMAGARGUMENT' => 'IMARGUMENT', //Returnerer argumentet theta, en vinkel udtrykt i radianer
        'IMAGKONJUGERE' => 'IMCONJUGATE', //Returnerer den komplekse konjugation af et komplekst tal
        'IMAGCOS' => 'IMCOS', //Returnerer et komplekst tals cosinus
        'IMAGDIV' => 'IMDIV', //Returnerer kvotienten for to komplekse tal
        'IMAGEKSP' => 'IMEXP', //Returnerer et komplekst tals eksponentialfunktion
        'IMAGLN' => 'IMLN', //Returnerer et komplekst tals naturlige logaritme
        'IMAGLOG10' => 'IMLOG10', //Returnerer et komplekst tals sædvanlige logaritme (titalslogaritme)
        'IMAGLOG2' => 'IMLOG2', //Returnerer et komplekst tals sædvanlige logaritme (totalslogaritme)
        'IMAGPOTENS' => 'IMPOWER', //Returnerer et komplekst tal opløftet i en heltalspotens
        'IMAGPRODUKT' => 'IMPRODUCT', //Returnerer produktet af komplekse tal
        'IMAGREELT' => 'IMREAL', //Returnerer den reelle koefficient for et komplekst tal
        'IMAGSIN' => 'IMSIN', //Returnerer et komplekst tals sinus
        'IMAGKVROD' => 'IMSQRT', //Returnerer et komplekst tals kvadratrod
        'IMAGSUB' => 'IMSUB', //Returnerer forskellen mellem to komplekse tal
        'IMAGSUM' => 'IMSUM', //Returnerer summen af komplekse tal
        'OKT.TIL.BIN' => 'OCT2BIN', //Konverterer et oktaltal til et binært tal
        'OKT.TIL.DEC' => 'OCT2DEC', //Konverterer et oktaltal til et decimaltal
        'OKT.TIL.HEX' => 'OCT2HEX', //Konverterer et oktaltal til et heksadecimalt tal
        'PÅLØBRENTE' => 'ACCRINT', //Returnerer den påløbne rente for et værdipapir med periodiske renteudbetalinger
        'PÅLØBRENTE.UDLØB' => 'ACCRINTM', //Returnerer den påløbne rente for et værdipapir, hvor renteudbetalingen finder sted ved papirets udløb
        'AMORDEGRC' => 'AMORDEGRC', //Returnerer afskrivningsbeløbet for hver regnskabsperiode ved hjælp af en afskrivningskoefficient
        'AMORLINC' => 'AMORLINC', //Returnerer afskrivningsbeløbet for hver regnskabsperiode
        'KUPONDAGE.SA' => 'COUPDAYBS', //Returnerer antallet af dage fra starten af kuponperioden til afregningsdatoen
        'KUPONDAGE.A' => 'COUPDAYS', //Returnerer antallet af dage fra begyndelsen af kuponperioden til afregningsdatoen
        'KUPONDAGE.ANK' => 'COUPDAYSNC', //Returnerer antallet af dage i den kuponperiode, der indeholder afregningsdatoen
        'KUPONDAG.NÆSTE' => 'COUPNCD', //Returnerer den næste kupondato efter afregningsdatoen
        'KUPONBETALINGER' => 'COUPNUM', //Returnerer antallet af kuponudbetalinger mellem afregnings- og udløbsdatoen
        'KUPONDAG.FORRIGE' => 'COUPPCD', //Returnerer den forrige kupondato før afregningsdatoen
        'AKKUM.RENTE' => 'CUMIPMT', //Returnerer den akkumulerede rente, der betales på et lån mellem to perioder
        'AKKUM.HOVEDSTOL' => 'CUMPRINC', //Returnerer den akkumulerede nedbringelse af hovedstol mellem to perioder
        'DB' => 'DB', //Returnerer afskrivningen på et aktiv i en angivet periode ved anvendelse af saldometoden
        'DSA' => 'DDB', //Returnerer afskrivningsbeløbet for et aktiv over en bestemt periode ved anvendelse af dobbeltsaldometoden eller en anden afskrivningsmetode, som du angiver
        'DISKONTO' => 'DISC', //Returnerer et værdipapirs diskonto
        'KR.DECIMAL' => 'DOLLARDE', //Konverterer en kronepris udtrykt som brøk til en kronepris udtrykt som decimaltal
        'KR.BRØK' => 'DOLLARFR', //Konverterer en kronepris udtrykt som decimaltal til en kronepris udtrykt som brøk
        'VARIGHED' => 'DURATION', //Returnerer den årlige løbetid for et værdipapir med periodiske renteudbetalinger
        'EFFEKTIV.RENTE' => 'EFFECT', //Returnerer den årlige effektive rente
        'FV' => 'FV', //Returnerer fremtidsværdien af en investering
        'FVTABEL' => 'FVSCHEDULE', //Returnerer den fremtidige værdi af en hovedstol, når der er tilskrevet rente og rentes rente efter forskellige rentesatser
        'RENTEFOD' => 'INTRATE', //Returnerer renten på et fuldt ud investeret værdipapir
        'R.YDELSE' => 'IPMT', //Returnerer renten fra en investering for en given periode
        'IA' => 'IRR', //Returnerer den interne rente for en række pengestrømme
        'ISPMT' => 'ISPMT', //Beregner den betalte rente i løbet af en bestemt investeringsperiode
        'MVARIGHED' => 'MDURATION', //Returnerer Macauleys modificerede løbetid for et værdipapir med en formodet pari på kr. 100
        'MIA' => 'MIRR', //Returnerer den interne forrentning, hvor positive og negative pengestrømme finansieres til forskellig rente
        'NOMINEL' => 'NOMINAL', //Returnerer den årlige nominelle rente
        'NPER' => 'NPER', //Returnerer antallet af perioder for en investering
        'NUTIDSVÆRDI' => 'NPV', //Returnerer nettonutidsværdien for en investering baseret på en række periodiske pengestrømme og en diskonteringssats
        'ULIGE.KURS.PÅLYDENDE' => 'ODDFPRICE', //Returnerer kursen pr. kr. 100 nominel værdi for et værdipapir med en ulige (kort eller lang) første periode
        'ULIGE.FØRSTE.AFKAST' => 'ODDFYIELD', //Returnerer afkastet for et værdipapir med ulige første periode
        'ULIGE.SIDSTE.KURS' => 'ODDLPRICE', //Returnerer kursen pr. kr. 100 nominel værdi for et værdipapir med ulige sidste periode
        'ULIGE.SIDSTE.AFKAST' => 'ODDLYIELD', //Returnerer afkastet for et værdipapir med ulige sidste periode
        'YDELSE' => 'PMT', //Returnerer renten fra en investering for en given periode
        'H.YDELSE' => 'PPMT', //Returnerer ydelsen på hovedstolen for en investering i en given periode
        'KURS' => 'PRICE', //Returnerer kursen pr. kr 100 nominel værdi for et værdipapir med periodiske renteudbetalinger
        'KURS.DISKONTO' => 'PRICEDISC', //Returnerer kursen pr. kr 100 nominel værdi for et diskonteret værdipapir
        'KURS.UDLØB' => 'PRICEMAT', //Returnerer kursen pr. kr 100 nominel værdi for et værdipapir, hvor renten udbetales ved papirets udløb
        'NV' => 'PV', //Returnerer den nuværende værdi af en investering
        'RENTE' => 'RATE', //Returnerer renten i hver periode for en annuitet
        'MODTAGET.VED.UDLØB' => 'RECEIVED', //Returnerer det beløb, der modtages ved udløbet af et fuldt ud investeret værdipapir
        'LA' => 'SLN', //Returnerer den lineære afskrivning for et aktiv i en enkelt periode
        'ÅRSAFSKRIVNING' => 'SYD', //Returnerer den årlige afskrivning på et aktiv i en bestemt periode
        'STATSOBLIGATION' => 'TBILLEQ', //Returnerer det obligationsækvivalente afkast for en statsobligation
        'STATSOBLIGATION.KURS' => 'TBILLPRICE', //Returnerer kursen pr. kr 100 nominel værdi for en statsobligation
        'STATSOBLIGATION.AFKAST' => 'TBILLYIELD', //Returnerer en afkastet på en statsobligation
        'VSA' => 'VDB', //Returnerer afskrivningen på et aktiv i en angivet periode, herunder delperioder, ved brug af dobbeltsaldometoden
        'INTERN.RENTE' => 'XIRR', //Returnerer den interne rente for en plan over pengestrømme, der ikke behøver at være periodiske
        'NETTO.NUTIDSVÆRDI' => 'XNPV', //Returnerer nutidsværdien for en plan over pengestrømme, der ikke behøver at være periodiske
        'AFKAST' => 'YIELD', //Returnerer afkastet for et værdipapir med periodiske renteudbetalinger
        'AFKAST.DISKONTO' => 'YIELDDISC', //Returnerer det årlige afkast for et diskonteret værdipapir, f.eks. en statsobligation
        'AFKAST.UDLØBSDATO' => 'YIELDMAT', //Returnerer det årlige afkast for et værdipapir, hvor renten udbetales ved papirets udløb
        'CELLE' => 'CELL', //Returnerer oplysninger om formatering, placering eller indhold af en celle
        'FEJLTYPE' => 'ERROR.TYPE', //Returnerer et tal, der svarer til en fejltype
        'INFO' => 'INFO', //Returnerer oplysninger om det aktuelle operativmiljø
        'ER.TOM' => 'ISBLANK', //Returnerer SAND, hvis værdien er tom
        'ER.FJL' => 'ISERR', //Returnerer SAND, hvis værdien er en fejlværdi undtagen #I/T
        'ER.FEJL' => 'ISERROR', //Returnerer SAND, hvis værdien er en fejlværdi
        'ER.LIGE' => 'ISEVEN', //Returnerer SAND, hvis tallet er lige
        'ER.LOGISK' => 'ISLOGICAL', //Returnerer SAND, hvis værdien er en logisk værdi
        'ER.IKKE.TILGÆNGELIG' => 'ISNA', //Returnerer SAND, hvis værdien er fejlværdien #I/T
        'ER.IKKE.TEKST' => 'ISNONTEXT', //Returnerer SAND, hvis værdien ikke er tekst
        'ER.TAL' => 'ISNUMBER', //Returnerer SAND, hvis værdien er et tal
        'ER.ULIGE' => 'ISODD', //Returnerer SAND, hvis tallet er ulige
        'ER.REFERENCE' => 'ISREF', //Returnerer SAND, hvis værdien er en reference
        'ER.TEKST' => 'ISTEXT', //Returnerer SAND, hvis værdien er tekst
        'TAL' => 'N', //Returnerer en værdi konverteret til et tal
        'IKKE.TILGÆNGELIG' => 'NA', //Returnerer fejlværdien #I/T
        'VÆRDITYPE' => 'TYPE', //Returnerer et tal, der angiver datatypen for en værdi
        'OG' => 'AND', //Returnerer SAND, hvis alle argumenterne er sande
        'FALSK' => 'FALSE', //Returnerer den logiske værdi FALSK
        'HVIS' => 'IF', //Angiver en logisk test, der skal udføres
        'HVIS.FEJL' => 'IFERROR', //Returnerer en værdi, du angiver, hvis en formel evauleres som en fejl. Returnerer i modsat fald resultatet af formlen
        'IKKE' => 'NOT', //Vender argumentets logik om
        'ELLER' => 'OR', //Returneret værdien SAND, hvis mindst ét argument er sandt
        'SAND' => 'TRUE', //Returnerer den logiske værdi SAND
        'ADRESSE' => 'ADDRESS', //Returnerer en reference som tekst til en enkelt celle i et regneark
        'OMRÅDER' => 'AREAS', //Returnerer antallet af områder i en reference
        'VÆLG' => 'CHOOSE', //Vælger en værdi på en liste med værdier
        'KOLONNE' => 'COLUMN', //Returnerer kolonnenummeret i en reference
        'KOLONNER' => 'COLUMNS', //Returnerer antallet af kolonner i en reference
        'VOPSLAG' => 'HLOOKUP', //Søger i den øverste række af en matrix og returnerer værdien af den angivne celle
        'HYPERLINK' => 'HYPERLINK', //Opretter en genvej kaldet et hyperlink, der åbner et dokument, som er lagret på en netværksserver, på et intranet eller på internettet
        'INDEKS' => 'INDEX', //Anvender et indeks til at vælge en værdi fra en reference eller en matrix
        'INDIREKTE' => 'INDIRECT', //Returnerer en reference, der er angivet af en tekstværdi
        'SLÅ.OP' => 'LOOKUP', //Søger værdier i en vektor eller en matrix
        'SAMMENLIGN' => 'MATCH', //Søger værdier i en reference eller en matrix
        'FORSKYDNING' => 'OFFSET', //Returnerer en reference forskudt i forhold til en given reference
        'RÆKKE' => 'ROW', //Returnerer rækkenummeret for en reference
        'RÆKKER' => 'ROWS', //Returnerer antallet af rækker i en reference
        'RTD' => 'RTD', //Henter realtidsdata fra et program, der understøtter COM-automatisering (Automation: En metode til at arbejde med objekter fra et andet program eller udviklingsværktøj. Automation, som tidligere blev kaldt OLE Automation, er en industristandard og en funktion i COM (Component Object Model).)
        'TRANSPONER' => 'TRANSPOSE', //Returnerer en transponeret matrix
        'LOPSLAG' => 'VLOOKUP', //Søger i øverste række af en matrix og flytter på tværs af rækken for at returnere en celleværdi
        'ABS' => 'ABS', //Returnerer den absolutte værdi af et tal
        'ARCCOS' => 'ACOS', //Returnerer et tals arcus cosinus
        'ARCCOSH' => 'ACOSH', //Returnerer den inverse hyperbolske cosinus af tal
        'ARCSIN' => 'ASIN', //Returnerer et tals arcus sinus
        'ARCSINH' => 'ASINH', //Returnerer den inverse hyperbolske sinus for tal
        'ARCTAN' => 'ATAN', //Returnerer et tals arcus tangens
        'ARCTAN2' => 'ATAN2', //Returnerer de angivne x- og y-koordinaters arcus tangens
        'ARCTANH' => 'ATANH', //Returnerer et tals inverse hyperbolske tangens
        'AFRUND.LOFT' => 'CEILING', //Afrunder et tal til nærmeste heltal eller til nærmeste multiplum af betydning
        'KOMBIN' => 'COMBIN', //Returnerer antallet af kombinationer for et givet antal objekter
        'COS' => 'COS', //Returnerer et tals cosinus
        'COSH' => 'COSH', //Returnerer den inverse hyperbolske cosinus af et tal
        'GRADER' => 'DEGREES', //Konverterer radianer til grader
        'LIGE' => 'EVEN', //Runder et tal op til nærmeste lige heltal
        'EKSP' => 'EXP', //Returnerer e opløftet til en potens af et angivet tal
        'FAKULTET' => 'FACT', //Returnerer et tals fakultet
        'DOBBELT.FAKULTET' => 'FACTDOUBLE', //Returnerer et tals dobbelte fakultet
        'AFRUND.GULV' => 'FLOOR', //Runder et tal ned mod nul
        'STØRSTE.FÆLLES.DIVISOR' => 'GCD', //Returnerer den største fælles divisor
        'HELTAL' => 'INT', //Nedrunder et tal til det nærmeste heltal
        'MINDSTE.FÆLLES.MULTIPLUM' => 'LCM', //Returnerer det mindste fælles multiplum
        'LN' => 'LN', //Returnerer et tals naturlige logaritme
        'LOG' => 'LOG', //Returnerer logaritmen for et tal på grundlag af et angivet grundtal
        'LOG10' => 'LOG10', //Returnerer titalslogaritmen af et tal
        'MDETERM' => 'MDETERM', //Returnerer determinanten for en matrix
        'MINVERT' => 'MINVERSE', //Returnerer den inverse matrix for en matrix
        'MPRODUKT' => 'MMULT', //Returnerer matrixproduktet af to matrixer
        'REST' => 'MOD', //Returnerer restværdien fra division
        'MAFRUND' => 'MROUND', //Returnerer et tal afrundet til det ønskede multiplum
        'MULTINOMIAL' => 'MULTINOMIAL', //Returnerer et multinomialt talsæt
        'ULIGE' => 'ODD', //Runder et tal op til nærmeste ulige heltal
        'PI' => 'PI', //Returnerer værdien af pi
        'POTENS' => 'POWER', //Returnerer resultatet af et tal opløftet til en potens
        'PRODUKT' => 'PRODUCT', //Multiplicerer argumenterne
        'KVOTIENT' => 'QUOTIENT', //Returnerer heltalsdelen ved division
        'RADIANER' => 'RADIANS', //Konverterer grader til radianer
        'SLUMP' => 'RAND', //Returnerer et tilfældigt tal mellem 0 og 1
        'SLUMP.MELLEM' => 'RANDBETWEEN', //Returnerer et tilfældigt tal mellem de tal, der angives
        'ROMERTAL' => 'ROMAN', //Konverterer et arabertal til romertal som tekst
        'AFRUND' => 'ROUND', //Afrunder et tal til et angivet antal decimaler
        'RUND.NED' => 'ROUNDDOWN', //Runder et tal ned mod nul
        'RUND.OP' => 'ROUNDUP', //Runder et tal op, væk fra 0 (nul)
        'SERIESUM' => 'SERIESSUM', //Returnerer summen af en potensserie baseret på en formel
        'FORTEGN' => 'SIGN', //Returnerer et tals fortegn
        'SIN' => 'SIN', //Returnerer en given vinkels sinusværdi
        'SINH' => 'SINH', //Returnerer den hyperbolske sinus af et tal
        'KVROD' => 'SQRT', //Returnerer en positiv kvadratrod
        'KVRODPI' => 'SQRTPI', //Returnerer kvadratroden af (tal * pi;)
        'SUBTOTAL' => 'SUBTOTAL', //Returnerer en subtotal på en liste eller i en database
        'SUM' => 'SUM', //Lægger argumenterne sammen
        'SUM.HVIS' => 'SUMIF', //Lægger de celler sammen, der er specificeret af et givet kriterium.
        'SUM.HVISER' => 'SUMIFS', //Lægger de celler i et område sammen, der opfylder flere kriterier.
        'SUMPRODUKT' => 'SUMPRODUCT', //Returnerer summen af produkter af ens matrixkomponenter
        'SUMKV' => 'SUMSQ', //Returnerer summen af argumenternes kvadrater
        'SUMX2MY2' => 'SUMX2MY2', //Returnerer summen af differensen mellem kvadrater af ens værdier i to matrixer
        'SUMX2PY2' => 'SUMX2PY2', //Returnerer summen af summen af kvadrater af tilsvarende værdier i to matrixer
        'SUMXMY2' => 'SUMXMY2', //Returnerer summen af kvadrater af differenser mellem ens værdier i to matrixer
        'TAN' => 'TAN', //Returnerer et tals tangens
        'TANH' => 'TANH', //Returnerer et tals hyperbolske tangens
        'AFKORT' => 'TRUNC', //Afkorter et tal til et heltal
        'MAD' => 'AVEDEV', //Returnerer den gennemsnitlige numeriske afvigelse fra stikprøvens middelværdi
        'MIDDEL' => 'AVERAGE', //Returnerer middelværdien af argumenterne
        'MIDDELV' => 'AVERAGEA', //Returnerer middelværdien af argumenterne og medtager tal, tekst og logiske værdier
        'MIDDEL.HVIS' => 'AVERAGEIF', //Returnerer gennemsnittet (den aritmetiske middelværdi) af alle de celler, der opfylder et givet kriterium, i et område
        'MIDDEL.HVISER' => 'AVERAGEIFS', //Returnerer gennemsnittet (den aritmetiske middelværdi) af alle de celler, der opfylder flere kriterier.
        'BETAFORDELING' => 'BETADIST', //Returnerer den kumulative betafordelingsfunktion
        'BETAINV' => 'BETAINV', //Returnerer den inverse kumulative fordelingsfunktion for en angivet betafordeling
        'BINOMIALFORDELING' => 'BINOMDIST', //Returnerer punktsandsynligheden for binomialfordelingen
        'CHIFORDELING' => 'CHIDIST', //Returnerer fraktilsandsynligheden for en chi2-fordeling
        'CHIINV' => 'CHIINV', //Returnerer den inverse fraktilsandsynlighed for en chi2-fordeling
        'CHITEST' => 'CHITEST', //Foretager en test for uafhængighed
        'KONFIDENSINTERVAL' => 'CONFIDENCE', //Returnerer et konfidensinterval for en population
        'KORRELATION' => 'CORREL', //Returnerer korrelationskoefficienten mellem to datasæt
        'TÆL' => 'COUNT', //Tæller antallet af tal på en liste med argumenter
        'TÆLV' => 'COUNTA', //Tæller antallet af værdier på en liste med argumenter
        'ANTAL.BLANKE' => 'COUNTBLANK', //Tæller antallet af tomme celler i et område
        'TÆLHVIS' => 'COUNTIF', //Tæller antallet af celler, som opfylder de givne kriterier, i et område
        'TÆL.HVISER' => 'COUNTIFS', //Tæller antallet af de celler, som opfylder flere kriterier, i et område
        'KOVARIANS' => 'COVAR', //Beregner kovariansen mellem to stokastiske variabler
        'KRITBINOM' => 'CRITBINOM', //Returnerer den mindste værdi for x, for hvilken det gælder, at fordelingsfunktionen er mindre end eller lig med kriterieværdien.
        'SAK' => 'DEVSQ', //Returnerer summen af de kvadrerede afvigelser fra middelværdien
        'EKSPFORDELING' => 'EXPONDIST', //Returnerer eksponentialfordelingen
        'FFORDELING' => 'FDIST', //Returnerer fraktilsandsynligheden for F-fordelingen
        'FINV' => 'FINV', //Returnerer den inverse fraktilsandsynlighed for F-fordelingen
        'FISHER' => 'FISHER', //Returnerer Fisher-transformationen
        'FISHERINV' => 'FISHERINV', //Returnerer den inverse Fisher-transformation
        'PROGNOSE' => 'FORECAST', //Returnerer en prognoseværdi baseret på lineær tendens
        'FREKVENS' => 'FREQUENCY', //Returnerer en frekvensfordeling i en søjlevektor
        'FTEST' => 'FTEST', //Returnerer resultatet af en F-test til sammenligning af varians
        'GAMMAFORDELING' => 'GAMMADIST', //Returnerer fordelingsfunktionen for gammafordelingen
        'GAMMAINV' => 'GAMMAINV', //Returnerer den inverse fordelingsfunktion for gammafordelingen
        'GAMMALN' => 'GAMMALN', //Returnerer den naturlige logaritme til gammafordelingen, G(x)
        'GEOMIDDELVÆRDI' => 'GEOMEAN', //Returnerer det geometriske gennemsnit
        'FORØGELSE' => 'GROWTH', //Returnerer værdier langs en eksponentiel tendens
        'HARMIDDELVÆRDI' => 'HARMEAN', //Returnerer det harmoniske gennemsnit
        'HYPGEOFORDELING' => 'HYPGEOMDIST', //Returnerer punktsandsynligheden i en hypergeometrisk fordeling
        'SKÆRING' => 'INTERCEPT', //Returnerer afskæringsværdien på y-aksen i en lineær regression
        'TOPSTEJL' => 'KURT', //Returnerer kurtosisværdien for en stokastisk variabel
        'STOR' => 'LARGE', //Returnerer den k'te største værdi i et datasæt
        'LINREGR' => 'LINEST', //Returnerer parameterestimaterne for en lineær tendens
        'LOGREGR' => 'LOGEST', //Returnerer parameterestimaterne for en eksponentiel tendens
        'LOGINV' => 'LOGINV', //Returnerer den inverse fordelingsfunktion for lognormalfordelingen
        'LOGNORMFORDELING' => 'LOGNORMDIST', //Returnerer fordelingsfunktionen for lognormalfordelingen
        'MAKS' => 'MAX', //Returnerer den maksimale værdi på en liste med argumenter.
        'MAKSV' => 'MAXA', //Returnerer den maksimale værdi på en liste med argumenter og medtager tal, tekst og logiske værdier
        'MEDIAN' => 'MEDIAN', //Returnerer medianen for de angivne tal
        'MIN' => 'MIN', //Returnerer den mindste værdi på en liste med argumenter.
        'MINV' => 'MINA', //Returnerer den mindste værdi på en liste med argumenter og medtager tal, tekst og logiske værdier
        'HYPPIGST' => 'MODE', //Returnerer den hyppigste værdi i et datasæt
        'NEGBINOMFORDELING' => 'NEGBINOMDIST', //Returnerer den negative binomialfordeling
        'NORMFORDELING' => 'NORMDIST', //Returnerer fordelingsfunktionen for normalfordelingen
        'NORMINV' => 'NORMINV', //Returnerer den inverse fordelingsfunktion for normalfordelingen
        'STANDARDNORMFORDELING' => 'NORMSDIST', //Returnerer fordelingsfunktionen for standardnormalfordelingen
        'STANDARDNORMINV' => 'NORMSINV', //Returnerer den inverse fordelingsfunktion for standardnormalfordelingen
        'PEARSON' => 'PEARSON', //Returnerer Pearsons korrelationskoefficient
        'FRAKTIL' => 'PERCENTILE', //Returnerer den k'te fraktil for datasættet
        'PROCENTPLADS' => 'PERCENTRANK', //Returnerer den procentuelle rang for en given værdi i et datasæt
        'PERMUT' => 'PERMUT', //Returnerer antallet af permutationer for et givet sæt objekter
        'POISSON' => 'POISSON', //Returnerer fordelingsfunktionen for en Poisson-fordeling
        'SANDSYNLIGHED' => 'PROB', //Returnerer intervalsandsynligheden
        'KVARTIL' => 'QUARTILE', //Returnerer kvartilen i et givet datasæt
        'PLADS' => 'RANK', //Returnerer rangen for et tal på en liste med tal
        'FORKLARINGSGRAD' => 'RSQ', //Returnerer R2-værdien fra en simpel lineær regression
        'SKÆVHED' => 'SKEW', //Returnerer skævheden for en stokastisk variabel
        'HÆLDNING' => 'SLOPE', //Returnerer estimatet på hældningen fra en simpel lineær regression
        'MINDSTE' => 'SMALL', //Returnerer den k'te mindste værdi i datasættet
        'STANDARDISER' => 'STANDARDIZE', //Returnerer en standardiseret værdi
        'STDAFV' => 'STDEV', //Estimerer standardafvigelsen på basis af en stikprøve
        'STDAFVV' => 'STDEVA', //Beregner standardafvigelsen på basis af en prøve og medtager tal, tekst og logiske værdier
        'STDAFVP' => 'STDEVP', //Beregner standardafvigelsen på basis af en hel population
        'STDAFVPV' => 'STDEVPA', //Beregner standardafvigelsen på basis af en hel population og medtager tal, tekst og logiske værdier
        'STFYX' => 'STEYX', //Returnerer standardafvigelsen for de estimerede y-værdier i den simple lineære regression
        'TFORDELING' => 'TDIST', //Returnerer fordelingsfunktionen for Student's t-fordeling
        'TINV' => 'TINV', //Returnerer den inverse fordelingsfunktion for Student's t-fordeling
        'TENDENS' => 'TREND', //Returnerer værdi under antagelse af en lineær tendens
        'TRIMMIDDELVÆRDI' => 'TRIMMEAN', //Returnerer den trimmede middelværdi for datasættet
        'TTEST' => 'TTEST', //Returnerer den sandsynlighed, der er forbundet med Student's t-test
        'VARIANS' => 'VAR', //Beregner variansen på basis af en prøve
        'VARIANSV' => 'VARA', //Beregner variansen på basis af en prøve og medtager tal, tekst og logiske værdier
        'VARIANSP' => 'VARP', //Beregner variansen på basis af hele populationen
        'VARIANSPV' => 'VARPA', //Beregner variansen på basis af hele populationen og medtager tal, tekst og logiske værdier
        'WEIBULL' => 'WEIBULL', //Returnerer fordelingsfunktionen for Weibull-fordelingen
        'ZTEST' => 'ZTEST', //Returnerer sandsynlighedsværdien ved en en-sidet z-test
        'ASC' => 'ASC', //Ændrer engelske tegn i fuld bredde (dobbelt-byte) eller katakana i en tegnstreng til tegn i halv bredde (enkelt-byte)
        'BAHTTEKST' => 'BAHTTEXT', //Konverterer et tal til tekst ved hjælp af valutaformatet ß (baht)
        'TEGN' => 'CHAR', //Returnerer det tegn, der svarer til kodenummeret
        'RENS' => 'CLEAN', //Fjerner alle tegn, der ikke kan udskrives, fra tekst
        'KODE' => 'CODE', //Returnerer en numerisk kode for det første tegn i en tekststreng
        'SAMMENKÆDNING' => 'CONCATENATE', //Sammenkæder adskillige tekstelementer til ét tekstelement
        'KR' => 'DOLLAR', //Konverterer et tal til tekst ved hjælp af valutaformatet kr. (kroner)
        'EKSAKT' => 'EXACT', //Kontrollerer, om to tekstværdier er identiske
        'FIND' => 'FIND', //Søger efter en tekstværdi i en anden tekstværdi (der skelnes mellem store og små bogstaver)
        'FINDB' => 'FINDB', //Søger efter en tekstværdi i en anden tekstværdi (der skelnes mellem store og små bogstaver)
        'FAST' => 'FIXED', //Formaterer et tal som tekst med et fast antal decimaler
        'JIS' => 'JIS', //Ændrer engelske tegn i halv bredde (enkelt-byte) eller katakana i en tegnstreng til tegn i fuld bredde (dobbelt-byte)
        'VENSTRE' => 'LEFT', //Returnerer tegnet længst til venstre i en tekstværdi
        'VENSTREB' => 'LEFTB', //Returnerer tegnet længst til venstre i en tekstværdi
        'LÆNGDE' => 'LEN', //Returnerer antallet af tegn i en tekststreng
        'LÆNGDEB' => 'LENB', //Returnerer antallet af tegn i en tekststreng
        'SMÅ.BOGSTAVER' => 'LOWER', //Konverterer tekst til små bogstaver
        'MIDT' => 'MID', //Returnerer et bestemt antal tegn fra en tekststreng fra og med den angivne startposition
        'MIDTB' => 'MIDB', //Returnerer et bestemt antal tegn fra en tekststreng fra og med den angivne startposition
        'FONETISK' => 'PHONETIC', //Uddrager de fonetiske (furigana) tegn fra en tekststreng
        'STORT.FORBOGSTAV' => 'PROPER', //Konverterer første bogstav i hvert ord i teksten til stort bogstav
        'ERSTAT' => 'REPLACE', //Erstatter tegn i tekst
        'ERSTATB' => 'REPLACEB', //Erstatter tegn i tekst
        'GENTAG' => 'REPT', //Gentager tekst et givet antal gange
        'HØJRE' => 'RIGHT', //Returnerer tegnet længste til højre i en tekstværdi
        'HØJREB' => 'RIGHTB', //Returnerer tegnet længste til højre i en tekstværdi
        'SØG' => 'SEARCH', //Søger efter en tekstværdi i en anden tekstværdi (der skelnes ikke mellem store og små bogstaver)
        'SØGB' => 'SEARCHB', //Søger efter en tekstværdi i en anden tekstværdi (der skelnes ikke mellem store og små bogstaver)
        'UDSKIFT' => 'SUBSTITUTE', //Udskifter gammel tekst med ny tekst i en tekststreng
        'T' => 'T', //Konverterer argumenterne til tekst
        'TEKST' => 'TEXT', //Formaterer et tal og konverterer det til tekst
        'FJERN.OVERFLØDIGE.BLANKE' => 'TRIM', //Fjerner mellemrum fra tekst
        'STORE.BOGSTAVER' => 'UPPER', //Konverterer tekst til store bogstaver
        'VÆRDI' => 'VALUE', //Konverterer et tekstargument til et tal
    ],
];
//EOF
