<?php
// de_DE

return [
    'language' => 'German',
    'formats' => [
        'date' => 'DD.MM.YYYY',
        'time' => 'HH:MM:SS',
        'datetime' => 'DD.MM.YYYY HH:MM:SS',
        'money' => '#,##0.00 [$€];[RED]-#,##0.00 [$€]',
    ],
    'functions' => [
        'PIVOTDATENZUORDNEN' => 'GETPIVOTDATA', //In einem PivotTable-Bericht gespeicherte Daten werden zurückgegeben.
        'CUBEKPIELEMENT' => 'CUBEKPIMEMBER', //Gibt Name, Eigenschaft und Measure eines Key Performance Indicators (KPI) zurück und zeigt den Namen und die Eigenschaft in der Zelle an. Ein KPI ist ein quantifizierbares Maß, wie z. B. der monatliche Bruttogewinn oder die vierteljährliche Mitarbeiterfluktuation, mit dessen Hilfe das Leistungsverhalten eines Unternehmens überwacht werden kann.
        'CUBEELEMENT' => 'CUBEMEMBER', //Gibt ein Element oder ein Tuple in einer Cubehierarchie zurück. Wird verwendet, um zu überprüfen, ob das Element oder Tuple im Cube vorhanden ist.
        'CUBEELEMENTEIGENSCHAFT' => 'CUBEMEMBERPROPERTY', //Gibt den Wert einer Elementeigenschaft im Cube zurück. Wird verwendet, um zu überprüfen, ob ein Elementname im Cube vorhanden ist, und um die für dieses Element angegebene Eigenschaft zurückzugeben.
        'CUBERANGELEMENT' => 'CUBERANKEDMEMBER', //Gibt das n-te oder n-rangige Element in einer Menge zurück. Wird verwendet, um mindestens ein Element in einer Menge zurückzugeben, wie z. B. bester Vertriebsmitarbeiter oder 10 beste Kursteilnehmer.
        'CUBEMENGE' => 'CUBESET', //Definiert eine berechnete Menge Elemente oder Tuples durch Senden eines Mengenausdrucks an den Cube auf dem Server, der die Menge erstellt und an Microsoft Office Excel zurückgibt.
        'CUBEMENGENANZAHL' => 'CUBESETCOUNT', //Gibt die Anzahl der Elemente in einer Menge zurück.
        'CUBEWERT' => 'CUBEVALUE', //Gibt einen Aggregatwert aus einem Cube zurück.
        'DBMITTELWERT' => 'DAVERAGE', //Gibt den Mittelwert der ausgewählten Datenbankeinträge zurück
        'DBANZAHL' => 'DCOUNT', //Zählt die Zellen mit Zahlen in einer Datenbank
        'DBANZAHL2' => 'DCOUNTA', //Zählt nicht leere Zellen in einer Datenbank
        'DBAUSZUG' => 'DGET', //Extrahiert aus einer Datenbank einen einzelnen Datensatz, der den angegebenen Kriterien entspricht
        'DBMAX' => 'DMAX', //Gibt den größten Wert aus ausgewählten Datenbankeinträgen zurück
        'DBMIN' => 'DMIN', //Gibt den kleinsten Wert aus ausgewählten Datenbankeinträgen zurück
        'DBPRODUKT' => 'DPRODUCT', //Multipliziert die Werte in einem bestimmten Feld mit Datensätzen, die den Kriterien in einer Datenbank entsprechen
        'DBSTDABW' => 'DSTDEV', //Schätzt die Standardabweichung auf der Grundlage einer Stichprobe aus ausgewählten Datenbankeinträgen
        'DBSTDABWN' => 'DSTDEVP', //Berechnet die Standardabweichung auf der Grundlage der Grundgesamtheit ausgewählter Datenbankeinträge
        'DBSUMME' => 'DSUM', //Addiert die Zahlen in der Feldspalte mit Datensätzen in der Datenbank, die den Kriterien entsprechen
        'DBVARIANZ' => 'DVAR', //Schätzt die Varianz auf der Grundlage ausgewählter Datenbankeinträge
        'DBVARIANZEN' => 'DVARP', //Berechnet die Varianz auf der Grundlage der Grundgesamtheit ausgewählter Datenbankeinträge
        'DATUM' => 'DATE', //Gibt die fortlaufende Zahl eines bestimmten Datums zurück
        'DATWERT' => 'DATEVALUE', //Wandelt ein Datum in Form von Text in eine fortlaufende Zahl um
        'TAG' => 'DAY', //Wandelt eine fortlaufende Zahl in den Tag des Monats um
        'TAGE360' => 'DAYS360', //Berechnet die Anzahl der Tage zwischen zwei Datumsangaben ausgehend von einem Jahr, das 360 Tage hat
        'EDATUM' => 'EDATE', //Gibt die fortlaufende Zahl des Datums zurück, bei dem es sich um die angegebene Anzahl von Monaten vor oder nach dem Anfangstermin handelt
        'MONATSENDE' => 'EOMONTH', //Gibt die fortlaufende Zahl des letzten Tags des Monats vor oder nach einer festgelegten Anzahl von Monaten zurück
        'STUNDE' => 'HOUR', //Wandelt eine fortlaufende Zahl in eine Stunde um
        'MINUTE' => 'MINUTE', //Wandelt eine fortlaufende Zahl in eine Minute um
        'MONAT' => 'MONTH', //Wandelt eine fortlaufende Zahl in einen Monat um
        'NETTOARBEITSTAGE' => 'NETWORKDAYS', //Gibt die Anzahl von ganzen Arbeitstagen zwischen zwei Datumswerten zurück
        'JETZT' => 'NOW', //Gibt die fortlaufende Zahl des aktuellen Datums und der aktuellen Uhrzeit zurück
        'SEKUNDE' => 'SECOND', //Wandelt eine fortlaufende Zahl in eine Sekunde um
        'ZEIT' => 'TIME', //Gibt die fortlaufende Zahl einer bestimmten Uhrzeit zurück
        'ZEITWERT' => 'TIMEVALUE', //Wandelt eine Uhrzeit in Form von Text in eine fortlaufende Zahl um
        'HEUTE' => 'TODAY', //Gibt die fortlaufende Zahl des heutigen Datums zurück
        'WOCHENTAG' => 'WEEKDAY', //Wandelt eine fortlaufende Zahl in den Wochentag um
        'KALENDERWOCHE' => 'WEEKNUM', //Wandelt eine fortlaufende Zahl in eine Zahl um, die angibt, in welche Woche eines Jahres das angegebene Datum fällt
        'ARBEITSTAG' => 'WORKDAY', //Gibt die fortlaufende Zahl des Datums vor oder nach einer bestimmten Anzahl von Arbeitstagen zurück
        'JAHR' => 'YEAR', //Wandelt eine fortlaufende Zahl in ein Jahr um
        'BRTEILJAHRE' => 'YEARFRAC', //Gibt die Anzahl der ganzen Tage zwischen Ausgangsdatum und Enddatum in Bruchteilen von Jahren zurück
        'BESSELI' => 'BESSELI', //Gibt die geänderte Besselfunktion In(x) zurück
        'BESSELJ' => 'BESSELJ', //Gibt die Besselfunktion Jn(x) zurück
        'BESSELK' => 'BESSELK', //Gibt die geänderte Besselfunktion Kn(x) zurück
        'BESSELY' => 'BESSELY', //Gibt die Besselfunktion Yn(x) zurück
        'BININDEZ' => 'BIN2DEC', //Wandelt eine binäre Zahl (Dualzahl) in eine dezimale Zahl um
        'BININHEX' => 'BIN2HEX', //Wandelt eine binäre Zahl (Dualzahl) in eine hexadezimale Zahl um
        'BININOKT' => 'BIN2OCT', //Wandelt eine binäre Zahl (Dualzahl) in eine oktale Zahl um
        'KOMPLEXE' => 'COMPLEX', //Wandelt den Real- und Imaginärteil in eine komplexe Zahl um
        'UMWANDELN' => 'CONVERT', //Wandelt eine Zahl von einem Maßsystem in ein anderes um
        'DEZINBIN' => 'DEC2BIN', //Wandelt eine dezimale Zahl in eine binäre Zahl (Dualzahl) um
        'DEZINHEX' => 'DEC2HEX', //Wandelt eine dezimale Zahl in eine hexadezimale Zahl um
        'DEZINOKT' => 'DEC2OCT', //Wandelt eine dezimale Zahl in eine oktale Zahl um
        'DELTA' => 'DELTA', //Überprüft, ob zwei Werte gleich sind
        'GAUSSFEHLER' => 'ERF', //Gibt die Gauss'sche Fehlerfunktion zurück
        'GAUSSFKOMPL' => 'ERFC', //Gibt das Komplement zur Gauss'schen Fehlerfunktion zurück
        'GGANZZAHL' => 'GESTEP', //Überprüft, ob eine Zahl größer als ein gegebener Schwellenwert ist
        'HEXINBIN' => 'HEX2BIN', //Wandelt eine hexadezimale Zahl in eine Binärzahl um
        'HEXINDEZ' => 'HEX2DEC', //Wandelt eine hexadezimale Zahl in eine dezimale Zahl um
        'HEXINOKT' => 'HEX2OCT', //Wandelt eine hexadezimale Zahl in eine Oktalzahl um
        'IMABS' => 'IMABS', //Gibt den Absolutbetrag (Modulo) einer komplexen Zahl zurück
        'IMAGINÄRTEIL' => 'IMAGINARY', //Gibt den Imaginärteil einer komplexen Zahl zurück
        'IMARGUMENT' => 'IMARGUMENT', //Gibt das Argument Theta zurück, einen Winkel, der als Bogenmaß ausgedrückt wird
        'IMKONJUGIERTE' => 'IMCONJUGATE', //Gibt die konjugierte komplexe Zahl zu einer komplexen Zahl zurück
        'IMCOS' => 'IMCOS', //Gibt den Kosinus einer komplexen Zahl zurück
        'IMDIV' => 'IMDIV', //Gibt den Quotienten zweier komplexer Zahlen zurück
        'IMEXP' => 'IMEXP', //Gibt die algebraische Form einer in exponentieller Schreibweise vorliegenden komplexen Zahl zurück
        'IMLN' => 'IMLN', //Gibt den natürlichen Logarithmus einer komplexen Zahl zurück
        'IMLOG10' => 'IMLOG10', //Gibt den Logarithmus einer komplexen Zahl zur Basis 10 zurück
        'IMLOG2' => 'IMLOG2', //Gibt den Logarithmus einer komplexen Zahl zur Basis 2 zurück
        'IMAPOTENZ' => 'IMPOWER', //Potenziert eine komplexe Zahl mit einer ganzen Zahl
        'IMPRODUKT' => 'IMPRODUCT', //Gibt das Produkt von komplexen Zahlen zurück
        'IMREALTEIL' => 'IMREAL', //Gibt den Realteil einer komplexen Zahl zurück
        'IMSIN' => 'IMSIN', //Gibt den Sinus einer komplexen Zahl zurück
        'IMWURZEL' => 'IMSQRT', //Gibt die Quadratwurzel einer komplexen Zahl zurück
        'IMSUB' => 'IMSUB', //Gibt die Differenz zwischen zwei komplexen Zahlen zurück
        'IMSUMME' => 'IMSUM', //Gibt die Summe von komplexen Zahlen zurück
        'OKTINBIN' => 'OCT2BIN', //Wandelt eine oktale Zahl in eine binäre Zahl (Dualzahl) um
        'OKTINDEZ' => 'OCT2DEC', //Wandelt eine oktale Zahl in eine dezimale Zahl um
        'OKTINHEX' => 'OCT2HEX', //Wandelt eine oktale Zahl in eine hexadezimale Zahl um
        'AUFGELZINS' => 'ACCRINT', //Gibt die aufgelaufenen Zinsen (Stückzinsen) eines Wertpapiers mit periodischen Zinszahlungen zurück
        'AUFGELZINSF' => 'ACCRINTM', //Gibt die aufgelaufenen Zinsen (Stückzinsen) eines Wertpapiers zurück, die bei Fälligkeit ausgezahlt werden
        'AMORDEGRK' => 'AMORDEGRC', //Gibt die Abschreibung für die einzelnen Abschreibungszeiträume mithilfe eines Abschreibungskoeffizienten zurück
        'AMORLINEARK' => 'AMORLINC', //Gibt die Abschreibung für die einzelnen Abschreibungszeiträume zurück
        'ZINSTERMTAGVA' => 'COUPDAYBS', //Gibt die Anzahl der Tage vom Anfang des Zinstermins bis zum Abrechnungstermin zurück
        'ZINSTERMTAGE' => 'COUPDAYS', //Gibt die Anzahl der Tage der Zinsperiode zurück, die den Abrechnungstermin einschließt
        'ZINSTERMTAGNZ' => 'COUPDAYSNC', //Gibt die Anzahl der Tage vom Abrechnungstermin bis zum nächsten Zinstermin zurück
        'ZINSTERMNZ' => 'COUPNCD', //Gibt das Datum des ersten Zinstermins nach dem Abrechnungstermin zurück
        'ZINSTERMZAHL' => 'COUPNUM', //Gibt die Anzahl der Zinstermine zwischen Abrechnungs- und Fälligkeitsdatum zurück
        'ZINSTERMVZ' => 'COUPPCD', //Gibt das Datum des letzten Zinstermins vor dem Abrechnungstermin zurück
        'KUMZINSZ' => 'CUMIPMT', //Berechnet die kumulierten Zinsen, die zwischen zwei Perioden zu zahlen sind
        'KUMKAPITAL' => 'CUMPRINC', //Berechnet die aufgelaufene Tilgung eines Darlehens, die zwischen zwei Perioden zu zahlen ist
        'GDA2' => 'DB', //Gibt die geometrisch-degressive Abschreibung eines Wirtschaftsguts für eine bestimmte Periode zurück
        'GDA' => 'DDB', //Gibt die Abschreibung eines Anlageguts für einen angegebenen Zeitraum unter Verwendung der degressiven Doppelraten-Abschreibung oder eines anderen von Ihnen angegebenen Abschreibungsverfahrens zurück
        'DISAGIO' => 'DISC', //Gibt den in Prozent ausgedrückten Abzinsungssatz eines Wertpapiers zurück
        'NOTIERUNGDEZ' => 'DOLLARDE', //Wandelt eine Notierung, die als Dezimalbruch ausgedrückt wurde, in eine Dezimalzahl um
        'NOTIERUNGBRU' => 'DOLLARFR', //Wandelt eine Notierung, die als Dezimalzahl ausgedrückt wurde, in einen Dezimalbruch um
        'DURATION' => 'DURATION', //Gibt die jährliche Duration eines Wertpapiers mit periodischen Zinszahlungen zurück
        'EFFEKTIV' => 'EFFECT', //Gibt die jährliche Effektivverzinsung zurück
        'ZW' => 'FV', //Gibt den zukünftigen Wert (Endwert) einer Investition zurück
        'ZW2' => 'FVSCHEDULE', //Gibt den aufgezinsten Wert des Anfangskapitals für eine Reihe periodisch unterschiedlicher Zinssätze zurück
        'ZINSSATZ' => 'INTRATE', //Gibt den Zinssatz eines voll investierten Wertpapiers zurück
        'ZINSZ' => 'IPMT', //Gibt die Zinszahlung einer Investition für die angegebene Periode zurück
        'IKV' => 'IRR', //Gibt den internen Zinsfuß einer Investition ohne Finanzierungskosten oder Reinvestitionsgewinne zurück
        'ISPMT' => 'ISPMT', //Berechnet die während eines bestimmten Zeitraums für eine Investition gezahlten Zinsen
        'MDURATION' => 'MDURATION', //Gibt die geänderte Dauer für ein Wertpapier mit einem angenommenen Nennwert von 100 € zurück
        'QIKV' => 'MIRR', //Gibt den internen Zinsfuß zurück, wobei positive und negative Zahlungen zu unterschiedlichen Sätzen finanziert werden
        'NOMINAL' => 'NOMINAL', //Gibt die jährliche Nominalverzinsung zurück
        'ZZR' => 'NPER', //Gibt die Anzahl der Zahlungsperioden einer Investition zurück
        'NBW' => 'NPV', //Gibt den Nettobarwert einer Investition auf Basis periodisch anfallender Zahlungen und eines Abzinsungsfaktors zurück
        'UNREGER.KURS' => 'ODDFPRICE', //Gibt den Kurs pro 100 € Nennwert eines Wertpapiers mit einem unregelmäßigen ersten Zinstermin zurück
        'UNREGER.REND' => 'ODDFYIELD', //Gibt die Rendite eines Wertpapiers mit einem unregelmäßigen ersten Zinstermin zurück
        'UNREGLE.KURS' => 'ODDLPRICE', //Gibt den Kurs pro 100 € Nennwert eines Wertpapiers mit einem unregelmäßigen letzten Zinstermin zurück
        'UNREGLE.REND' => 'ODDLYIELD', //Gibt die Rendite eines Wertpapiers mit einem unregelmäßigen letzten Zinstermin zurück
        'RMZ' => 'PMT', //Gibt die periodische Zahlung für eine Annuität zurück
        'KAPZ' => 'PPMT', //Gibt die Kapitalrückzahlung einer Investition für eine angegebene Periode zurück
        'KURS' => 'PRICE', //Gibt den Kurs pro 100 € Nennwert eines Wertpapiers zurück, das periodisch Zinsen auszahlt
        'KURSDISAGIO' => 'PRICEDISC', //Gibt den Kurs pro 100 € Nennwert eines unverzinslichen Wertpapiers zurück
        'KURSFÄLLIG' => 'PRICEMAT', //Gibt den Kurs pro 100 € Nennwert eines Wertpapiers zurück, das Zinsen am Fälligkeitsdatum auszahlt
        'BW' => 'PV', //Gibt den Barwert einer Investition zurück
        'ZINS' => 'RATE', //Gibt den Zinssatz pro Zeitraum einer Annuität zurück
        'AUSZAHLUNG' => 'RECEIVED', //Gibt den Auszahlungsbetrag eines voll investierten Wertpapiers am Fälligkeitstermin zurück
        'LIA' => 'SLN', //Gibt die lineare Abschreibung eines Wirtschaftsguts pro Periode zurück
        'DIA' => 'SYD', //Gibt die arithmetisch-degressive Abschreibung eines Wirtschaftsguts für eine bestimmte Periode zurück
        'TBILLÄQUIV' => 'TBILLEQ', //Gibt die Rendite für ein Wertpapier zurück
        'TBILLKURS' => 'TBILLPRICE', //Gibt den Kurs pro 100 € Nennwert eines Wertpapiers zurück
        'TBILLRENDITE' => 'TBILLYIELD', //Gibt die Rendite für ein Wertpapier zurück
        'VDB' => 'VDB', //Gibt die degressive Abschreibung eines Wirtschaftsguts für eine bestimmte Periode oder Teilperiode zurück
        'XINTZINSFUSS' => 'XIRR', //Gibt den internen Zinsfuß einer Reihe nicht periodisch anfallender Zahlungen zurück
        'XKAPITALWERT' => 'XNPV', //Gibt den Nettobarwert (Kapitalwert) einer Reihe nicht periodisch anfallender Zahlungen zurück
        'RENDITE' => 'YIELD', //Gibt die Rendite eines Wertpapiers zurück, das periodisch Zinsen auszahlt
        'RENDITEDIS' => 'YIELDDISC', //Gibt die jährliche Rendite eines unverzinslichen Wertpapiers zurück
        'RENDITEFÄLL' => 'YIELDMAT', //Gibt die jährliche Rendite eines Wertpapiers zurück, das Zinsen am Fälligkeitsdatum auszahlt
        'ZELLE' => 'CELL', //Gibt Informationen zu Formatierung, Position oder Inhalt einer Zelle zurück
        'FEHLER.TYP' => 'ERROR.TYPE', //Gibt eine Zahl zurück, die einem Fehlertyp entspricht
        'INFO' => 'INFO', //Gibt Informationen zur aktuellen Betriebssystemumgebung zurück
        'ISTLEER' => 'ISBLANK', //Gibt WAHR zurück, wenn der Wert leer ist
        'ISTFEHL' => 'ISERR', //Gibt WAHR zurück, wenn der Wert ein beliebiger Fehlerwert außer #N/V ist
        'ISTFEHLER' => 'ISERROR', //Gibt WAHR zurück, wenn der Wert ein beliebiger Fehlerwert ist
        'ISTGERADE' => 'ISEVEN', //Gibt WAHR zurück, wenn es sich um eine gerade Zahl handelt
        'ISTLOG' => 'ISLOGICAL', //Gibt WAHR zurück, wenn der Wert ein Wahrheitswert ist
        'ISTNV' => 'ISNA', //Gibt WAHR zurück, wenn der Wert der Fehlerwert #N/V ist
        'ISTKTEXT' => 'ISNONTEXT', //Gibt WAHR zurück, wenn der Wert ein Element ist, das keinen Text enthält
        'ISTZAHL' => 'ISNUMBER', //Gibt WAHR zurück, wenn der Wert eine Zahl ist
        'ISTUNGERADE' => 'ISODD', //Gibt WAHR zurück, wenn es sich um eine ungerade Zahl handelt
        'ISTBEZUG' => 'ISREF', //Gibt WAHR zurück, wenn der Wert ein Bezug ist
        'ISTTEXT' => 'ISTEXT', //Gibt WAHR zurück, wenn der Wert ein Element ist, das Text enthält
        'N' => 'N', //Gibt den in eine Zahl umgewandelten Wert zurück
        'NV' => 'NA', //Gibt den Fehlerwert #NV zurück
        'TYP' => 'TYPE', //Gibt eine Zahl zurück, die den Datentyp des angegebenen Werts anzeigt
        'UND' => 'AND', //Gibt WAHR zurück, wenn alle zugehörigen Argumente WAHR sind
        'FALSCH' => 'FALSE', //Gibt den Wahrheitswert FALSCH zurück
        'WENN' => 'IF', //Gibt einen logischen Test zum Ausführen an
        'WENNFEHLER' => 'IFERROR', //Gibt einen von Ihnen festgelegten Wert zurück, wenn die Auswertung der Formel zu einem Fehler führt; andernfalls wird das Ergebnis der Formel zurückgegeben
        'NICHT' => 'NOT', //Kehrt den Wahrheitswert der zugehörigen Argumente um
        'ODER' => 'OR', //Gibt WAHR zurück, wenn ein Argument WAHR ist
        'WAHR' => 'TRUE', //Gibt den Wahrheitswert WAHR zurück
        'ADRESSE' => 'ADDRESS', //Gibt einen Bezug auf eine einzelne Zelle in einem Tabellenblatt als Text zurück
        'BEREICHE' => 'AREAS', //Gibt die Anzahl der innerhalb eines Bezugs aufgeführten Bereiche zurück
        'WAHL' => 'CHOOSE', //Wählt einen Wert aus eine Liste mit Werten aus
        'SPALTE' => 'COLUMN', //Gibt die Spaltennummer eines Bezugs zurück
        'SPALTEN' => 'COLUMNS', //Gibt die Anzahl der Spalten in einem Bezug zurück
        'HVERWEIS' => 'HLOOKUP', //Sucht in der obersten Zeile einer Matrix und gibt den Wert der angegebenen Zelle zurück
        'HYPERLINK' => 'HYPERLINK', //Erstellt eine Verknüpfung, über die ein auf einem Netzwerkserver, in einem Intranet oder im Internet gespeichertes Dokument geöffnet wird
        'INDEX' => 'INDEX', //Verwendet einen Index, um einen Wert aus einem Bezug oder einer Matrix auszuwählen
        'INDIREKT' => 'INDIRECT', //Gibt einen Bezug zurück, der von einem Textwert angegeben wird
        'LOOKUP' => 'LOOKUP', //Sucht Werte in einem Vektor oder einer Matrix
        'VERGLEICH' => 'MATCH', //Sucht Werte in einem Bezug oder einer Matrix
        'BEREICH.VERSCHIEBEN' => 'OFFSET', //Gibt einen Bezugoffset aus einem gegebenen Bezug zurück
        'ZEILE' => 'ROW', //Gibt die Zeilennummer eines Bezugs zurück
        'ZEILEN' => 'ROWS', //Gibt die Anzahl der Zeilen in einem Bezug zurück
        'RTD' => 'RTD', //Ruft Echtzeitdaten von einem Programm ab, das die COM-Automatisierung (Automatisierung: Ein Verfahren, bei dem aus einer Anwendung oder einem Entwicklungstool heraus mit den Objekten einer anderen Anwendung gearbeitet wird. Die früher als OLE-Automatisierung bezeichnete Automatisierung ist ein Industriestandard und eine Funktion von COM (Component Object Model).) unterstützt
        'MTRANS' => 'TRANSPOSE', //Gibt die transponierte Matrix einer Matrix zurück
        'SVERWEIS' => 'VLOOKUP', //Sucht in der ersten Spalte einer Matrix und arbeitet sich durch die Zeile, um den Wert einer Zelle zurückzugeben
        'ABS' => 'ABS', //Gibt den Absolutwert einer Zahl zurück
        'ARCCOS' => 'ACOS', //Gibt den Arkuskosinus einer Zahl zurück
        'ARCCOSHYP' => 'ACOSH', //Gibt den umgekehrten hyperbolischen Kosinus einer Zahl zurück
        'ARCSIN' => 'ASIN', //Gibt den Arkussinus einer Zahl zurück
        'ARCSINHYP' => 'ASINH', //Gibt den umgekehrten hyperbolischen Sinus einer Zahl zurück
        'ARCTAN' => 'ATAN', //Gibt den Arkustangens einer Zahl zurück
        'ARCTAN2' => 'ATAN2', //Gibt den Arkustangens einer x- und einer y-Koordinate zurück
        'ARCTANHYP' => 'ATANH', //Gibt den umgekehrten hyperbolischen Tangens einer Zahl zurück
        'OBERGRENZE' => 'CEILING', //Rundet eine Zahl auf die nächste ganze Zahl oder das nächste Vielfache von Schritt
        'KOMBINATIONEN' => 'COMBIN', //Gibt die Anzahl der Kombinationen für eine bestimmte Anzahl von Objekten zurück
        'COS' => 'COS', //Gibt den Kosinus einer Zahl zurück
        'COSHYP' => 'COSH', //Gibt den hyperbolischen Kosinus einer Zahl zurück
        'GRAD' => 'DEGREES', //Wandelt Bogenmaß (Radiant) in Grad um
        'GERADE' => 'EVEN', //Rundet eine Zahl auf die nächste gerade ganze Zahl auf
        'EXP' => 'EXP', //Potenziert die Basis e mit der als Argument angegebenen Zahl
        'FAKULTÄT' => 'FACT', //Gibt die Fakultät einer Zahl zurück
        'ZWEIFAKULTÄT' => 'FACTDOUBLE', //Gibt die Fakultät zu Zahl mit Schrittlänge 2 zurück
        'UNTERGRENZE' => 'FLOOR', //Rundet die Zahl auf Anzahl_Stellen ab
        'GGT' => 'GCD', //Gibt den größten gemeinsamen Teiler zurück
        'GANZZAHL' => 'INT', //Rundet eine Zahl auf die nächstkleinere ganze Zahl ab
        'KGV' => 'LCM', //Gibt das kleinste gemeinsame Vielfache zurück
        'LN' => 'LN', //Gibt den natürlichen Logarithmus einer Zahl zurück
        'LOG' => 'LOG', //Gibt den Logarithmus einer Zahl zu der angegebenen Basis zurück
        'LOG10' => 'LOG10', //Gibt den Logarithmus einer Zahl zur Basis 10 zurück
        'MDET' => 'MDETERM', //Gibt die Determinante einer Matrix zurück
        'MINV' => 'MINVERSE', //Gibt die inverse Matrix einer Matrix zurück
        'MMULT' => 'MMULT', //Gibt das Produkt zweier Matrizen zurück
        'REST' => 'MOD', //Gibt den Rest einer Division zurück
        'VRUNDEN' => 'MROUND', //Gibt eine auf das gewünschte Vielfache gerundete Zahl zurück
        'POLYNOMIAL' => 'MULTINOMIAL', //Gibt den Polynomialkoeffizienten einer Gruppe von Zahlen zurück
        'UNGERADE' => 'ODD', //Rundet eine Zahl auf die nächste ungerade ganze Zahl auf
        'PI' => 'PI', //Gibt den Wert Pi zurück
        'POTENZ' => 'POWER', //Gibt als Ergebnis eine potenzierte Zahl zurück
        'PRODUKT' => 'PRODUCT', //Multipliziert die zugehörigen Argumente
        'QUOTIENT' => 'QUOTIENT', //Gibt den ganzzahligen Anteil einer Division zurück
        'BOGENMASS' => 'RADIANS', //Wandelt Grad in Bogenmaß (Radiant) um
        'ZUFALLSZAHL' => 'RAND', //Gibt eine Zufallszahl zwischen 0 und 1 zurück
        'ZUFALLSBEREICH' => 'RANDBETWEEN', //Gibt eine Zufallszahl aus dem festgelegten Bereich zurück
        'RÖMISCH' => 'ROMAN', //Wandelt eine arabische Zahl in eine römische Zahl als Text um
        'RUNDEN' => 'ROUND', //Rundet eine Zahl auf eine bestimmte Anzahl von Dezimalstellen
        'ABRUNDEN' => 'ROUNDDOWN', //Rundet die Zahl auf Anzahl_Stellen ab
        'AUFRUNDEN' => 'ROUNDUP', //Rundet die Zahl auf Anzahl_Stellen auf
        'POTENZREIHE' => 'SERIESSUM', //Gibt die Summe von Potenzen (zur Berechnung von Potenzreihen und dichotomen Wahrscheinlichkeiten) zurück
        'VORZEICHEN' => 'SIGN', //Gibt das Vorzeichen einer Zahl zurück
        'SIN' => 'SIN', //Gibt den Sinus einer Zahl zurück
        'SINHYP' => 'SINH', //Gibt den hyperbolischen Sinus einer Zahl zurück
        'WURZEL' => 'SQRT', //Gibt die Quadratwurzel einer Zahl zurück
        'WURZELPI' => 'SQRTPI', //Gibt die Wurzel aus der mit Pi (pi) multiplizierten Zahl zurück
        'TEILERGEBNIS' => 'SUBTOTAL', //Gibt ein Teilergebnis in einer Liste oder Datenbank zurück
        'SUMME' => 'SUM', //Addiert die zugehörigen Argumente
        'SUMMEWENN' => 'SUMIF', //Addiert Zahlen, die mit den Suchkriterien übereinstimmen
        'SUMMEWENNS' => 'SUMIFS', //Die Zellen, die mehrere Kriterien erfüllen, werden in einem Bereich hinzugefügt
        'SUMMENPRODUKT' => 'SUMPRODUCT', //Gibt die Summe der Produkte zusammengehöriger Matrixkomponenten zurück
        'QUADRATESUMME' => 'SUMSQ', //Gibt die Summe der quadrierten Argumente zurück
        'SUMMEX2MY2' => 'SUMX2MY2', //Gibt die Summe der Differenzen der Quadrate für zusammengehörige Komponenten zweier Matrizen zurück
        'SUMMEX2PY2' => 'SUMX2PY2', //Gibt die Summe der Quadrate für zusammengehörige Komponenten zweier Matrizen zurück
        'SUMMEXMY2' => 'SUMXMY2', //Gibt die Summe der quadrierten Differenzen für zusammengehörige Komponenten zweier Matrizen zurück
        'TAN' => 'TAN', //Gibt den Tangens einer Zahl zurück
        'TANHYP' => 'TANH', //Gibt den hyperbolischen Tangens einer Zahl zurück
        'KÜRZEN' => 'TRUNC', //Schneidet die Kommastellen einer Zahl ab und gibt als Ergebnis eine ganze Zahl zurück
        'MITTELABW' => 'AVEDEV', //Gibt die durchschnittliche absolute Abweichung einer Reihe von Merkmalsausprägungen und ihrem Mittelwert zurück
        'MITTELWERT' => 'AVERAGE', //Gibt den Mittelwert der zugehörigen Argumente zurück
        'MITTELWERTA' => 'AVERAGEA', //Gibt den Mittelwert der zugehörigen Argumente, die Zahlen, Text und Wahrheitswerte enthalten, zurück
        'MITTELWERTWENN' => 'AVERAGEIF', //Der Durchschnittswert (arithmetisches Mittel) für alle Zellen in einem Bereich, die einem angegebenen Kriterium entsprechen, wird zurückgegeben
        'MITTELWERTWENNS' => 'AVERAGEIFS', //Gibt den Durchschnittswert (arithmetisches Mittel) aller Zellen zurück, die mehreren Kriterien entsprechen
        'BETAVERT' => 'BETADIST', //Gibt die Werte der kumulierten Betaverteilungsfunktion zurück
        'BETAINV' => 'BETAINV', //Gibt das Quantil der angegebenen Betaverteilung zurück
        'BINOMVERT' => 'BINOMDIST', //Gibt Wahrscheinlichkeiten einer binomialverteilten Zufallsvariablen zurück
        'CHIVERT' => 'CHIDIST', //Gibt Werte der Verteilungsfunktion (1-Alpha) einer Chi-Quadrat-verteilten Zufallsgröße zurück
        'CHIINV' => 'CHIINV', //Gibt Quantile der Verteilungsfunktion (1-Alpha) der Chi-Quadrat-Verteilung zurück
        'CHITEST' => 'CHITEST', //Gibt die Teststatistik eines Unabhängigkeitstests zurück
        'KONFIDENZ' => 'CONFIDENCE', //Ermöglicht die Berechnung des 1-Alpha Konfidenzintervalls für den Erwartungswert einer Zufallsvariablen
        'KORREL' => 'CORREL', //Gibt den Korrelationskoeffizienten zweier Reihen von Merkmalsausprägungen zurück
        'ANZAHL' => 'COUNT', //Gibt die Anzahl der Zahlen in der Liste mit Argumenten an
        'ANZAHL2' => 'COUNTA', //Gibt die Anzahl der Werte in der Liste mit Argumenten an
        'ANZAHLLEEREZELLEN' => 'COUNTBLANK', //Gibt die Anzahl der leeren Zellen in einem Bereich an
        'ZÄHLENWENN' => 'COUNTIF', //Gibt die Anzahl der Zellen in einem Bereich an, deren Inhalte mit den Suchkriterien übereinstimmen
        'ZÄHLENWENNS' => 'COUNTIFS', //Gibt die Anzahl der Zellen in einem Bereich an, deren Inhalte mit mehreren Suchkriterien übereinstimmen
        'KOVAR' => 'COVAR', //Gibt die Kovarianz zurück, den Mittelwert der für alle Datenpunktpaare gebildeten Produkte der Abweichungen
        'KRITBINOM' => 'CRITBINOM', //Gibt den kleinsten Wert zurück, für den die kumulierten Wahrscheinlichkeiten der Binomialverteilung kleiner oder gleich einer Grenzwahrscheinlichkeit sind
        'SUMQUADABW' => 'DEVSQ', //Gibt die Summe der quadrierten Abweichungen der Datenpunkte von ihrem Stichprobenmittelwert zurück
        'EXPONVERT' => 'EXPONDIST', //Gibt Wahrscheinlichkeiten einer exponential verteilten Zufallsvariablen zurück
        'FVERT' => 'FDIST', //Gibt Werte der Verteilungsfunktion (1-Alpha) einer F-verteilten Zufallsvariablen zurück
        'FINV' => 'FINV', //Gibt Quantile der F-Verteilung zurück
        'FISHER' => 'FISHER', //Gibt die Fisher-Transformation zurück
        'FISHERINV' => 'FISHERINV', //Gibt die Umkehrung der Fisher-Transformation zurück
        'PROGNOSE' => 'FORECAST', //Gibt einen Wert zurück, der sich aus einem linearen Trend ergibt
        'HÄUFIGKEIT' => 'FREQUENCY', //Gibt eine Häufigkeitsverteilung als vertikale Matrix zurück
        'FTEST' => 'FTEST', //Gibt die Teststatistik eines F-Tests zurück
        'GAMMAVERT' => 'GAMMADIST', //Gibt Wahrscheinlichkeiten einer gammaverteilten Zufallsvariablen zurück
        'GAMMAINV' => 'GAMMAINV', //Gibt Quantile der Gammaverteilung zurück
        'GAMMALN' => 'GAMMALN', //Gibt den natürlichen Logarithmus der Gammafunktion zurück, Γ(x)
        'GEOMITTEL' => 'GEOMEAN', //Gibt das geometrische Mittel zurück
        'VARIATION' => 'GROWTH', //Gibt Werte zurück, die sich aus einem exponentiellen Trend ergeben
        'HARMITTEL' => 'HARMEAN', //Gibt das harmonische Mittel zurück
        'HYPGEOMVERT' => 'HYPGEOMDIST', //Gibt Wahrscheinlichkeiten einer hypergeometrisch-verteilten Zufallsvariablen zurück
        'ACHSENABSCHNITT' => 'INTERCEPT', //Gibt den Schnittpunkt der Regressionsgeraden zurück
        'KURT' => 'KURT', //Gibt die Kurtosis (Exzess) einer Datengruppe zurück
        'KGRÖSSTE' => 'LARGE', //Gibt den k-größten Wert einer Datengruppe zurück
        'RGP' => 'LINEST', //Gibt die Parameter eines linearen Trends zurück
        'RKP' => 'LOGEST', //Gibt die Parameter eines exponentiellen Trends zurück
        'LOGINV' => 'LOGINV', //Gibt Quantile der Lognormalverteilung zurück
        'LOGNORMVERT' => 'LOGNORMDIST', //Gibt Werte der Verteilungsfunktion einer lognormalverteilten Zufallsvariablen zurück
        'MAX' => 'MAX', //Gibt den Maximalwert einer Liste mit Argumenten zurück
        'MAXA' => 'MAXA', //Gibt den Maximalwert einer Liste mit Argumenten zurück, die Zahlen, Text und Wahrheitswerte enthalten
        'MEDIAN' => 'MEDIAN', //Gibt den Median der angegebenen Zahlen zurück
        'MIN' => 'MIN', //Gibt den Minimalwert einer Liste mit Argumenten zurück
        'MINA' => 'MINA', //Gibt den kleinsten Wert einer Liste mit Argumenten zurück, die Zahlen, Text und Wahrheitswerte enthalten
        'MODALWERT' => 'MODE', //Gibt den am häufigsten vorkommenden Wert in einer Datengruppe zurück
        'NEGBINOMVERT' => 'NEGBINOMDIST', //Gibt Wahrscheinlichkeiten einer negativen, binominal verteilten Zufallsvariablen zurück
        'NORMVERT' => 'NORMDIST', //Gibt Wahrscheinlichkeiten einer normal verteilten Zufallsvariablen zurück
        'NORMINV' => 'NORMINV', //Gibt Quantile der Normalverteilung zurück
        'STANDNORMVERT' => 'NORMSDIST', //Gibt Werte der Verteilungsfunktion einer standardnormalverteilten Zufallsvariablen zurück
        'STANDNORMINV' => 'NORMSINV', //Gibt Quantile der Standardnormalverteilung zurück
        'PEARSON' => 'PEARSON', //Gibt den Pearsonschen Korrelationskoeffizienten zurück
        'QUANTIL' => 'PERCENTILE', //Gibt das Alpha-Quantil einer Gruppe von Daten zurück
        'QUANTILSRANG' => 'PERCENTRANK', //Gibt den prozentualen Rang (Alpha) eines Werts in einer Datengruppe zurück
        'VARIATIONEN' => 'PERMUT', //Gibt die Anzahl der Möglichkeiten zurück, um k Elemente aus einer Menge von n Elementen ohne Zurücklegen zu ziehen
        'POISSON' => 'POISSON', //Gibt Wahrscheinlichkeiten einer poissonverteilten Zufallsvariablen zurück
        'WAHRSCHBEREICH' => 'PROB', //Gibt die Wahrscheinlichkeit für ein von zwei Werten eingeschlossenes Intervall zurück
        'QUARTILE' => 'QUARTILE', //Gibt die Quartile der Datengruppe zurück
        'RANG' => 'RANK', //Gibt den Rang zurück, den eine Zahl innerhalb einer Liste von Zahlen einnimmt
        'BESTIMMTHEITSMASS' => 'RSQ', //Gibt das Quadrat des Pearsonschen Korrelationskoeffizienten zurück
        'SCHIEFE' => 'SKEW', //Gibt die Schiefe einer Verteilung zurück
        'STEIGUNG' => 'SLOPE', //Gibt die Steigung der Regressionsgeraden zurück
        'KKLEINSTE' => 'SMALL', //Gibt den k-kleinsten Wert einer Datengruppe zurück
        'STANDARDISIERUNG' => 'STANDARDIZE', //Gibt den standardisierten Wert zurück
        'STABW' => 'STDEV', //Schätzt die Standardabweichung ausgehend von einer Stichprobe
        'STABWA' => 'STDEVA', //Schätzt die Standardabweichung ausgehend von einer Stichprobe, die Zahlen, Text und Wahrheitswerte enthält
        'STABWN' => 'STDEVP', //Berechnet die Standardabweichung ausgehend von der Grundgesamtheit
        'STABWNA' => 'STDEVPA', //Berechnet die Standardabweichung ausgehend von der Grundgesamtheit, die Zahlen, Text und Wahrheitswerte enthält
        'STFEHLERYX' => 'STEYX', //Gibt den Standardfehler der geschätzten y-Werte für alle x-Werte der Regression zurück
        'TVERT' => 'TDIST', //Gibt Werte der Verteilungsfunktion (1-Alpha) einer (Student) t-verteilten Zufallsvariablen zurück
        'TINV' => 'TINV', //Gibt Quantile der t-Verteilung zurück
        'TREND' => 'TREND', //Gibt Werte zurück, die sich aus einem linearen Trend ergeben
        'GESTUTZTMITTEL' => 'TRIMMEAN', //Gibt den Mittelwert einer Datengruppe zurück, ohne die Randwerte zu berücksichtigen
        'TTEST' => 'TTEST', //Gibt die Teststatistik eines Student'schen t-Tests zurück
        'VARIANZ' => 'VAR', //Schätzt die Varianz ausgehend von einer Stichprobe
        'VARIANZA' => 'VARA', //Schätzt die Varianz ausgehend von einer Stichprobe, die Zahlen, Text und Wahrheitswerte enthält
        'VARIANZEN' => 'VARP', //Berechnet die Varianz ausgehend von der Grundgesamtheit
        'VARIANZENA' => 'VARPA', //Berechnet die Varianz ausgehend von der Grundgesamtheit, die Zahlen, Text und Wahrheitswerte enthält
        'WEIBULL' => 'WEIBULL', //Gibt Wahrscheinlichkeiten einer weibullverteilten Zufallsvariablen zurück
        'GTEST' => 'ZTEST', //Gibt den einseitigen Wahrscheinlichkeitswert für einen Gausstest (Normalverteilung) zurück
        'ASC' => 'ASC', //Konvertiert DB-Text in einer Zeichenfolge (lateinische Buchstaben oder Katakana) in SB-Text
        'BAHTTEXT' => 'BAHTTEXT', //Wandelt eine Zahl in Text im Währungsformat ß (Baht) um
        'ZEICHEN' => 'CHAR', //Gibt das der Codezahl entsprechende Zeichen zurück
        'SÄUBERN' => 'CLEAN', //Löscht alle nicht druckbaren Zeichen aus einem Text
        'CODE' => 'CODE', //Gibt die Codezahl des ersten Zeichens in einem Text zurück
        'VERKETTEN' => 'CONCATENATE', //Verknüpft mehrere Textelemente zu einem Textelement
        'DM' => 'DOLLAR', //Wandelt eine Zahl in Text im Währungsformat € (Euro) um
        'IDENTISCH' => 'EXACT', //Prüft, ob zwei Textwerte identisch sind
        'FINDEN' => 'FIND', //Sucht nach einem Textwert, der in einem anderen Textwert enthalten ist (Groß-/Kleinschreibung wird unterschieden)
        'FINDENB' => 'FINDB', //Sucht nach einem Textwert, der in einem anderen Textwert enthalten ist (Groß-/Kleinschreibung wird unterschieden)
        'FEST' => 'FIXED', //Formatiert eine Zahl als Text mit einer festen Anzahl von Dezimalstellen
        'JIS' => 'JIS', //Konvertiert SB-Text in einer Zeichenfolge (lateinische Buchstaben oder Katakana) in DB-Text
        'LINKS' => 'LEFT', //Gibt die Zeichen ganz links in einem Textwert zurück
        'LINKSB' => 'LEFTB', //Gibt die Zeichen ganz links in einem Textwert zurück
        'LÄNGE' => 'LEN', //Gibt die Anzahl der Zeichen in einer Zeichenfolge zurück
        'LÄNGEB' => 'LENB', //Gibt die Anzahl der Zeichen in einer Zeichenfolge zurück
        'KLEIN' => 'LOWER', //Wandelt Text in Kleinbuchstaben um
        'TEIL' => 'MID', //Gibt eine bestimmte Anzahl Zeichen aus einer Zeichenfolge ab der von Ihnen angegebenen Stelle zurück
        'TEILB' => 'MIDB', //Gibt eine bestimmte Anzahl Zeichen aus einer Zeichenfolge ab der von Ihnen angegebenen Stelle zurück
        'PHONETIC' => 'PHONETIC', //Extrahiert die phonetischen (Furigana-)Zeichen aus einer Textzeichenfolge
        'GROSS2' => 'PROPER', //Wandelt den ersten Buchstaben aller Wörter eines Textwerts in Großbuchstaben um
        'ERSETZEN' => 'REPLACE', //Ersetzt Zeichen in Text
        'ERSETZENB' => 'REPLACEB', //Ersetzt Zeichen in Text
        'WIEDERHOLEN' => 'REPT', //Wiederholt einen Text so oft wie angegeben
        'RECHTS' => 'RIGHT', //Gibt die Zeichen ganz rechts in einem Textwert zurück
        'RECHTSB' => 'RIGHTB', //Gibt die Zeichen ganz rechts in einem Textwert zurück
        'SUCHEN' => 'SEARCH', //Sucht nach einem Textwert, der in einem anderen Textwert enthalten ist (Groß-/Kleinschreibung wird nicht unterschieden)
        'SUCHENB' => 'SEARCHB', //Sucht nach einem Textwert, der in einem anderen Textwert enthalten ist (Groß-/Kleinschreibung wird nicht unterschieden)
        'WECHSELN' => 'SUBSTITUTE', //Ersetzt in einer Zeichenfolge neuen Text gegen alten
        'T' => 'T', //Wandelt die zugehörigen Argumente in Text um
        'TEXT' => 'TEXT', //Formatiert eine Zahl und wandelt sie in Text um
        'GLÄTTEN' => 'TRIM', //Entfernt Leerzeichen aus Text
        'GROSS' => 'UPPER', //Wandelt Text in Großbuchstaben um
        'WERT' => 'VALUE', //Wandelt ein Textargument in eine Zahl um
    ],
];
//EOF
