<?php
// es_ES

return [
    'language' => 'Spanish',
    'formats' => [
        'date' => 'D/M/YY',
        'time' => 'H:MM:SS',
        'datetime' => 'D/M/YY H:MM:SS',
        'money' => '#,##0.00 [$€];[RED]-#,##0.00 [$€]',
    ],
    'functions' => [
        'IMPORTARDATOSDINAMICOS' => 'GETPIVOTDATA', //Devuelve los datos almacenados en un informe de tabla dinámica.
        'MIEMBROKPICUBO' => 'CUBEKPIMEMBER', //Devuelve un nombre, propiedad y medida de indicador de rendimiento clave (KPI) y muestra el nombre y la propiedad en la celda. Un KPI es una medida cuantificable, como los beneficios brutos mensuales o la facturación trimestral por empleado, que se usa para supervisar el rendimiento de una organización.
        'MIEMBROCUBO' => 'CUBEMEMBER', //Devuelve un miembro o tupla en una jerarquía de cubo. Se usa para validar la existencia del miembro o la tupla en el cubo.
        'PROPIEDADMIEMBROCUBO' => 'CUBEMEMBERPROPERTY', //Devuelve el valor de una propiedad de miembro del cubo Se usa para validar la existencia de un nombre de miembro en el cubo y para devolver la propiedad especificada para este miembro.
        'MIEMBRORANGOCUBO' => 'CUBERANKEDMEMBER', //Devuelve el miembro n, o clasificado, de un conjunto. Se usa para devolver uno o más elementos de un conjunto, por ejemplo, el representante con mejores ventas o los diez mejores alumnos.
        'CONJUNTOCUBO' => 'CUBESET', //Define un conjunto calculado de miembros o tuplas mediante el envío de una expresión de conjunto al cubo en el servidor, lo que crea el conjunto y, después, devuelve dicho conjunto a Microsoft Office Excel.
        'RECUENTOCONJUNTOCUBO' => 'CUBESETCOUNT', //Devuelve el número de elementos de un conjunto.
        'VALORCUBO' => 'CUBEVALUE', //Devuelve un valor agregado de un cubo.
        'BDPROMEDIO' => 'DAVERAGE', //Devuelve el promedio de las entradas seleccionadas en la base de datos.
        'BDCONTAR' => 'DCOUNT', //Cuenta el número de celdas que contienen números en una base de datos.
        'BDCONTARA' => 'DCOUNTA', //Cuenta el número de celdas no vacías en una base de datos.
        'BDEXTRAER' => 'DGET', //Extrae de una base de datos un único registro que cumple los criterios especificados.
        'BDMAX' => 'DMAX', //Devuelve el valor máximo de las entradas seleccionadas de la base de datos.
        'BDMIN' => 'DMIN', //Devuelve el valor mínimo de las entradas seleccionadas de la base de datos.
        'BDPRODUCTO' => 'DPRODUCT', //Multiplica los valores de un campo concreto de registros de una base de datos que cumplen los criterios especificados.
        'BDDESVEST' => 'DSTDEV', //Calcula la desviación estándar a partir de una muestra de entradas seleccionadas en la base de datos.
        'BDDESVESTP' => 'DSTDEVP', //Calcula la desviación estándar en función de la población total de las entradas seleccionadas de la base de datos.
        'BDSUMA' => 'DSUM', //Suma los números de la columna de campo de los registros de la base de datos que cumplen los criterios.
        'BDVAR' => 'DVAR', //Calcula la varianza a partir de una muestra de entradas seleccionadas de la base de datos.
        'BDVARP' => 'DVARP', //Calcula la varianza a partir de la población total de entradas seleccionadas de la base de datos.
        'FECHA' => 'DATE', //Devuelve el número de serie correspondiente a una fecha determinada.
        'FECHANUMERO' => 'DATEVALUE', //Convierte una fecha con formato de texto en un valor de número de serie.
        'DIA' => 'DAY', //Convierte un número de serie en un valor de día del mes.
        'DIAS360' => 'DAYS360', //Calcula el número de días entre dos fechas a partir de un año de 360 días.
        'FECHA.MES' => 'EDATE', //Devuelve el número de serie de la fecha equivalente al número indicado de meses anteriores o posteriores a la fecha inicial.
        'FIN.MES' => 'EOMONTH', //Devuelve el número de serie correspondiente al último día del mes anterior o posterior a un número de meses especificado.
        'HORA' => 'HOUR', //Convierte un número de serie en un valor de hora.
        'MINUTO' => 'MINUTE', //Convierte un número de serie en un valor de minuto.
        'MES' => 'MONTH', //Convierte un número de serie en un valor de mes.
        'DIAS.LAB' => 'NETWORKDAYS', //Devuelve el número de todos los días laborables existentes entre dos fechas.
        'AHORA' => 'NOW', //Devuelve el número de serie correspondiente a la fecha y hora actuales.
        'SEGUNDO' => 'SECOND', //Convierte un número de serie en un valor de segundo.
        //'HORA' => 'TIME', //Devuelve el número de serie correspondiente a una hora determinada.
        'HORANUMERO' => 'TIMEVALUE', //Convierte una hora con formato de texto en un valor de número de serie.
        'HOY' => 'TODAY', //Devuelve el número de serie correspondiente al día actual.
        'DIASEM' => 'WEEKDAY', //Convierte un número de serie en un valor de día de la semana.
        'NUM.DE.SEMANA' => 'WEEKNUM', //Convierte un número de serie en un número que representa el lugar numérico correspondiente a una semana de un año.
        'DIA.LAB' => 'WORKDAY', //Devuelve el número de serie de la fecha que tiene lugar antes o después de un número determinado de días laborables.
        'AÑO' => 'YEAR', //Convierte un número de serie en un valor de año.
        'FRAC.AÑO' => 'YEARFRAC', //Devuelve la fracción de año que representa el número total de días existentes entre el valor de fecha_inicial y el de fecha_final.
        'BESSELI' => 'BESSELI', //Devuelve la función Bessel In(x) modificada.
        'BESSELJ' => 'BESSELJ', //Devuelve la función Bessel Jn(x).
        'BESSELK' => 'BESSELK', //Devuelve la función Bessel Kn(x) modificada.
        'BESSELY' => 'BESSELY', //Devuelve la función Bessel Yn(x).
        'BIN.A.DEC' => 'BIN2DEC', //Convierte un número binario en decimal.
        'BIN.A.HEX' => 'BIN2HEX', //Convierte un número binario en hexadecimal.
        'BIN.A.OCT' => 'BIN2OCT', //Convierte un número binario en octal.
        'COMPLEJO' => 'COMPLEX', //Convierte coeficientes reales e imaginarios en un número complejo.
        'CONVERTIR' => 'CONVERT', //Convierte un número de un sistema de medida a otro.
        'DEC.A.BIN' => 'DEC2BIN', //Convierte un número decimal en binario.
        'DEC.A.HEX' => 'DEC2HEX', //Convierte un número decimal en hexadecimal.
        'DEC.A.OCT' => 'DEC2OCT', //Convierte un número decimal en octal.
        'DELTA' => 'DELTA', //Comprueba si dos valores son iguales.
        'FUN.ERROR' => 'ERF', //Devuelve la función de error.
        'FUN.ERROR.COMPL' => 'ERFC', //Devuelve la función de error complementario.
        'MAYOR.O.IGUAL' => 'GESTEP', //Comprueba si un número es mayor que un valor de umbral.
        'HEX.A.BIN' => 'HEX2BIN', //Convierte un número hexadecimal en binario.
        'HEX.A.DEC' => 'HEX2DEC', //Convierte un número hexadecimal en decimal.
        'HEX.A.OCT' => 'HEX2OCT', //Convierte un número hexadecimal en octal.
        'IM.ABS' => 'IMABS', //Devuelve el valor absoluto (módulo) de un número complejo.
        'IMAGINARIO' => 'IMAGINARY', //Devuelve el coeficiente imaginario de un número complejo.
        'IM.ANGULO' => 'IMARGUMENT', //Devuelve el argumento theta, un ángulo expresado en radianes.
        'IM.CONJUGADA' => 'IMCONJUGATE', //Devuelve la conjugada compleja de un número complejo.
        'IM.COS' => 'IMCOS', //Devuelve el coseno de un número complejo.
        'IM.DIV' => 'IMDIV', //Devuelve el cociente de dos números complejos.
        'IM.EXP' => 'IMEXP', //Devuelve el valor exponencial de un número complejo.
        'IM.LN' => 'IMLN', //Devuelve el logaritmo natural (neperiano) de un número complejo.
        'IM.LOG10' => 'IMLOG10', //Devuelve el logaritmo en base 10 de un número complejo.
        'IM.LOG2' => 'IMLOG2', //Devuelve el logaritmo en base 2 de un número complejo.
        'IM.POT' => 'IMPOWER', //Devuelve un número complejo elevado a una potencia entera.
        'IM.PRODUCT' => 'IMPRODUCT', //Devuelve el producto de números complejos.
        'IM.REAL' => 'IMREAL', //Devuelve el coeficiente real de un número complejo.
        'IM.SENO' => 'IMSIN', //Devuelve el seno de un número complejo.
        'IM.RAIZ2' => 'IMSQRT', //Devuelve la raíz cuadrada de un número complejo.
        'IM.SUSTR' => 'IMSUB', //Devuelve la diferencia entre dos números complejos.
        'IM.SUM' => 'IMSUM', //Devuelve la suma de números complejos.
        'OCT.A.BIN' => 'OCT2BIN', //Convierte un número octal en binario.
        'OCT.A.DEC' => 'OCT2DEC', //Convierte un número octal en decimal.
        'OCT.A.HEX' => 'OCT2HEX', //Convierte un número octal en hexadecimal.
        'INT.ACUM' => 'ACCRINT', //Devuelve el interés acumulado de un valor bursátil con pagos de interés periódicos.
        'INT.ACUM.V' => 'ACCRINTM', //Devuelve el interés acumulado de un valor bursátil con pagos de interés al vencimiento.
        'AMORTIZ.PROGRE' => 'AMORDEGRC', //Devuelve la amortización de cada período contable mediante el uso de un coeficiente de amortización.
        'AMORTIZ.LIN' => 'AMORLINC', //Devuelve la amortización de cada uno de los períodos contables.
        'CUPON.DIAS.L1' => 'COUPDAYBS', //Devuelve el número de días desde el principio del período de un cupón hasta la fecha de liquidación.
        'CUPON.DIAS' => 'COUPDAYS', //Devuelve el número de días del período (entre dos cupones) donde se encuentra la fecha de liquidación.
        'CUPON.DIAS.L2' => 'COUPDAYSNC', //Devuelve el número de días desde la fecha de liquidación hasta la fecha del próximo cupón.
        'CUPON.FECHA.L2' => 'COUPNCD', //Devuelve la fecha del próximo cupón después de la fecha de liquidación.
        'CUPON.NUM' => 'COUPNUM', //Devuelve el número de pagos de cupón entre la fecha de liquidación y la fecha de vencimiento.
        'CUPON.FECHA.L1' => 'COUPPCD', //Devuelve la fecha de cupón anterior a la fecha de liquidación.
        'PAGO.INT.ENTRE' => 'CUMIPMT', //Devuelve el interés acumulado pagado entre dos períodos.
        'PAGO.PRINC.ENTRE' => 'CUMPRINC', //Devuelve el capital acumulado pagado de un préstamo entre dos períodos.
        'DB' => 'DB', //Devuelve la amortización de un bien durante un período específico a través del método de amortización de saldo fijo.
        'DDB' => 'DDB', //Devuelve la amortización de un bien durante un período específico a través del método de amortización por doble disminución de saldo u otro método que se especifique.
        'TASA.DESC' => 'DISC', //Devuelve la tasa de descuento de un valor bursátil.
        'MONEDA.DEC' => 'DOLLARDE', //Convierte una cotización de un valor bursátil expresada en forma fraccionaria en una cotización de un valor bursátil expresada en forma decimal.
        'MONEDA.FRAC' => 'DOLLARFR', //Convierte una cotización de un valor bursátil expresada en forma decimal en una cotización de un valor bursátil expresada en forma fraccionaria.
        'DURACION' => 'DURATION', //Devuelve la duración anual de un valor bursátil con pagos de interés periódico.
        'INT.EFECTIVO' => 'EFFECT', //Devuelve la tasa de interés anual efectiva.
        'VF' => 'FV', //Devuelve el valor futuro de una inversión.
        'VF.PLAN' => 'FVSCHEDULE', //Devuelve el valor futuro de un capital inicial después de aplicar una serie de tasas de interés compuesto.
        'TASA.INT' => 'INTRATE', //Devuelve la tasa de interés para la inversión total de un valor bursátil.
        'PAGOINT' => 'IPMT', //Devuelve el pago de intereses de una inversión durante un período determinado.
        'TIR' => 'IRR', //Devuelve la tasa interna de retorno para una serie de flujos de efectivo periódicos.
        'INT.PAGO.DIR' => 'ISPMT', //Calcula el interés pagado durante un período específico de una inversión.
        'DURACION.MODIF' => 'MDURATION', //Devuelve la duración de Macauley modificada de un valor bursátil con un valor nominal supuesto de 100 $.
        'TIRM' => 'MIRR', //Devuelve la tasa interna de retorno donde se financian flujos de efectivo positivos y negativos a tasas diferentes.
        'TASA.NOMINAL' => 'NOMINAL', //Devuelve la tasa nominal de interés anual.
        'NPER' => 'NPER', //Devuelve el número de períodos de una inversión.
        'VNA' => 'NPV', //Devuelve el valor neto actual de una inversión en función de una serie de flujos periódicos de efectivo y una tasa de descuento.
        'PRECIO.PER.IRREGULAR.1' => 'ODDFPRICE', //Devuelve el precio por un valor nominal de 100 $ de un valor bursátil con un primer período impar.
        'RENDTO.PER.IRREGULAR.1' => 'ODDFYIELD', //Devuelve el rendimiento de un valor bursátil con un primer período impar.
        'PRECIO.PER.IRREGULAR.2' => 'ODDLPRICE', //Devuelve el precio por un valor nominal de 100 $ de un valor bursátil con un último período impar.
        'RENDTO.PER.IRREGULAR.2' => 'ODDLYIELD', //Devuelve el rendimiento de un valor bursátil con un último período impar.
        'PAGO' => 'PMT', //Devuelve el pago periódico de una anualidad.
        'PAGOPRIN' => 'PPMT', //Devuelve el pago de capital de una inversión durante un período determinado.
        'PRECIO' => 'PRICE', //Devuelve el precio por un valor nominal de 100 $ de un valor bursátil que paga una tasa de interés periódico.
        'PRECIO.DESCUENTO' => 'PRICEDISC', //Devuelve el precio por un valor nominal de 100 $ de un valor bursátil con descuento.
        'PRECIO.VENCIMIENTO' => 'PRICEMAT', //Devuelve el precio por un valor nominal de 100 $ de un valor bursátil que paga interés a su vencimiento.
        'VALACT' => 'PV', //Devuelve el valor actual de una inversión.
        'TASA' => 'RATE', //Devuelve la tasa de interés por período de una anualidad.
        'CANTIDAD.RECIBIDA' => 'RECEIVED', //Devuelve la cantidad recibida al vencimiento de un valor bursátil completamente invertido.
        'SLN' => 'SLN', //Devuelve la amortización por método directo de un bien en un período dado.
        'SYD' => 'SYD', //Devuelve la amortización por suma de dígitos de los años de un bien durante un período especificado.
        'LETRA.DE.TES.EQV.A.BONO' => 'TBILLEQ', //Devuelve el rendimiento de un bono equivalente a una letra del Tesoro (de EE.UU.)
        'LETRA.DE.TES.PRECIO' => 'TBILLPRICE', //Devuelve el precio por un valor nominal de 100 $ de una letra del Tesoro (de EE.UU.)
        'LETRA.DE.TES.RENDTO' => 'TBILLYIELD', //Devuelve el rendimiento de una letra del Tesoro (de EE.UU.)
        'DVS' => 'VDB', //Devuelve la amortización de un bien durante un período específico o parcial a través del método de cálculo del saldo en disminución.
        'TIR.NO.PER' => 'XIRR', //Devuelve la tasa interna de retorno para un flujo de efectivo que no es necesariamente periódico.
        'VNA.NO.PER' => 'XNPV', //Devuelve el valor neto actual para un flujo de efectivo que no es necesariamente periódico.
        'RENDTO' => 'YIELD', //Devuelve el rendimiento de un valor bursátil que paga intereses periódicos.
        'RENDTO.DESC' => 'YIELDDISC', //Devuelve el rendimiento anual de un valor bursátil con descuento; por ejemplo, una letra del Tesoro (de EE.UU.)
        'RENDTO.VENCTO' => 'YIELDMAT', //Devuelve el rendimiento anual de un valor bursátil que paga intereses al vencimiento.
        'CELDA' => 'CELL', //Devuelve información acerca del formato, la ubicación o el contenido de una celda.
        'TIPO.DE.ERROR' => 'ERROR.TYPE', //Devuelve un número que corresponde a un tipo de error.
        'INFO' => 'INFO', //Devuelve información acerca del entorno operativo en uso.
        'ESBLANCO' => 'ISBLANK', //Devuelve VERDADERO si el valor está en blanco.
        'ESERR' => 'ISERR', //Devuelve VERDADERO si el valor es cualquier valor de error excepto #N/A.
        'ESERROR' => 'ISERROR', //Devuelve VERDADERO si el valor es cualquier valor de error.
        'ES.PAR' => 'ISEVEN', //Devuelve VERDADERO si el número es par.
        'ESLOGICO' => 'ISLOGICAL', //Devuelve VERDADERO si el valor es un valor lógico.
        'ESNOD' => 'ISNA', //Devuelve VERDADERO si el valor es el valor de error #N/A.
        'ESNOTEXTO' => 'ISNONTEXT', //Devuelve VERDADERO si el valor no es texto.
        'ESNUMERO' => 'ISNUMBER', //Devuelve VERDADERO si el valor es un número.
        'ES.IMPAR' => 'ISODD', //Devuelve VERDADERO si el número es impar.
        'ESREF' => 'ISREF', //Devuelve VERDADERO si el valor es una referencia.
        'ESTEXTO' => 'ISTEXT', //Devuelve VERDADERO si el valor es texto.
        'N' => 'N', //Devuelve un valor convertido en un número.
        'ND' => 'NA', //Devuelve el valor de error #N/A.
        'TIPO' => 'TYPE', //Devuelve un número que indica el tipo de datos de un valor.
        'Y' => 'AND', //Devuelve VERDADERO si todos sus argumentos son VERDADERO.
        'FALSO' => 'FALSE', //Devuelve el valor lógico FALSO.
        'SI' => 'IF', //Especifica una prueba lógica que realizar.
        'SI.ERROR' => 'IFERROR', //Devuelve un valor que se especifica si una fórmula lo evalúa como un error; de lo contrario, devuelve el resultado de la fórmula.
        'NO' => 'NOT', //Invierte el valor lógico del argumento.
        'O' => 'OR', //Devuelve VERDADERO si cualquier argumento es VERDADERO.
        'VERDADERO' => 'TRUE', //Devuelve el valor lógico VERDADERO.
        'DIRECCION' => 'ADDRESS', //Devuelve una referencia como texto a una sola celda de una hoja de cálculo.
        'AREAS' => 'AREAS', //Devuelve el número de áreas de una referencia.
        'ELEGIR' => 'CHOOSE', //Elige un valor de una lista de valores.
        'COLUMNA' => 'COLUMN', //Devuelve el número de columna de una referencia.
        'COLUMNAS' => 'COLUMNS', //Devuelve el número de columnas de una referencia.
        'BUSCARH' => 'HLOOKUP', //Busca en la fila superior de una matriz y devuelve el valor de la celda indicada.
        'HIPERVINCULO' => 'HYPERLINK', //Crea un acceso directo o un salto que abre un documento almacenado en un servidor de red, en una intranet o en Internet.
        'INDICE' => 'INDEX', //Usa un índice para elegir un valor de una referencia o matriz.
        'INDIRECTO' => 'INDIRECT', //Devuelve una referencia indicada por un valor de texto.
        'BUSCAR' => 'LOOKUP', //Busca valores de un vector o una matriz.
        'COINCIDIR' => 'MATCH', //Busca valores de una referencia o matriz.
        'DESREF' => 'OFFSET', //Devuelve un desplazamiento de referencia respecto a una referencia dada.
        'FILA' => 'ROW', //Devuelve el número de fila de una referencia.
        'FILAS' => 'ROWS', //Devuelve el número de filas de una referencia.
        'RDTR' => 'RTD', //Recupera datos en tiempo real desde un programa compatible con la automatización COM (automatización: modo de trabajar con los objetos de una aplicación desde otra aplicación o herramienta de entorno. La automatización, antes denominada automatización OLE, es un estándar de la industria y una función del Modelo de objetos componentes (COM).).
        'TRANSPONER' => 'TRANSPOSE', //Devuelve la transposición de una matriz.
        'BUSCARV' => 'VLOOKUP', //Busca en la primera columna de una matriz y se mueve en horizontal por la fila para devolver el valor de una celda.
        'ABS' => 'ABS', //Devuelve el valor absoluto de un número.
        'ACOS' => 'ACOS', //Devuelve el arcocoseno de un número.
        'ACOSH' => 'ACOSH', //Devuelve el coseno hiperbólico inverso de un número.
        'ASENO' => 'ASIN', //Devuelve el arcoseno de un número.
        'ASENOH' => 'ASINH', //Devuelve el seno hiperbólico inverso de un número.
        'ATAN' => 'ATAN', //Devuelve la arcotangente de un número.
        'ATAN2' => 'ATAN2', //Devuelve la arcotangente de las coordenadas "x" e "y".
        'ATANH' => 'ATANH', //Devuelve la tangente hiperbólica inversa de un número.
        'MULTIPLO.SUPERIOR' => 'CEILING', //Redondea un número al entero más próximo o al múltiplo significativo más cercano.
        'COMBINAT' => 'COMBIN', //Devuelve el número de combinaciones para un número determinado de objetos.
        'COS' => 'COS', //Devuelve el coseno de un número.
        'COSH' => 'COSH', //Devuelve el coseno hiperbólico de un número.
        'GRADOS' => 'DEGREES', //Convierte radianes en grados.
        'REDONDEA.PAR' => 'EVEN', //Redondea un número hasta el entero par más próximo.
        'EXP' => 'EXP', //Devuelve e elevado a la potencia de un número dado.
        'FACT' => 'FACT', //Devuelve el factorial de un número.
        'FACT.DOBLE' => 'FACTDOUBLE', //Devuelve el factorial doble de un número.
        'MULTIPLO.INFERIOR' => 'FLOOR', //Redondea un número hacia abajo, en dirección hacia cero.
        'M.C.D' => 'GCD', //Devuelve el máximo común divisor.
        'ENTERO' => 'INT', //Redondea un número hacia abajo hasta el entero más próximo.
        'M.C.M' => 'LCM', //Devuelve el mínimo común múltiplo.
        'LN' => 'LN', //Devuelve el logaritmo natural (neperiano) de un número.
        'LOG' => 'LOG', //Devuelve el logaritmo de un número en una base especificada.
        'LOG10' => 'LOG10', //Devuelve el logaritmo en base 10 de un número.
        'MDETERM' => 'MDETERM', //Devuelve la determinante matricial de una matriz.
        'MINVERSA' => 'MINVERSE', //Devuelve la matriz inversa de una matriz.
        'MMULT' => 'MMULT', //Devuelve el producto de matriz de dos matrices.
        'RESIDUO' => 'MOD', //Devuelve el resto de la división.
        'REDOND.MULT' => 'MROUND', //Devuelve un número redondeado al múltiplo deseado.
        'MULTINOMIAL' => 'MULTINOMIAL', //Devuelve el polinomio de un conjunto de números.
        'REDONDEA.IMPAR' => 'ODD', //Redondea un número hacia arriba hasta el entero impar más próximo.
        'PI' => 'PI', //Devuelve el valor de pi.
        'POTENCIA' => 'POWER', //Devuelve el resultado de elevar un número a una potencia.
        'PRODUCTO' => 'PRODUCT', //Multiplica sus argumentos.
        'COCIENTE' => 'QUOTIENT', //Devuelve la parte entera de una división.
        'RADIANES' => 'RADIANS', //Convierte grados en radianes.
        'ALEATORIO' => 'RAND', //Devuelve un número aleatorio entre 0 y 1.
        'ALEATORIO.ENTRE' => 'RANDBETWEEN', //Devuelve un número aleatorio entre los números que especifique.
        'NUMERO.ROMANO' => 'ROMAN', //Convierte un número arábigo en número romano, con formato de texto.
        'REDONDEAR' => 'ROUND', //Redondea un número al número de decimales especificado.
        'REDONDEAR.MENOS' => 'ROUNDDOWN', //Redondea un número hacia abajo, en dirección hacia cero.
        'REDONDEAR.MAS' => 'ROUNDUP', //Redondea un número hacia arriba, en dirección contraria a cero.
        'SUMA.SERIES' => 'SERIESSUM', //Devuelve la suma de una serie de potencias en función de la fórmula.
        'SIGNO' => 'SIGN', //Devuelve el signo de un número.
        'SENO' => 'SIN', //Devuelve el seno de un ángulo determinado.
        'SENOH' => 'SINH', //Devuelve el seno hiperbólico de un número.
        'RAIZ' => 'SQRT', //Devuelve la raíz cuadrada positiva de un número.
        'RAIZ2PI' => 'SQRTPI', //Devuelve la raíz cuadrada de un número multiplicado por PI (número * pi).
        'SUBTOTALES' => 'SUBTOTAL', //Devuelve un subtotal en una lista o base de datos.
        'SUMA' => 'SUM', //Suma sus argumentos.
        'SUMAR.SI' => 'SUMIF', //Suma las celdas especificadas que cumplen unos criterios determinados.
        'SUMAR.SI.CONJUNTO' => 'SUMIFS', //Suma las celdas de un rango que cumplen varios criterios.
        'SUMAPRODUCTO' => 'SUMPRODUCT', //Devuelve la suma de los productos de los correspondientes componentes de matriz.
        'SUMA.CUADRADOS' => 'SUMSQ', //Devuelve la suma de los cuadrados de los argumentos.
        'SUMAX2MENOSY2' => 'SUMX2MY2', //Devuelve la suma de la diferencia de los cuadrados de los valores correspondientes de dos matrices.
        'SUMAX2MASY2' => 'SUMX2PY2', //Devuelve la suma de la suma de los cuadrados de los valores correspondientes de dos matrices.
        'SUMAXMENOSY2' => 'SUMXMY2', //Devuelve la suma de los cuadrados de las diferencias de los valores correspondientes de dos matrices.
        'TAN' => 'TAN', //Devuelve la tangente de un número.
        'TANH' => 'TANH', //Devuelve la tangente hiperbólica de un número.
        'TRUNCAR' => 'TRUNC', //Trunca un número a un entero.
        'DESVPROM' => 'AVEDEV', //Devuelve el promedio de las desviaciones absolutas de la media de los puntos de datos.
        'PROMEDIO' => 'AVERAGE', //Devuelve el promedio de sus argumentos.
        'PROMEDIOA' => 'AVERAGEA', //Devuelve el promedio de sus argumentos, incluidos números, texto y valores lógicos.
        'PROMEDIO.SI' => 'AVERAGEIF', //Devuelve el promedio (media aritmética) de todas las celdas de un rango que cumplen unos criterios determinados.
        'PROMEDIO.SI.CONJUNTO' => 'AVERAGEIFS', //Devuelve el promedio (media aritmética) de todas las celdas que cumplen múltiples criterios.
        'DISTR.BETA' => 'BETADIST', //Devuelve la función de distribución beta acumulativa.
        'DISTR.BETA.INV' => 'BETAINV', //Devuelve la función inversa de la función de distribución acumulativa de una distribución beta especificada.
        'DISTR.BINOM' => 'BINOMDIST', //Devuelve la probabilidad de una variable aleatoria discreta siguiendo una distribución binomial.
        'DISTR.CHI' => 'CHIDIST', //Devuelve la probabilidad de una variable aleatoria continua siguiendo una distribución chi cuadrado de una sola cola.
        'PRUEBA.CHI.INV' => 'CHIINV', //Devuelve la función inversa de la probabilidad de una variable aleatoria continua siguiendo una distribución chi cuadrado de una sola cola.
        'PRUEBA.CHI' => 'CHITEST', //Devuelve la prueba de independencia.
        'INTERVALO.CONFIANZA' => 'CONFIDENCE', //Devuelve el intervalo de confianza de la media de una población.
        'COEF.DE.CORREL' => 'CORREL', //Devuelve el coeficiente de correlación entre dos conjuntos de datos.
        'CONTAR' => 'COUNT', //Cuenta cuántos números hay en la lista de argumentos.
        'CONTARA' => 'COUNTA', //Cuenta cuántos valores hay en la lista de argumentos.
        'CONTAR.BLANCO' => 'COUNTBLANK', //Cuenta el número de celdas en blanco de un rango.
        'CONTAR.SI' => 'COUNTIF', //Cuenta el número de celdas, dentro del rango, que cumplen el criterio especificado.
        'CONTAR.SI.CONJUNTO' => 'COUNTIFS', //Cuenta el número de celdas, dentro del rango, que cumplen varios criterios.
        'COVAR' => 'COVAR', //Devuelve la covarianza, que es el promedio de los productos de las desviaciones para cada pareja de puntos de datos.
        'BINOM.CRIT' => 'CRITBINOM', //Devuelve el menor valor cuya distribución binomial acumulativa es menor o igual a un valor de criterio.
        'DESVIA2' => 'DEVSQ', //Devuelve la suma de los cuadrados de las desviaciones.
        'DISTR.EXP' => 'EXPONDIST', //Devuelve la distribución exponencial.
        'DISTR.F' => 'FDIST', //Devuelve la distribución de probabilidad F.
        'DISTR.F.INV' => 'FINV', //Devuelve la función inversa de la distribución de probabilidad F.
        'FISHER' => 'FISHER', //Devuelve la transformación Fisher.
        'PRUEBA.FISHER.INV' => 'FISHERINV', //Devuelve la función inversa de la transformación Fisher.
        'PRONOSTICO' => 'FORECAST', //Devuelve un valor en una tendencia lineal.
        'FRECUENCIA' => 'FREQUENCY', //Devuelve una distribución de frecuencia como una matriz vertical.
        'PRUEBA.F' => 'FTEST', //Devuelve el resultado de una prueba F.
        'DISTR.GAMMA' => 'GAMMADIST', //Devuelve la distribución gamma.
        'DISTR.GAMMA.INV' => 'GAMMAINV', //Devuelve la función inversa de la distribución gamma acumulativa.
        'GAMMA.LN' => 'GAMMALN', //Devuelve el logaritmo natural de la función gamma, G(x).
        'MEDIA.GEOM' => 'GEOMEAN', //Devuelve la media geométrica.
        'CRECIMIENTO' => 'GROWTH', //Devuelve valores en una tendencia exponencial.
        'MEDIA.ARMO' => 'HARMEAN', //Devuelve la media armónica.
        'DISTR.HIPERGEOM' => 'HYPGEOMDIST', //Devuelve la distribución hipergeométrica.
        'INTERSECCION.EJE' => 'INTERCEPT', //Devuelve la intersección de la línea de regresión lineal.
        'CURTOSIS' => 'KURT', //Devuelve la curtosis de un conjunto de datos.
        'K.ESIMO.MAYOR' => 'LARGE', //Devuelve el k-ésimo mayor valor de un conjunto de datos.
        'ESTIMACION.LINEAL' => 'LINEST', //Devuelve los parámetros de una tendencia lineal.
        'ESTIMACION.LOGARITMICA' => 'LOGEST', //Devuelve los parámetros de una tendencia exponencial.
        'DISTR.LOG.INV' => 'LOGINV', //Devuelve la función inversa de la distribución logarítmico-normal.
        'DISTR.LOG.NORM' => 'LOGNORMDIST', //Devuelve la distribución logarítmico-normal acumulativa.
        'MAX' => 'MAX', //Devuelve el valor máximo de una lista de argumentos.
        'MAXA' => 'MAXA', //Devuelve el valor máximo de una lista de argumentos, incluidos números, texto y valores lógicos.
        'MEDIANA' => 'MEDIAN', //Devuelve la mediana de los números dados.
        'MIN' => 'MIN', //Devuelve el valor mínimo de una lista de argumentos.
        'MINA' => 'MINA', //Devuelve el valor mínimo de una lista de argumentos, incluidos números, texto y valores lógicos.
        'MODA' => 'MODE', //Devuelve el valor más común de un conjunto de datos.
        'NEGBINOMDIST' => 'NEGBINOMDIST', //Devuelve la distribución binomial negativa.
        'DISTR.NORM' => 'NORMDIST', //Devuelve la distribución normal acumulativa.
        'DISTR.NORM.INV' => 'NORMINV', //Devuelve la función inversa de la distribución normal acumulativa.
        'DISTR.NORM.ESTAND' => 'NORMSDIST', //Devuelve la distribución normal estándar acumulativa.
        'DISTR.NORM.ESTAND.INV' => 'NORMSINV', //Devuelve la función inversa de la distribución normal estándar acumulativa.
        'PEARSON' => 'PEARSON', //Devuelve el coeficiente de momento de correlación de producto Pearson.
        'PERCENTIL' => 'PERCENTILE', //Devuelve el k-ésimo percentil de los valores de un rango.
        'RANGO.PERCENTIL' => 'PERCENTRANK', //Devuelve el rango porcentual de un valor de un conjunto de datos.
        'PERMUTACIONES' => 'PERMUT', //Devuelve el número de permutaciones de un número determinado de objetos.
        'POISSON' => 'POISSON', //Devuelve la distribución de Poisson.
        'PROBABILIDAD' => 'PROB', //Devuelve la probabilidad de que los valores de un rango se encuentren entre dos límites.
        'CUARTIL' => 'QUARTILE', //Devuelve el cuartil de un conjunto de datos.
        'JERARQUIA' => 'RANK', //Devuelve la jerarquía de un número en una lista de números.
        'COEFICIENTE.R2' => 'RSQ', //Devuelve el cuadrado del coeficiente de momento de correlación de producto Pearson.
        'COEFICIENTE.ASIMETRIA' => 'SKEW', //Devuelve la asimetría de una distribución.
        'PENDIENTE' => 'SLOPE', //Devuelve la pendiente de la línea de regresión lineal.
        'K.ESIMO.MENOR' => 'SMALL', //Devuelve el k-ésimo menor valor de un conjunto de datos.
        'NORMALIZACION' => 'STANDARDIZE', //Devuelve un valor normalizado.
        'DESVEST' => 'STDEV', //Calcula la desviación estándar a partir de una muestra.
        'DESVESTA' => 'STDEVA', //Calcula la desviación estándar a partir de una muestra, incluidos números, texto y valores lógicos.
        'DESVESTP' => 'STDEVP', //Calcula la desviación estándar en función de toda la población.
        'DESVESTPA' => 'STDEVPA', //Calcula la desviación estándar en función de toda la población, incluidos números, texto y valores lógicos.
        'ERROR.TIPICO.XY' => 'STEYX', //Devuelve el error estándar del valor de "y" previsto para cada "x" de la regresión.
        'DISTR.T' => 'TDIST', //Devuelve la distribución de t de Student.
        'DISTR.T.INV' => 'TINV', //Devuelve la función inversa de la distribución de t de Student.
        'TENDENCIA' => 'TREND', //Devuelve valores en una tendencia lineal.
        'MEDIA.ACOTADA' => 'TRIMMEAN', //Devuelve la media del interior de un conjunto de datos.
        'PRUEBA.T' => 'TTEST', //Devuelve la probabilidad asociada a una prueba t de Student.
        'VAR' => 'VAR', //Calcula la varianza en función de una muestra.
        'VARA' => 'VARA', //Calcula la varianza en función de una muestra, incluidos números, texto y valores lógicos.
        'VARP' => 'VARP', //Calcula la varianza en función de toda la población.
        'VARPA' => 'VARPA', //Calcula la varianza en función de toda la población, incluidos números, texto y valores lógicos.
        'DIST.WEIBULL' => 'WEIBULL', //Devuelve la distribución de Weibull.
        'PRUEBA.Z' => 'ZTEST', //Devuelve el valor de una probabilidad de una cola de una prueba z.
        'ASC' => 'ASC', //Convierte las letras inglesas o katakana de ancho completo (de dos bytes) dentro de una cadena de caracteres en caracteres de ancho medio (de un byte).
        'TEXTOBAHT' => 'BAHTTEXT', //Convierte un número en texto, con el formato de moneda ß (Baht).
        'CARACTER' => 'CHAR', //Devuelve el carácter especificado por el número de código.
        'LIMPIAR' => 'CLEAN', //Quita del texto todos los caracteres no imprimibles.
        'CODIGO' => 'CODE', //Devuelve un código numérico del primer carácter de una cadena de texto.
        'CONCATENAR' => 'CONCATENATE', //Concatena varios elementos de texto en uno solo.
        'MONEDA' => 'DOLLAR', //Convierte un número en texto, con el formato de moneda $ (dólar).
        'IGUAL' => 'EXACT', //Comprueba si dos valores de texto son idénticos.
        'ENCONTRAR' => 'FIND', //Busca un valor de texto dentro de otro (distingue mayúsculas de minúsculas).
        'ENCONTRARB' => 'FINDB', //Busca un valor de texto dentro de otro (distingue mayúsculas de minúsculas).
        'DECIMAL' => 'FIXED', //Da formato a un número como texto con un número fijo de decimales.
        'JIS' => 'JIS', //Convierte las letras inglesas o katakana de ancho medio (de un byte) dentro de una cadena de caracteres en caracteres de ancho completo (de dos bytes).
        'IZQUIERDA' => 'LEFT', //Devuelve los caracteres del lado izquierdo de un valor de texto.
        'IZQUIERDAB' => 'LEFTB', //Devuelve los caracteres del lado izquierdo de un valor de texto.
        'LARGO' => 'LEN', //Devuelve el número de caracteres de una cadena de texto.
        'LARGOB' => 'LENB', //Devuelve el número de caracteres de una cadena de texto.
        'MINUSC' => 'LOWER', //Pone el texto en minúsculas.
        'EXTRAE' => 'MID', //Devuelve un número específico de caracteres de una cadena de texto que comienza en la posición que se especifique.
        'EXTRAEB' => 'MIDB', //Devuelve un número específico de caracteres de una cadena de texto que comienza en la posición que se especifique.
        'FONETICO' => 'PHONETIC', //Extrae los caracteres fonéticos (furigana) de una cadena de texto.
        'NOMPROPIO' => 'PROPER', //Pone en mayúscula la primera letra de cada palabra de un valor de texto.
        'REEMPLAZAR' => 'REPLACE', //Reemplaza caracteres de texto.
        'REEMPLAZARB' => 'REPLACEB', //Reemplaza caracteres de texto.
        'REPETIR' => 'REPT', //Repite el texto un número determinado de veces.
        'DERECHA' => 'RIGHT', //Devuelve los caracteres del lado derecho de un valor de texto.
        'DERECHAB' => 'RIGHTB', //Devuelve los caracteres del lado derecho de un valor de texto.
        'HALLAR' => 'SEARCH', //Busca un valor de texto dentro de otro (no distingue mayúsculas de minúsculas).
        'HALLARB' => 'SEARCHB', //Busca un valor de texto dentro de otro (no distingue mayúsculas de minúsculas).
        'SUSTITUIR' => 'SUBSTITUTE', //Sustituye texto nuevo por texto antiguo en una cadena de texto.
        'T' => 'T', //Convierte sus argumentos a texto.
        'TEXTO' => 'TEXT', //Da formato a un número y lo convierte en texto.
        'ESPACIOS' => 'TRIM', //Quita los espacios del texto.
        'MAYUSC' => 'UPPER', //Pone el texto en mayúsculas.
        'VALOR' => 'VALUE', //Convierte un argumento de texto en un número.
    ],
];
//EOF
