<?php
// hu_HU

return [
    'language' => 'Hungarian',
    'formats' => [
        'date' => 'YYYY-MM-DD',
        'time' => 'HH:MM:SS',
        'datetime' => 'YYYY-MM-DD HH:MM:SS',
        'money' => '# ##0.00 [$Ft];[RED]-# ##0.00 [$Ft]',
    ],
    'functions' => [
        'KIMUTATÁSADATOT.VESZ' => 'GETPIVOTDATA', //A kimutatásokban tárolt adatok visszaadására használható.
        'KOCKA.FŐTELJMUT' => 'CUBEKPIMEMBER', //Egy fő teljesítménymutató (KPI) nevét, tulajdonságát és mértékegységét adja eredményül, a nevet és a tulajdonságot megjeleníti a cellában. A KPI-k számszerűsíthető mérési lehetőséget jelentenek – ilyen mutató például a havi bruttó nyereség vagy az egy alkalmazottra jutó negyedéves forgalom –, egy szervezet teljesítményének nyomonkövetésére használhatók.
        'KOCKA.TAG' => 'CUBEMEMBER', //Kockahierachia tagját vagy rekordját adja eredményül. Ellenőrizhető vele, hogy szerepel-e a kockában az adott tag vagy rekord.
        'KOCKA.TAG.TUL' => 'CUBEMEMBERPROPERTY', //A kocka egyik tagtulajdonságának értékét adja eredményül. Használatával ellenőrizhető, hogy szerepel-e egy tagnév a kockában, eredménye pedig az erre a tagra vonatkozó, megadott tulajdonság.
        'KOCKA.HALM.ELEM' => 'CUBERANKEDMEMBER', //Egy halmaz rangsor szerinti n-edik tagját adja eredményül. Használatával egy halmaz egy vagy több elemét kaphatja meg, például a legnagyobb teljesítményű üzletkötőt vagy a 10 legjobb tanulót.
        'KOCKA.HALM' => 'CUBESET', //Számított tagok vagy rekordok halmazát adja eredményül, ehhez egy beállított kifejezést elküld a kiszolgálón található kockának, majd ezt a halmazt adja vissza a Microsoft Office Excel alkalmazásnak.
        'KOCKA.HALM.DB' => 'CUBESETCOUNT', //Egy halmaz elemszámát adja eredményül.
        'KOCKA.ÉRTÉK' => 'CUBEVALUE', //Kockából összesített értéket ad eredményül.
        'AB.ÁTLAG' => 'DAVERAGE', //A kijelölt adatbáziselemek átlagát számítja ki.
        'AB.DARAB' => 'DCOUNT', //Megszámolja, hogy az adatbázisban hány cella tartalmaz számokat.
        'AB.DARAB2' => 'DCOUNTA', //Megszámolja az adatbázisban lévő nem üres cellákat.
        'AB.MEZŐ' => 'DGET', //Egy adatbázisból egyetlen olyan rekordot ad vissza, amely megfelel a megadott feltételeknek.
        'AB.MAX' => 'DMAX', //A kiválasztott adatbáziselemek közül a legnagyobb értéket adja eredményül.
        'AB.MIN' => 'DMIN', //A kijelölt adatbáziselemek közül a legkisebb értéket adja eredményül.
        'AB.SZORZAT' => 'DPRODUCT', //Az adatbázis megadott feltételeknek eleget tevő rekordjaira összeszorozza a megadott mezőben található számértékeket, és eredményül ezt a szorzatot adja.
        'AB.SZÓRÁS' => 'DSTDEV', //A kijelölt adatbáziselemek egy mintája alapján megbecsüli a szórást.
        'AB.SZÓRÁS2' => 'DSTDEVP', //A kijelölt adatbáziselemek teljes sokasága alapján kiszámítja a szórást.
        'AB.SZUM' => 'DSUM', //Összeadja a feltételnek megfelelő adatbázisrekordok mezőoszlopában a számokat.
        'AB.VAR' => 'DVAR', //A kijelölt adatbáziselemek mintája alapján becslést ad a szórásnégyzetre.
        'AB.VAR2' => 'DVARP', //A kijelölt adatbáziselemek teljes sokasága alapján kiszámítja a szórásnégyzetet.
        'DÁTUM' => 'DATE', //Adott dátum dátumértékét adja eredményül.
        'DÁTUMÉRTÉK' => 'DATEVALUE', //Szövegként megadott dátumot dátumértékké alakít át.
        'NAP' => 'DAY', //Dátumértéket a hónap egy napjává (0-31) alakít.
        'NAP360' => 'DAYS360', //Két dátum közé eső napok számát számítja ki a 360 napos év alapján.
        'EDATE' => 'EDATE', //Adott dátumnál adott számú hónappal korábbi vagy későbbi dátum dátumértékét adja eredményül.
        'EOMONTH' => 'EOMONTH', //Adott dátumnál adott számú hónappal korábbi vagy későbbi hónap utolsó napjának dátumértékét adja eredményül.
        'ÓRA' => 'HOUR', //Időértéket órákká alakít.
        'PERC' => 'MINUTE', //Időértéket percekké alakít.
        'HÓNAP' => 'MONTH', //Időértéket hónapokká alakít.
        'NETWORKDAYS' => 'NETWORKDAYS', //Két dátum között a teljes munkanapok számát adja meg.
        'MOST' => 'NOW', //A napi dátum dátumértékét és a pontos idő időértékét adja eredményül.
        'MPERC' => 'SECOND', //Időértéket másodpercekké alakít át.
        'IDŐ' => 'TIME', //Adott időpont időértékét adja meg.
        'IDŐÉRTÉK' => 'TIMEVALUE', //Szövegként megadott időpontot időértékké alakít át.
        'MA' => 'TODAY', //A napi dátum dátumértékét adja eredményül.
        'HÉT.NAPJA' => 'WEEKDAY', //Dátumértéket a hét napjává alakítja át.
        'WEEKNUM' => 'WEEKNUM', //Visszatérési értéke egy szám, amely azt mutatja meg, hogy a megadott dátum az év hányadik hetére esik.
        'WORKDAY' => 'WORKDAY', //Adott dátumnál adott munkanappal korábbi vagy későbbi dátum dátumértékét adja eredményül.
        'ÉV' => 'YEAR', //Sorszámot évvé alakít át.
        'YEARFRAC' => 'YEARFRAC', //Az adott dátumok közötti teljes napok számát törtévként adja meg.
        'BESSELI' => 'BESSELI', //Az In(x) módosított Bessel-függvény értékét adja eredményül.
        'BESSELJ' => 'BESSELJ', //A Jn(x) Bessel-függvény értékét adja eredményül.
        'BESSELK' => 'BESSELK', //A Kn(x) módosított Bessel-függvény értékét adja eredményül.
        'BESSELY' => 'BESSELY', //Az Yn(x) módosított Bessel-függvény értékét adja eredményül.
        'BIN2DEC' => 'BIN2DEC', //Bináris számot decimálissá alakít át.
        'BIN2HEX' => 'BIN2HEX', //Bináris számot hexadecimálissá alakít át.
        'BIN2OCT' => 'BIN2OCT', //Bináris számot oktálissá alakít át.
        'COMPLEX' => 'COMPLEX', //Valós és képzetes részből komplex számot képez.
        'CONVERT' => 'CONVERT', //Mértékegységeket vált át.
        'DEC2BIN' => 'DEC2BIN', //Decimális számot binárissá alakít át.
        'DEC2HEX' => 'DEC2HEX', //Decimális számot hexadecimálissá alakít át.
        'DEC2OCT' => 'DEC2OCT', //Decimális számot oktálissá alakít át.
        'DELTA' => 'DELTA', //Azt vizsgálja, hogy két érték egyenlő-e.
        'ERF' => 'ERF', //A hibafüggvény értékét adja eredményül.
        'ERFC' => 'ERFC', //A kiegészített hibafüggvény értékét adja eredményül.
        'GESTEP' => 'GESTEP', //Azt vizsgálja, hogy egy szám nagyobb-e adott küszöbértéknél.
        'HEX2BIN' => 'HEX2BIN', //Hexadecimális számot binárissá alakít át.
        'HEX2DEC' => 'HEX2DEC', //Hexadecimális számot decimálissá alakít át.
        'HEX2OCT' => 'HEX2OCT', //Hexadecimális számot oktálissá alakít át.
        'IMABS' => 'IMABS', //Komplex szám abszolút értékét (modulusát) adja eredményül.
        'IMAGINARY' => 'IMAGINARY', //Komplex szám képzetes részét adja eredményül.
        'IMARGUMENT' => 'IMARGUMENT', //A komplex szám radiánban kifejezett théta argumentumát adja eredményül.
        'IMCONJUGATE' => 'IMCONJUGATE', //Komplex szám komplex konjugáltját adja eredményül.
        'IMCOS' => 'IMCOS', //Komplex szám koszinuszát adja eredményül.
        'IMDIV' => 'IMDIV', //Két komplex szám hányadosát adja eredményül.
        'IMEXP' => 'IMEXP', //Az e szám komplex kitevőjű hatványát adja eredményül.
        'IMLN' => 'IMLN', //Komplex szám természetes logaritmusát adja eredményül.
        'IMLOG10' => 'IMLOG10', //Komplex szám tízes alapú logaritmusát adja eredményül.
        'IMLOG2' => 'IMLOG2', //Komplex szám kettes alapú logaritmusát adja eredményül.
        'IMPOWER' => 'IMPOWER', //Komplex szám hatványát adja eredményül.
        'IMPRODUCT' => 'IMPRODUCT', //Komplex számok szorzatát adja eredményül.
        'IMREAL' => 'IMREAL', //Komplex szám valós részét adja eredményül.
        'IMSIN' => 'IMSIN', //Komplex szám szinuszát adja eredményül.
        'IMSQRT' => 'IMSQRT', //Komplex szám négyzetgyökét adja eredményül.
        'IMSUB' => 'IMSUB', //Két komplex szám különbségét adja eredményül.
        'IMSUM' => 'IMSUM', //Komplex számok összegét adja eredményül.
        'OCT2BIN' => 'OCT2BIN', //Oktális számot binárissá alakít át.
        'OCT2DEC' => 'OCT2DEC', //Oktális számot decimálissá alakít át.
        'OCT2HEX' => 'OCT2HEX', //Oktális számot hexadecimálissá alakít át.
        'ACCRINT' => 'ACCRINT', //Periodikusan kamatozó értékpapír felszaporodott kamatát adja eredményül.
        'ACCRINTM' => 'ACCRINTM', //Lejáratkor kamatozó értékpapír felszaporodott kamatát adja eredményül.
        'AMORDEGRC' => 'AMORDEGRC', //Állóeszköz lineáris értékcsökkenését adja meg az egyes könyvelési időszakokra vonatkozóan.
        'AMORLINC' => 'AMORLINC', //Az egyes könyvelési időszakokban az értékcsökkenést adja meg.
        'COUPDAYBS' => 'COUPDAYBS', //A szelvényidőszak kezdetétől a kifizetés időpontjáig eltelt napokat adja vissza.
        'COUPDAYS' => 'COUPDAYS', //A kifizetés időpontját magában foglaló szelvényperiódus hosszát adja meg napokban.
        'COUPDAYSNC' => 'COUPDAYSNC', //A kifizetés időpontja és a legközelebbi szelvénydátum közötti napok számát adja meg.
        'COUPNCD' => 'COUPNCD', //A kifizetést követő legelső szelvénydátumot adja eredményül.
        'COUPNUM' => 'COUPNUM', //A kifizetés és a lejárat időpontja között kifizetendő szelvények számát adja eredményül.
        'COUPPCD' => 'COUPPCD', //A kifizetés előtti utolsó szelvénydátumot adja eredményül.
        'CUMIPMT' => 'CUMIPMT', //Két fizetési időszak között kifizetett kamat halmozott értékét adja eredményül.
        'CUMPRINC' => 'CUMPRINC', //Két fizetési időszak között kifizetett részletek halmozott (kamatot nem tartalmazó) értékét adja eredményül.
        'KCS2' => 'DB', //Eszköz adott időszak alatti értékcsökkenését számítja ki a lineáris leírási modell alkalmazásával.
        'KCSA' => 'DDB', //Eszköz értékcsökkenését számítja ki adott időszakra vonatkozóan a progresszív vagy egyéb megadott leírási modell alkalmazásával.
        'DISC' => 'DISC', //Értékpapír leszámítolási kamatlábát adja eredményül.
        'DOLLARDE' => 'DOLLARDE', //Egy közönséges törtként megadott számot tizedes törtté alakít át.
        'DOLLARFR' => 'DOLLARFR', //Tizedes törtként megadott számot közönséges törtté alakít át.
        'DURATION' => 'DURATION', //Periodikus kamatfizetésű értékpapír éves kamatérzékenységét adja eredményül.
        'EFFECT' => 'EFFECT', //Az éves tényleges kamatláb értékét adja eredményül.
        'JBÉ' => 'FV', //Befektetés jövőbeli értékét számítja ki.
        'FVSCHEDULE' => 'FVSCHEDULE', //A kezdőtőke adott kamatlábak szerint megnövelt jövőbeli értékét adja eredményül.
        'INTRATE' => 'INTRATE', //A lejáratig teljesen lekötött értékpapír kamatrátáját adja eredményül.
        'RRÉSZLET' => 'IPMT', //Hiteltörlesztésen belül a tőketörlesztés nagyságát számítja ki adott időszakra.
        'BMR' => 'IRR', //A befektetés belső megtérülési rátáját számítja ki pénzáramláshoz.
        'LRÉSZLETKAMAT' => 'ISPMT', //A befektetés adott időszakára fizetett kamatot számítja ki.
        'MDURATION' => 'MDURATION', //Egy 100 Ft névértékű értékpapír Macauley-féle módosított kamatérzékenységét adja eredményül.
        'MEGTÉRÜLÉS' => 'MIRR', //A befektetés belső megtérülési rátáját számítja ki a költségek és a bevételek különböző kamatlába mellett.
        'NOMINAL' => 'NOMINAL', //Az éves névleges kamatláb értékét adja eredményül.
        'PER.SZÁM' => 'NPER', //A törlesztési időszakok számát adja meg.
        'NMÉ' => 'NPV', //Befektetéshez kapcsolódó pénzáramlás nettó jelenértékét számítja ki ismert pénzáramlás és kamatláb mellett.
        'ODDFPRICE' => 'ODDFPRICE', //Egy 100 Ft névértékű, a futamidő elején töredék-időszakos értékpapír árát adja eredményül.
        'ODDFYIELD' => 'ODDFYIELD', //A futamidő elején töredék-időszakos értékpapír hozamát adja eredményül.
        'ODDLPRICE' => 'ODDLPRICE', //Egy 100 Ft névértékű, a futamidő végén töredék-időszakos értékpapír árát adja eredményül.
        'ODDLYIELD' => 'ODDLYIELD', //A futamidő végén töredék-időszakos értékpapír hozamát adja eredményül.
        'RÉSZLET' => 'PMT', //A törlesztési időszakra vonatkozó törlesztési összeget számítja ki.
        'PRÉSZLET' => 'PPMT', //Hiteltörlesztésen belül a tőketörlesztés nagyságát számítja ki adott időszakra.
        'PRICE' => 'PRICE', //Egy 100 Ft névértékű, periodikusan kamatozó értékpapír árát adja eredményül.
        'PRICEDISC' => 'PRICEDISC', //Egy 100 Ft névértékű leszámítolt értékpapír árát adja eredményül.
        'PRICEMAT' => 'PRICEMAT', //Egy 100 Ft névértékű, a lejáratkor kamatozó értékpapír árát adja eredményül.
        'MÉ' => 'PV', //Befektetés jelenlegi értékét számítja ki.
        'RÁTA' => 'RATE', //Egy törlesztési időszakban az egy időszakra eső kamatláb nagyságát számítja ki.
        'RECEIVED' => 'RECEIVED', //A lejáratig teljesen lekötött értékpapír lejáratakor kapott összegét adja eredményül.
        'LCSA' => 'SLN', //Tárgyi eszköz egy időszakra eső amortizációját adja meg bruttó érték szerinti lineáris leírási kulcsot alkalmazva.
        'SYD' => 'SYD', //Tárgyi eszköz értékcsökkenését számítja ki adott időszakra az évek számjegyösszegével dolgozó módszer alapján.
        'TBILLEQ' => 'TBILLEQ', //Kincstárjegy kötvény-egyenértékű hozamát adja eredményül.
        'TBILLPRICE' => 'TBILLPRICE', //Egy 100 Ft névértékű kincstárjegy árát adja eredményül.
        'TBILLYIELD' => 'TBILLYIELD', //Kincstárjegy hozamát adja eredményül.
        'ÉCSRI' => 'VDB', //Tárgyi eszköz amortizációját számítja ki megadott vagy részidőszakra a csökkenő egyenleg módszerének alkalmazásával.
        'XIRR' => 'XIRR', //Ütemezett készpénzforgalom (cash flow) belső megtérülési kamatrátáját adja eredményül.
        'XNPV' => 'XNPV', //Ütemezett készpénzforgalom (cash flow) nettó jelenlegi értékét adja eredményül.
        'YIELD' => 'YIELD', //Periodikusan kamatozó értékpapír hozamát adja eredményül.
        'YIELDDISC' => 'YIELDDISC', //Leszámítolt értékpapír (például kincstárjegy) éves hozamát adja eredményül.
        'YIELDMAT' => 'YIELDMAT', //Lejáratkor kamatozó értékpapír éves hozamát adja eredményül.
        'CELLA' => 'CELL', //Egy cella formátumára, elhelyezkedésére vagy tartalmára vonatkozó adatokat ad eredményül.
        'HIBA.TÍPUS' => 'ERROR.TYPE', //Egy hibatípushoz tartozó számot ad eredményül.
        'INFÓ' => 'INFO', //A rendszer- és munkakörnyezet pillanatnyi állapotáról ad felvilágosítást.
        'ÜRES' => 'ISBLANK', //Eredménye IGAZ, ha az érték üres.
        'HIBA' => 'ISERR', //Eredménye IGAZ, ha az érték valamelyik hibaérték a #HIÁNYZIK kivételével.
        'HIBÁS' => 'ISERROR', //Eredménye IGAZ, ha az érték valamelyik hibaérték.
        'ISEVEN' => 'ISEVEN', //Eredménye IGAZ, ha argumentuma páros szám.
        'LOGIKAI' => 'ISLOGICAL', //Eredménye IGAZ, ha az érték logikai érték.
        'NINCS' => 'ISNA', //Eredménye IGAZ, ha az érték a #HIÁNYZIK hibaérték.
        'NEM.SZÖVEG' => 'ISNONTEXT', //Eredménye IGAZ, ha az érték nem szöveg.
        'SZÁM' => 'ISNUMBER', //Eredménye IGAZ, ha az érték szám.
        'ISODD' => 'ISODD', //Eredménye IGAZ, ha argumentuma páratlan szám.
        'HIVATKOZÁS' => 'ISREF', //Eredménye IGAZ, ha az érték hivatkozás.
        'SZÖVEG.E' => 'ISTEXT', //Eredménye IGAZ, ha az érték szöveg.
        'N' => 'N', //Argumentumának értékét számmá alakítja.
        'HIÁNYZIK' => 'NA', //Eredménye a #HIÁNYZIK hibaérték.
        'TÍPUS' => 'TYPE', //Érték adattípusának azonosítószámát adja eredményül.
        'ÉS' => 'AND', //Eredménye IGAZ, ha minden argumentuma IGAZ.
        'HAMIS' => 'FALSE', //A HAMIS logikai értéket adja eredményül.
        'HA' => 'IF', //Logikai vizsgálatot hajt végre.
        'HAHIBA' => 'IFERROR', //A megadott értéket adja vissza, ha egy képlet hibához vezet; más esetben a képlet értékét adja eredményül.
        'NEM' => 'NOT', //Argumentuma értékének ellentettjét adja eredményül.
        'VAGY' => 'OR', //Eredménye IGAZ, ha bármely argumentuma IGAZ.
        'IGAZ' => 'TRUE', //Az IGAZ logikai értéket adja eredményül.
        'CÍM' => 'ADDRESS', //A munkalap egy cellájára való hivatkozást adja szövegként eredményül.
        'TERÜLET' => 'AREAS', //Hivatkozásban a területek számát adja eredményül.
        'VÁLASZT' => 'CHOOSE', //Értékek listájából választ ki egy elemet.
        'OSZLOP' => 'COLUMN', //Egy hivatkozás oszlopszámát adja eredményül.
        'OSZLOPOK' => 'COLUMNS', //A hivatkozásban található oszlopok számát adja eredményül.
        'VKERES' => 'HLOOKUP', //A megadott tömb felső sorában adott értékű elemet keres, és a megtalált elem oszlopából adott sorban elhelyezkedő értékkel tér vissza.
        'HIPERHIVATKOZÁS' => 'HYPERLINK', //Hálózati kiszolgálón, intraneten vagy az interneten tárolt dokumentumot megnyitó parancsikont vagy hivatkozást hoz létre.
        'INDEX' => 'INDEX', //Tömb- vagy hivatkozás indexszel megadott értékét adja vissza.
        'INDIREKT' => 'INDIRECT', //Szöveg megadott hivatkozást ad eredményül.
        'KERES' => 'LOOKUP', //Vektorban vagy tömbben keres meg értékeket.
        'HOL.VAN' => 'MATCH', //Hivatkozásban vagy tömbben értékeket keres.
        'OFSZET' => 'OFFSET', //Hivatkozás egy másik hivatkozástól számított távolságát adja meg.
        'SOR' => 'ROW', //Egy hivatkozás sorának számát adja meg.
        'SOROK' => 'ROWS', //Egy hivatkozás sorainak számát adja meg.
        'RTD' => 'RTD', //Valós idejű adatokat keres vissza a COM automatizmust (automatizálás: Egy alkalmazás objektumaival való munka másik alkalmazásból vagy fejlesztőeszközből. A korábban OLE automatizmusnak nevezett automatizálás iparági szabvány, a Component Object Model (COM) szolgáltatása.) támogató programból.
        'TRANSZPONÁLÁS' => 'TRANSPOSE', //Egy tömb transzponáltját adja eredményül.
        'FKERES' => 'VLOOKUP', //A megadott tömb bal szélső oszlopában megkeres egy értéket, majd annak sora és a megadott oszlop metszéspontjában levő értéked adja eredményül.
        'ABS' => 'ABS', //Egy szám abszolút értékét adja eredményül.
        'ARCCOS' => 'ACOS', //Egy szám arkusz koszinuszát számítja ki.
        'ACOSH' => 'ACOSH', //Egy szám inverz koszinusz hiperbolikuszát számítja ki.
        'ARCSIN' => 'ASIN', //Egy szám arkusz szinuszát számítja ki.
        'ASINH' => 'ASINH', //Egy szám inverz szinusz hiperbolikuszát számítja ki.
        'ARCTAN' => 'ATAN', //Egy szám arkusz tangensét számítja ki.
        'ARCTAN2' => 'ATAN2', //X és y koordináták alapján számítja ki az arkusz tangens értéket.
        'ATANH' => 'ATANH', //A szám inverz tangens hiperbolikuszát számítja ki.
        'PLAFON' => 'CEILING', //Egy számot a legközelebbi egészre vagy a pontosságként megadott érték legközelebb eső többszörösére kerekít.
        'KOMBINÁCIÓK' => 'COMBIN', //Adott számú objektum összes lehetséges kombinációinak számát számítja ki.
        'COS' => 'COS', //Egy szám koszinuszát számítja ki.
        'COSH' => 'COSH', //Egy szám koszinusz hiperbolikuszát számítja ki.
        'FOK' => 'DEGREES', //Radiánt fokká alakít át.
        'PÁROS' => 'EVEN', //Egy számot a legközelebbi páros egész számra kerekít.
        'KITEVŐ' => 'EXP', //Az e adott kitevőjű hatványát adja eredményül.
        'FAKT' => 'FACT', //Egy szám faktoriálisát számítja ki.
        'FACTDOUBLE' => 'FACTDOUBLE', //Egy szám dupla faktoriálisát adja eredményül.
        'PADLÓ' => 'FLOOR', //Egy számot lefelé, a nulla felé kerekít.
        'GCD' => 'GCD', //A legnagyobb közös osztót adja eredményül.
        'INT' => 'INT', //Egy számot lefelé kerekít a legközelebbi egészre.
        'LCM' => 'LCM', //A legkisebb közös többszöröst adja eredményül.
        'LN' => 'LN', //Egy szám természetes logaritmusát számítja ki.
        'LOG' => 'LOG', //Egy szám adott alapú logaritmusát számítja ki.
        'LOG10' => 'LOG10', //Egy szám 10-es alapú logaritmusát számítja ki.
        'MDETERM' => 'MDETERM', //Egy tömb mátrix-determinánsát számítja ki.
        'INVERZ.MÁTRIX' => 'MINVERSE', //Egy tömb mátrix inverzét adja eredményül.
        'MSZORZAT' => 'MMULT', //Két tömb mátrix-szorzatát adja meg.
        'MARADÉK' => 'MOD', //Egy szám osztási maradékát adja eredményül.
        'MROUND' => 'MROUND', //A kívánt többszörösére kerekített értéket ad eredményül.
        'MULTINOMIAL' => 'MULTINOMIAL', //Számhalmaz multinomiálisát adja eredményül.
        'PÁRATLAN' => 'ODD', //Egy számot a legközelebbi páratlan számra kerekít.
        'PI' => 'PI', //A pi matematikai állandót adja vissza.
        'HATVÁNY' => 'POWER', //Egy szám adott kitevőjű hatványát számítja ki.
        'SZORZAT' => 'PRODUCT', //Argumentumai szorzatát számítja ki.
        'QUOTIENT' => 'QUOTIENT', //Egy hányados egész részét adja eredményül.
        'RADIÁN' => 'RADIANS', //Fokot radiánná alakít át.
        'VÉL' => 'RAND', //Egy 0 és 1 közötti véletlen számot ad eredményül.
        'RANDBETWEEN' => 'RANDBETWEEN', //Megadott számok közé eső véletlen számot állít elő.
        'RÓMAI' => 'ROMAN', //Egy számot római számokkal kifejezve szövegként ad eredményül.
        'KEREKÍTÉS' => 'ROUND', //Egy számot adott számú számjegyre kerekít.
        'KEREKÍTÉS.LE' => 'ROUNDDOWN', //Egy számot lefelé, a nulla felé kerekít.
        'KEREKÍTÉS.FEL' => 'ROUNDUP', //Egy számot felfelé, a nullától távolabbra kerekít.
        'SERIESSUM' => 'SERIESSUM', //Hatványsor összegét adja eredményül.
        'ELŐJEL' => 'SIGN', //Egy szám előjelét adja meg.
        'SIN' => 'SIN', //Egy szög szinuszát számítja ki.
        'SINH' => 'SINH', //Egy szám szinusz hiperbolikuszát számítja ki.
        'GYÖK' => 'SQRT', //Egy szám pozitív négyzetgyökét számítja ki.
        'SQRTPI' => 'SQRTPI', //A (szám*pi) négyzetgyökét adja eredményül.
        'RÉSZÖSSZEG' => 'SUBTOTAL', //Lista vagy adatbázis részösszegét adja eredményül.
        'SZUM' => 'SUM', //Összeadja az argumentumlistájában lévő számokat.
        'SZUMHA' => 'SUMIF', //A megadott feltételeknek eleget tevő cellákban található értékeket adja össze.
        'SZUMHATÖBB' => 'SUMIFS', //Több megadott feltételnek eleget tévő tartománycellák összegét adja eredményül.
        'SZORZATÖSSZEG' => 'SUMPRODUCT', //A megfelelő tömbelemek szorzatának összegét számítja ki.
        'NÉGYZETÖSSZEG' => 'SUMSQ', //Argumentumai négyzetének összegét számítja ki.
        'SZUMX2BŐLY2' => 'SUMX2MY2', //Két tömb megfelelő elemei négyzetének különbségét összegzi.
        'SZUMX2MEGY2' => 'SUMX2PY2', //Két tömb megfelelő elemei négyzetének összegét összegzi.
        'SZUMXBŐLY2' => 'SUMXMY2', //Két tömb megfelelő elemei különbségének négyzetösszegét számítja ki.
        'TAN' => 'TAN', //Egy szám tangensét számítja ki.
        'TANH' => 'TANH', //Egy szám tangens hiperbolikuszát számítja ki.
        'CSONK' => 'TRUNC', //Egy számot egésszé csonkít.
        'ÁTL.ELTÉRÉS' => 'AVEDEV', //Az adatpontoknak átlaguktól való átlagos abszolút eltérését számítja ki.
        'ÁTLAG' => 'AVERAGE', //Argumentumai átlagát számítja ki.
        'ÁTLAGA' => 'AVERAGEA', //Argumentumai átlagát számítja ki (beleértve a számokat, szöveget és logikai értékeket).
        'ÁTLAGHA' => 'AVERAGEIF', //A megadott feltételnek eleget tévő tartomány celláinak átlagát (számtani közepét) adja eredményül.
        'ÁTLAGHATÖBB' => 'AVERAGEIFS', //A megadott feltételeknek eleget tévő cellák átlagát (számtani közepét) adja eredményül.
        'BÉTA.ELOSZLÁS' => 'BETADIST', //A béta-eloszlás függvényt számítja ki.
        'INVERZ.BÉTA' => 'BETAINV', //Adott béta-eloszláshoz kiszámítja a béta eloszlásfüggvény inverzét.
        'BINOM.ELOSZLÁS' => 'BINOMDIST', //A diszkrét binomiális eloszlás valószínűségértékét számítja ki.
        'KHI.ELOSZLÁS' => 'CHIDIST', //A khi-négyzet-eloszlás egyszélű valószínűségértékét számítja ki.
        'INVERZ.KHI' => 'CHIINV', //A khi-négyzet-eloszlás egyszélű valószínűségértékének inverzét számítja ki.
        'KHI.PRÓBA' => 'CHITEST', //Függetlenségvizsgálatot hajt végre.
        'MEGBÍZHATÓSÁG' => 'CONFIDENCE', //Egy statisztikai sokaság várható értékének megbízhatósági intervallumát adja eredményül.
        'KORREL' => 'CORREL', //Két adathalmaz korrelációs együtthatóját számítja ki.
        'DARAB' => 'COUNT', //Megszámolja, hogy argumentumlistájában hány szám található.
        'DARAB2' => 'COUNTA', //Megszámolja, hogy argumentumlistájában hány érték található.
        'DARABÜRES' => 'COUNTBLANK', //Egy tartományban összeszámolja az üres cellákat.
        'DARABTELI' => 'COUNTIF', //Egy tartományban összeszámolja azokat a cellákat, amelyek eleget tesznek a megadott feltételnek.
        'DARABHATÖBB' => 'COUNTIFS', //Egy tartományban összeszámolja azokat a cellákat, amelyek eleget tesznek több feltételnek.
        'KOVAR' => 'COVAR', //A kovarianciát, azaz a páronkénti eltérések szorzatának átlagát számítja ki.
        'KRITBINOM' => 'CRITBINOM', //Azt a legkisebb számot adja eredményül, amelyre a binomiális eloszlásfüggvény értéke nem kisebb egy adott határértéknél.
        'SQ' => 'DEVSQ', //Az átlagtól való eltérések négyzetének összegét számítja ki.
        'EXP.ELOSZLÁS' => 'EXPONDIST', //Az exponenciális eloszlás értékét számítja ki.
        'F.ELOSZLÁS' => 'FDIST', //Az F-eloszlás értékét számítja ki.
        'INVERZ.F' => 'FINV', //Az F-eloszlás inverzének értékét számítja ki.
        'FISHER' => 'FISHER', //Fisher-transzformációt hajt végre.
        'INVERZ.FISHER' => 'FISHERINV', //A Fisher-transzformáció inverzét hajtja végre.
        'ELŐREJELZÉS' => 'FORECAST', //Az ismert értékek alapján lineáris regresszióval becsült értéket ad eredményül.
        'GYAKORISÁG' => 'FREQUENCY', //A gyakorisági vagy empirikus eloszlás értékét függőleges tömbként adja eredményül.
        'F.PRÓBA' => 'FTEST', //Az F-próba értékét adja eredményül.
        'GAMMA.ELOSZLÁS' => 'GAMMADIST', //A gamma-eloszlás értékét számítja ki.
        'INVERZ.GAMMA' => 'GAMMAINV', //A gamma-eloszlás eloszlásfüggvénye inverzének értékét számítja ki.
        'GAMMALN' => 'GAMMALN', //A gamma-függvény természetes logaritmusát számítja ki.
        'MÉRTANI.KÖZÉP' => 'GEOMEAN', //Argumentumai mértani középértékét számítja ki.
        'NÖV' => 'GROWTH', //Exponenciális regresszió alapján ad becslést.
        'HARM.KÖZÉP' => 'HARMEAN', //Argumentumai harmonikus átlagát számítja ki.
        'HIPERGEOM.ELOSZLÁS' => 'HYPGEOMDIST', //A hipergeometriai eloszlás értékét számítja ki.
        'METSZ' => 'INTERCEPT', //A regressziós egyenes y tengellyel való metszéspontját határozza meg.
        'CSÚCSOSSÁG' => 'KURT', //Egy adathalmaz csúcsosságát számítja ki.
        'NAGY' => 'LARGE', //Egy adathalmaz k-adik legnagyobb elemét adja eredményül.
        'LIN.ILL' => 'LINEST', //A legkisebb négyzetek módszerével az adatokra illesztett egyenes paramétereit határozza meg.
        'LOG.ILL' => 'LOGEST', //Az adatokra illesztett exponenciális görbe paramétereit határozza meg.
        'INVERZ.LOG.ELOSZLÁS' => 'LOGINV', //A lognormális eloszlás inverzét számítja ki.
        'LOG.ELOSZLÁS' => 'LOGNORMDIST', //A lognormális eloszlásfüggvény értékét számítja ki.
        'MAX' => 'MAX', //Az argumentumai között szereplő legnagyobb számot adja meg.
        'MAX2' => 'MAXA', //Az argumentumai között szereplő legnagyobb számot adja meg (beleértve a számokat, szöveget és logikai értékeket).
        'MEDIÁN' => 'MEDIAN', //Adott számhalmaz mediánját számítja ki.
        'MIN' => 'MIN', //Az argumentumai között szereplő legkisebb számot adja meg.
        'MIN2' => 'MINA', //Az argumentumai között szereplő legkisebb számot adja meg, beleértve a számokat, szöveget és logikai értékeket.
        'MÓDUSZ' => 'MODE', //Egy adathalmazból kiválasztja a leggyakrabban előforduló számot.
        'NEGBINOM.ELOSZL' => 'NEGBINOMDIST', //A negatív binomiális eloszlás értékét számítja ki.
        'NORM.ELOSZL' => 'NORMDIST', //A normális eloszlás értékét számítja ki.
        'INVERZ.NORM' => 'NORMINV', //A normális eloszlás eloszlásfüggvénye inverzének értékét számítja ki.
        'STNORMELOSZL' => 'NORMSDIST', //A standard normális eloszlás eloszlásfüggvényének értékét számítja ki.
        'INVERZ.STNORM' => 'NORMSINV', //A standard normális eloszlás eloszlásfüggvénye inverzének értékét számítja ki.
        'PEARSON' => 'PEARSON', //A Pearson-féle korrelációs együtthatót számítja ki.
        'PERCENTILIS' => 'PERCENTILE', //Egy tartományban található értékek k-adik percentilisét, azaz százalékosztályát adja eredményül.
        'SZÁZALÉKRANG' => 'PERCENTRANK', //Egy értéknek egy adathalmazon belül vett százalékos rangját (elhelyezkedését) számítja ki.
        'VARIÁCIÓK' => 'PERMUT', //Adott számú objektum k-ad osztályú ismétlés nélküli variációinak számát számítja ki.
        'POISSON' => 'POISSON', //A Poisson-eloszlás értékét számítja ki.
        'VALÓSZÍNŰSÉG' => 'PROB', //Annak valószínűségét számítja ki, hogy adott értékek két határérték közé esnek.
        'KVARTILIS' => 'QUARTILE', //Egy adathalmaz kvartilisét (negyedszintjét) számítja ki.
        'SORSZÁM' => 'RANK', //Kiszámítja, hogy egy szám hányadik egy számsorozatban.
        'RNÉGYZET' => 'RSQ', //Kiszámítja a Pearson-féle szorzatmomentum korrelációs együtthatójának négyzetét.
        'FERDESÉG' => 'SKEW', //Egy eloszlás ferdeségét határozza meg.
        'MEREDEKSÉG' => 'SLOPE', //Egy lineáris regressziós egyenes meredekségét számítja ki.
        'KICSI' => 'SMALL', //Egy adathalmaz k-adik legkisebb elemét adja meg.
        'NORMALIZÁLÁS' => 'STANDARDIZE', //Normalizált értéket ad eredményül.
        'SZÓRÁS' => 'STDEV', //Egy statisztikai sokaság mintájából kiszámítja annak szórását.
        'SZÓRÁSA' => 'STDEVA', //Egy statisztikai sokaság mintájából kiszámítja annak szórását (beleértve a számokat, szöveget és logikai értékeket).
        'SZÓRÁSP' => 'STDEVP', //Egy statisztikai sokaság egészéből kiszámítja annak szórását.
        'SZÓRÁSPA' => 'STDEVPA', //Egy statisztikai sokaság egészéből kiszámítja annak szórását (beleértve számokat, szöveget és logikai értékeket).
        'STHIBAYX' => 'STEYX', //Egy regresszió esetén az egyes x-értékek alapján meghatározott y-értékek standard hibáját számítja ki.
        'T.ELOSZLÁS' => 'TDIST', //A Student-féle t-eloszlás értékét számítja ki.
        'INVERZ.T' => 'TINV', //A Student-féle t-eloszlás inverzét számítja ki.
        'TREND' => 'TREND', //Lineáris trend értékeit számítja ki.
        'RÉSZÁTLAG' => 'TRIMMEAN', //Egy adathalmaz középső részének átlagát számítja ki.
        'T.PRÓBA' => 'TTEST', //A Student-féle t-próbához tartozó valószínűséget számítja ki.
        'VAR' => 'VAR', //Minta alapján becslést ad a varianciára.
        'VARA' => 'VARA', //Minta alapján becslést ad a varianciára (beleértve számokat, szöveget és logikai értékeket).
        'VARP' => 'VARP', //Egy statisztikai sokaság varianciáját számítja ki.
        'VARPA' => 'VARPA', //Egy statisztikai sokaság varianciáját számítja ki (beleértve számokat, szöveget és logikai értékeket).
        'WEIBULL' => 'WEIBULL', //A Weibull-féle eloszlás értékét számítja ki.
        'Z.PRÓBA' => 'ZTEST', //Az egyszélű z-próbával kapott valószínűségértéket számítja ki.
        'ASC' => 'ASC', //Szöveg teljes szélességű (kétbájtos) latin és katakana karaktereit félszélességű (egybájtos) karakterekké alakítja.
        'BAHTSZÖVEG' => 'BAHTTEXT', //Számot szöveggé alakít a ß (baht) pénznemformátum használatával.
        'KARAKTER' => 'CHAR', //A kódszámmal meghatározott karaktert adja eredményül.
        'TISZTÍT' => 'CLEAN', //A szövegből eltávolítja az összes nem nyomtatható karaktert.
        'KÓD' => 'CODE', //Karaktersorozat első karakterének numerikus kódját adja eredményül.
        'ÖSSZEFŰZ' => 'CONCATENATE', //Több szövegelemet egyetlen szöveges elemmé fűz össze.
        'FORINT' => 'DOLLAR', //Számot pénznem formátumú szöveggé alakít át.
        'AZONOS' => 'EXACT', //Megvizsgálja, hogy két érték azonos-e.
        'SZÖVEG.TALÁL' => 'FIND', //Karaktersorozatot keres egy másikban (a kis- és nagybetűk megkülönböztetésével).
        'SZÖVEG.TALÁL2' => 'FINDB', //Karaktersorozatot keres egy másikban (a kis- és nagybetűk megkülönböztetésével).
        'FIX' => 'FIXED', //Számot szöveges formátumúra alakít adott számú tizedesjegyre kerekítve.
        'JIS' => 'JIS', //A félszélességű (egybájtos) latin és a katakana karaktereket teljes szélességű (kétbájtos) karakterekké alakítja.
        'BAL' => 'LEFT', //Szöveg bal szélső karaktereit adja eredményül.
        'BAL2' => 'LEFTB', //Szöveg bal szélső karaktereit adja eredményül.
        'HOSSZ' => 'LEN', //Szöveg karakterekben mért hosszát adja eredményül.
        'HOSSZ2' => 'LENB', //Szöveg karakterekben mért hosszát adja eredményül.
        'KISBETŰ' => 'LOWER', //Szöveget kisbetűssé alakít át.
        'KÖZÉP' => 'MID', //A szöveg adott pozíciójától kezdve megadott számú karaktert ad vissza eredményként.
        'KÖZÉP2' => 'MIDB', //A szöveg adott pozíciójától kezdve megadott számú karaktert ad vissza eredményként.
        'PHONETIC' => 'PHONETIC', //Szöveg furigana (fonetikus) karaktereit adja vissza.
        'TNÉV' => 'PROPER', //Szöveg minden szavának kezdőbetűjét nagybetűsre cseréli.
        'CSERE' => 'REPLACE', //A szövegen belül karaktereket cserél.
        'CSERE2' => 'REPLACEB', //A szövegen belül karaktereket cserél.
        'SOKSZOR' => 'REPT', //Megadott számú alkalommal megismétel egy szövegrészt.
        'JOBB' => 'RIGHT', //Szövegrész jobb szélső karaktereit adja eredményül.
        'JOBB2' => 'RIGHTB', //Szövegrész jobb szélső karaktereit adja eredményül.
        'SZÖVEG.KERES' => 'SEARCH', //Karaktersorozatot keres egy másikban (a kis- és nagybetűk között nem tesz különbséget).
        'SZÖVEG.KERES2' => 'SEARCHB', //Karaktersorozatot keres egy másikban (a kis- és nagybetűk között nem tesz különbséget).
        'HELYETTE' => 'SUBSTITUTE', //Szövegben adott karaktereket másikra cserél.
        'T' => 'T', //Argumentumát szöveggé alakítja át.
        'SZÖVEG' => 'TEXT', //Számértéket alakít át adott számformátumú szöveggé.
        'TRIM' => 'TRIM', //A szövegből eltávolítja a szóközöket.
        'NAGYBETŰS' => 'UPPER', //Szöveget nagybetűssé alakít át.
        'ÉRTÉK' => 'VALUE', //Szöveget számmá alakít át.
    ],
];
//EOF
