<?php
// it_IT

return [
    'language' => 'Italian',
    'formats' => [
        'date' => 'DD/MM/YYYY',
        'time' => 'HH:MM:SS',
        'datetime' => 'DD/MM/YYYY HH:MM:SS',
        'money' => '[$€]# ##0.00;[RED][$€]-# ##0.00',
    ],
    'functions' => [
        'INFO.DATI.TAB.PIVOT' => 'GETPIVOTDATA', //Restituisce i dati memorizzati in un rapporto di tabella pivot
        'MEMBRO.KPI.CUBO' => 'CUBEKPIMEMBER', //Restituisce il nome, la proprietà e la misura di un indicatore di prestazioni chiave (KPI) e visualizza il nome e la proprietà nella cella. Un KPI è una misura quantificabile, ad esempio l'utile lordo mensile o il fatturato trimestrale dei dipendenti, utilizzata per il monitoraggio delle prestazioni di un'organizzazione.
        'MEMBRO.CUBO' => 'CUBEMEMBER', //Restituisce un membro o una tupla in una gerarchia di cubi. Consente di verificare l'esistenza del membro o della tupla nel cubo.
        'PROPRIETÀ.MEMBRO.CUBO' => 'CUBEMEMBERPROPERTY', //Restituisce il valore di una proprietà di un membro del cubo. Consente di verificare l'esistenza di un nome di membro all'interno del cubo e di restituire la proprietà specificata per tale membro.
        'MEMBRO.CUBO.CON.RANGO' => 'CUBERANKEDMEMBER', //Restituisce l'n-esimo membro o il membro ordinato di un insieme. Consente di restituire uno o più elementi in un insieme, ad esempio l'agente di vendita migliore o i primi 10 studenti.
        'SET.CUBO' => 'CUBESET', //Definisce un insieme di tuple o membri calcolati mediante l'invio di un'espressione di insieme al cubo sul server. In questo modo l'insieme viene creato e restituito a Microsoft Office Excel.
        'CONTA.SET.CUBO' => 'CUBESETCOUNT', //Restituisce il numero di elementi di un insieme.
        'VALORE.CUBO' => 'CUBEVALUE', //Restituisce un valore aggregato da un cubo.
        'DB.MEDIA' => 'DAVERAGE', //Restituisce la media di voci del database selezionate
        'DB.CONTA.NUMERI' => 'DCOUNT', //Conta le celle di un database contenenti numeri
        'DB.CONTA.VALORI' => 'DCOUNTA', //Conta le celle non vuote in un database
        'DB.VALORI' => 'DGET', //Estrae da un database un singolo record che soddisfa i criteri specificati
        'DB.MAX' => 'DMAX', //Restituisce il valore massimo dalle voci selezionate in un database
        'DB.MIN' => 'DMIN', //Restituisce il valore minimo dalle voci di un database selezionate
        'DB.PRODOTTO' => 'DPRODUCT', //Moltiplica i valori in un determinato campo di record che soddisfano i criteri del database
        'DB.DEV.ST' => 'DSTDEV', //Restituisce una stima della deviazione standard sulla base di un campione di voci di un database selezionate
        'DB.DEV.ST.POP' => 'DSTDEVP', //Calcola la deviazione standard sulla base di tutte le voci di un database selezionate
        'DB.SOMMA' => 'DSUM', //Aggiunge i numeri nel campo colonna di record del database che soddisfa determinati criteri
        'DB.VAR' => 'DVAR', //Restituisce una stima della varianza sulla base di un campione da voci di un database selezionate
        'DB.VAR.POP' => 'DVARP', //Calcola la varianza sulla base di tutte le voci di un database selezionate
        'DATA' => 'DATE', //Restituisce il numero seriale di una determinata data
        'DATA.VALORE' => 'DATEVALUE', //Converte una data sotto forma di testo in un numero seriale
        'GIORNO' => 'DAY', //Converte un numero seriale in un giorno del mese
        'GIORNO360' => 'DAYS360', //Calcola il numero di giorni compreso tra due date basandosi su un anno di 360 giorni
        'DATA.MESE' => 'EDATE', //Restituisce il numero seriale della data che rappresenta il numero di mesi prima o dopo la data di inizio
        'FINE.MESE' => 'EOMONTH', //Restituisce il numero seriale dell'ultimo giorno del mese, prima o dopo un determinato numero di mesi
        'ORA' => 'HOUR', //Converte un numero seriale in un'ora
        'MINUTO' => 'MINUTE', //Converte un numero seriale in un minuto
        'MESE' => 'MONTH', //Converte un numero seriale in un mese
        'GIORNI.LAVORATIVI.TOT' => 'NETWORKDAYS', //Restituisce il numero di tutti i giorni lavorativi compresi fra due date
        'ADESSO' => 'NOW', //Restituisce il numero seriale della data e dell'ora corrente
        'SECONDO' => 'SECOND', //Converte un numero seriale in un secondo
        'ORARIO' => 'TIME', //Restituisce il numero seriale di una determinata ora
        'ORARIO.VALORE' => 'TIMEVALUE', //Converte un orario in forma di testo in un numero seriale
        'OGGI' => 'TODAY', //Restituisce il numero seriale relativo alla data odierna
        'GIORNO.SETTIMANA' => 'WEEKDAY', //Converte un numero seriale in un giorno della settimana
        'NUM.SETTIMANA' => 'WEEKNUM', //Converte un numero seriale in un numero che rappresenta la posizione numerica di una settimana nell'anno
        'GIORNO.LAVORATIVO' => 'WORKDAY', //Restituisce il numero della data prima o dopo un determinato numero di giorni lavorativi
        'ANNO' => 'YEAR', //Converte un numero seriale in un anno
        'FRAZIONE.ANNO' => 'YEARFRAC', //Restituisce la frazione dell'anno che rappresenta il numero dei giorni compresi tra una data_ iniziale e una data_finale
        'BESSEL.I' => 'BESSELI', //Restituisce la funzione di Bessel modificata In(x)
        'BESSEL.J' => 'BESSELJ', //Restituisce la funzione di Bessel Jn(x)
        'BESSEL.K' => 'BESSELK', //Restituisce la funzione di Bessel modificata Kn(x)
        'BESSEL.Y' => 'BESSELY', //Restituisce la funzione di Bessel Yn(x)
        'BINARIO.DECIMALE' => 'BIN2DEC', //Converte un numero binario in decimale
        'BINARIO.HEX' => 'BIN2HEX', //Converte un numero binario in esadecimale
        'BINARIO.OCT' => 'BIN2OCT', //Converte un numero binario in ottale
        'COMPLESSO' => 'COMPLEX', //Converte i coefficienti reali e immaginari in numeri complessi
        'CONVERTI' => 'CONVERT', //Converte un numero da un sistema di misura in un altro
        'DECIMALE.BINARIO' => 'DEC2BIN', //Converte un numero decimale in binario
        'DECIMALE.HEX' => 'DEC2HEX', //Converte un numero decimale in esadecimale
        'DECIMALE.OCT' => 'DEC2OCT', //Converte un numero decimale in ottale
        'DELTA' => 'DELTA', //Verifica se due valori sono uguali
        'FUNZ.ERRORE' => 'ERF', //Restituisce la funzione di errore
        'FUNZ.ERRORE.COMP' => 'ERFC', //Restituisce la funzione di errore complementare
        'SOGLIA' => 'GESTEP', //Verifica se un numero è maggiore del valore di soglia
        'HEX.BINARIO' => 'HEX2BIN', //Converte un numero esadecimale in binario
        'HEX.DECIMALE' => 'HEX2DEC', //Converte un numero esadecimale in decimale
        'HEX.OCT' => 'HEX2OCT', //Converte un numero esadecimale in ottale
        'COMP.MODULO' => 'IMABS', //Restituisce il valore assoluto (modulo) di un numero complesso
        'COMP.IMMAGINARIO' => 'IMAGINARY', //Restituisce il coefficiente immaginario di un numero complesso
        'COMP.ARGOMENTO' => 'IMARGUMENT', //Restituisce l'argomento theta, un angolo espresso in radianti
        'COMP.CONIUGATO' => 'IMCONJUGATE', //Restituisce il complesso coniugato del numero complesso
        'COMP.COS' => 'IMCOS', //Restituisce il coseno di un numero complesso
        'COMP.DIV' => 'IMDIV', //Restituisce il quoziente di due numeri complessi
        'COMP.EXP' => 'IMEXP', //Restituisce il valore esponenziale di un numero complesso
        'COMP.LN' => 'IMLN', //Restituisce il logaritmo naturale di un numero complesso
        'COMP.LOG10' => 'IMLOG10', //Restituisce il logaritmo in base 10 di un numero complesso
        'COMP.LOG2' => 'IMLOG2', //Restituisce un logaritmo in base 2 di un numero complesso
        'COMP.POTENZA' => 'IMPOWER', //Restituisce il numero complesso elevato a una potenza intera
        'COMP.PRODOTTO' => 'IMPRODUCT', //Restituisce il prodotto di numeri complessi compresi tra 2 e 29
        'COMP.PARTE.REALE' => 'IMREAL', //Restituisce il coefficiente reale di un numero complesso
        'COMP.SEN' => 'IMSIN', //Restituisce il seno di un numero complesso
        'COMP.RADQ' => 'IMSQRT', //Restituisce la radice quadrata di un numero complesso
        'COMP.DIFF' => 'IMSUB', //Restituisce la differenza fra due numeri complessi
        'COMP.SOMMA' => 'IMSUM', //Restituisce la somma di numeri complessi
        'OCT.BINARIO' => 'OCT2BIN', //Converte un numero ottale in binario
        'OCT.DECIMALE' => 'OCT2DEC', //Converte un numero ottale in decimale
        'OCT.HEX' => 'OCT2HEX', //Converte un numero ottale in esadecimale
        'INT.MATURATO.PER' => 'ACCRINT', //Restituisce l'interesse maturato di un titolo che paga interessi periodici
        'INT.MATURATO.SCAD' => 'ACCRINTM', //Restituisce l'interesse maturato di un titolo che paga interessi alla scadenza
        'AMMORT.DEGR' => 'AMORDEGRC', //Restituisce l'ammortamento per ogni periodo contabile utilizzando un coefficiente di ammortamento
        'AMMORT.PER' => 'AMORLINC', //Restituisce l'ammortamento per ogni periodo contabile
        'GIORNI.CED.INIZ.LIQ' => 'COUPDAYBS', //Restituisce il numero dei giorni che vanno dall'inizio del periodo di durata della cedola alla data di liquidazione
        'GIORNI.CED' => 'COUPDAYS', //Restituisce il numero dei giorni relativi al periodo della cedola che contiene la data di liquidazione
        'GIORNI.CED.NUOVA' => 'COUPDAYSNC', //Restituisce il numero di giorni che vanno dalla data di liquidazione alla data della cedola successiva
        'DATA.CED.SUCC' => 'COUPNCD', //Restituisce un numero che rappresenta la data della cedola successiva alla data di liquidazione
        'NUM.CED' => 'COUPNUM', //Restituisce il numero di cedole pagabili fra la data di liquidazione e la data di scadenza
        'DATA.CED.PREC' => 'COUPPCD', //Restituisce un numero che rappresenta la data della cedola precedente alla data di liquidazione
        'INT.CUMUL' => 'CUMIPMT', //Restituisce l'interesse cumulativo pagato fra due periodi
        'CAP.CUM' => 'CUMPRINC', //Restituisce il capitale cumulativo pagato per estinguere un debito fra due periodi
        'DB' => 'DB', //Restituisce l'ammortamento di un bene per un periodo specificato utilizzando il metodo di ammortamento a quote fisse decrescenti
        'AMMORT' => 'DDB', //Restituisce l'ammortamento di un bene per un periodo specificato utilizzando il metodo di ammortamento a doppie quote decrescenti o altri metodi specificati
        'TASSO.SCONTO' => 'DISC', //Restituisce il tasso di sconto per un titolo
        'VALUTA.DEC' => 'DOLLARDE', //Converte un prezzo valuta, espresso come frazione, in prezzo valuta, espresso come numero decimale
        'VALUTA.FRAZ' => 'DOLLARFR', //Converte un prezzo valuta, espresso come numero decimale, in prezzo valuta, espresso come frazione
        'DURATA' => 'DURATION', //Restituisce la durata annuale di un titolo con i pagamenti di interesse periodico
        'EFFETTIVO' => 'EFFECT', //Restituisce l'effettivo tasso di interesse annuo
        'VAL.FUT' => 'FV', //Restituisce il valore futuro di un investimento
        'VAL.FUT.CAPITALE' => 'FVSCHEDULE', //Restituisce il valore futuro di un capitale iniziale dopo aver applicato una serie di tassi di interesse composti
        'TASSO.INT' => 'INTRATE', //Restituisce il tasso di interesse per un titolo interamente investito
        'INTERESSI' => 'IPMT', //Restituisce il valore degli interessi per un investimento relativo a un periodo specifico
        'TIR.COST' => 'IRR', //Restituisce il tasso di rendimento interno per una serie di flussi di cassa
        'INTERESSE.RATA' => 'ISPMT', //Calcola l'interesse di un investimento pagato durante un periodo specifico
        'DURATA.M' => 'MDURATION', //Restituisce la durata Macauley modificata per un titolo con un valore presunto di € 100
        'TIR.VAR' => 'MIRR', //Restituisce il tasso di rendimento interno in cui i flussi di cassa positivi e negativi sono finanziati a tassi differenti
        'NOMINALE' => 'NOMINAL', //Restituisce il tasso di interesse nominale annuale
        'NUM.RATE' => 'NPER', //Restituisce un numero di periodi relativi a un investimento
        'VAN' => 'NPV', //Restituisce il valore attuale netto di un investimento basato su una serie di flussi di cassa periodici e sul tasso di sconto
        'PREZZO.PRIMO.IRR' => 'ODDFPRICE', //Restituisce il prezzo di un titolo dal valore nominale di € 100 avente il primo periodo di durata irregolare
        'REND.PRIMO.IRR' => 'ODDFYIELD', //Restituisce il rendimento di un titolo avente il primo periodo di durata irregolare
        'PREZZO.ULTIMO.IRR' => 'ODDLPRICE', //Restituisce il prezzo di un titolo dal valore nominale di € 100 avente l'ultimo periodo di durata irregolare
        'REND.ULTIMO.IRR' => 'ODDLYIELD', //Restituisce il rendimento di un titolo avente l'ultimo periodo di durata irregolare
        'RATA' => 'PMT', //Restituisce il pagamento periodico di una rendita annua
        'P.RATA' => 'PPMT', //Restituisce il pagamento sul capitale di un investimento per un dato periodo
        'PREZZO' => 'PRICE', //Restituisce il prezzo di un titolo dal valore nominale di € 100 che paga interessi periodici
        'PREZZO.SCONT' => 'PRICEDISC', //Restituisce il prezzo di un titolo scontato dal valore nominale di € 100
        'PREZZO.SCAD' => 'PRICEMAT', //Restituisce il prezzo di un titolo dal valore nominale di € 100 che paga gli interessi alla scadenza
        'VA' => 'PV', //Restituisce il valore attuale di un investimento
        'TASSO' => 'RATE', //Restituisce il tasso di interesse per un periodo di un'annualità
        'RICEV.SCAD' => 'RECEIVED', //Restituisce l'ammontare ricevuto alla scadenza di un titolo interamente investito
        'AMMORT.COST' => 'SLN', //Restituisce l'ammortamento a quote costanti di un bene per un singolo periodo
        'AMMORT.ANNUO' => 'SYD', //Restituisce l'ammortamento a somma degli anni di un bene per un periodo specificato
        'BOT.EQUIV' => 'TBILLEQ', //Restituisce il rendimento equivalente ad un'obbligazione per un Buono ordinario del Tesoro
        'BOT.PREZZO' => 'TBILLPRICE', //Restituisce il prezzo di un Buono del Tesoro dal valore nominale di € 100
        'BOT.REND' => 'TBILLYIELD', //Restituisce il rendimento di un Buono del Tesoro
        'AMMORT.VAR' => 'VDB', //Restituisce l'ammortamento di un bene per un periodo specificato o parziale utilizzando il metodo a doppie quote proporzionali ai valori residui
        'TIR.X' => 'XIRR', //Restituisce il tasso di rendimento interno di un impiego di flussi di cassa
        'VAN.X' => 'XNPV', //Restituisce il valore attuale netto di un impiego di flussi di cassa non necessariamente periodici
        'REND' => 'YIELD', //Restituisce il rendimento di un titolo che frutta interessi periodici
        'REND.TITOLI.SCONT' => 'YIELDDISC', //Restituisce il rendimento annuale di un titolo scontato, ad esempio un Buono del Tesoro
        'REND.SCAD' => 'YIELDMAT', //Restituisce il rendimento annuo di un titolo che paga interessi alla scadenza
        'CELLA' => 'CELL', //Restituisce le informazioni sulla formattazione, la posizione o i contenuti di una cella
        'ERRORE.TIPO' => 'ERROR.TYPE', //Restituisce un numero che corrisponde a un tipo di errore
        'INFO' => 'INFO', //Restituisce le informazioni sull'ambiente operativo corrente
        'VAL.VUOTO' => 'ISBLANK', //Restituisce VERO se il valore è vuoto
        'VAL.ERR' => 'ISERR', //Restituisce VERO se il valore è un valore di errore qualsiasi tranne #N/D
        'VAL.ERRORE' => 'ISERROR', //Restituisce VERO se il valore è un valore di errore qualsiasi
        'VAL.PARI' => 'ISEVEN', //Restituisce VERO se il numero è pari
        'VAL.LOGICO' => 'ISLOGICAL', //Restituisce VERO se il valore è un valore logico
        'VAL.NON.DISP' => 'ISNA', //Restituisce VERO se il valore è un valore di errore #N/D
        'VAL.NON.TESTO' => 'ISNONTEXT', //Restituisce VERO se il valore non è in formato testo
        'VAL.NUMERO' => 'ISNUMBER', //Restituisce VERO se il valore è un numero
        'VAL.DISPARI' => 'ISODD', //Restituisce VERO se il numero è dispari
        'VAL.RIF' => 'ISREF', //Restituisce VERO se il valore è un riferimento
        'VAL.TESTO' => 'ISTEXT', //Restituisce VERO se il valore è in formato testo
        'NUM' => 'N', //Restituisce un valore convertito in numero
        'NON.DISP' => 'NA', //Restituisce il valore di errore #N/D
        'TIPO' => 'TYPE', //Restituisce un numero che indica il tipo di dati relativi a un valore
        'E' => 'AND', //Restituisce VERO se tutti gli argomenti sono VERO
        'FALSO' => 'FALSE', //Restituisce il valore logico FALSO
        'SE' => 'IF', //Specifica un test logico da eseguire
        'SE.ERRORE' => 'IFERROR', //Restituisce un valore specificato se una formula fornisce un errore come risultato; in caso contrario, restituisce il risultato della formula
        'NON' => 'NOT', //Inverte la logica degli argomenti
        'O' => 'OR', //Restituisce VERO se un argomento qualsiasi è VERO
        'VERO' => 'TRUE', //Restituisce il valore logico VERO
        'INDIRIZZO' => 'ADDRESS', //Restituisce un riferimento come testo in una singola cella di un foglio di lavoro
        'AREE' => 'AREAS', //Restituisce il numero di aree in un riferimento
        'SCEGLI' => 'CHOOSE', //Sceglie un valore da un elenco di valori
        'RIF.COLONNA' => 'COLUMN', //Restituisce il numero di colonna di un riferimento
        'COLONNE' => 'COLUMNS', //Restituisce il numero di colonne in un riferimento
        'CERCA.ORIZZ' => 'HLOOKUP', //Effettua una ricerca nella riga superiore di una matrice e restituisce il valore della cella specificata
        'COLLEG.IPERTESTUALE' => 'HYPERLINK', //Crea un collegamento che apre un documento memorizzato in un server di rete, una rete Intranet o Internet
        'INDICE' => 'INDEX', //Utilizza un indice per scegliere un valore da un riferimento o da una matrice
        'INDIRETTO' => 'INDIRECT', //Restituisce un riferimento specificato da un valore testo
        'CERCA' => 'LOOKUP', //Ricerca i valori in un vettore o in una matrice
        'CONFRONTA' => 'MATCH', //Ricerca i valori in un riferimento o in una matrice
        'SCARTO' => 'OFFSET', //Restituisce uno scarto di riferimento da un riferimento dato
        'RIF.RIGA' => 'ROW', //Restituisce il numero di riga di un riferimento
        'RIGHE' => 'ROWS', //Restituisce il numero delle righe in un riferimento
        'DATITEMPOREALE' => 'RTD', //Recupera dati in tempo reale da un programma che supporta l'automazione COM (automazione: Metodo per utilizzare gli oggetti di un'applicazione da un'altra applicazione o da un altro strumento di sviluppo. Precedentemente nota come automazione OLE, l'automazione è uno standard del settore e una caratteristica del modello COM (Component Object Model).)
        'MATR.TRASPOSTA' => 'TRANSPOSE', //Restituisce la trasposizione di una matrice
        'CERCA.VERT' => 'VLOOKUP', //Effettua una ricerca nella prima colonna di una matrice e si sposta attraverso la riga per restituire il valore di una cella
        'ASS' => 'ABS', //Restituisce il valore assoluto di un numero.
        'ARCCOS' => 'ACOS', //Restituisce l'arcocoseno di un numero
        'ARCCOSH' => 'ACOSH', //Restituisce l'inverso del coseno iperbolico di un numero
        'ARCSEN' => 'ASIN', //Restituisce l'arcoseno di un numero
        'ARCSENH' => 'ASINH', //Restituisce l'inverso del seno iperbolico di un numero
        'ARCTAN' => 'ATAN', //Restituisce l'arcotangente di un numero
        'ARCTAN.2' => 'ATAN2', //Restituisce l'arcotangente delle coordinate x e y specificate
        'ARCTANH' => 'ATANH', //Restituisce l'inverso della tangente iperbolica di un numero
        'ARROTONDA.ECCESSO' => 'CEILING', //Arrotonda un numero per eccesso all'intero più vicino o al multiplo più vicino a peso
        'COMBINAZIONE' => 'COMBIN', //Restituisce il numero di combinazioni possibili per un numero assegnato di elementi
        'COS' => 'COS', //Restituisce il coseno dell'angolo specificato
        'COSH' => 'COSH', //Restituisce il coseno iperbolico di un numero
        'GRADI' => 'DEGREES', //Converte i radianti in gradi
        'PARI' => 'EVEN', //Arrotonda il valore assoluto di un numero per eccesso al più vicino intero pari
        'ESP' => 'EXP', //Restituisce il numero e elevato alla potenza di num
        'FATTORIALE' => 'FACT', //Restituisce il fattoriale di un numero
        'FATT.DOPPIO' => 'FACTDOUBLE', //Restituisce il fattoriale doppio di un numero
        'ARROTONDA.DIFETTO' => 'FLOOR', //Arrotonda un numero per difetto al multiplo più vicino a zero
        'MCD' => 'GCD', //Restituisce il massimo comune divisore
        'INT' => 'INT', //Arrotonda un numero per difetto al numero intero più vicino
        'MCM' => 'LCM', //Restituisce il minimo comune multiplo
        'LN' => 'LN', //Restituisce il logaritmo naturale di un numero
        'LOG' => 'LOG', //Restituisce il logaritmo di un numero in una specificata base
        'LOG10' => 'LOG10', //Restituisce il logaritmo in base 10 di un numero
        'MATR.DETERM' => 'MDETERM', //Restituisce il determinante di una matrice
        'MATR.INVERSA' => 'MINVERSE', //Restituisce l'inverso di una matrice
        'MATR.PRODOTTO' => 'MMULT', //Restituisce il prodotto di due matrici
        'RESTO' => 'MOD', //Restituisce il resto della divisione
        'ARROTONDA.MULTIPLO' => 'MROUND', //Restituisce un numero arrotondato al multiplo desiderato
        'MULTINOMIALE' => 'MULTINOMIAL', //Restituisce il multinomiale di un insieme di numeri
        'DISPARI' => 'ODD', //Arrotonda un numero per eccesso al più vicino intero dispari
        'PI.GRECO' => 'PI', //Restituisce il valore di pi greco
        'POTENZA' => 'POWER', //Restituisce il risultato di un numero elevato a potenza
        'PRODOTTO' => 'PRODUCT', //Moltiplica i suoi argomenti
        'QUOZIENTE' => 'QUOTIENT', //Restituisce la parte intera di una divisione
        'RADIANTI' => 'RADIANS', //Converte i gradi in radianti
        'CASUALE' => 'RAND', //Restituisce un numero casuale compreso tra 0 e 1
        'CASUALE.TRA' => 'RANDBETWEEN', //Restituisce un numero casuale compreso tra i numeri specificati
        'ROMANO' => 'ROMAN', //Restituisce il numero come numero romano sotto forma di testo
        'ARROTONDA' => 'ROUND', //Arrotonda il numero al numero di cifre specificato
        'ARROTONDA.PER.DIF' => 'ROUNDDOWN', //Arrotonda il valore assoluto di un numero per difetto
        'ARROTONDA.PER.ECC' => 'ROUNDUP', //Arrotonda il valore assoluto di un numero per eccesso
        'SOMMA.SERIE' => 'SERIESSUM', //Restituisce la somma di una serie di potenze in base alla formula
        'SEGNO' => 'SIGN', //Restituisce il segno di un numero
        'SEN' => 'SIN', //Restituisce il seno di un dato angolo
        'SENH' => 'SINH', //Restituisce il seno iperbolico di un numero
        'RADQ' => 'SQRT', //Restituisce una radice quadrata
        'RADQ.PI.GRECO' => 'SQRTPI', //Restituisce la radice quadrata di un numero (numero * pi greco)
        'SUBTOTALE' => 'SUBTOTAL', //Restituisce un subtotale in un elenco o in un database
        'SOMMA' => 'SUM', //Somma i suoi argomenti
        'SOMMA.SE' => 'SUMIF', //Somma le celle specificate da un dato criterio
        'SOMMA.PIÙ.SE' => 'SUMIFS', //Somma le celle in un intervallo che soddisfano più criteri
        'MATR.SOMMA.PRODOTTO' => 'SUMPRODUCT', //Restituisce la somma dei prodotti dei componenti corrispondenti della matrice
        'SOMMA.Q' => 'SUMSQ', //Restituisce la somma dei quadrati degli argomenti
        'SOMMA.DIFF.Q' => 'SUMX2MY2', //Restituisce la somma della differenza dei quadrati dei corrispondenti elementi in due matrici
        'SOMMA.SOMMA.Q' => 'SUMX2PY2', //Restituisce la somma della somma dei quadrati dei corrispondenti elementi in due matrici
        'SOMMA.Q.DIFF' => 'SUMXMY2', //Restituisce la somma dei quadrati delle differenze dei corrispondenti elementi in due matrici
        'TAN' => 'TAN', //Restituisce la tangente di un numero
        'TANH' => 'TANH', //Restituisce la tangente iperbolica di un numero
        'TRONCA' => 'TRUNC', //Tronca la parte decimale di un numero
        'MEDIA.DEV' => 'AVEDEV', //Restituisce la media delle deviazioni assolute delle coordinate rispetto alla loro media
        'MEDIA' => 'AVERAGE', //Restituisce la media degli argomenti
        'MEDIA.VALORI' => 'AVERAGEA', //Restituisce la media degli argomenti, inclusi i numeri, il testo e i valori logici
        'MEDIA.SE' => 'AVERAGEIF', //Restituisce la media aritmetica di tutte le celle in un intervallo che soddisfano un determinato criterio
        'MEDIA.PIÙ.SE' => 'AVERAGEIFS', //Restituisce la media aritmetica di tutte le celle che soddisfano più criteri
        'DISTRIB.BETA' => 'BETADIST', //Restituisce la funzione di distribuzione cumulativa beta
        'INV.BETA' => 'BETAINV', //Restituisce l'inverso della funzione di distribuzione cumulativa per una distribuzione beta specificata
        'DISTRIB.BINOM' => 'BINOMDIST', //Restituisce la distribuzione binomiale per il termine individuale
        'DISTRIB.CHI' => 'CHIDIST', //Restituisce la probabilità a una coda per la distribuzione del chi quadrato
        'INV.CHI' => 'CHIINV', //Restituisce l'inverso della probabilità ad una coda per la distribuzione del chi quadrato
        'TEST.CHI' => 'CHITEST', //Restituisce il test per l'indipendenza
        'CONFIDENZA' => 'CONFIDENCE', //Restituisce l'intervallo di confidenza per una popolazione
        'CORRELAZIONE' => 'CORREL', //Restituisce il coefficiente di correlazione tra due insiemi di dati
        'CONTA.NUMERI' => 'COUNT', //Conta la quantità di numeri nell'elenco di argomenti
        'CONTA.VALORI' => 'COUNTA', //Conta il numero di valori nell'elenco di argomenti
        'CONTA.VUOTE' => 'COUNTBLANK', //Conta il numero di celle vuote all'interno di un intervallo
        'CONTA.SE' => 'COUNTIF', //Conta il numero di celle all'interno di un intervallo che soddisfa i criteri specificati
        'CONTA.PIÙ.SE' => 'COUNTIFS', //Conta il numero di celle in un intervallo che soddisfano più criteri.
        'COVARIANZA' => 'COVAR', //Calcola la covarianza, la media dei prodotti delle deviazioni accoppiate
        'CRIT.BINOM' => 'CRITBINOM', //Restituisce il più piccolo valore per il quale la distribuzione cumulativa binomiale risulta maggiore o uguale ad un valore di criterio
        'DEV.Q' => 'DEVSQ', //Restituisce la somma dei quadrati delle deviazioni
        'DISTRIB.EXP' => 'EXPONDIST', //Restituisce la distribuzione esponenziale
        'DISTRIB.F' => 'FDIST', //Restituisce la distribuzione di probabilità F
        'INV.F' => 'FINV', //Restituisce l'inverso della distribuzione della probabilità F
        'FISHER' => 'FISHER', //Restituisce la trasformazione di Fisher
        'INV.FISHER' => 'FISHERINV', //Restituisce l'inverso della trasformazione di Fisher
        'PREVISIONE' => 'FORECAST', //Restituisce i valori lungo una tendenza lineare
        'FREQUENZA' => 'FREQUENCY', //Restituisce la distribuzione di frequenza come matrice verticale
        'TEST.F' => 'FTEST', //Restituisce il risultato di un test F
        'DISTRIB.GAMMA' => 'GAMMADIST', //Restituisce la distribuzione gamma
        'INV.GAMMA' => 'GAMMAINV', //Restituisce l'inverso della distribuzione cumulativa gamma
        'LN.GAMMA' => 'GAMMALN', //Restituisce il logaritmo naturale della funzione gamma, G(x)
        'MEDIA.GEOMETRICA' => 'GEOMEAN', //Restituisce la media geometrica
        'CRESCITA' => 'GROWTH', //Restituisce i valori lungo una linea di tendenza esponenziale
        'MEDIA.ARMONICA' => 'HARMEAN', //Restituisce la media armonica
        'DISTRIB.IPERGEOM' => 'HYPGEOMDIST', //Restituisce la distribuzione ipergeometrica
        'INTERCETTA' => 'INTERCEPT', //Restituisce l'intercetta della retta di regressione lineare
        'CURTOSI' => 'KURT', //Restituisce la curtosi di un insieme di dati
        'GRANDE' => 'LARGE', //Restituisce il k-esimo valore più grande in un insieme di dati
        'REGR.LIN' => 'LINEST', //Restituisce i parametri di una tendenza lineare
        'REGR.LOG' => 'LOGEST', //Restituisce i parametri di una linea di tendenza esponenziale
        'INV.LOGNORM' => 'LOGINV', //Restituisce l'inverso di una distribuzione lognormale
        'DISTRIB.LOGNORM' => 'LOGNORMDIST', //Restituisce la distribuzione lognormale cumulativa
        'MAX' => 'MAX', //Restituisce il valore massimo in un elenco di argomenti
        'MAX.VALORI' => 'MAXA', //Restituisce il valore massimo in un elenco di argomenti, inclusi i numeri, il testo e i valori logici
        'MEDIANA' => 'MEDIAN', //Restituisce la mediana dei numeri specificati
        'MIN' => 'MIN', //Restituisce il valore minimo in un elenco di argomenti
        'MIN.VALORI' => 'MINA', //Restituisce il più piccolo valore in un elenco di argomenti, inclusi i numeri, il testo e i valori logici
        'MODA' => 'MODE', //Restituisce il valore più comune in un insieme di dati
        'DISTRIB.BINOM.NEG' => 'NEGBINOMDIST', //Restituisce la distribuzione binomiale negativa
        'DISTRIB.NORM' => 'NORMDIST', //Restituisce la distribuzione cumulativa normale
        'INV.NORM' => 'NORMINV', //Restituisce l'inverso della distribuzione cumulativa normale standard
        'DISTRIB.NORM.ST' => 'NORMSDIST', //Restituisce la distribuzione cumulativa normale standard
        'INV.NORM.ST' => 'NORMSINV', //Restituisce l'inverso della distribuzione cumulativa normale
        'PEARSON' => 'PEARSON', //Restituisce il coefficiente del momento di correlazione di Pearson
        'PERCENTILE' => 'PERCENTILE', //Restituisce il k-esimo dato percentile di valori in un intervallo
        'PERCENT.RANGO' => 'PERCENTRANK', //Restituisce il rango di un valore in un insieme di dati come percentuale
        'PERMUTAZIONE' => 'PERMUT', //Restituisce il numero delle permutazioni per un determinato numero di oggetti
        'POISSON' => 'POISSON', //Restituisce la distribuzione di Poisson
        'PROBABILITÀ' => 'PROB', //Calcola la probabilità che dei valori in un intervallo siano compresi tra due limiti
        'QUARTILE' => 'QUARTILE', //Restituisce il quartile di un insieme di dati
        'RANGO' => 'RANK', //Restituisce il rango di un numero in un elenco di numeri
        'RQ' => 'RSQ', //Restituisce la radice quadrata del coefficiente di momento di correlazione di Pearson
        'ASIMMETRIA' => 'SKEW', //Restituisce il grado di asimmetria di una distribuzione
        'PENDENZA' => 'SLOPE', //Restituisce la pendenza di una retta di regressione lineare
        'PICCOLO' => 'SMALL', //Restituisce il k-esimo valore più piccolo in un insieme di dati
        'NORMALIZZA' => 'STANDARDIZE', //Restituisce un valore normalizzato
        'DEV.ST' => 'STDEV', //Restituisce una stima della deviazione standard sulla base di un campione
        'DEV.ST.VALORI' => 'STDEVA', //Restituisce una stima della deviazione standard sulla base di un campione, inclusi i numeri, il testo e i valori logici
        'DEV.ST.POP' => 'STDEVP', //Calcola la deviazione standard sulla base di un'intera popolazione
        'DEV.ST.POP.VALORI' => 'STDEVPA', //Calcola la deviazione standard sulla base sull'intera popolazione, inclusi i numeri, il testo e i valori logici
        'ERR.STD.YX' => 'STEYX', //Restituisce l'errore standard del valore previsto per y per ogni valore x nella regressione
        'DISTRIB.T' => 'TDIST', //Restituisce la distribuzione t di Student
        'INV.T' => 'TINV', //Restituisce l'inversa della distribuzione t di Student
        'TENDENZA' => 'TREND', //Restituisce i valori lungo una linea di tendenza lineare
        'MEDIA.TRONCATA' => 'TRIMMEAN', //Restituisce la media della parte interna di un insieme di dati
        'TEST.T' => 'TTEST', //Restituisce la probabilità associata ad un test t di Student
        'VAR' => 'VAR', //Stima la varianza sulla base di un campione
        'VAR.VALORI' => 'VARA', //Stima la varianza sulla base di un campione, inclusi i numeri, il testo e i valori logici
        'VAR.POP' => 'VARP', //Calcola la varianza sulla base dell'intera popolazione
        'VAR.POP.VALORI' => 'VARPA', //Calcola la deviazione standard sulla base sull'intera popolazione, inclusi i numeri, il testo e i valori logici
        'WEIBULL' => 'WEIBULL', //Restituisce la distribuzione di Weibull
        'TEST.Z' => 'ZTEST', //Restituisce il valore di probabilità a una coda per un test z
        'ASC' => 'ASC', //Modifica le lettere inglesi o il katakana a doppio byte all'interno di una stringa di caratteri in caratteri a singolo byte
        'BAHTTESTO' => 'BAHTTEXT', //Converte un numero in testo, utilizzando il formato valuta ß (baht)
        'CODICE.CARATT' => 'CHAR', //Restituisce il carattere specificato dal numero di codice
        'LIBERA' => 'CLEAN', //Elimina dal testo tutti i caratteri che non è possibile stampare
        'CODICE' => 'CODE', //Restituisce il codice numerico del primo carattere di una stringa di testo
        'CONCATENA' => 'CONCATENATE', //Unisce diversi elementi di testo in un unico elemento di testo
        'VALUTA' => 'DOLLAR', //Converte un numero in testo, utilizzando il formato valuta € (euro)
        'IDENTICO' => 'EXACT', //Verifica se due valori di testo sono uguali
        'TROVA' => 'FIND', //Rileva un valore di testo all'interno di un altro (distinzione tra maiuscole e minuscole)
        'TROVA.B' => 'FINDB', //Rileva un valore di testo all'interno di un altro (distinzione tra maiuscole e minuscole)
        'FISSO' => 'FIXED', //Formatta un numero come testo con un numero fisso di decimali
        'ORDINAMENTO.JIS' => 'JIS', //Modifica le lettere inglesi o i caratteri katakana a byte singolo all'interno di una stringa di caratteri in caratteri a byte doppio.
        'SINISTRA' => 'LEFT', //Restituisce il carattere più a sinistra di un valore di testo
        'SINISTRA.B' => 'LEFTB', //Restituisce il carattere più a sinistra di un valore di testo
        'LUNGHEZZA' => 'LEN', //Restituisce il numero di caratteri di una stringa di testo
        'LUNB' => 'LENB', //Restituisce il numero di caratteri di una stringa di testo
        'MINUSC' => 'LOWER', //Converte il testo in lettere minuscole
        'MEDIA' => 'MID', //Restituisce un numero specifico di caratteri di una stringa di testo a partire dalla posizione specificata
        'MEDIA.B' => 'MIDB', //Restituisce un numero specifico di caratteri di una stringa di testo a partire dalla posizione specificata
        'FURIGANA' => 'PHONETIC', //Estrae i caratteri fonetici (furigana) da una stringa di testo.
        'MAIUSC.INIZ' => 'PROPER', //Converte in maiuscolo la prima lettera di ogni parola di un valore di testo
        'RIMPIAZZA' => 'REPLACE', //Sostituisce i caratteri all'interno di un testo
        'SOSTITUISCI.B' => 'REPLACEB', //Sostituisce i caratteri all'interno di un testo
        'RIPETI' => 'REPT', //Ripete un testo per un dato numero di volte
        'DESTRA' => 'RIGHT', //Restituisce il carattere più a destra di un valore di testo
        'DESTRA.B' => 'RIGHTB', //Restituisce il carattere più a destra di un valore di testo
        'RICERCA' => 'SEARCH', //Rileva un valore di testo all'interno di un altro (non è sensibile alle maiuscole e minuscole)
        'CERCA.B' => 'SEARCHB', //Rileva un valore di testo all'interno di un altro (non è sensibile alle maiuscole e minuscole)
        'SOSTITUISCI' => 'SUBSTITUTE', //Sostituisce il nuovo testo al testo contenuto in una stringa
        'T' => 'T', //Converte gli argomenti in testo
        'TESTO' => 'TEXT', //Formatta un numero e lo converte in testo
        'ANNULLA.SPAZI' => 'TRIM', //Elimina gli spazi dal testo
        'MAIUSC' => 'UPPER', //Converte il testo in lettere maiuscole
        'VALORE' => 'VALUE', //Converte un argomento di testo in numero
    ],
];
//EOF
