<?php
// pt_PT

return [
    'language' => 'Portuguese',
    'formats' => [
        'date' => 'DD/MM/YYYY',
        'time' => 'HH:MM:SS',
        'datetime' => 'DD/MM/YYYY HH:MM:SS',
        'money' => '#,##0.00 [$€];[RED]-#,##0.00 [$€]',
    ],
    'functions' => [
        'OBTERDADOSDIN' => 'GETPIVOTDATA', //Devolve dados armazenados num relatório de Tabela Dinâmica
        'MEMBROKPICUBO' => 'CUBEKPIMEMBER', //Devolve o nome, propriedade e medição de um KPI (key performance indicator) e apresenta o nome e a propriedade na célula. Um KPI é uma medida quantificável, como, por exemplo, o lucro mensal bruto ou a rotatividade trimestral de pessoal, utilizada para monitorizar o desempenho de uma organização.
        'MEMBROCUBO' => 'CUBEMEMBER', //Devolve um membro ou cadeia de identificação numa hierarquia de cubo. Utilizada para validar a existência do membro ou cadeia de identificação no cubo.
        'PROPRIEDADEMEMBROCUBO' => 'CUBEMEMBERPROPERTY', //Devolve o valor de uma propriedade de membro no cubo. Utilizada para validar a existência de um nome de membro no cubo e para devolver a propriedade especificada para esse membro.
        'MEMBROCLASSIFICADOCUBO' => 'CUBERANKEDMEMBER', //Devolve o enésimo ou a classificação mais alta num conjunto. Utilizada para devolver um ou mais elementos num conjunto, tal como o melhor vendedor ou os 10 melhores alunos.
        'CONJUNTOCUBO' => 'CUBESET', //Define um conjunto calculado de membros ou cadeias de identificação enviando uma expressão de conjunto para o cubo no servidor, que cria o conjunto e, em seguida, devolve o conjunto ao Microsoft Office Excel.
        'CONTARCONJUNTOCUBO' => 'CUBESETCOUNT', //Devolve o número de itens num conjunto.
        'VALORCUBO' => 'CUBEVALUE', //Devolve um valor agregado do cubo.
        'BDMÉDIA' => 'DAVERAGE', //Devolve a média das entradas da base de dados seleccionadas
        'BDCONTAR' => 'DCOUNT', //Conta as células que contêm números numa base de dados
        'BDCONTAR.VAL' => 'DCOUNTA', //Conta as células que não estejam em branco numa base de dados
        'BDOBTER' => 'DGET', //Extrai de uma base de dados um único registo que corresponde aos critérios especificados
        'BDMÁX' => 'DMAX', //Devolve o valor máximo das entradas da base de dados seleccionadas
        'BDMÍN' => 'DMIN', //Devolve o valor mínimo das entradas da base de dados seleccionadas
        'BDMULTIPL' => 'DPRODUCT', //Multiplica os valores de um determinado campo de registos que correspondem aos critérios numa base de dados
        'BDDESVPAD' => 'DSTDEV', //Calcula o desvio-padrão com base numa amostra de entradas da base de dados seleccionadas
        'BDDESVPADP' => 'DSTDEVP', //Calcula o desvio-padrão com base na população total das entradas da base de dados seleccionadas
        'BDSOMA' => 'DSUM', //Adiciona os números na coluna de campo dos registos de base de dados que correspondem aos critérios
        'BDVAR' => 'DVAR', //Calcula a variância com base numa amostra das entradas de base de dados seleccionadas
        'BDVARP' => 'DVARP', //Calcula a variância com base na população total das entradas de base de dados seleccionadas
        'DATA' => 'DATE', //Devolve o número de série de uma determinada data
        'DATA.VALOR' => 'DATEVALUE', //Converte uma data em forma de texto num número de série
        'DIA' => 'DAY', //Converte um número de série num dia do mês
        'DIAS360' => 'DAYS360', //Calcula o número de dias entre duas datas com base num ano com 360 dias
        'DATAM' => 'EDATE', //Devolve um número de série de data que corresponde ao número de meses indicado antes ou depois da data de início
        'FIMMÊS' => 'EOMONTH', //Devolve o número de série do último dia do mês antes ou depois de um número de meses especificado
        'HORA' => 'HOUR', //Converte um número de série numa hora
        'MINUTO' => 'MINUTE', //Converte um número de série num minuto
        'MÊS' => 'MONTH', //Converte um número de série num mês
        'DIATRABALHOTOTAL' => 'NETWORKDAYS', //Devolve o número total de dias úteis entre duas datas
        'AGORA' => 'NOW', //Devolve o número de série da data e hora actuais
        'SEGUNDO' => 'SECOND', //Converte um número de série num segundo
        'TEMPO' => 'TIME', //Devolve o número de série de um determinado tempo
        'VALOR.TEMPO' => 'TIMEVALUE', //Converte um tempo em forma de texto num número de série
        'HOJE' => 'TODAY', //Devolve o número de série da data actual
        'DIA.SEMANA' => 'WEEKDAY', //Converte um número de série num dia da semana
        'NÚMSEMANA' => 'WEEKNUM', //Converte um número de série num número que representa o número da semana num determinado ano
        'DIA.TRABALHO' => 'WORKDAY', //Devolve o número de série da data antes ou depois de um número de dias úteis especificado
        'ANO' => 'YEAR', //Converte um número de série num ano
        'FRACÇÃOANO' => 'YEARFRAC', //Devolve a fracção de ano que representa o número de dias inteiros entre a data_de_início e a data_de_fim
        'BESSELI' => 'BESSELI', //Devolve a função de Bessel modificada In(x)
        'BESSELJ' => 'BESSELJ', //Devolve a função de Bessel Jn(x)
        'BESSELK' => 'BESSELK', //Devolve a função de Bessel modificada Kn(x)
        'BESSELY' => 'BESSELY', //Devolve a função de Bessel Yn(x)
        'BINADEC' => 'BIN2DEC', //Converte um número binário em decimal
        'BINAHEX' => 'BIN2HEX', //Converte um número binário em hexadecimal
        'BINAOCT' => 'BIN2OCT', //Converte um número binário em octal
        'COMPLEXO' => 'COMPLEX', //Converte coeficientes reais e imaginários num número complexo
        'CONVERTER' => 'CONVERT', //Converte um número de um sistema de medida noutro
        'DECABIN' => 'DEC2BIN', //Converte um número decimal em binário
        'DECAHEX' => 'DEC2HEX', //Converte um número decimal em hexadecimal
        'DECAOCT' => 'DEC2OCT', //Converte um número decimal em octal
        'DELTA' => 'DELTA', //Testa se dois valores são iguais
        'FUNCERRO' => 'ERF', //Devolve a função de erro
        'FUNCERROCOMPL' => 'ERFC', //Devolve a função de erro complementar
        'DEGRAU' => 'GESTEP', //Testa se um número é maior do que um valor limite
        'HEXABIN' => 'HEX2BIN', //Converte um número hexadecimal em binário
        'HEXADEC' => 'HEX2DEC', //Converte um número hexadecimal em decimal
        'HEXAOCT' => 'HEX2OCT', //Converte um número hexadecimal em octal
        'IMABS' => 'IMABS', //Devolve o valor absoluto (módulo) de um número complexo
        'IMAGINÁRIO' => 'IMAGINARY', //Devolve o coeficiente imaginário de um número complexo
        'IMARG' => 'IMARGUMENT', //Devolve o argumento Teta, um ângulo expresso em radianos
        'IMCONJ' => 'IMCONJUGATE', //Devolve o conjugado complexo de um número complexo
        'IMCOS' => 'IMCOS', //Devolve o co-seno de um número complexo
        'IMDIV' => 'IMDIV', //Devolve o quociente de dois números complexos
        'IMEXP' => 'IMEXP', //Devolve o exponencial de um número complexo
        'IMLN' => 'IMLN', //Devolve o logaritmo natural de um número complexo
        'IMLOG10' => 'IMLOG10', //Devolve o logaritmo de base 10 de um número complexo
        'IMLOG2' => 'IMLOG2', //Devolve o logaritmo de base 2 de um número complexo
        'IMPOT' => 'IMPOWER', //Devolve um número complexo elevado a uma potência inteira
        'IMPROD' => 'IMPRODUCT', //Devolve o produto de números complexos
        'IMREAL' => 'IMREAL', //Devolve o coeficiente real de um número complexo
        'IMSENO' => 'IMSIN', //Devolve o seno de um número complexo
        'IMRAIZ' => 'IMSQRT', //Devolve a raiz quadrada de um número complexo
        'IMSUBTR' => 'IMSUB', //Devolve a diferença entre dois números complexos
        'IMSOMA' => 'IMSUM', //Devolve a soma de números complexos
        'OCTABIN' => 'OCT2BIN', //Converte um número octal em binário
        'OCTADEC' => 'OCT2DEC', //Converte um número octal em decimal
        'OCTAHEX' => 'OCT2HEX', //Converte um número octal em hexadecimal
        'JUROSACUM' => 'ACCRINT', //Devolve os juros acumulados de um título que paga juros periódicos
        'JUROSACUMV' => 'ACCRINTM', //Devolve os juros acumulados de um título que paga juros no vencimento
        'AMORDEGRC' => 'AMORDEGRC', //Devolve a depreciação correspondente a cada período contabilístico utilizando um coeficiente de depreciação
        'AMORLINC' => 'AMORLINC', //Devolve a depreciação correspondente a cada período contabilístico
        'CUPDIASINLIQ' => 'COUPDAYBS', //Devolve o número de dias entre o início do período do cupão e a data de regularização
        'CUPDIAS' => 'COUPDAYS', //Devolve o número de dias no período do cupão que contém a data de regularização
        'CUPDIASPRÓX' => 'COUPDAYSNC', //Devolve o número de dias entre a data de regularização e a data do cupão seguinte
        'CUPDATAPRÓX' => 'COUPNCD', //Devolve a data do cupão seguinte após a data de regularização
        'CUPNÚM' => 'COUPNUM', //Devolve o número de cupões a serem pagos entre a data de regularização e a data de vencimento
        'CUPDATAANT' => 'COUPPCD', //Devolve a data do cupão anterior antes da data de regularização
        'PGTOJURACUM' => 'CUMIPMT', //Devolve os juros cumulativos pagos entre dois períodos
        'PGTOCAPACUM' => 'CUMPRINC', //Devolve o capital cumulativo pago a título de empréstimo entre dois períodos
        'BD' => 'DB', //Devolve a depreciação de um activo relativo a um período especificado utilizando o método das quotas degressivas fixas
        'BDD' => 'DDB', //Devolve a depreciação de um activo relativo a um período especificado utilizando o método das quotas degressivas duplas ou qualquer outro método especificado
        'DESC' => 'DISC', //Devolve a taxa de desconto de um título
        'MOEDADEC' => 'DOLLARDE', //Converte um preço em unidade monetária, expresso como uma fracção, num preço em unidade monetária, expresso como um número decimal
        'MOEDAFRA' => 'DOLLARFR', //Converte um preço em unidade monetária, expresso como um número decimal, num preço em unidade monetária, expresso como uma fracção
        'DURAÇÃO' => 'DURATION', //Devolve a duração anual de um título com pagamentos de juros periódicos
        'EFECTIVA' => 'EFFECT', //Devolve a taxa de juros anual efectiva
        'VF' => 'FV', //Devolve o valor futuro de um investimento
        'VFPLANO' => 'FVSCHEDULE', //Devolve o valor futuro de um capital inicial após a aplicação de uma série de taxas de juro compostas
        'TAXAJUROS' => 'INTRATE', //Devolve a taxa de juros de um título investido na totalidade
        'IPGTO' => 'IPMT', //Devolve o pagamento dos juros de um investimento durante um determinado período
        'TIR' => 'IRR', //Devolve a taxa de rentabilidade interna para uma série de fluxos monetários
        'É.PGTO' => 'ISPMT', //Calcula os juros pagos durante um período específico de um investimento
        'MDURAÇÃO' => 'MDURATION', //Devolve a duração modificada de Macauley de um título com um valor de paridade equivalente a € 100
        'MTIR' => 'MIRR', //Devolve a taxa interna de rentabilidade em que os fluxos monetários positivos e negativos são financiados com taxas diferentes
        'NOMINAL' => 'NOMINAL', //Devolve a taxa de juros nominal anual
        'NPER' => 'NPER', //Devolve o número de períodos de um investimento
        'VAL' => 'NPV', //Devolve o valor actual líquido de um investimento com base numa série de fluxos monetários periódicos e numa taxa de desconto
        'PREÇOPRIMINC' => 'ODDFPRICE', //Devolve o preço por € 100 do valor nominal de um título com um período inicial incompleto
        'LUCROPRIMINC' => 'ODDFYIELD', //Devolve o lucro de um título com um período inicial incompleto
        'PREÇOÚLTINC' => 'ODDLPRICE', //Devolve o preço por € 100 do valor nominal de um título com um período final incompleto
        'LUCROÚLTINC' => 'ODDLYIELD', //Devolve o lucro de um título com um período final incompleto
        'PGTO' => 'PMT', //Devolve o pagamento periódico de uma anuidade
        'PPGTO' => 'PPMT', //Devolve o pagamento sobre o capital de um investimento num determinado período
        'PREÇO' => 'PRICE', //Devolve o preço por € 100 do valor nominal de um título que paga juros periódicos
        'PREÇODESC' => 'PRICEDISC', //Devolve o preço por € 100 do valor nominal de um título descontado
        'PREÇOVENC' => 'PRICEMAT', //Devolve o preço por € 100 do valor nominal de um título que paga juros no vencimento
        'VA' => 'PV', //Devolve o valor actual de um investimento
        'TAXA' => 'RATE', //Devolve a taxa de juros por período de uma anuidade
        'RECEBER' => 'RECEIVED', //Devolve o montante recebido no vencimento de um título investido na totalidade
        'AMORT' => 'SLN', //Devolve uma depreciação linear de um activo durante um período
        'AMORTD' => 'SYD', //Devolve a depreciação por algarismos da soma dos anos de um activo durante um período especificado
        'OTN' => 'TBILLEQ', //Devolve o lucro de um título equivalente a uma Obrigação do Tesouro
        'OTNVALOR' => 'TBILLPRICE', //Devolve o preço por € 100 de valor nominal de uma Obrigação do Tesouro
        'OTNLUCRO' => 'TBILLYIELD', //Devolve o lucro de uma Obrigação do Tesouro
        'BDV' => 'VDB', //Devolve a depreciação de um activo relativo a um período específico ou parcial utilizando um método de quotas degressivas
        'XTIR' => 'XIRR', //Devolve a taxa interna de rentabilidade de um plano de fluxos monetários que não seja necessariamente periódica
        'XVAL' => 'XNPV', //Devolve o valor actual líquido de um plano de fluxos monetários que não seja necessariamente periódico
        'LUCRO' => 'YIELD', //Devolve o lucro de um título que paga juros periódicos
        'LUCRODESC' => 'YIELDDISC', //Devolve o lucro anual de um título emitido abaixo do valor nominal, por exemplo, uma Obrigação do Tesouro
        'LUCROVENC' => 'YIELDMAT', //Devolve o lucro anual de um título que paga juros na data de vencimento
        'CÉL' => 'CELL', //Devolve informações sobre a formatação, localização ou conteúdo de uma célula
        'TIPO.ERRO' => 'ERROR.TYPE', //Devolve um número correspondente a um tipo de erro
        'INFORMAÇÃO' => 'INFO', //Devolve informações sobre o ambiente de funcionamento actual
        'É.CÉL.VAZIA' => 'ISBLANK', //Devolve VERDADEIRO se o valor estiver em branco
        'É.ERROS' => 'ISERR', //Devolve VERDADEIRO se o valor for um valor de erro diferente de #N/D
        'É.ERRO' => 'ISERROR', //Devolve VERDADEIRO se o valor for um valor de erro
        'ÉPAR' => 'ISEVEN', //Devolve VERDADEIRO se o número for par
        'É.LÓGICO' => 'ISLOGICAL', //Devolve VERDADEIRO se o valor for lógico
        'É.NÃO.DISP' => 'ISNA', //Devolve VERDADEIRO se o valor for o valor de erro #N/D
        'É.NÃO.TEXTO' => 'ISNONTEXT', //Devolve VERDADEIRO se o valor não for texto
        'É.NÚM' => 'ISNUMBER', //Devolve VERDADEIRO se o valor for um número
        'ÉÍMPAR' => 'ISODD', //Devolve VERDADEIRO se o número for ímpar
        'É.REF' => 'ISREF', //Devolve VERDADEIRO se o valor for uma referência
        'É.TEXTO' => 'ISTEXT', //Devolve VERDADEIRO se o valor for texto
        'N' => 'N', //Devolve um valor convertido num número
        'NÃO.DISP' => 'NA', //Devolve o valor de erro #N/D
        'TIPO' => 'TYPE', //Devolve um número que indica o tipo de dados de um valor
        'E' => 'AND', //Devolve VERDADEIRO se todos os respectivos argumentos corresponderem a VERDADEIRO
        'FALSO' => 'FALSE', //Devolve o valor lógico FALSO
        'SE' => 'IF', //Especifica um teste lógico a ser executado
        'SE.ERRO' => 'IFERROR', //Devolve um valor definido pelo utilizador se ocorrer um erro na fórmula, e devolve o resultado da fórmula se não ocorrer nenhum erro
        'NÃO' => 'NOT', //Inverte a lógica do respectivo argumento
        'OU' => 'OR', //Devolve VERDADEIRO se qualquer argumento for VERDADEIRO
        'VERDADEIRO' => 'TRUE', //Devolve o valor lógico VERDADEIRO
        'ENDEREÇO' => 'ADDRESS', //Devolve uma referência a uma única célula numa folha de cálculo como texto
        'ÁREAS' => 'AREAS', //Devolve o número de áreas numa referência
        'SELECCIONAR' => 'CHOOSE', //Selecciona um valor a partir de uma lista de valores
        'COL' => 'COLUMN', //Devolve o número da coluna de uma referência
        'COLS' => 'COLUMNS', //Devolve o número de colunas numa referência
        'PROCH' => 'HLOOKUP', //Procura na linha superior de uma matriz e devolve o valor da célula indicada
        'HIPERLIGAÇÃO' => 'HYPERLINK', //Cria um atalho ou hiperligação que abre um documento armazenado num servidor de rede, numa intranet ou na Internet
        'ÍNDICE' => 'INDEX', //Utiliza um índice para escolher um valor de uma referência ou de uma matriz
        'INDIRECTO' => 'INDIRECT', //Devolve uma referência indicada por um valor de texto
        'PROC' => 'LOOKUP', //Procura valores num vector ou numa matriz
        'CORRESP' => 'MATCH', //Procura valores numa referência ou numa matriz
        'DESLOCAMENTO' => 'OFFSET', //Devolve o deslocamento de referência de uma determinada referência
        'LIN' => 'ROW', //Devolve o número da linha de uma referência
        'LINS' => 'ROWS', //Devolve o número de linhas numa referência
        'RTD' => 'RTD', //Obtém dados em tempo real a partir de um programa que suporte automatização COM (automatização: modo de trabalhar com objectos de uma aplicação a partir de outra aplicação ou ferramenta de desenvolvimento. Anteriormente conhecida como automatização OLE, a automatização é uma norma da indústria de software e uma funcionalidade COM (Component Object Model).)
        'TRANSPOR' => 'TRANSPOSE', //Devolve a transposição de uma matriz
        'PROCV' => 'VLOOKUP', //Procura na primeira coluna de uma matriz e percorre a linha para devolver o valor de uma célula
        'ABS' => 'ABS', //Devolve o valor absoluto de um número
        'ACOS' => 'ACOS', //Devolve o arco de co-seno de um número
        'ACOSH' => 'ACOSH', //Devolve o co-seno hiperbólico inverso de um número
        'ASEN' => 'ASIN', //Devolve o arco de seno de um número
        'ASENH' => 'ASINH', //Devolve o seno hiperbólico inverso de um número
        'ATAN' => 'ATAN', //Devolve o arco de tangente de um número
        'ATAN2' => 'ATAN2', //Devolve o arco de tangente das coordenadas x e y
        'ATANH' => 'ATANH', //Devolve a tangente hiperbólica inversa de um número
        'ARRED.EXCESSO' => 'CEILING', //Arredonda um número para o número inteiro mais próximo ou para o múltiplo de significância mais próximo
        'COMBIN' => 'COMBIN', //Devolve o número de combinações de um determinado número de objectos
        'COS' => 'COS', //Devolve o co-seno de um número
        'COSH' => 'COSH', //Devolve o co-seno hiperbólico de um número
        'GRAUS' => 'DEGREES', //Converte radianos em graus
        'PAR' => 'EVEN', //Arredonda um número por excesso para o número inteiro mais próximo
        'EXP' => 'EXP', //Devolve e elevado à potência de um determinado número
        'FACTORIAL' => 'FACT', //Devolve o factorial de um número
        'FACTDUPLO' => 'FACTDOUBLE', //Devolve o factorial duplo de um número
        'ARRED.DEFEITO' => 'FLOOR', //Arredonda um número por defeito até zero
        'MDC' => 'GCD', //Devolve o maior divisor comum
        'INT' => 'INT', //Arredonda um número por defeito para o número inteiro mais próximo
        'MMC' => 'LCM', //Devolve o mínimo múltiplo comum
        'LN' => 'LN', //Devolve o logaritmo natural de um número
        'LOG' => 'LOG', //Devolve o logaritmo de um número com uma base especificada
        'LOG10' => 'LOG10', //Devolve o logaritmo de base 10 de um número
        'MATRIZ.DETERM' => 'MDETERM', //Devolve o determinante matricial de uma matriz
        'MATRIZ.INVERSA' => 'MINVERSE', //Devolve o inverso matricial de uma matriz
        'MATRIZ.MULT' => 'MMULT', //Devolve o produto matricial de duas matrizes
        'RESTO' => 'MOD', //Devolve o resto da divisão
        'MARRED' => 'MROUND', //Devolve um número arredondado para o múltiplo pretendido
        'POLINOMIAL' => 'MULTINOMIAL', //Devolve o polinomial de um conjunto de números
        'ÍMPAR' => 'ODD', //Arredonda por excesso um número para o número inteiro ímpar mais próximo
        'PI' => 'PI', //Devolve o valor de pi
        'POTÊNCIA' => 'POWER', //Devolve o resultado de um número elevado a uma potência
        'PRODUTO' => 'PRODUCT', //Multiplica os respectivos argumentos
        'QUOCIENTE' => 'QUOTIENT', //Devolve a parte inteira de uma divisão
        'RADIANOS' => 'RADIANS', //Converte graus em radianos
        'ALEATÓRIO' => 'RAND', //Devolve um número aleatório entre 0 e 1
        'ALEATÓRIOENTRE' => 'RANDBETWEEN', //Devolve um número aleatório entre os números especificados
        'ROMANO' => 'ROMAN', //Converte um número árabe em romano, como texto
        'ARRED' => 'ROUND', //Arredonda um número para um número de dígitos especificado
        'ARRED.PARA.BAIXO' => 'ROUNDDOWN', //Arredonda um número por defeito até zero
        'ARRED.PARA.CIMA' => 'ROUNDUP', //Arredonda um número por excesso, afastando-o de zero
        'SOMASÉRIE' => 'SERIESSUM', //Devolve a soma de uma série de potências baseada na fórmula
        'SINAL' => 'SIGN', //Devolve o sinal de um número
        'SEN' => 'SIN', //Devolve o seno de um determinado ângulo
        'SENH' => 'SINH', //Devolve o seno hiperbólico de um número
        'RAIZQ' => 'SQRT', //Devolve uma raiz quadrada positiva
        'RAIZPI' => 'SQRTPI', //Devolve a raiz quadrada de (núm * pi)
        'SUBTOTAL' => 'SUBTOTAL', //Devolve um subtotal numa lista ou base de dados
        'SOMA' => 'SUM', //Adiciona os respectivos argumentos
        'SOMA.SE' => 'SUMIF', //Adiciona as células especificadas por um determinado critério
        'SOMA.SE.S' => 'SUMIFS', //Adiciona as células num intervalo que cumpre vários critérios
        'SOMARPRODUTO' => 'SUMPRODUCT', //Devolve a soma dos produtos de componentes de matrizes correspondentes
        'SOMARQUAD' => 'SUMSQ', //Devolve a soma dos quadrados dos argumentos
        'SOMAX2DY2' => 'SUMX2MY2', //Devolve a soma da diferença dos quadrados dos valores correspondentes em duas matrizes
        'SOMAX2SY2' => 'SUMX2PY2', //Devolve a soma da soma dos quadrados dos valores correspondentes em duas matrizes
        'SOMAXMY2' => 'SUMXMY2', //Devolve a soma dos quadrados da diferença dos valores correspondentes em duas matrizes
        'TAN' => 'TAN', //Devolve a tangente de um número
        'TANH' => 'TANH', //Devolve a tangente hiperbólica de um número
        'TRUNCAR' => 'TRUNC', //Trunca um número para um número inteiro
        'DESV.MÉDIO' => 'AVEDEV', //Devolve a média aritmética dos desvios absolutos à média dos pontos de dados
        'MÉDIA' => 'AVERAGE', //Devolve a média dos respectivos argumentos
        'MÉDIAA' => 'AVERAGEA', //Devolve uma média dos respectivos argumentos, incluindo números, texto e valores lógicos
        'MÉDIA.SE' => 'AVERAGEIF', //Devolve a média aritmética de todas as células num intervalo que cumprem determinado critério
        'MÉDIA.SE.S' => 'AVERAGEIFS', //Devolve a média aritmética de todas as células que cumprem múltiplos critérios
        'DISTBETA' => 'BETADIST', //Devolve a função de distribuição cumulativa beta
        'BETA.ACUM.INV' => 'BETAINV', //Devolve o inverso da função de distribuição cumulativa relativamente a uma distribuição beta específica
        'DISTRBINOM' => 'BINOMDIST', //Devolve a probabilidade de distribuição binomial de termo individual
        'DIST.CHI' => 'CHIDIST', //Devolve a probabilidade unicaudal da distribuição qui-quadrada
        'INV.CHI' => 'CHIINV', //Devolve o inverso da probabilidade unicaudal da distribuição qui-quadrada
        'TESTE.CHI' => 'CHITEST', //Devolve o teste para independência
        'INT.CONFIANÇA' => 'CONFIDENCE', //Devolve o intervalo de confiança correspondente a uma média de população
        'CORREL' => 'CORREL', //Devolve o coeficiente de correlação entre dois conjuntos de dados
        'CONTAR' => 'COUNT', //Conta os números que existem na lista de argumentos
        'CONTAR.VAL' => 'COUNTA', //Conta os valores que existem na lista de argumentos
        'CONTAR.VAZIO' => 'COUNTBLANK', //Conta o número de células em branco num intervalo
        'CONTAR.SE' => 'COUNTIF', //Calcula o número de células num intervalo que corresponde aos critérios determinados
        'CONTAR.SE.S' => 'COUNTIFS', //Conta o número de células num intervalo que cumprem múltiplos critérios
        'COVAR' => 'COVAR', //Devolve a covariância, que é a média dos produtos de desvios de pares
        'CRIT.BINOM' => 'CRITBINOM', //Devolve o menor valor em que a distribuição binomial cumulativa é inferior ou igual a um valor de critério
        'DESVQ' => 'DEVSQ', //Devolve a soma dos quadrados dos desvios
        'DISTEXPON' => 'EXPONDIST', //Devolve a distribuição exponencial
        'DISTF' => 'FDIST', //Devolve a distribuição da probabilidade F
        'INVF' => 'FINV', //Devolve o inverso da distribuição da probabilidade F
        'FISHER' => 'FISHER', //Devolve a transformação Fisher
        'FISHERINV' => 'FISHERINV', //Devolve o inverso da transformação Fisher
        'PREVISÃO' => 'FORECAST', //Devolve um valor ao longo de uma tendência linear
        'FREQUÊNCIA' => 'FREQUENCY', //Devolve uma distribuição de frequência como uma matriz vertical
        'TESTEF' => 'FTEST', //Devolve o resultado de um teste F
        'DISTGAMA' => 'GAMMADIST', //Devolve a distribuição gama
        'INVGAMA' => 'GAMMAINV', //Devolve o inverso da distribuição gama cumulativa
        'LNGAMA' => 'GAMMALN', //Devolve o logaritmo natural da função gama, Γ(x)
        'MÉDIA.GEOMÉTRICA' => 'GEOMEAN', //Devolve a média geométrica
        'CRESCIMENTO' => 'GROWTH', //Devolve valores ao longo de uma tendência exponencial
        'MÉDIA.HARMÓNICA' => 'HARMEAN', //Devolve a média harmónica
        'DIST.HIPERGEOM' => 'HYPGEOMDIST', //Devolve a distribuição hipergeométrica
        'INTERCEPTAR' => 'INTERCEPT', //Devolve a intercepção da linha de regressão linear
        'CURT' => 'KURT', //Devolve a curtose de um conjunto de dados
        'MAIOR' => 'LARGE', //Devolve o maior valor k-ésimo de um conjunto de dados
        'PROJ.LIN' => 'LINEST', //Devolve os parâmetros de uma tendência linear
        'PROJ.LOG' => 'LOGEST', //Devolve os parâmetros de uma tendência exponencial
        'INVLOG' => 'LOGINV', //Devolve o inverso da distribuição normal logarítmica
        'DIST.NORMALLOG' => 'LOGNORMDIST', //Devolve a distribuição normal logarítmica cumulativa
        'MÁXIMO' => 'MAX', //Devolve o valor máximo numa lista de argumentos
        'MÁXIMOA' => 'MAXA', //Devolve o valor máximo numa lista de argumentos, incluindo números, texto e valores lógicos
        'MED' => 'MEDIAN', //Devolve a mediana dos números indicados
        'MÍNIMO' => 'MIN', //Devolve o valor mínimo numa lista de argumentos
        'MÍNIMOA' => 'MINA', //Devolve o valor mínimo numa lista de argumentos, incluindo números, texto e valores lógicos
        'MODA' => 'MODE', //Devolve o valor mais comum num conjunto de dados
        'DIST.BIN.NEG' => 'NEGBINOMDIST', //Devolve a distribuição binominal negativa
        'DIST.NORM' => 'NORMDIST', //Devolve a distribuição cumulativa normal
        'INV.NORM' => 'NORMINV', //Devolve o inverso da distribuição cumulativa normal
        'DIST.NORMP' => 'NORMSDIST', //Devolve a distribuição cumulativa normal padrão
        'INV.NORMP' => 'NORMSINV', //Devolve o inverso da distribuição cumulativa normal padrão
        'PEARSON' => 'PEARSON', //Devolve o coeficiente de correlação momento/produto de Pearson
        'PERCENTIL' => 'PERCENTILE', //Devolve o k-ésimo percentil de valores num intervalo
        'ORDEM.PERCENTUAL' => 'PERCENTRANK', //Devolve a ordem percentual de um valor num conjunto de dados
        'PERMUTAR' => 'PERMUT', //Devolve o número de permutações de um determinado número de objectos
        'POISSON' => 'POISSON', //Devolve a distribuição de Poisson
        'PROB' => 'PROB', //Devolve a probabilidade dos valores num intervalo se encontrarem entre dois limites
        'QUARTIL' => 'QUARTILE', //Devolve o quartil de um conjunto de dados
        'ORDEM' => 'RANK', //Devolve a ordem de um número numa lista numérica
        'RQUAD' => 'RSQ', //Devolve o quadrado do coeficiente de correlação momento/produto de Pearson
        'DISTORÇÃO' => 'SKEW', //Devolve a distorção de uma distribuição
        'DECLIVE' => 'SLOPE', //Devolve o declive da linha de regressão linear
        'MENOR' => 'SMALL', //Devolve o menor valor de k-ésimo de um conjunto de dados
        'NORMALIZAR' => 'STANDARDIZE', //Devolve um valor normalizado
        'DESVPAD' => 'STDEV', //Calcula o desvio-padrão com base numa amostra
        'DESVPADA' => 'STDEVA', //Calcula o desvio-padrão com base numa amostra, incluindo números, texto e valores lógicos
        'DESVPADP' => 'STDEVP', //Calcula o desvio-padrão com base na população total
        'DESVPADPA' => 'STDEVPA', //Calcula o desvio-padrão com base na população total, incluindo números, texto e valores lógicos
        'EPADYX' => 'STEYX', //Devolve o erro-padrão do valor de y previsto para cada x na regressão
        'DISTT' => 'TDIST', //Devolve a distribuição t de Student
        'INVT' => 'TINV', //Devolve o inverso da distribuição t de Student
        'TENDÊNCIA' => 'TREND', //Devolve valores ao longo de uma tendência linear
        'MÉDIA.INTERNA' => 'TRIMMEAN', //Devolve a média do interior de um conjunto de dados
        'TESTET' => 'TTEST', //Devolve a probabilidade associada ao teste t de Student
        'VAR' => 'VAR', //Calcula a variância com base numa amostra
        'VARA' => 'VARA', //Calcula a variância com base numa amostra, incluindo números, texto e valores lógicos
        'VARP' => 'VARP', //Calcula a variância com base na população total
        'VARPA' => 'VARPA', //Calcula a variância com base na população total, incluindo números, texto e valores lógicos
        'WEIBULL' => 'WEIBULL', //Devolve a distribuição Weibull
        'TESTEZ' => 'ZTEST', //Devolve o valor de probabilidade unicaudal de um teste-z
        'ASC' => 'ASC', //Altera letras ou katakana de largura total (byte duplo) numa cadeia de caracteres para caracteres de largura média (byte único)
        'TEXTO.BAHT' => 'BAHTTEXT', //Converte um número em texto, utilizando o formato monetário ß (baht)
        'CARÁCT' => 'CHAR', //Devolve o carácter especificado pelo número de código
        'LIMPAR' => 'CLEAN', //Remove do texto todos os caracteres não imprimíveis
        'CÓDIGO' => 'CODE', //Devolve um código numérico correspondente ao primeiro carácter numa cadeia de texto
        'CONCATENAR' => 'CONCATENATE', //Agrupa vários itens de texto num único item de texto
        'MOEDA' => 'DOLLAR', //Converte um número em texto, utilizando o formato monetário € (Euro)
        'EXACTO' => 'EXACT', //Verifica se dois valores de texto são idênticos
        'LOCALIZAR' => 'FIND', //Localiza um valor de texto dentro de outro (sensível às maiúsculas e minúsculas)
        'LOCALIZARB' => 'FINDB', //Localiza um valor de texto dentro de outro (sensível às maiúsculas e minúsculas)
        'FIXA' => 'FIXED', //Formata um número como texto com um número fixo de decimais
        'JIS' => 'JIS', //Altera letras ou katakana de largura média (byte único) numa cadeia de caracteres para caracteres de largura total (byte duplo)
        'ESQUERDA' => 'LEFT', //Devolve os caracteres mais à esquerda de um valor de texto
        'ESQUERDAB' => 'LEFTB', //Devolve os caracteres mais à esquerda de um valor de texto
        'NÚM.CARACT' => 'LEN', //Devolve o número de caracteres de uma cadeia de texto
        'NÚM.CARACTB' => 'LENB', //Devolve o número de caracteres de uma cadeia de texto
        'MINÚSCULAS' => 'LOWER', //Converte o texto em minúsculas
        'SEG.TEXTO' => 'MID', //Devolve um número específico de caracteres de uma cadeia de texto, a partir da posição especificada
        'SEG.TEXTOB' => 'MIDB', //Devolve um número específico de caracteres de uma cadeia de texto, a partir da posição especificada
        'FONÉTICA' => 'PHONETIC', //Retira os caracteres fonéticos (furigana) de uma cadeia de texto
        'INICIAL.MAIÚSCULA' => 'PROPER', //Coloca em maiúsculas a primeira letra de cada palavra de um valor de texto
        'SUBSTITUIR' => 'REPLACE', //Substitui caracteres no texto
        'SUBSTITUIRB' => 'REPLACEB', //Substitui caracteres no texto
        'REPETIR' => 'REPT', //Repete texto um determinado número de vezes
        'DIREITA' => 'RIGHT', //Devolve os caracteres mais à direita de um valor de texto
        'DIREITAB' => 'RIGHTB', //Devolve os caracteres mais à direita de um valor de texto
        'PROCURAR' => 'SEARCH', //Localiza um valor de texto dentro de outro (não sensível a maiúsculas e minúsculas)
        'PROCURARB' => 'SEARCHB', //Localiza um valor de texto dentro de outro (não sensível a maiúsculas e minúsculas)
        'SUBST' => 'SUBSTITUTE', //Substitui texto novo por texto antigo numa cadeia de texto
        'T' => 'T', //Converte os respectivos argumentos em texto
        'TEXTO' => 'TEXT', //Formata um número e converte-o em texto
        'COMPACTAR' => 'TRIM', //Remove espaços do texto
        'MAIÚSCULAS' => 'UPPER', //Converte texto em maiúsculas
        'VALOR' => 'VALUE', //Converte um argumento de texto num número
    ],
];
//EOF
