<?php
// sv_SE

return [
    'language' => 'Swedish',
    'formats' => [
        'date' => 'YYYY-MM-DD',
        'time' => 'HH:MM:SS',
        'datetime' => 'YYYY-MM-DD HH:MM:SS',
        'money' => '#,##0.00 [$kr];[RED]-#,##0.00 [$kr]',
    ],
    'functions' => [
        'HÄMTA.PIVOTDATA' => 'GETPIVOTDATA', //Returnerar data som lagrats i en pivottabellrapport
        'KUBKPIMEDLEM' => 'CUBEKPIMEMBER', //Returnerar namn, egenskap och mått för en KPI och visar namnet och egenskapen i cellen. En KPI, eller prestandaindikator, är ett kvantifierbart mått, t.ex. månatlig bruttovinst eller personalomsättning per kvartal, som används för att analysera ett företags resultat.
        'KUBMEDLEM' => 'CUBEMEMBER', //Returnerar en medlem eller ett par i en kubhierarki. Används för att verifiera att medlemmen eller paret finns i kuben.
        'KUBMEDLEMSEGENSKAP' => 'CUBEMEMBERPROPERTY', //Returnerar värdet för en medlemsegenskap i kuben. Används för att verifiera att ett medlemsnamn finns i kuben, samt för att returnera den angivna egenskapen för medlemmen.
        'KUBRANGORDNADMEDLEM' => 'CUBERANKEDMEMBER', //Returnerar den n:te, eller rangordnade, medlemmen i en uppsättning. Används för att returnera ett eller flera element i en uppsättning, till exempelvis den bästa försäljaren eller de tio bästa eleverna.
        'KUBINSTÄLLNING' => 'CUBESET', //Definierar en beräknad uppsättning medlemmar eller par genom att skicka ett bestämt uttryck till kuben på servern, som skapar uppsättningen och sedan returnerar den till Microsoft Office Excel.
        'KUBINSTÄLLNINGANTAL' => 'CUBESETCOUNT', //Returnerar antalet objekt i en uppsättning.
        'KUBVÄRDE' => 'CUBEVALUE', //Returnerar ett mängdvärde från en kub.
        'DMEDEL' => 'DAVERAGE', //Returnerar medelvärdet av databasposterna
        'DANTAL' => 'DCOUNT', //Räknar antalet celler som innehåller tal i en databas
        'DANTALV' => 'DCOUNTA', //Räknar ifyllda celler i en databas
        'DHÄMTA' => 'DGET', //Hämtar en enstaka post från en databas som uppfyller de angivna villkoren
        'DMAX' => 'DMAX', //Returnerar det största värdet från databasposterna
        'DMIN' => 'DMIN', //Returnerar det minsta värdet från databasposterna
        'DPRODUKT' => 'DPRODUCT', //Multiplicerar värdena i ett visst fält i poster som uppfyller villkoret
        'DSTDAV' => 'DSTDEV', //Uppskattar standardavvikelsen baserat på ett urval av databasposterna
        'DSTDAVP' => 'DSTDEVP', //Beräknar standardavvikelsen utifrån hela populationen av valda databasposter
        'DSUMMA' => 'DSUM', //Summerar talen i kolumnfält i databasposter som uppfyller villkoret
        'DVARIANS' => 'DVAR', //Uppskattar variansen baserat på ett urval av databasposterna
        'DVARIANSP' => 'DVARP', //Beräknar variansen utifrån hela populationen av valda databasposter
        'DATUM' => 'DATE', //Returnerar ett serienummer för ett visst datum
        'DATUMVÄRDE' => 'DATEVALUE', //Konverterar ett datum i textformat till ett serienummer
        'DAG' => 'DAY', //Konverterar ett serienummer till dag i månaden
        'DAGAR360' => 'DAYS360', //Beräknar antalet dagar mellan två datum baserat på ett 360-dagarsår
        'EDATUM' => 'EDATE', //Returnerar serienumret för ett datum som infaller ett visst antal månader före eller efter startdatumet
        'SLUTMÅNAD' => 'EOMONTH', //Returnerar serienumret för sista dagen i månaden ett visst antal månader tidigare eller senare
        'TIMME' => 'HOUR', //Konverterar ett serienummer till en timme
        'MINUT' => 'MINUTE', //Konverterar ett serienummer till en minut
        'MÅNAD' => 'MONTH', //Konverterar ett serienummer till en månad
        'NETTOARBETSDAGAR' => 'NETWORKDAYS', //Returnerar antalet hela arbetsdagar mellan två datum
        'NU' => 'NOW', //Returnerar serienumret för dagens datum och aktuell tid
        'SEKUND' => 'SECOND', //Konverterar ett serienummer till en sekund
        'KLOCKSLAG' => 'TIME', //Returnerar serienumret för en viss tid
        'TIDVÄRDE' => 'TIMEVALUE', //Konverterar en tid i textformat till ett serienummer
        'IDAG' => 'TODAY', //Returnerar serienumret för dagens datum
        'VECKODAG' => 'WEEKDAY', //Konverterar ett serienummer till en dag i veckan
        'VECKONR' => 'WEEKNUM', //Konverterar ett serienummer till ett veckonummer
        'ARBETSDAGAR' => 'WORKDAY', //Returnerar serienumret för ett datum ett visst antal arbetsdagar tidigare eller senare
        'ÅR' => 'YEAR', //Konverterar ett serienummer till ett år
        'ÅRDEL' => 'YEARFRAC', //Returnerar en del av ett år som representerar antalet hela dagar mellan start- och slutdatum
        'BESSELI' => 'BESSELI', //Returnerar den modifierade Bessel-funktionen In(x)
        'BESSELJ' => 'BESSELJ', //Returnerar Bessel-funktionen Jn(x)
        'BESSELK' => 'BESSELK', //Returnerar den modifierade Bessel-funktionen Kn(x)
        'BESSELY' => 'BESSELY', //Returnerar Bessel-funktionen Yn(x)
        'BIN.TILL.DEC' => 'BIN2DEC', //Omvandlar ett binärt tal till decimalt
        'BIN.TILL.HEX' => 'BIN2HEX', //Omvandlar ett binärt tal till hexadecimalt
        'BIN.TILL.OKT' => 'BIN2OCT', //Omvandlar ett binärt tal till oktalt
        'KOMPLEX' => 'COMPLEX', //Omvandlar reella och imaginära koefficienter till ett komplext tal
        'KONVERTERA' => 'CONVERT', //Omvandlar ett tal från ett måttsystem till ett annat
        'DEC.TILL.BIN' => 'DEC2BIN', //Omvandlar ett decimalt tal till binärt
        'DEC.TILL.HEX' => 'DEC2HEX', //Omvandlar ett decimalt tal till hexadecimalt
        'DEC.TILL.OKT' => 'DEC2OCT', //Omvandlar ett decimalt tal till oktalt
        'DELTA' => 'DELTA', //Testar om två värden är lika
        'FELF' => 'ERF', //Returnerar felfunktionen
        'FELFK' => 'ERFC', //Returnerar den komplementära felfunktionen
        'SLSTEG' => 'GESTEP', //Testar om ett tal är större än ett tröskelvärde
        'HEX.TILL.BIN' => 'HEX2BIN', //Omvandlar ett hexadecimalt tal till binärt
        'HEX.TILL.DEC' => 'HEX2DEC', //Omvandlar ett hexadecimalt tal till decimalt
        'HEX.TILL.OKT' => 'HEX2OCT', //Omvandlar ett hexadecimalt tal till oktalt
        'IMABS' => 'IMABS', //Returnerar absolutvärdet (modulus) för ett komplext tal
        'IMAGINÄR' => 'IMAGINARY', //Returnerar den imaginära koefficienten för ett komplext tal
        'IMARGUMENT' => 'IMARGUMENT', //Returnerar det komplexa talets argument, en vinkel uttryckt i radianer
        'IMKONJUGAT' => 'IMCONJUGATE', //Returnerar det komplexa talets konjugat
        'IMCOS' => 'IMCOS', //Returnerar cosinus för ett komplext tal
        'IMDIV' => 'IMDIV', //Returnerar kvoten för två komplexa tal
        'IMEUPPHÖJT' => 'IMEXP', //Returnerar exponenten för ett komplext tal
        'IMLN' => 'IMLN', //Returnerar den naturliga logaritmen för ett komplext tal
        'IMLOG10' => 'IMLOG10', //Returnerar 10-logaritmen för ett komplext tal
        'IMLOG2' => 'IMLOG2', //Returnerar 2-logaritmen för ett komplext tal
        'IMUPPHÖJT' => 'IMPOWER', //Returnerar ett komplext tal upphöjt till en exponent
        'IMPRODUKT' => 'IMPRODUCT', //Returnerar produkten av komplexa tal
        'IMREAL' => 'IMREAL', //Returnerar den reella koefficienten för ett komplext tal
        'IMSIN' => 'IMSIN', //Returnerar sinus för ett komplext tal
        'IMROT' => 'IMSQRT', //Returnerar kvadratroten av ett komplext tal
        'IMDIFF' => 'IMSUB', //Returnerar differensen mellan två komplexa tal
        'IMSUM' => 'IMSUM', //Returnerar summan av komplexa tal
        'OKT.TILL.BIN' => 'OCT2BIN', //Omvandlar ett oktalt tal till binärt
        'OKT.TILL.DEC' => 'OCT2DEC', //Omvandlar ett oktalt tal till decimalt
        'OKT.TILL.HEX' => 'OCT2HEX', //Omvandlar ett oktalt tal till hexadecimalt
        'UPPLRÄNTA' => 'ACCRINT', //Returnerar den upplupna räntan för värdepapper med periodisk ränta
        'UPPLOBLRÄNTA' => 'ACCRINTM', //Returnerar den upplupna räntan för ett värdepapper som ger avkastning på förfallodagen
        'AMORDEGRC' => 'AMORDEGRC', //Returnerar avskrivningen för varje redovisningsperiod med hjälp av en avskrivningskoefficient
        'AMORLINC' => 'AMORLINC', //Returnerar avskrivningen för varje redovisningsperiod
        'KUPDAGBB' => 'COUPDAYBS', //Returnerar antal dagar från början av kupongperioden till likviddagen
        'KUPDAGARS' => 'COUPDAYS', //Returnerar antalet dagar i kupongperioden som innehåller betalningsdatumet
        'KUPDAGNK' => 'COUPDAYSNC', //Returnerar antalet dagar från betalningsdatumet till nästa kupongdatum
        'KUPNKD' => 'COUPNCD', //Returnerar nästa kupongdatum efter likviddagen
        'KUPANT' => 'COUPNUM', //Returnerar kuponger som förfaller till betalning mellan likviddagen och förfallodagen
        'KUPFKD' => 'COUPPCD', //Returnerar föregående kupongdatum före likviddagen
        'KUMRÄNTA' => 'CUMIPMT', //Returnerar den ackumulerade räntan som betalats mellan två perioder
        'KUMPRIS' => 'CUMPRINC', //Returnerar det ackumulerade kapitalbeloppet som betalats på ett lån mellan två perioder
        'DB' => 'DB', //Returnerar avskrivningen för en tillgång under en angiven tid enligt metoden för fast degressiv avskrivning
        'DEGAVSKR' => 'DDB', //Returnerar en tillgångs värdeminskning under en viss period med hjälp av dubbel degressiv avskrivning eller någon annan metod som du anger
        'DISK' => 'DISC', //Returnerar diskonteringsräntan för ett värdepapper
        'DECTAL' => 'DOLLARDE', //Omvandlar ett pris uttryckt som ett bråk till ett decimaltal
        'BRÅK' => 'DOLLARFR', //Omvandlar ett pris i kronor uttryckt som ett decimaltal till ett bråk
        'LÖPTID' => 'DURATION', //Returnerar den årliga löptiden för en säkerhet med periodiska räntebetalningar
        'EFFRÄNTA' => 'EFFECT', //Returnerar den årliga effektiva räntesatsen
        'SLUTVÄRDE' => 'FV', //Returnerar det framtida värdet på en investering
        'FÖRRÄNTNING' => 'FVSCHEDULE', //Returnerar det framtida värdet av ett begynnelsekapital beräknat på olika räntenivåer
        'ÅRSRÄNTA' => 'INTRATE', //Returnerar räntesatsen för ett betalt värdepapper
        'RBETALNING' => 'IPMT', //Returnerar räntedelen av en betalning för en given period
        'IR' => 'IRR', //Returnerar internräntan för en serie betalningar
        'RALÅN' => 'ISPMT', //Beräknar räntan som har betalats under en specifik betalningsperiod
        'MLÖPTID' => 'MDURATION', //Returnerar den modifierade Macauley-löptiden för ett värdepapper med det antagna nominella värdet 100 kr
        'MODIR' => 'MIRR', //Returnerar internräntan där positiva och negativa betalningar finansieras med olika räntor
        'NOMRÄNTA' => 'NOMINAL', //Returnerar den årliga nominella räntesatsen
        'PERIODER' => 'NPER', //Returnerar antalet perioder för en investering
        'NETNUVÄRDE' => 'NPV', //Returnerar nuvärdet av en serie periodiska betalningar vid en given diskonteringsränta
        'UDDAFPRIS' => 'ODDFPRICE', //Returnerar priset per 100 kr nominellt värde för ett värdepapper med en udda första period
        'UDDAFAVKASTNING' => 'ODDFYIELD', //Returnerar avkastningen för en säkerhet med en udda första period
        'UDDASPRIS' => 'ODDLPRICE', //Returnerar priset per 100 kr nominellt värde för ett värdepapper med en udda sista period
        'UDDASAVKASTNING' => 'ODDLYIELD', //Returnerar avkastningen för en säkerhet med en udda sista period
        'BETALNING' => 'PMT', //Returnerar den periodiska betalningen för en annuitet
        'AMORT' => 'PPMT', //Returnerar amorteringsdelen av en annuitetsbetalning för en given period
        'PRIS' => 'PRICE', //Returnerar priset per 100 kr nominellt värde för ett värdepapper som ger periodisk ränta
        'PRISDISK' => 'PRICEDISC', //Returnerar priset per 100 kr nominellt värde för ett diskonterat värdepapper
        'PRISFÖRF' => 'PRICEMAT', //Returnerar priset per 100 kr nominellt värde för ett värdepapper som ger ränta på förfallodagen
        'PV' => 'PV', //Returnerar nuvärdet av en serie lika stora periodiska betalningar
        'RÄNTA' => 'RATE', //Returnerar räntesatsen per period i en annuitet
        'BELOPP' => 'RECEIVED', //Returnerar beloppet som utdelas på förfallodagen för ett betalat värdepapper
        'LINAVSKR' => 'SLN', //Returnerar den linjära avskrivningen för en tillgång under en period
        'ÅRSAVSKR' => 'SYD', //Returnerar den årliga avskrivningssumman för en tillgång under en angiven period
        'SSVXEKV' => 'TBILLEQ', //Returnerar avkastningen motsvarande en obligation för en statsskuldväxel
        'SSVXPRIS' => 'TBILLPRICE', //Returnerar priset per 100 kr nominellt värde för en statsskuldväxel
        'SSVXRÄNTA' => 'TBILLYIELD', //Returnerar avkastningen för en statsskuldväxel
        'VDEGRAVSKR' => 'VDB', //Returnerar avskrivningen för en tillgång under en angiven period (med degressiv avskrivning)
        'XIRR' => 'XIRR', //Returnerar internräntan för en serie betalningar som inte nödvändigtvis är periodiska
        'XNUVÄRDE' => 'XNPV', //Returnerar det nuvarande nettovärdet för en serie betalningar som inte nödvändigtvis är periodiska
        'NOMAVK' => 'YIELD', //Returnerar avkastningen för ett värdepapper som ger periodisk ränta
        'NOMAVKDISK' => 'YIELDDISC', //Returnerar den årliga avkastningen för diskonterade värdepapper, exempelvis en statsskuldväxel
        'NOMAVKFÖRF' => 'YIELDMAT', //Returnerar den årliga avkastningen för ett värdepapper som ger ränta på förfallodagen
        'CELL' => 'CELL', //Returnerar information om formatering, plats och innehåll i en cell
        'FEL.TYP' => 'ERROR.TYPE', //Returnerar ett tal som motsvarar ett felvärde
        'INFO' => 'INFO', //Returnerar information om operativsystemet
        'ÄRREF' => 'ISBLANK', //Returnerar SANT om värdet är tomt
        'Ä' => 'ISERR', //Returnerar SANT om värdet är ett felvärde annat än #SAKNAS!
        'ÄRFEL' => 'ISERROR', //Returnerar SANT om värdet är ett felvärde
        'ÄRJÄMN' => 'ISEVEN', //Returnerar SANT om talet är jämnt
        'ÄREJTEXT' => 'ISLOGICAL', //Returnerar SANT om värdet är ett logiskt värde
        'ÄRLOGISK' => 'ISNA', //Returnerar SANT om värdet är felvärdet #SAKNAS!
        'ÄRSAKNAD' => 'ISNONTEXT', //Returnerar SANT om värdet inte är text
        'ÄRTAL' => 'ISNUMBER', //Returnerar SANT om värdet är ett tal
        'ÄRUDDA' => 'ISODD', //Returnerar SANT om talet är udda
        'ÄRTOM' => 'ISREF', //Returnerar SANT om värdet är en referens
        'ÄRTEXT' => 'ISTEXT', //Returnerar SANT om värdet är text
        'N' => 'N', //Returnerar ett värde omvandlat till ett tal
        'SAKNAS' => 'NA', //Returnerar felvärdet #SAKNAS!
        'VÄRDETYP' => 'TYPE', //Returnerar ett tal som anger värdets datatyp
        'OCH' => 'AND', //Returnerar SANT om alla argument är sanna
        'FALSKT' => 'FALSE', //Returnerar det logiska värdet FALSKT
        'OM' => 'IF', //Anger vilket logiskt test som ska utföras
        'OMFEL' => 'IFERROR', //Returnerar ett värde som du anger om en formel utvärderar till ett fel; annars returneras resultatet av formeln
        'ICKE' => 'NOT', //Inverterar logiken för argumenten
        'ELLER' => 'OR', //Returnerar SANT om något argument är SANT
        'SANT' => 'TRUE', //Returnerar det logiska värdet SANT
        'ADRESS' => 'ADDRESS', //Returnerar en referens som text till en enstaka cell i ett kalkylblad
        'OMRÅDEN' => 'AREAS', //Returnerar antalet områden i en referens
        'VÄLJ' => 'CHOOSE', //Väljer ett värde i en lista över värden
        'KOLUMN' => 'COLUMN', //Returnerar kolumnnumret för en referens
        'KOLUMNER' => 'COLUMNS', //Returnerar antalet kolumner i en referens
        'LETAKOLUMN' => 'HLOOKUP', //Söker i den översta raden i en matris och returnerar värdet för angiven cell
        'HYPERLÄNK' => 'HYPERLINK', //Skapar en genväg eller ett hopp till ett dokument i nätverket, i ett intranät eller på Internet
        'INDEX' => 'INDEX', //Använder ett index för ett välja ett värde i en referens eller matris
        'INDIREKT' => 'INDIRECT', //Returnerar en referens som anges av ett textvärde
        'LETAUPP' => 'LOOKUP', //Letar upp värden i en vektor eller matris
        'PASSA' => 'MATCH', //Letar upp värden i en referens eller matris
        'FÖRSKJUTNING' => 'OFFSET', //Returnerar en referens förskjuten i förhållande till en given referens
        'RAD' => 'ROW', //Returnerar radnumret för en referens
        'RADER' => 'ROWS', //Returnerar antalet rader i en referens
        'RTD' => 'RTD', //Hämtar realtidsdata från ett program som stöder COM-automation (Automation: Ett sätt att arbeta med ett programs objekt från ett annat program eller utvecklingsverktyg. Detta kallades tidigare för OLE Automation, och är en branschstandard och ingår i Component Object Model (COM).)
        'TRANSPONERA' => 'TRANSPOSE', //Transponerar en matris
        'LETARAD' => 'VLOOKUP', //Letar i den första kolumnen i en matris och flyttar över raden för att returnera värdet för en cell
        'ABS' => 'ABS', //Returnerar absolutvärdet av ett tal
        'ARCCOS' => 'ACOS', //Returnerar arcus cosinus för ett tal
        'ARCCOSH' => 'ACOSH', //Returnerar inverterad hyperbolisk cosinus för ett tal
        'ARCSIN' => 'ASIN', //Returnerar arcus cosinus för ett tal
        'ARCSINH' => 'ASINH', //Returnerar hyperbolisk arcus sinus för ett tal
        'ARCTAN' => 'ATAN', //Returnerar arcus tangens för ett tal
        'ARCTAN2' => 'ATAN2', //Returnerar arcus tangens för en x- och en y- koordinat
        'ARCTANH' => 'ATANH', //Returnerar hyperbolisk arcus tangens för ett tal
        'RUNDA.UPP' => 'CEILING', //Avrundar ett tal till närmaste heltal eller närmaste signifikanta multipel
        'KOMBIN' => 'COMBIN', //Returnerar antalet kombinationer för ett givet antal objekt
        'COS' => 'COS', //Returnerar cosinus för ett tal
        'COSH' => 'COSH', //Returnerar hyperboliskt cosinus för ett tal
        'GRADER' => 'DEGREES', //Omvandlar radianer till grader
        'JÄMN' => 'EVEN', //Avrundar ett tal uppåt till närmaste heltal
        'EXP' => 'EXP', //Returnerar e upphöjt till ett givet tal
        'FAKULTET' => 'FACT', //Returnerar fakulteten för ett tal
        'DUBBELFAKULTET' => 'FACTDOUBLE', //Returnerar dubbelfakulteten för ett tal
        'RUNDA.NED' => 'FLOOR', //Avrundar ett tal nedåt mot noll
        'SGD' => 'GCD', //Returnerar den största gemensamma nämnaren
        'HELTAL' => 'INT', //Avrundar ett tal nedåt till närmaste heltal
        'MGM' => 'LCM', //Returnerar den minsta gemensamma multipeln
        'LN' => 'LN', //Returnerar den naturliga logaritmen för ett tal
        'LOG' => 'LOG', //Returnerar logaritmen för ett tal för en given bas
        'LOG10' => 'LOG10', //Returnerar 10-logaritmen för ett tal
        'MDETERM' => 'MDETERM', //Returnerar matrisen som är avgörandet av en matris
        'MINVERT' => 'MINVERSE', //Returnerar matrisinversen av en matris
        'MMULT' => 'MMULT', //Returnerar matrisprodukten av två matriser
        'REST' => 'MOD', //Returnerar resten vid en division
        'MAVRUNDA' => 'MROUND', //Returnerar ett tal avrundat till en given multipel
        'MULTINOMIAL' => 'MULTINOMIAL', //Returnerar multinomialen för en uppsättning tal
        'UDDA' => 'ODD', //Avrundar ett tal uppåt till närmaste udda heltal
        'PI' => 'PI', //Returnerar värdet pi
        'UPPHÖJT.TILL' => 'POWER', //Returnerar resultatet av ett tal upphöjt till en exponent
        'PRODUKT' => 'PRODUCT', //Multiplicerar argumenten
        'KVOT' => 'QUOTIENT', //Returnerar heltalsdelen av en division
        'RADIANER' => 'RADIANS', //Omvandlar grader till radianer
        'SLUMP' => 'RAND', //Returnerar ett slumptal mellan 0 och 1
        'SLUMP.MELLAN' => 'RANDBETWEEN', //Returnerar ett slumptal mellan de tal som du anger
        'ROMERSK' => 'ROMAN', //Omvandlar vanliga (arabiska) siffror till romerska som text
        'AVRUNDA' => 'ROUND', //Avrundar ett tal till ett angivet antal siffror
        'AVRUNDA.NEDÅT' => 'ROUNDDOWN', //Avrundar ett tal nedåt mot noll
        'AVRUNDA.UPPÅT' => 'ROUNDUP', //Avrundar ett tal uppåt, från noll
        'SERIESUMMA' => 'SERIESSUM', //Returnerar summan av en potensserie baserat på formeln
        'TECKEN' => 'SIGN', //Returnerar tecknet för ett tal
        'SIN' => 'SIN', //Returnerar sinus för en given vinkel
        'SINH' => 'SINH', //Returnerar hyperbolisk sinus för ett tal
        'ROT' => 'SQRT', //Returnerar den positiva kvadratroten
        'ROTPI' => 'SQRTPI', //Returnerar kvadratroten för (tal * pi)
        'DELSUMMA' => 'SUBTOTAL', //Returnerar en delsumma i en lista eller databas
        'SUMMA' => 'SUM', //Summerar argumenten
        'SUMMA.OM' => 'SUMIF', //Summerar celler enligt ett angivet villkor
        'SUMMA.OMF' => 'SUMIFS', //Lägger till cellerna i ett område som uppfyller flera kriterier
        'PRODUKTSUMMA' => 'SUMPRODUCT', //Returnerar summan av produkterna i motsvarande matriskomponenter
        'KVADRATSUMMA' => 'SUMSQ', //Returnerar summan av argumentens kvadrater
        'SUMMAX2MY2' => 'SUMX2MY2', //Returnerar summan av differensen mellan kvadraterna för motsvarande värden i två matriser
        'SUMMAX2PY2' => 'SUMX2PY2', //Returnerar summan av summan av kvadraterna av motsvarande värden i två matriser
        'SUMMAXMY2' => 'SUMXMY2', //Returnerar summan av kvadraten av skillnaden mellan motsvarande värden i två matriser
        'TAN' => 'TAN', //Returnerar tangens för ett tal
        'TANH' => 'TANH', //Returnerar hyperbolisk tangens för ett tal
        'AVKORTA' => 'TRUNC', //Avkortar ett tal till ett heltal
        'MEDELAVV' => 'AVEDEV', //Returnerar medelvärdet för datapunkters absoluta avvikelse från deras medelvärde
        'MEDEL' => 'AVERAGE', //Returnerar medelvärdet av argumenten
        'AVERAGEA' => 'AVERAGEA', //Returnerar medelvärdet av argumenten, inklusive tal, text och logiska värden
        'MEDELOM' => 'AVERAGEIF', //Returnerar medelvärdet (aritmetiskt medelvärde) för alla celler i ett område som uppfyller ett givet kriterium
        'MEDELOMF' => 'AVERAGEIFS', //Returnerar medelvärdet (det aritmetiska medelvärdet) för alla celler som uppfyller flera villkor.
        'BETAFÖRD' => 'BETADIST', //Returnerar den kumulativa betafördelningsfunktionen
        'BETAINV' => 'BETAINV', //Returnerar inversen till den kumulativa fördelningsfunktionen för en viss betafördelning
        'BINOMFÖRD' => 'BINOMDIST', //Returnerar den individuella binomialfördelningen
        'CHI2FÖRD' => 'CHIDIST', //Returnerar den ensidiga sannolikheten av c2-fördelningen
        'CHI2INV' => 'CHIINV', //Returnerar inversen av chi2-fördelningen
        'CHI2TEST' => 'CHITEST', //Returnerar oberoendetesten
        'KONFIDENS' => 'CONFIDENCE', //Returnerar konfidensintervallet för en populations medelvärde
        'KORREL' => 'CORREL', //Returnerar korrelationskoefficienten mellan två datamängder
        'ANTAL' => 'COUNT', //Räknar hur många tal som finns bland argumenten
        'ANTALV' => 'COUNTA', //Räknar hur många värden som finns bland argumenten
        'ANTAL.TOMMA' => 'COUNTBLANK', //Räknar antalet tomma celler i ett område
        'ANTAL.OM' => 'COUNTIF', //Räknar antalet celler i ett område som uppfyller angivna villkor.
        'ANTAL.OMF' => 'COUNTIFS', //Räknar antalet celler i ett område som uppfyller flera villkor.
        'KOVAR' => 'COVAR', //Returnerar kovariansen, d.v.s. medelvärdet av produkterna för parade avvikelser
        'KRITBINOM' => 'CRITBINOM', //Returnerar det minsta värdet för vilket den kumulativa binomialfördelningen är mindre än eller lika med ett villkorsvärde
        'KVADAVV' => 'DEVSQ', //Returnerar summan av kvadrater på avvikelser
        'EXPONFÖRD' => 'EXPONDIST', //Returnerar exponentialfördelningen
        'FFÖRD' => 'FDIST', //Returnerar F-sannolikhetsfördelningen
        'FINV' => 'FINV', //Returnerar inversen till F-sannolikhetsfördelningen
        'FISHER' => 'FISHER', //Returnerar Fisher-transformationen
        'FISHERINV' => 'FISHERINV', //Returnerar inversen till Fisher-transformationen
        'PREDIKTION' => 'FORECAST', //Returnerar ett värde längs en linjär trendlinje
        'FREKVENS' => 'FREQUENCY', //Returnerar en frekvensfördelning som en lodrät matris
        'FTEST' => 'FTEST', //Returnerar resultatet av en F-test
        'GAMMAFÖRD' => 'GAMMADIST', //Returnerar gammafördelningen
        'GAMMAINV' => 'GAMMAINV', //Returnerar inversen till den kumulativa gammafördelningen
        'GAMMALN' => 'GAMMALN', //Returnerar den naturliga logaritmen för gammafunktionen, G(x)
        'GEOMEDEL' => 'GEOMEAN', //Returnerar det geometriska medelvärdet
        'EXPTREND' => 'GROWTH', //Returnerar värden längs en exponentiell trend
        'HARMMEDEL' => 'HARMEAN', //Returnerar det harmoniska medelvärdet
        'HYPGEOMFÖRD' => 'HYPGEOMDIST', //Returnerar den hypergeometriska fördelningen
        'SKÄRNINGSPUNKT' => 'INTERCEPT', //Returnerar skärningspunkten för en linjär regressionslinje
        'TOPPIGHET' => 'KURT', //Returnerar toppigheten av en mängd data
        'STÖRSTA' => 'LARGE', //Returnerar det n:te största värdet i en mängd data
        'REGR' => 'LINEST', //Returnerar parametrar till en linjär trendlinje
        'EXPREGR' => 'LOGEST', //Returnerar parametrarna i en exponentiell trend
        'LOGINV' => 'LOGINV', //Returnerar inversen till den lognormala fördelningen
        'LOGNORMFÖRD' => 'LOGNORMDIST', //Returnerar den kumulativa lognormala fördelningen
        'MAX' => 'MAX', //Returnerar det största värdet i en lista av argument
        'MAXA' => 'MAXA', //Returnerar det största värdet i en lista av argument, inklusive tal, text och logiska värden
        'MEDIAN' => 'MEDIAN', //Returnerar medianen för angivna tal
        'MIN' => 'MIN', //Returnerar det minsta värdet i en lista med argument
        'MINA' => 'MINA', //Returnerar det minsta värdet i en lista över argument, inklusive tal, text och logiska värden
        'TYPVÄRDE' => 'MODE', //Returnerar det vanligaste värdet i en datamängd
        'NEGBINOMFÖRD' => 'NEGBINOMDIST', //Returnerar den negativa binomialfördelningen
        'NORMFÖRD' => 'NORMDIST', //Returnerar den kumulativa normalfördelningen
        'NORMINV' => 'NORMINV', //Returnerar inversen till den kumulativa normalfördelningen
        'NORMSFÖRD' => 'NORMSDIST', //Returnerar den kumulativa standardnormalfördelningen
        'NORMSINV' => 'NORMSINV', //Returnerar inversen till den kumulativa standardnormalfördelningen
        'PEARSON' => 'PEARSON', //Returnerar korrelationskoefficienten till Pearsons momentprodukt
        'PERCENTIL' => 'PERCENTILE', //Returnerar den n:te percentilen av värden i ett område
        'PROCENTRANG' => 'PERCENTRANK', //Returnerar procentrangen för ett värde i en datamängd
        'PERMUT' => 'PERMUT', //Returnerar antal permutationer för ett givet antal objekt
        'POISSON' => 'POISSON', //Returnerar Poisson-fördelningen
        'SANNOLIKHET' => 'PROB', //Returnerar sannolikheten att värden i ett område ligger mellan två gränser
        'KVARTIL' => 'QUARTILE', //Returnerar kvartilen av en mängd data
        'RANG' => 'RANK', //Returnerar rangordningen för ett tal i en lista med tal
        'RKV' => 'RSQ', //Returnerar kvadraten av Pearsons produktmomentkorrelationskoefficient
        'SNEDHET' => 'SKEW', //Returnerar snedheten för en fördelning
        'LUTNING' => 'SLOPE', //Returnerar lutningen på en linjär regressionslinje
        'MINSTA' => 'SMALL', //Returnerar det n:te minsta värdet i en mängd data
        'STANDARDISERA' => 'STANDARDIZE', //Returnerar ett normaliserat värde
        'STDAV' => 'STDEV', //Uppskattar standardavvikelsen baserat på ett urval
        'STDEVA' => 'STDEVA', //Uppskattar standardavvikelsen baserat på ett urval, inklusive tal, text och logiska värden
        'STDAVP' => 'STDEVP', //Beräknar standardavvikelsen baserat på hela populationen
        'STDEVPA' => 'STDEVPA', //Beräknar standardavvikelsen baserat på hela populationen, inklusive tal, text och logiska värden
        'STDFELYX' => 'STEYX', //Returnerar standardfelet för ett förutspått y-värde för varje x-värde i regressionen
        'TFÖRD' => 'TDIST', //Returnerar Students t-fördelning
        'TINV' => 'TINV', //Returnerar inversen till Students t-fördelning
        'TREND' => 'TREND', //Returnerar värden längs en linjär trend
        'TRIMMEDEL' => 'TRIMMEAN', //Returnerar medelvärdet av mittpunkterna i en datamängd
        'TTEST' => 'TTEST', //Returnerar sannolikheten beräknad ur Students t-test
        'VARIANS' => 'VAR', //Uppskattar variansen baserat på ett urval
        'VARA' => 'VARA', //Uppskattar variansen baserat på ett urval, inklusive tal, text och logiska värden
        'VARIANSP' => 'VARP', //Beräknar variansen baserat på hela populationen
        'VARPA' => 'VARPA', //Beräknar variansen baserat på hela populationen, inklusive tal, text och logiska värden
        'WEIBULL' => 'WEIBULL', //Returnerar Weibull-fördelningen
        'ZTEST' => 'ZTEST', //Returnerar det ensidiga sannolikhetsvärdet av ett z-test
        'ASC' => 'ASC', //Ändrar helbredds (dubbel byte) engelska bokstäver eller katakana inom en teckensträng till tecken med halvt breddsteg (enkel byte)
        'BAHTTEXT' => 'BAHTTEXT', //Omvandlar ett tal till text med valutaformatet ß (baht)
        'TECKENKOD' => 'CHAR', //Returnerar tecknet som anges av kod
        'STÄDA' => 'CLEAN', //Tar bort alla icke utskrivbara tecken i en text
        'KOD' => 'CODE', //Returnerar en numerisk kod för det första tecknet i en textsträng
        'SAMMANFOGA' => 'CONCATENATE', //Sammanfogar flera textdelar till en textsträng
        'VALUTA' => 'DOLLAR', //Omvandlar ett tal till text med valutaformat
        'EXAKT' => 'EXACT', //Kontrollerar om två textvärden är identiska
        'HITTA' => 'FIND', //Hittar en text i en annan (skiljer på gemener och versaler)
        'HITTAB' => 'FINDB', //Hittar en text i en annan (skiljer på gemener och versaler)
        'FASTTAL' => 'FIXED', //Formaterar ett tal som text med ett fast antal decimaler
        'JIS' => 'JIS', //Ändrar halvbredds (enkel byte) engelska bokstäver eller katakana inom en teckensträng till tecken med helt breddsteg (dubbel byte)
        'VÄNSTER' => 'LEFT', //Returnerar tecken längst till vänster i en sträng
        'VÄNSTERB' => 'LEFTB', //Returnerar tecken längst till vänster i en sträng
        'LÄNGD' => 'LEN', //Returnerar antalet tecken i en textsträng
        'LÄNGDB' => 'LENB', //Returnerar antalet tecken i en textsträng
        'GEMENER' => 'LOWER', //Omvandlar text till gemener
        'EXTEXT' => 'MID', //Returnerar angivet antal tecken från en text med början vid den position som du anger
        'EXTEXTB' => 'MIDB', //Returnerar angivet antal tecken från en text med början vid den position som du anger
        'PHONETIC' => 'PHONETIC', //Returnerar de fonetiska (furigana) tecknen i en textsträng
        'INITIAL' => 'PROPER', //Ändrar första bokstaven i varje ord i ett textvärde till versal
        'ERSÄTT' => 'REPLACE', //Ersätter tecken i text
        'ERSÄTTB' => 'REPLACEB', //Ersätter tecken i text
        'REP' => 'REPT', //Upprepar en text ett bestämt antal gånger
        'HÖGER' => 'RIGHT', //Returnerar tecken längst till höger i en sträng
        'HÖGERB' => 'RIGHTB', //Returnerar tecken längst till höger i en sträng
        'SÖK' => 'SEARCH', //Hittar ett textvärde i ett annat (skiljer inte på gemener och versaler)
        'SÖKB' => 'SEARCHB', //Hittar ett textvärde i ett annat (skiljer inte på gemener och versaler)
        'BYT.UT' => 'SUBSTITUTE', //Ersätter gammal text med ny text i en textsträng
        'T' => 'T', //Omvandlar argumenten till text
        'TEXT' => 'TEXT', //Formaterar ett tal och omvandlar det till text
        'RENSA' => 'TRIM', //Tar bort blanksteg från text
        'VERSALER' => 'UPPER', //Omvandlar text till versaler
        'TEXTNUM' => 'VALUE', //Omvandlar ett textargument till ett tal
    ],
];
//EOF
