<?php
// tr_TR

return [
    'language' => 'Turkish',
    'formats' => [
        'date' => 'DD-MM-YYYY',
        'time' => 'HH:MM:SS',
        'datetime' => 'DD-MM-YYYY HH:MM:SS',
        'money' => '#,##0.00 [$₺];[RED]-#,##0.00 [$₺]',
    ],
    'functions' => [
        'ÖZETVERİAL' => 'GETPIVOTDATA', //Bir Özet Tablo raporunda saklanan verileri verir.
        'KÜPKPIÜYE' => 'CUBEKPIMEMBER', //Kilit performans göstergesi (KPI-Key Performance Indicator) adını, özelliğini ve ölçüsünü verir ve hücredeki ad ve özelliği gösterir. KPI, bir kurumun performansını izlemek için kullanılan aylık brüt kâr ya da üç aylık çalışan giriş çıkışları gibi ölçülebilen bir birimdir.
        'KÜPÜYE' => 'CUBEMEMBER', //Bir küp hiyerarşisinde bir üyeyi veya kaydı verir. Üye veya kaydın küpte varolduğunu doğrulamak için kullanılır.
        'KÜPÜYEÖZELLİĞİ' => 'CUBEMEMBERPROPERTY', //Bir küpte bir üyenin özelliğinin değerini verir. Küp içinde üye adının varlığını doğrulamak ve bu üyenin belli özelliklerini getirmek için kullanılır.
        'KÜPÜYESIRASI' => 'CUBERANKEDMEMBER', //Bir küme içindeki üyenin derecesini veya kaçıncı olduğunu verir. En iyi satış elemanı, veya en iyi on öğrenci gibi bir kümedeki bir veya daha fazla öğeyi getirmek için kullanılır.
        'KÜPKÜME' => 'CUBESET', //Kümeyi oluşturan ve ardından bu kümeyi Microsoft Office Excel'e getiren sunucudaki küpe küme ifadelerini göndererek hesaplanan üye veya kayıt kümesini tanımlar.
        'KÜPKÜMESAY' => 'CUBESETCOUNT', //Bir kümedeki öğelerin sayısını getirir.
        'KÜPDEĞER' => 'CUBEVALUE', //Bir küpten toplam değeri getirir.
        'VSEÇORT' => 'DAVERAGE', //Seçili veritabanı girdilerinin ortalamasını verir.
        'VSEÇSAY' => 'DCOUNT', //Veritabanında sayı içeren hücre sayısını hesaplar.
        'VSEÇSAYDOLU' => 'DCOUNTA', //Veritabanındaki boş olmayan hücreleri sayar.
        'VAL' => 'DGET', //Veritabanından, belirtilen ölçütlerle eşleşen tek bir rapor çıkarır.
        'VSEÇMAK' => 'DMAX', //Seçili veritabanı girişlerinin en yüksek değerini verir.
        'VSEÇMİN' => 'DMIN', //Seçili veritabanı girişlerinin en düşük değerini verir.
        'VSEÇÇARP' => 'DPRODUCT', //Kayıtların belli bir alanında bulunan, bir veritabanındaki ölçütlerle eşleşen değerleri çarpar.
        'VSEÇSTDSAPMA' => 'DSTDEV', //Seçili veritabanı girişlerinden oluşan bir örneğe dayanarak, standart sapmayı tahmin eder.
        'VSEÇSTDSAPMAS' => 'DSTDEVP', //Standart sapmayı, seçili veritabanı girişlerinin tüm popülasyonunu esas alarak hesaplar.
        'VSEÇTOPLA' => 'DSUM', //Kayıtların alan sütununda bulunan, ölçütle eşleşen sayıları toplar.
        'VSEÇVAR' => 'DVAR', //Seçili veritabanı girişlerinden oluşan bir örneği esas alarak farkı tahmin eder.
        'VSEÇVARS' => 'DVARP', //Seçili veritabanı girişlerinin tüm popülasyonunu esas alarak farkı hesaplar.
        'TARİH' => 'DATE', //Belirli bir tarihin seri numarasını verir.
        'TARİHSAYISI' => 'DATEVALUE', //Metin biçimindeki bir tarihi seri numarasına dönüştürür.
        'GÜN' => 'DAY', //Seri numarasını, ayın bir gününe dönüştürür.
        'GÜN360' => 'DAYS360', //İki tarih arasındaki gün sayısını, 360 günlük yılı esas alarak hesaplar.
        'SERİTARİH' => 'EDATE', //Başlangıç tarihinden itibaren, belirtilen ay sayısından önce veya sonraki tarihin seri numarasını verir.
        'SERİAY' => 'EOMONTH', //Belirtilen sayıda ay önce veya sonraki ayın son gününün seri numarasını verir.
        'SAAT' => 'HOUR', //Bir seri numarasını saate dönüştürür.
        'DAKİKA' => 'MINUTE', //Bir seri numarasını dakikaya dönüştürür.
        'AY' => 'MONTH', //Bir seri numarasını aya dönüştürür.
        'TAMİŞGÜNÜ' => 'NETWORKDAYS', //İki tarih arasındaki tam çalışma günlerinin sayısını verir.
        'ŞİMDİ' => 'NOW', //Geçerli tarihin ve saatin seri numarasını verir.
        'SANİYE' => 'SECOND', //Bir seri numarasını saniyeye dönüştürür.
        'ZAMAN' => 'TIME', //Belirli bir zamanın seri numarasını verir.
        'ZAMANSAYISI' => 'TIMEVALUE', //Metin biçimindeki zamanı seri numarasına dönüştürür.
        'BUGÜN' => 'TODAY', //Bugünün tarihini seri numarasına dönüştürür.
        'HAFTANINGÜNÜ' => 'WEEKDAY', //Bir seri numarasını, haftanın gününe dönüştürür.
        'HAFTASAY' => 'WEEKNUM', //Dizisel değerini, haftanın yıl içinde bulunduğu konumu sayısal olarak gösteren sayıya dönüştürür.
        'İŞGÜNÜ' => 'WORKDAY', //Belirtilen sayıda çalışma günü öncesinin ya da sonrasının tarihinin seri numarasını verir.
        'YIL' => 'YEAR', //Bir seri numarasını yıla dönüştürür.
        'YILORAN' => 'YEARFRAC', //Başlangıç_tarihi ve bitiş_tarihi arasındaki tam günleri gösteren yıl kesrini verir.
        'BESSELI' => 'BESSELI', //Değiştirilmiş Bessel fonksiyonu In(x)'i verir.
        'BESSELJ' => 'BESSELJ', //Bessel fonksiyonu Jn(x)'i verir.
        'BESSELK' => 'BESSELK', //Değiştirilmiş Bessel fonksiyonu Kn(x)'i verir.
        'BESSELY' => 'BESSELY', //Bessel fonksiyonu Yn(x)'i verir.
        'BIN2DEC' => 'BIN2DEC', //İkili bir sayıyı, ondalık sayıya dönüştürür.
        'BIN2HEX' => 'BIN2HEX', //İkili bir sayıyı, onaltılıya dönüştürür.
        'BIN2OCT' => 'BIN2OCT', //İkili bir sayıyı, sekizliye dönüştürür.
        'KARMAŞIK' => 'COMPLEX', //Gerçek ve sanal katsayıları, karmaşık sayıya dönüştürür.
        'ÇEVİR' => 'CONVERT', //Bir sayıyı, bir ölçüm sisteminden bir başka ölçüm sistemine dönüştürür.
        'DEC2BIN' => 'DEC2BIN', //Ondalık bir sayıyı, ikiliye dönüştürür.
        'DEC2HEX' => 'DEC2HEX', //Ondalık bir sayıyı, onaltılıya dönüştürür.
        'DEC2OCT' => 'DEC2OCT', //Ondalık bir sayıyı sekizliğe dönüştürür.
        'DELTA' => 'DELTA', //İki değerin eşit olup olmadığını sınar.
        'HATAİŞLEV' => 'ERF', //Hata işlevini verir.
        'TÜMHATAİŞLEV' => 'ERFC', //Tümleyici hata işlevini verir.
        'BESINIR' => 'GESTEP', //Bir sayının eşik değerinden büyük olup olmadığını sınar.
        'HEX2BIN' => 'HEX2BIN', //Onaltılı bir sayıyı ikiliye dönüştürür.
        'HEX2DEC' => 'HEX2DEC', //Onaltılı bir sayıyı ondalığa dönüştürür.
        'HEX2OCT' => 'HEX2OCT', //Onaltılı bir sayıyı sekizliğe dönüştürür.
        'SANMUTLAK' => 'IMABS', //Karmaşık bir sayının mutlak değerini (modül) verir.
        'SANAL' => 'IMAGINARY', //Karmaşık bir sayının sanal katsayısını verir.
        'SANBAĞ_DEĞİŞKEN' => 'IMARGUMENT', //Radyanlarla belirtilen bir açı olan teta bağımsız değişkenini verir.
        'SANEŞLENEK' => 'IMCONJUGATE', //Karmaşık bir sayının karmaşık eşleniğini verir.
        'SANCOS' => 'IMCOS', //Karmaşık bir sayının kosinüsünü verir.
        'SANBÖL' => 'IMDIV', //İki karmaşık sayının bölümünü verir.
        'SANÜS' => 'IMEXP', //Karmaşık bir sayının üssünü verir.
        'SANLN' => 'IMLN', //Karmaşık bir sayının doğal logaritmasını verir.
        'SANLOG10' => 'IMLOG10', //Karmaşık bir sayının, 10 tabanında logaritmasını verir.
        'SANLOG2' => 'IMLOG2', //Karmaşık bir sayının 2 tabanında logaritmasını verir.
        'SANÜSSÜ' => 'IMPOWER', //Karmaşık bir sayıyı, bir tamsayı üssüne yükseltilmiş olarak verir.
        'SANÇARP' => 'IMPRODUCT', //Karmaşık sayıların çarpımını verir.
        'SANGERÇEK' => 'IMREAL', //Karmaşık bir sayının, gerçek katsayısını verir.
        'SANSIN' => 'IMSIN', //Karmaşık bir sayının sinüsünü verir.
        'SANKAREKÖK' => 'IMSQRT', //Karmaşık bir sayının karekökünü verir.
        'SANÇIKAR' => 'IMSUB', //İki karmaşık sayının farkını verir.
        'SANTOPLA' => 'IMSUM', //Karmaşık sayıların toplamını verir.
        'OCT2BIN' => 'OCT2BIN', //Sekizli bir sayıyı ikiliye dönüştürür.
        'OCT2DEC' => 'OCT2DEC', //Sekizli bir sayıyı ondalığa dönüştürür.
        'OCT2HEX' => 'OCT2HEX', //Sekizli bir sayıyı onaltılıya dönüştürür.
        'GERÇEKFAİZ' => 'ACCRINT', //Dönemsel faiz ödeyen hisse senedine ilişkin tahakkuk eden faizi getirir.
        'GERÇEKFAİZV' => 'ACCRINTM', //Vadesinde ödeme yapan bir tahvilin tahakkuk etmiş faizini verir.
        'AMORDEGRC' => 'AMORDEGRC', //Yıpranma katsayısı kullanarak her hesap döneminin değer kaybını verir.
        'AMORLINC' => 'AMORLINC', //Her hesap dönemi içindeki yıpranmayı verir.
        'KUPONGÜNBD' => 'COUPDAYBS', //Kupon süresinin başlangıcından alış tarihine kadar olan süredeki gün sayısını verir.
        'KUPONGÜN' => 'COUPDAYS', //Kupon süresindeki, gün sayısını, alış tarihini de içermek üzere, verir.
        'KUPONGÜNDSK' => 'COUPDAYSNC', //Alış tarihinden bir sonraki kupon tarihine kadar olan gün sayısını verir.
        'KUPONGÜNSKT' => 'COUPNCD', //Alış tarihinden bir sonraki kupon tarihini verir.
        'KUPONSAYI' => 'COUPNUM', //Alış tarihiyle vade tarihi arasında ödenecek kuponların sayısını verir.
        'KUPONGÜNÖKT' => 'COUPPCD', //Alış tarihinden bir önceki kupon tarihini verir.
        'AİÇVERİMORANI' => 'CUMIPMT', //İki dönem arasında ödenen kümülatif faizi verir.
        'ANA_PARA_ÖDEMESİ' => 'CUMPRINC', //İki dönem arasında bir borç üzerine ödenen birikimli temeli verir.
        'AZALANBAKİYE' => 'DB', //Bir malın belirtilen bir süre içindeki yıpranmasını, sabit azalan bakiye yöntemini kullanarak verir.
        'ÇİFTAZALANBAKİYE' => 'DDB', //Bir malın belirtilen bir süre içindeki yıpranmasını, çift azalan bakiye yöntemi ya da sizin belirttiğiniz başka bir yöntemi kullanarak verir.
        'İNDİRİM' => 'DISC', //Bir tahvilin indirim oranını verir.
        'LİRAON' => 'DOLLARDE', //Kesir olarak tanımlanmış lira fiyatını, ondalık sayı olarak tanımlanmış lira fiyatına dönüştürür.
        'LİRAKES' => 'DOLLARFR', //Ondalık sayı olarak tanımlanmış lira fiyatını, kesir olarak tanımlanmış lira fiyatına dönüştürür.
        'SÜRE' => 'DURATION', //Belli aralıklarla faiz ödemesi yapan bir tahvilin yıllık süresini verir.
        'ETKİN' => 'EFFECT', //Efektif yıllık faiz oranını verir.
        'ANBD' => 'FV', //Bir yatırımın gelecekteki değerini verir.
        'GDPROGRAM' => 'FVSCHEDULE', //Bir seri birleşik faiz oranı uyguladıktan sonra, bir başlangıçtaki anaparanın gelecekteki değerini verir.
        'FAİZORANI' => 'INTRATE', //Tam olarak yatırım yapılmış bir tahvilin faiz oranını verir.
        'FAİZTUTARI' => 'IPMT', //Bir yatırımın verilen bir süre için faiz ödemesini verir.
        'İÇ_VERİM_ORANI' => 'IRR', //Bir para akışı serisi için, iç verim oranını verir.
        'ISPMT' => 'ISPMT', //Yatırımın belirli bir dönemi boyunca ödenen faizi hesaplar.
        'MSÜRE' => 'MDURATION', //Varsayılan par değeri 10.000.000 lira olan bir tahvil için Macauley değiştirilmiş süreyi verir.
        'D_İÇ_VERİM_ORANI' => 'MIRR', //Pozitif ve negatif para akışlarının farklı oranlarda finanse edildiği durumlarda, iç verim oranını verir.
        'NOMİNAL' => 'NOMINAL', //Yıllık nominal faiz oranını verir.
        'DÖNEM_SAYISI' => 'NPER', //Bir yatırımın dönem sayısını verir.
        'NBD' => 'NPV', //Bir yatırımın bugünkü net değerini, bir dönemsel para akışları serisine ve bir indirim oranına bağlı olarak verir.
        'TEKYDEĞER' => 'ODDFPRICE', //Tek bir ilk dönemi olan bir tahvilin değerini, her 100.000.000 lirada bir verir.
        'TEKYÖDEME' => 'ODDFYIELD', //Tek bir ilk dönemi olan bir tahvilin ödemesini verir.
        'TEKSDEĞER' => 'ODDLPRICE', //Tek bir son dönemi olan bir tahvilin fiyatını her 10.000.000 lirada bir verir.
        'TEKSÖDEME' => 'ODDLYIELD', //Tek bir son dönemi olan bir tahvilin ödemesini verir.
        'DEVRESEL_ÖDEME' => 'PMT', //Bir yıllık dönemsel ödemeyi verir.
        'ANA_PARA_ÖDEMESİ' => 'PPMT', //Verilen bir süre için, bir yatırımın anaparasına dayanan ödemeyi verir.
        'DEĞER' => 'PRICE', //Dönemsel faiz ödeyen bir tahvilin fiyatını 10.000.00 liralık değer başına verir.
        'DEĞERİND' => 'PRICEDISC', //İndirimli bir tahvilin fiyatını 10.000.000 liralık nominal değer başına verir.
        'DEĞERVADE' => 'PRICEMAT', //Faizini vade sonunda ödeyen bir tahvilin fiyatını 10.000.000 nominal değer başına verir.
        'BD' => 'PV', //Bir yatırımın bugünkü değerini verir.
        'FAİZ_ORANI' => 'RATE', //Bir yıllık dönem başına düşen faiz oranını verir.
        'GETİRİ' => 'RECEIVED', //Tam olarak yatırılmış bir tahvilin vadesinin bitiminde alınan miktarı verir.
        'DA' => 'SLN', //Bir malın bir dönem içindeki doğrusal yıpranmasını verir.
        'YAT' => 'SYD', //Bir malın belirli bir dönem için olan amortismanını verir.
        'HTAHEŞ' => 'TBILLEQ', //Bir Hazine bonosunun bono eşdeğeri ödemesini verir.
        'HTAHDEĞER' => 'TBILLPRICE', //Bir Hazine bonosunun değerini, 10.000.000 liralık nominal değer başına verir.
        'HTAHÖDEME' => 'TBILLYIELD', //Bir Hazine bonosunun ödemesini verir.
        'DAB' => 'VDB', //Bir malın amortismanını, belirlenmiş ya da kısmi bir dönem için, bir azalan bakiye yöntemi kullanarak verir.
        'AİÇVERİMORANI' => 'XIRR', //Dönemsel olması gerekmeyen bir para akışları programı için, iç verim oranını verir.
        'ANBD' => 'XNPV', //Dönemsel olması gerekmeyen bir para akışları programı için, bugünkü net değeri verir.
        'ÖDEME' => 'YIELD', //Belirli aralıklarla faiz ödeyen bir tahvilin ödemesini verir.
        'ÖDEMEİND' => 'YIELDDISC', //İndirimli bir tahvilin yıllık ödemesini verir; örneğin, bir Hazine bonosunun.
        'ÖDEMEVADE' => 'YIELDMAT', //Vadesinin bitiminde faiz ödeyen bir tahvilin yıllık ödemesini verir.
        'HÜCRE' => 'CELL', //Bir hücrenin biçimlendirmesi, konumu ya da içeriği hakkında bilgi verir.
        'HATA.TİPİ' => 'ERROR.TYPE', //Bir hata türüne ilişkin sayıları verir.
        'BİLGİ' => 'INFO', //Geçerli işletim ortamı hakkında bilgi verir.
        'EBOŞSA' => 'ISBLANK', //Değer boşsa, DOĞRU verir.
        'EHATA' => 'ISERR', //Değer, #YOK dışındaki bir hata değeriyse, DOĞRU verir.
        'EHATALIYSA' => 'ISERROR', //Değer, herhangi bir hata değeriyse, DOĞRU verir.
        'ÇİFTTİR' => 'ISEVEN', //Sayı çiftse, DOĞRU verir.
        'EMANTIKSALSA' => 'ISLOGICAL', //Değer, mantıksal bir değerse, DOĞRU verir.
        'EYOKSA' => 'ISNA', //Değer, #YOK hata değeriyse, DOĞRU verir.
        'EMETİNDEĞİLSE' => 'ISNONTEXT', //Değer, metin değilse, DOĞRU verir.
        'ESAYIYSA' => 'ISNUMBER', //Değer, bir sayıysa, DOĞRU verir.
        'TEKTİR' => 'ISODD', //Sayı tekse, DOĞRU verir.
        'EREFSE' => 'ISREF', //Değer bir başvuruysa, DOĞRU verir.
        'EMETİNSE' => 'ISTEXT', //Değer bir metinse DOĞRU verir.
        'N' => 'N', //Sayıya dönüştürülmüş bir değer verir.
        'YOKSAY' => 'NA', //#YOK hata değerini verir.
        'TİP' => 'TYPE', //Bir değerin veri türünü belirten bir sayı verir.
        'VE' => 'AND', //Bütün bağımsız değişkenleri DOĞRU ise, DOĞRU verir.
        'YANLIŞ' => 'FALSE', //YANLIŞ mantıksal değerini verir.
        'EĞER' => 'IF', //Gerçekleştirilecek bir mantıksal sınama belirtir.
        'EĞERHATA' => 'IFERROR', //Formül hatalıysa belirttiğiniz değeri verir; bunun dışındaki durumlarda formülün sonucunu verir.
        'DEĞİL' => 'NOT', //Bağımsız değişkeninin mantığını tersine çevirir.
        'YADA' => 'OR', //Bağımsız değişkenlerden herhangi birisi DOĞRU ise, DOĞRU verir.
        'DOĞRU' => 'TRUE', //DOĞRU mantıksal değerini verir.
        'ADRES' => 'ADDRESS', //Bir başvuruyu, çalışma sayfasındaki tek bir hücreye metin olarak verir.
        'ALANSAY' => 'AREAS', //Renvoie le nombre de zones dans une référence.
        'ELEMAN' => 'CHOOSE', //Değerler listesinden bir değer seçer.
        'SÜTUN' => 'COLUMN', //Bir başvurunun sütun sayısını verir.
        'SÜTUNSAY' => 'COLUMNS', //Bir başvurudaki sütunların sayısını verir.
        'YATAYARA' => 'HLOOKUP', //Bir dizinin en üst satırına bakar ve belirtilen hücrenin değerini verir.
        'KÖPRÜ' => 'HYPERLINK', //Bir ağ sunucusunda, bir intranette ya da Internet'te depolanan bir belgeyi açan bir kısayol ya da atlama oluşturur.
        'İNDİS' => 'INDEX', //Başvurudan veya diziden bir değer seçmek için, bir dizin kullanır.
        'DOLAYLI' => 'INDIRECT', //Metin değeriyle belirtilen bir başvuru verir.
        'ARA' => 'LOOKUP', //Bir vektördeki veya dizideki değerleri arar.
        'KAÇINCI' => 'MATCH', //Bir başvurudaki veya dizideki değerleri arar.
        'KAYDIR' => 'OFFSET', //Verilen bir başvurudan, bir başvuru kaydırmayı verir.
        'SATIR' => 'ROW', //Bir başvurunun satır sayısını verir.
        'SATIRSAY' => 'ROWS', //Bir başvurudaki satırların sayısını verir.
        'RTD' => 'RTD', //COM otomasyonunu destekleyen programdan gerçek zaman verileri alır.
        'DEVRİK_DÖNÜŞÜM' => 'TRANSPOSE', //Bir dizinin devrik dönüşümünü verir.
        'DÜŞEYARA' => 'VLOOKUP', //Bir dizinin ilk sütununa bakar ve bir hücrenin değerini vermek için satır boyunca hareket eder.
        'MUTLAK' => 'ABS', //Bir sayının mutlak değerini verir.
        'ACOS' => 'ACOS', //Bir sayının ark kosinüsünü verir.
        'ACOSH' => 'ACOSH', //Bir sayının ters hiperbolik kosinüsünü verir.
        'ASİN' => 'ASIN', //Bir sayının ark sinüsünü verir.
        'ASİNH' => 'ASINH', //Bir sayının ters hiperbolik sinüsünü verir.
        'ATAN' => 'ATAN', //Bir sayının ark tanjantını verir.
        'ATAN2' => 'ATAN2', //Ark tanjantı, x- ve y- koordinatlarından verir.
        'ATANH' => 'ATANH', //Bir sayının ters hiperbolik tanjantını verir.
        'TAVANAYUVARLA' => 'CEILING', //Bir sayıyı, en yakın tamsayıya ya da en yakın katına yuvarlar.
        'KOMBİNASYON' => 'COMBIN', //Verilen sayıda öğenin kombinasyon sayısını verir.
        'COS' => 'COS', //Bir sayının kosinüsünü verir.
        'COSH' => 'COSH', //Bir sayının hiperbolik kosinüsünü verir.
        'DERECE' => 'DEGREES', //Radyanları dereceye dönüştürür.
        'ÇİFT' => 'EVEN', //Bir sayıyı, en yakın daha büyük çift tamsayıya yuvarlar.
        'ÜS' => 'EXP', //e'yi, verilen bir sayının üssüne yükseltilmiş olarak verir.
        'ÇARPINIM' => 'FACT', //Bir sayının faktörünü verir.
        'ÇİFTFAKTÖR' => 'FACTDOUBLE', //Bir sayının çift çarpınımını verir.
        'TABANAYUVARLA' => 'FLOOR', //Bir sayıyı, daha küçük sayıya, sıfıra yakınsayarak yuvarlar.
        'OBEB' => 'GCD', //En büyük ortak böleni verir.
        'TAMSAYI' => 'INT', //Bir sayıyı aşağıya doğru en yakın tamsayıya yuvarlar.
        'OKEK' => 'LCM', //En küçük ortak katı verir.
        'LN' => 'LN', //Bir sayının doğal logaritmasını verir.
        'LOG' => 'LOG', //Bir sayının, belirtilen bir tabandaki logaritmasını verir.
        'LOG10' => 'LOG10', //Bir sayının 10 tabanında logaritmasını verir.
        'DETERMİNANT' => 'MDETERM', //Bir dizinin dizey determinantını verir.
        'DİZEY_TERS' => 'MINVERSE', //Bir dizinin dizey tersini verir.
        'DÇARP' => 'MMULT', //İki dizinin dizey çarpımını verir.
        'MODÜLO' => 'MOD', //Bölmeden kalanı verir.
        'KYUVARLA' => 'MROUND', //İstenen kata yuvarlanmış bir sayı verir.
        'ÇOKTERİMLİ' => 'MULTINOMIAL', //Bir sayılar kümesinin çok terimlisini verir.
        'TEK' => 'ODD', //Bir sayıyı en yakın daha büyük tek sayıya yuvarlar.
        'Pİ' => 'PI', //Pi değerini verir.
        'KUVVET' => 'POWER', //Bir üsse yükseltilmiş sayının sonucunu verir.
        'ÇARPIM' => 'PRODUCT', //Bağımsız değişkenlerini çarpar.
        'BÖLÜM' => 'QUOTIENT', //Bir bölme işleminin tamsayı kısmını verir.
        'RADYAN' => 'RADIANS', //Dereceleri radyanlara dönüştürür.
        'S_SAYI_ÜRET' => 'RAND', //0 ile 1 arasında rastgele bir sayı verir.
        'RASTGELEARALIK' => 'RANDBETWEEN', //Belirttiğiniz sayılar arasında rastgele bir sayı verir.
        'ROMEN' => 'ROMAN', //Bir normal rakamı, metin olarak, romen rakamına çevirir.
        'YUVARLA' => 'ROUND', //Bir sayıyı, belirtilen basamak sayısına yuvarlar.
        'AŞAĞIYUVARLA' => 'ROUNDDOWN', //Bir sayıyı, daha küçük sayıya, sıfıra yakınsayarak yuvarlar.
        'YUKARIYUVARLA' => 'ROUNDUP', //Bir sayıyı daha büyük sayıya, sıfırdan ıraksayarak yuvarlar.
        'SERİTOPLA' => 'SERIESSUM', //Bir üs serisinin toplamını, formüle bağlı olarak verir.
        'İŞARET' => 'SIGN', //Bir sayının işaretini verir.
        'SİN' => 'SIN', //Verilen bir açının sinüsünü verir.
        'SİNH' => 'SINH', //Bir sayının hiperbolik sinüsünü verir.
        'KAREKÖK' => 'SQRT', //Pozitif bir karekök verir.
        'KAREKÖKPİ' => 'SQRTPI', //(* Pi sayısının) kare kökünü verir.
        'ALTTOPLAM' => 'SUBTOTAL', //Bir listedeki ya da veritabanındaki bir alt toplamı verir.
        'TOPLA' => 'SUM', //Bağımsız değişkenlerini toplar.
        'ETOPLA' => 'SUMIF', //Verilen ölçütle belirlenen hücreleri toplar.
        'SUMIFS' => 'SUMIFS', //Bir aralıktaki, birden fazla ölçüte uyan hücreleri ekler.
        'TOPLA.ÇARPIM' => 'SUMPRODUCT', //İlişkili dizi bileşenlerinin çarpımlarının toplamını verir.
        'TOPKARE' => 'SUMSQ', //Bağımsız değişkenlerin karelerinin toplamını verir.
        'TOPX2EY2' => 'SUMX2MY2', //İki dizideki ilişkili değerlerin farkının toplamını verir.
        'TOPX2AY2' => 'SUMX2PY2', //İki dizideki ilişkili değerlerin karelerinin toplamının toplamını verir.
        'TOPXEY2' => 'SUMXMY2', //İki dizideki ilişkili değerlerin farklarının karelerinin toplamını verir.
        'TAN' => 'TAN', //Bir sayının tanjantını verir.
        'TANH' => 'TANH', //Bir sayının hiperbolik tanjantını verir.
        'NSAT' => 'TRUNC', //Bir sayının, tamsayı durumuna gelecek şekilde, fazlalıklarını atar.
        'ORTSAP' => 'AVEDEV', //Veri noktalarının ortalamalarından mutlak sapmalarının ortalamasını verir.
        'ORTALAMA' => 'AVERAGE', //Bağımsız değişkenlerinin ortalamasını verir.
        'ORTALAMAA' => 'AVERAGEA', //Bağımsız değişkenlerinin, sayılar, metin ve mantıksal değerleri içermek üzere ortalamasını verir.
        'EĞERORTALAMA' => 'AVERAGEIF', //Verili ölçütü karşılayan bir aralıktaki bütün hücrelerin ortalamasını (aritmetik ortalama) hesaplar.
        'EĞERLERORTALAMA' => 'AVERAGEIFS', //Birden çok ölçüte uyan tüm hücrelerin ortalamasını (aritmetik ortalama) hesaplar.
        'BETADAĞ' => 'BETADIST', //Beta birikimli dağılım fonksiyonunu verir.
        'BETATERS' => 'BETAINV', //Belirli bir beta dağılımı için birikimli dağılım fonksiyonunun tersini verir.
        'BİNOMDAĞ' => 'BINOMDIST', //Tek terimli binom dağılımı olasılığını verir.
        'KİKAREDAĞ' => 'CHIDIST', //Kikare dağılımın tek kuyruklu olasılığını verir.
        'KİKARETERS' => 'CHIINV', //Kikare dağılımın kuyruklu olasılığının tersini verir.
        'KİKARETEST' => 'CHITEST', //Bağımsızlık sınamalarını verir.
        'GÜVENİRLİK' => 'CONFIDENCE', //Bir popülasyon ortalaması için güvenirlik aralığını verir.
        'KORELASYON' => 'CORREL', //İki veri kümesi arasındaki bağlantı katsayısını verir.
        'BAĞ_DEĞ_SAY' => 'COUNT', //Bağımsız değişkenler listesinde kaç tane sayı bulunduğunu sayar.
        'BAĞ_DEĞ_DOLU_SAY' => 'COUNTA', //Bağımsız değişkenler listesinde kaç tane değer bulunduğunu sayar.
        'BOŞLUKSAY' => 'COUNTBLANK', //Aralıktaki boş hücre sayısını hesaplar.
        'EĞERSAY' => 'COUNTIF', //Verilen ölçütlere uyan bir aralık içindeki hücreleri sayar.
        'ÇOKEĞERSAY' => 'COUNTIFS', //Birden çok ölçüte uyan bir aralık içindeki hücreleri sayar.
        'KOVARYANS' => 'COVAR', //Eşleştirilmiş sapmaların ortalaması olan kovaryansı verir.
        'KRİTİKBİNOM' => 'CRITBINOM', //Birikimli binom dağılımının bir ölçüt değerinden küçük veya ölçüt değerine eşit olduğu en küçük değeri verir.
        'SAPKARE' => 'DEVSQ', //Sapmaların karelerinin toplamını verir.
        'ÜSTELDAĞ' => 'EXPONDIST', //Üstel dağılımı verir.
        'FDAĞ' => 'FDIST', //F olasılık dağılımını verir.
        'FTERS' => 'FINV', //F olasılık dağılımının tersini verir.
        'FISHER' => 'FISHER', //Fisher dönüşümünü verir.
        'FISHERTERS' => 'FISHERINV', //Fisher dönüşümünün tersini verir.
        'TAHMİN' => 'FORECAST', //Bir doğrusal eğilim boyunca bir değer verir.
        'SIKLIK' => 'FREQUENCY', //Bir sıklık dağılımını, dikey bir dizi olarak verir.
        'FTEST' => 'FTEST', //Bir F-test'in sonucunu verir.
        'GAMADAĞ' => 'GAMMADIST', //Gama dağılımını verir.
        'GAMATERS' => 'GAMMAINV', //Gama kümülatif dağılımının tersini verir.
        'GAMALN' => 'GAMMALN', //Gama fonksiyonunun (?(x)) doğal logaritmasını verir.
        'GEOORT' => 'GEOMEAN', //Geometrik ortayı verir.
        'BÜYÜME' => 'GROWTH', //Üstel bir eğilim boyunca değerler verir.
        'HARORT' => 'HARMEAN', //Harmonik ortayı verir.
        'HİPERGEOMDAĞ' => 'HYPGEOMDIST', //Hipergeometrik dağılımı verir.
        'KESMENOKTASI' => 'INTERCEPT', //Doğrusal çakıştırma çizgisinin kesişme noktasını verir.
        'BASIKLIK' => 'KURT', //Bir veri kümesinin basıklığını verir.
        'BÜYÜK' => 'LARGE', //Bir veri kümesinde k. en büyük değeri verir.
        'DOT' => 'LINEST', //Doğrusal bir eğilimin parametrelerini verir.
        'LOT' => 'LOGEST', //Üstel bir eğilimin parametrelerini verir.
        'LOGTERS' => 'LOGINV', //Bir lognormal dağılımının tersini verir.
        'LOGNORMDAĞ' => 'LOGNORMDIST', //Birikimli lognormal dağılımını verir.
        'MAK' => 'MAX', //Bir bağımsız değişkenler listesindeki en büyük değeri verir.
        'MAKA' => 'MAXA', //Bir bağımsız değişkenler listesindeki, sayılar, metin ve mantıksal değerleri içermek üzere, en büyük değeri verir.
        'ORTANCA' => 'MEDIAN', //Belirtilen sayıların orta değerini verir.
        'MİN' => 'MIN', //Bir bağımsız değişkenler listesindeki en küçük değeri verir.
        'MİNA' => 'MINA', //Bir bağımsız değişkenler listesindeki, sayılar, metin ve mantıksal değerleri de içermek üzere, en küçük değeri verir.
        'ENÇOK_OLAN' => 'MODE', //Bir veri kümesindeki en sık rastlanan değeri verir.
        'NEGBİNOMDAĞ' => 'NEGBINOMDIST', //Negatif binom dağılımını verir.
        'NORMDAĞ' => 'NORMDIST', //Normal birikimli dağılımı verir.
        'NORMTERS' => 'NORMINV', //Normal kümülatif dağılımın tersini verir.
        'NORMSDAĞ' => 'NORMSDIST', //Standart normal birikimli dağılımı verir.
        'NORMSTERS' => 'NORMSINV', //Standart normal birikimli dağılımın tersini verir.
        'PEARSON' => 'PEARSON', //Pearson çarpım moment korelasyon katsayısını verir.
        'YÜZDEBİRLİK' => 'PERCENTILE', //Bir aralık içerisinde bulunan değerlerin k. frekans toplamını verir.
        'YÜZDERANK' => 'PERCENTRANK', //Bir veri kümesindeki bir değerin yüzde mertebesini verir.
        'PERMÜTASYON' => 'PERMUT', //Verilen sayıda nesne için permütasyon sayısını verir.
        'POISSON' => 'POISSON', //Poisson dağılımını verir.
        'OLASILIK' => 'PROB', //Bir aralıktaki değerlerin iki sınır arasında olması olasılığını verir.
        'DÖRTTEBİRLİK' => 'QUARTILE', //Bir veri kümesinin dörtte birliğini verir.
        'RANK' => 'RANK', //Bir sayılar listesinde bir sayının mertebesini verir.
        'RKARE' => 'RSQ', //Pearson çarpım moment korelasyon katsayısının karesini verir.
        'ÇARPIKLIK' => 'SKEW', //Bir dağılımın çarpıklığını verir.
        'EĞİM' => 'SLOPE', //Doğrusal çakışma çizgisinin eğimini verir.
        'KÜÇÜK' => 'SMALL', //Bir veri kümesinde k. en küçük değeri verir.
        'STANDARTLAŞTIRMA' => 'STANDARDIZE', //Normalleştirilmiş bir değer verir.
        'STDSAPMA' => 'STDEV', //Bir örneğe dayanarak standart sapmayı tahmin eder.
        'STDSAPMAA' => 'STDEVA', //Standart sapmayı, sayılar, metin ve mantıksal değerleri içermek üzere, bir örneğe bağlı olarak tahmin eder.
        'STDSAPMAS' => 'STDEVP', //Standart sapmayı, tüm popülasyona bağlı olarak hesaplar.
        'STDSAPMASA' => 'STDEVPA', //Standart sapmayı, sayılar, metin ve mantıksal değerleri içermek üzere, tüm popülasyona bağlı olarak hesaplar.
        'STHYX' => 'STEYX', //Regresyondaki her x için tahmini y değerinin standart hatasını verir.
        'TDAĞ' => 'TDIST', //T-dağılımını verir.
        'TTERS' => 'TINV', //T-dağılımının tersini verir.
        'EĞİLİM' => 'TREND', //Doğrusal bir eğilim boyunca değerler verir.
        'KIRPORTALAMA' => 'TRIMMEAN', //Bir veri kümesinin içinin ortalamasını verir.
        'TTEST' => 'TTEST', //T-test'le ilişkilendirilmiş olasılığı verir.
        'VAR' => 'VAR', //Varyansı, bir örneğe bağlı olarak tahmin eder.
        'VARA' => 'VARA', //Varyansı, sayılar, metin ve mantıksal değerleri içermek üzere, bir örneğe bağlı olarak tahmin eder.
        'VARS' => 'VARP', //Varyansı, tüm popülasyona dayanarak hesaplar.
        'VARSA' => 'VARPA', //Varyansı, sayılar, metin ve mantıksal değerleri içermek üzere, tüm popülasyona bağlı olarak hesaplar.
        'WEIBULL' => 'WEIBULL', //Weibull dağılımını hesaplar.
        'ZTEST' => 'ZTEST', //Z-testinin tek kuyruklu olasılık değerini hesaplar.
        'ASC' => 'ASC', //Bir karakter dizesindeki çift enli (iki bayt) İngilizce harfleri veya katakanayı yarım enli (tek bayt) karakterlerle değiştirir.
        'BAHTTEXT' => 'BAHTTEXT', //Sayıyı, ß (baht) para birimi biçimini kullanarak metne dönüştürür.
        'DAMGA' => 'CHAR', //Kod sayısıyla belirtilen karakteri verir.
        'TEMİZ' => 'CLEAN', //Metindeki bütün yazdırılamaz karakterleri kaldırır.
        'KOD' => 'CODE', //Bir metin dizesindeki ilk karakter için sayısal bir kod verir.
        'BİRLEŞTİR' => 'CONCATENATE', //Pek çok metin öğesini bir metin öğesi olarak birleştirir.
        'LİRA' => 'DOLLAR', //Bir sayıyı YTL (yeni Türk lirası) para birimi biçimini kullanarak metne dönüştürür.
        'ÖZDEŞ' => 'EXACT', //İki metin değerinin özdeş olup olmadığını anlamak için, değerleri denetler.
        'BUL' => 'FIND', //Bir metin değerini, bir başkasının içinde bulur (büyük küçük harf duyarlıdır).
        'BULB' => 'FINDB', //Bir metin değerini, bir başkasının içinde bulur (büyük küçük harf duyarlıdır).
        'SAYIDÜZENLE' => 'FIXED', //Bir sayıyı, sabit sayıda ondalıkla, metin olarak biçimlendirir.
        'JIS' => 'JIS', //Bir karakter dizesindeki tek enli (tek bayt) İngilizce harfleri veya katakanayı çift enli (iki bayt) karakterlerle değiştirir.
        'SOL' => 'LEFT', //Bir metin değerinden en soldaki karakterleri verir.
        'SOLB' => 'LEFTB', //Bir metin değerinden en soldaki karakterleri verir.
        'UZUNLUK' => 'LEN', //Bir metin dizesindeki karakter sayısını verir.
        'UZUNLUKB' => 'LENB', //Bir metin dizesindeki karakter sayısını verir.
        'KÜÇÜKHARF' => 'LOWER', //Metni küçük harfe çevirir.
        'ORTA' => 'MID', //Bir metin dizesinden belirli sayıda karakteri, belirttiğiniz konumdan başlamak üzere verir.
        'ORTAB' => 'MIDB', //Bir metin dizesinden belirli sayıda karakteri, belirttiğiniz konumdan başlamak üzere verir.
        'SES' => 'PHONETIC', //Metin dizesinden ses (furigana) karakterlerini ayıklar.
        'YAZIM.DÜZENİ' => 'PROPER', //Bir metin değerinin her bir sözcüğünün ilk harfini büyük harfe çevirir.
        'DEĞİŞTİR' => 'REPLACE', //Metnin içindeki karakterleri değiştirir.
        'DEĞİŞTİRB' => 'REPLACEB', //Metnin içindeki karakterleri değiştirir.
        'YİNELE' => 'REPT', //Metni belirtilen sayıda yineler.
        'SAĞ' => 'RIGHT', //Bir metin değerinden en sağdaki karakterleri verir.
        'SAĞB' => 'RIGHTB', //Bir metin değerinden en sağdaki karakterleri verir.
        'BUL' => 'SEARCH', //Bir metin değerini, bir başkasının içinde bulur (büyük küçük harf duyarlı değildir).
        'BULB' => 'SEARCHB', //Bir metin değerini, bir başkasının içinde bulur (büyük küçük harf duyarlı değildir).
        'YERİNEKOY' => 'SUBSTITUTE', //Bir metin dizesinde, eski metnin yerine yeni metin koyar.
        'M' => 'T', //Bağımsız değerlerini metne dönüştürür.
        'METNEÇEVİR' => 'TEXT', //Bir sayıyı biçimlendirir ve metne dönüştürür.
        'KIRP' => 'TRIM', //Metindeki boşlukları kaldırır.
        'BÜYÜKHARF' => 'UPPER', //Metni büyük harfe çevirir.
        'SAYIYAÇEVİR' => 'VALUE', //Bir metin bağımsız değişkenini sayıya dönüştürür.
    ],
];
//EOF
